/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.DataSetFieldFlags;
import com.prosysopc.ua.stack.core.KeyValuePair;
import com.prosysopc.ua.stack.utils.InternalStructureUtils;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.UUID;
import java.util.function.Supplier;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=14524")
public class FieldMetaData
extends DynamicStructure {
    public static final StructureSpecification SPECIFICATION;

    public FieldMetaData() {
        super((UaDataTypeSpecification)SPECIFICATION);
    }

    protected FieldMetaData(UaDataTypeSpecification uaDataTypeSpecification) {
        super(uaDataTypeSpecification);
    }

    public FieldMetaData(String string, LocalizedText localizedText, DataSetFieldFlags dataSetFieldFlags, UnsignedByte unsignedByte, NodeId nodeId, Integer n2, UnsignedInteger[] unsignedIntegerArray, UnsignedInteger unsignedInteger, UUID uUID, KeyValuePair[] keyValuePairArray) {
        super((UaDataTypeSpecification)SPECIFICATION);
        this.setName(string);
        this.setDescription(localizedText);
        this.setFieldFlags(dataSetFieldFlags);
        this.setBuiltInType(unsignedByte);
        this.setDataType(nodeId);
        this.setValueRank(n2);
        this.setArrayDimensions(unsignedIntegerArray);
        this.setMaxStringLength(unsignedInteger);
        this.setDataSetFieldId(uUID);
        this.setProperties(keyValuePairArray);
    }

    public String getName() {
        return (String)this.indexGet(0);
    }

    public void setName(String string) {
        this.indexSet(string, 0);
    }

    public LocalizedText getDescription() {
        return (LocalizedText)this.indexGet(1);
    }

    public void setDescription(LocalizedText localizedText) {
        this.indexSet(localizedText, 1);
    }

    public DataSetFieldFlags getFieldFlags() {
        return (DataSetFieldFlags)this.indexGet(2);
    }

    public void setFieldFlags(DataSetFieldFlags dataSetFieldFlags) {
        this.indexSet(dataSetFieldFlags, 2);
    }

    public UnsignedByte getBuiltInType() {
        return (UnsignedByte)this.indexGet(3);
    }

    public void setBuiltInType(UnsignedByte unsignedByte) {
        this.indexSet(unsignedByte, 3);
    }

    public NodeId getDataType() {
        return (NodeId)this.indexGet(4);
    }

    public void setDataType(NodeId nodeId) {
        this.indexSet(nodeId, 4);
    }

    public Integer getValueRank() {
        return (Integer)this.indexGet(5);
    }

    public void setValueRank(Integer n2) {
        this.indexSet(n2, 5);
    }

    public UnsignedInteger[] getArrayDimensions() {
        return (UnsignedInteger[])this.indexGet(6);
    }

    public void setArrayDimensions(UnsignedInteger[] unsignedIntegerArray) {
        this.indexSet(unsignedIntegerArray, 6);
    }

    public UnsignedInteger getMaxStringLength() {
        return (UnsignedInteger)this.indexGet(7);
    }

    public void setMaxStringLength(UnsignedInteger unsignedInteger) {
        this.indexSet(unsignedInteger, 7);
    }

    public UUID getDataSetFieldId() {
        return (UUID)this.indexGet(8);
    }

    public void setDataSetFieldId(UUID uUID) {
        this.indexSet(uUID, 8);
    }

    public KeyValuePair[] getProperties() {
        return (KeyValuePair[])this.indexGet(9);
    }

    public void setProperties(KeyValuePair[] keyValuePairArray) {
        this.indexSet(keyValuePairArray, 9);
    }

    @Override
    public FieldMetaData clone() {
        return (FieldMetaData)super.clone();
    }

    public static Builder builder() {
        return new Builder(SPECIFICATION, () -> new FieldMetaData());
    }

    @Override
    public Builder toBuilder() {
        return (Builder)super.toBuilder();
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Name);
        builder.addField(Fields.Description);
        builder.addField(Fields.FieldFlags);
        builder.addField(Fields.BuiltInType);
        builder.addField(Fields.DataType);
        builder.addField(Fields.ValueRank);
        builder.addField(Fields.ArrayDimensions);
        builder.addField(Fields.MaxStringLength);
        builder.addField(Fields.DataSetFieldId);
        builder.addField(Fields.Properties);
        builder.setBinaryEncodeId(UaIds.FieldMetaData_DefaultBinary);
        builder.setXmlEncodeId(UaIds.FieldMetaData_DefaultXml);
        builder.setJsonEncodeId(UaIds.FieldMetaData_DefaultJson);
        builder.setTypeId(UaIds.FieldMetaData);
        builder.addSuperTypeId(UaIds.Structure);
        builder.setName("FieldMetaData");
        builder.setJavaClass(FieldMetaData.class);
        builder.setAbstract(false);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(uaDataTypeSpecification -> new Builder((UaDataTypeSpecification)uaDataTypeSpecification, () -> new FieldMetaData((UaDataTypeSpecification)uaDataTypeSpecification)));
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(FieldMetaData.class, SPECIFICATION);
    }

    public static class Builder
    extends DynamicStructure.Builder {
        protected Builder(UaDataTypeSpecification uaDataTypeSpecification, Supplier<? extends Structure> supplier) {
            super(uaDataTypeSpecification, supplier);
        }

        public String getName() {
            return (String)this.indexGet(0);
        }

        public Builder setName(String string) {
            this.indexSet(string, 0);
            return this;
        }

        public LocalizedText getDescription() {
            return (LocalizedText)this.indexGet(1);
        }

        public Builder setDescription(LocalizedText localizedText) {
            this.indexSet(localizedText, 1);
            return this;
        }

        public DataSetFieldFlags getFieldFlags() {
            return (DataSetFieldFlags)this.indexGet(2);
        }

        public Builder setFieldFlags(DataSetFieldFlags dataSetFieldFlags) {
            this.indexSet(dataSetFieldFlags, 2);
            return this;
        }

        public UnsignedByte getBuiltInType() {
            return (UnsignedByte)this.indexGet(3);
        }

        public Builder setBuiltInType(UnsignedByte unsignedByte) {
            this.indexSet(unsignedByte, 3);
            return this;
        }

        public NodeId getDataType() {
            return (NodeId)this.indexGet(4);
        }

        public Builder setDataType(NodeId nodeId) {
            this.indexSet(nodeId, 4);
            return this;
        }

        public Integer getValueRank() {
            return (Integer)this.indexGet(5);
        }

        public Builder setValueRank(Integer n2) {
            this.indexSet(n2, 5);
            return this;
        }

        public UnsignedInteger[] getArrayDimensions() {
            return (UnsignedInteger[])this.indexGet(6);
        }

        public Builder setArrayDimensions(UnsignedInteger[] unsignedIntegerArray) {
            this.indexSet(unsignedIntegerArray, 6);
            return this;
        }

        public UnsignedInteger getMaxStringLength() {
            return (UnsignedInteger)this.indexGet(7);
        }

        public Builder setMaxStringLength(UnsignedInteger unsignedInteger) {
            this.indexSet(unsignedInteger, 7);
            return this;
        }

        public UUID getDataSetFieldId() {
            return (UUID)this.indexGet(8);
        }

        public Builder setDataSetFieldId(UUID uUID) {
            this.indexSet(uUID, 8);
            return this;
        }

        public KeyValuePair[] getProperties() {
            return (KeyValuePair[])this.indexGet(9);
        }

        public Builder setProperties(KeyValuePair[] keyValuePairArray) {
            this.indexSet(keyValuePairArray, 9);
            return this;
        }

        @Override
        public FieldMetaData build() {
            return (FieldMetaData)super.build();
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Name(0, "Name", String.class, false, UaIds.String, -1, null, false, 0),
        Description(1, "Description", LocalizedText.class, false, UaIds.LocalizedText, -1, null, false, 0),
        FieldFlags(2, "FieldFlags", DataSetFieldFlags.class, false, UaIds.DataSetFieldFlags, -1, null, false, 0),
        BuiltInType(3, "BuiltInType", UnsignedByte.class, false, UaIds.Byte, -1, null, false, 0),
        DataType(4, "DataType", NodeId.class, false, UaIds.NodeId, -1, null, false, 0),
        ValueRank(5, "ValueRank", Integer.class, false, UaIds.Int32, -1, null, false, 0),
        ArrayDimensions(6, "ArrayDimensions", UnsignedInteger[].class, false, UaIds.UInt32, 1, UaArrayDimensions.valueOf(0L), false, 1),
        MaxStringLength(7, "MaxStringLength", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false, 0),
        DataSetFieldId(8, "DataSetFieldId", UUID.class, false, UaIds.Guid, -1, null, false, 0),
        Properties(9, "Properties", KeyValuePair[].class, false, UaIds.KeyValuePair, 1, UaArrayDimensions.valueOf(0L), false, 1);

        private final int fieldIndex;
        private final String name;
        private final Class<?> javaClass;
        private final boolean isOptional;
        private final UaNodeId dataTypeId;
        private final int valueRank;
        private final UaArrayDimensions arrayDimensions;
        private final boolean allowSubTypes;
        private final int javaClassDimensions;
        private final Class<?> compositeClass;
        private final UaNodeId encodeTypeId;

        private Fields(int n3, String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n4, UaArrayDimensions uaArrayDimensions, boolean bl2, int n5) {
            this.fieldIndex = n3;
            this.name = string2;
            this.javaClass = clazz;
            this.isOptional = bl;
            this.dataTypeId = uaNodeId;
            this.valueRank = n4;
            this.arrayDimensions = uaArrayDimensions;
            this.allowSubTypes = bl2;
            this.javaClassDimensions = n5;
            this.compositeClass = MultiDimensionArrayUtils.getComponentType(clazz);
            this.encodeTypeId = InternalStructureUtils.encodeTypeFor(this.compositeClass, bl2, uaNodeId);
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.arrayDimensions;
        }

        @Override
        public Class<?> getCompositeClass() {
            return this.compositeClass;
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.dataTypeId;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public UaNodeId getEncodeTypeId() {
            return this.encodeTypeId;
        }

        @Override
        public int getFieldIndex() {
            return this.fieldIndex;
        }

        @Override
        public Class<?> getJavaClass() {
            return this.javaClass;
        }

        @Override
        public int getJavaClassDimensions() {
            return this.javaClassDimensions;
        }

        @Override
        public int getMaxStringLength() {
            return 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getValueRank() {
            return this.valueRank;
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.allowSubTypes;
        }

        @Override
        public boolean isArray() {
            return this.javaClassDimensions != 0;
        }

        @Override
        public boolean isOptional() {
            return this.isOptional;
        }
    }
}

