/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.DataChangeTrigger;
import com.prosysopc.ua.stack.core.MonitoringFilter;
import com.prosysopc.ua.stack.utils.InternalStructureUtils;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.function.Supplier;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=722")
public class DataChangeFilter
extends MonitoringFilter {
    public static final StructureSpecification SPECIFICATION;

    public DataChangeFilter() {
        super((UaDataTypeSpecification)SPECIFICATION);
    }

    protected DataChangeFilter(UaDataTypeSpecification uaDataTypeSpecification) {
        super(uaDataTypeSpecification);
    }

    public DataChangeFilter(DataChangeTrigger dataChangeTrigger, UnsignedInteger unsignedInteger, Double d2) {
        super((UaDataTypeSpecification)SPECIFICATION);
        this.setTrigger(dataChangeTrigger);
        this.setDeadbandType(unsignedInteger);
        this.setDeadbandValue(d2);
    }

    public DataChangeTrigger getTrigger() {
        return (DataChangeTrigger)this.indexGet(0);
    }

    public void setTrigger(DataChangeTrigger dataChangeTrigger) {
        this.indexSet(dataChangeTrigger, 0);
    }

    public UnsignedInteger getDeadbandType() {
        return (UnsignedInteger)this.indexGet(1);
    }

    public void setDeadbandType(UnsignedInteger unsignedInteger) {
        this.indexSet(unsignedInteger, 1);
    }

    public Double getDeadbandValue() {
        return (Double)this.indexGet(2);
    }

    public void setDeadbandValue(Double d2) {
        this.indexSet(d2, 2);
    }

    @Override
    public DataChangeFilter clone() {
        return (DataChangeFilter)super.clone();
    }

    public static Builder builder() {
        return new Builder(SPECIFICATION, () -> new DataChangeFilter());
    }

    @Override
    public Builder toBuilder() {
        return (Builder)super.toBuilder();
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.Trigger);
        builder.addField(Fields.DeadbandType);
        builder.addField(Fields.DeadbandValue);
        builder.setBinaryEncodeId(UaIds.DataChangeFilter_DefaultBinary);
        builder.setXmlEncodeId(UaIds.DataChangeFilter_DefaultXml);
        builder.setJsonEncodeId(UaIds.DataChangeFilter_DefaultJson);
        builder.setTypeId(UaIds.DataChangeFilter);
        builder.addSuperTypeId(UaIds.Structure);
        builder.addSuperTypeId(UaIds.MonitoringFilter);
        builder.setName("DataChangeFilter");
        builder.setJavaClass(DataChangeFilter.class);
        builder.setAbstract(false);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(uaDataTypeSpecification -> new Builder((UaDataTypeSpecification)uaDataTypeSpecification, () -> new DataChangeFilter((UaDataTypeSpecification)uaDataTypeSpecification)));
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(DataChangeFilter.class, SPECIFICATION);
    }

    public static class Builder
    extends MonitoringFilter.Builder {
        protected Builder(UaDataTypeSpecification uaDataTypeSpecification, Supplier<? extends Structure> supplier) {
            super(uaDataTypeSpecification, supplier);
        }

        public DataChangeTrigger getTrigger() {
            return (DataChangeTrigger)this.indexGet(0);
        }

        public Builder setTrigger(DataChangeTrigger dataChangeTrigger) {
            this.indexSet(dataChangeTrigger, 0);
            return this;
        }

        public UnsignedInteger getDeadbandType() {
            return (UnsignedInteger)this.indexGet(1);
        }

        public Builder setDeadbandType(UnsignedInteger unsignedInteger) {
            this.indexSet(unsignedInteger, 1);
            return this;
        }

        public Double getDeadbandValue() {
            return (Double)this.indexGet(2);
        }

        public Builder setDeadbandValue(Double d2) {
            this.indexSet(d2, 2);
            return this;
        }

        @Override
        public DataChangeFilter build() {
            return (DataChangeFilter)super.build();
        }
    }

    public static enum Fields implements FieldSpecification
    {
        Trigger(0, "Trigger", DataChangeTrigger.class, false, UaIds.DataChangeTrigger, -1, null, false, 0),
        DeadbandType(1, "DeadbandType", UnsignedInteger.class, false, UaIds.UInt32, -1, null, false, 0),
        DeadbandValue(2, "DeadbandValue", Double.class, false, UaIds.Double, -1, null, false, 0);

        private final int fieldIndex;
        private final String name;
        private final Class<?> javaClass;
        private final boolean isOptional;
        private final UaNodeId dataTypeId;
        private final int valueRank;
        private final UaArrayDimensions arrayDimensions;
        private final boolean allowSubTypes;
        private final int javaClassDimensions;
        private final Class<?> compositeClass;
        private final UaNodeId encodeTypeId;

        private Fields(int n3, String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n4, UaArrayDimensions uaArrayDimensions, boolean bl2, int n5) {
            this.fieldIndex = n3;
            this.name = string2;
            this.javaClass = clazz;
            this.isOptional = bl;
            this.dataTypeId = uaNodeId;
            this.valueRank = n4;
            this.arrayDimensions = uaArrayDimensions;
            this.allowSubTypes = bl2;
            this.javaClassDimensions = n5;
            this.compositeClass = MultiDimensionArrayUtils.getComponentType(clazz);
            this.encodeTypeId = InternalStructureUtils.encodeTypeFor(this.compositeClass, bl2, uaNodeId);
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.arrayDimensions;
        }

        @Override
        public Class<?> getCompositeClass() {
            return this.compositeClass;
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.dataTypeId;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public UaNodeId getEncodeTypeId() {
            return this.encodeTypeId;
        }

        @Override
        public int getFieldIndex() {
            return this.fieldIndex;
        }

        @Override
        public Class<?> getJavaClass() {
            return this.javaClass;
        }

        @Override
        public int getJavaClassDimensions() {
            return this.javaClassDimensions;
        }

        @Override
        public int getMaxStringLength() {
            return 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getValueRank() {
            return this.valueRank;
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.allowSubTypes;
        }

        @Override
        public boolean isArray() {
            return this.javaClassDimensions != 0;
        }

        @Override
        public boolean isOptional() {
            return this.isOptional;
        }
    }
}

