/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=307")
public enum ApplicationType implements Enumeration
{
    Server(0),
    Client(1),
    ClientAndServer(2),
    DiscoveryServer(3);

    public static final EnumerationSpecification SPECIFICATION;
    public static final EnumSet<ApplicationType> NONE;
    public static final EnumSet<ApplicationType> ALL;
    private static final Map<Integer, ApplicationType> map;
    private final int value;

    private ApplicationType(int n3) {
        this.value = n3;
    }

    @Override
    public EnumerationSpecification specification() {
        return SPECIFICATION;
    }

    public static ApplicationType valueOf(int n2) {
        return map.get(n2);
    }

    public static ApplicationType valueOf(Integer n2) {
        return n2 == null ? null : ApplicationType.valueOf((int)n2);
    }

    public static ApplicationType valueOf(UnsignedInteger unsignedInteger) {
        return unsignedInteger == null ? null : ApplicationType.valueOf(unsignedInteger.intValue());
    }

    public static ApplicationType[] valueOf(int[] nArray) {
        ApplicationType[] applicationTypeArray = new ApplicationType[nArray.length];
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            applicationTypeArray[i2] = ApplicationType.valueOf(nArray[i2]);
        }
        return applicationTypeArray;
    }

    public static ApplicationType[] valueOf(Integer[] integerArray) {
        ApplicationType[] applicationTypeArray = new ApplicationType[integerArray.length];
        for (int i2 = 0; i2 < integerArray.length; ++i2) {
            applicationTypeArray[i2] = ApplicationType.valueOf(integerArray[i2]);
        }
        return applicationTypeArray;
    }

    public static ApplicationType[] valueOf(UnsignedInteger[] unsignedIntegerArray) {
        ApplicationType[] applicationTypeArray = new ApplicationType[unsignedIntegerArray.length];
        for (int i2 = 0; i2 < unsignedIntegerArray.length; ++i2) {
            applicationTypeArray[i2] = ApplicationType.valueOf(unsignedIntegerArray[i2]);
        }
        return applicationTypeArray;
    }

    public static UnsignedInteger getMask(ApplicationType ... applicationTypeArray) {
        int n2 = 0;
        for (ApplicationType applicationType : applicationTypeArray) {
            n2 |= applicationType.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static UnsignedInteger getMask(Collection<ApplicationType> collection) {
        int n2 = 0;
        for (ApplicationType applicationType : collection) {
            n2 |= applicationType.value;
        }
        return UnsignedInteger.getFromBits(n2);
    }

    public static EnumSet<ApplicationType> getSet(UnsignedInteger unsignedInteger) {
        return ApplicationType.getSet(unsignedInteger.intValue());
    }

    public static EnumSet<ApplicationType> getSet(int n2) {
        ArrayList<ApplicationType> arrayList = new ArrayList<ApplicationType>();
        for (ApplicationType applicationType : ApplicationType.values()) {
            if ((n2 & applicationType.value) != applicationType.value) continue;
            arrayList.add(applicationType);
        }
        return EnumSet.copyOf(arrayList);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        Builder builder = ApplicationType.builder();
        builder.setValue(this.getValue());
        return builder;
    }

    static {
        NONE = EnumSet.noneOf(ApplicationType.class);
        ALL = EnumSet.allOf(ApplicationType.class);
        map = new HashMap<Integer, ApplicationType>();
        for (ApplicationType applicationType : ApplicationType.values()) {
            map.put(applicationType.value, applicationType);
        }
        EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
        builder.setName("ApplicationType");
        builder.setJavaClass(ApplicationType.class);
        builder.setTypeId(UaIds.ApplicationType);
        builder.addMapping(0, "Server");
        builder.addMapping(1, "Client");
        builder.addMapping(2, "ClientAndServer");
        builder.addMapping(3, "DiscoveryServer");
        builder.setBuilderSupplier(new EnumerationSpecification.EnumerationBuilderSupplier(){

            @Override
            public Enumeration.Builder get() {
                return ApplicationType.builder();
            }
        });
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(ApplicationType.class, SPECIFICATION);
    }

    public static class Builder
    implements Enumeration.Builder {
        private ApplicationType value;

        private Builder() {
        }

        @Override
        public ApplicationType build() {
            return this.value;
        }

        @Override
        public Builder setValue(int n2) {
            this.value = ApplicationType.valueOf(n2);
            if (this.value == null) {
                throw new IllegalArgumentException("Unknown enum ApplicationType int value: " + n2);
            }
            return this;
        }
    }
}

