/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.core;

import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.TypeDefinitionId;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.AggregateConfiguration;
import com.prosysopc.ua.stack.core.MonitoringFilterResult;
import com.prosysopc.ua.stack.utils.InternalStructureUtils;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.util.function.Supplier;

@TypeDefinitionId(value="nsu=http://opcfoundation.org/UA/;i=737")
public class AggregateFilterResult
extends MonitoringFilterResult {
    public static final StructureSpecification SPECIFICATION;

    public AggregateFilterResult() {
        super((UaDataTypeSpecification)SPECIFICATION);
    }

    protected AggregateFilterResult(UaDataTypeSpecification uaDataTypeSpecification) {
        super(uaDataTypeSpecification);
    }

    public AggregateFilterResult(DateTime dateTime, Double d2, AggregateConfiguration aggregateConfiguration) {
        super((UaDataTypeSpecification)SPECIFICATION);
        this.setRevisedStartTime(dateTime);
        this.setRevisedProcessingInterval(d2);
        this.setRevisedAggregateConfiguration(aggregateConfiguration);
    }

    public DateTime getRevisedStartTime() {
        return (DateTime)this.indexGet(0);
    }

    public void setRevisedStartTime(DateTime dateTime) {
        this.indexSet(dateTime, 0);
    }

    public Double getRevisedProcessingInterval() {
        return (Double)this.indexGet(1);
    }

    public void setRevisedProcessingInterval(Double d2) {
        this.indexSet(d2, 1);
    }

    public AggregateConfiguration getRevisedAggregateConfiguration() {
        return (AggregateConfiguration)this.indexGet(2);
    }

    public void setRevisedAggregateConfiguration(AggregateConfiguration aggregateConfiguration) {
        this.indexSet(aggregateConfiguration, 2);
    }

    @Override
    public AggregateFilterResult clone() {
        return (AggregateFilterResult)super.clone();
    }

    public static Builder builder() {
        return new Builder(SPECIFICATION, () -> new AggregateFilterResult());
    }

    @Override
    public Builder toBuilder() {
        return (Builder)super.toBuilder();
    }

    static {
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.addField(Fields.RevisedStartTime);
        builder.addField(Fields.RevisedProcessingInterval);
        builder.addField(Fields.RevisedAggregateConfiguration);
        builder.setBinaryEncodeId(UaIds.AggregateFilterResult_DefaultBinary);
        builder.setXmlEncodeId(UaIds.AggregateFilterResult_DefaultXml);
        builder.setJsonEncodeId(UaIds.AggregateFilterResult_DefaultJson);
        builder.setTypeId(UaIds.AggregateFilterResult);
        builder.addSuperTypeId(UaIds.Structure);
        builder.addSuperTypeId(UaIds.MonitoringFilterResult);
        builder.setName("AggregateFilterResult");
        builder.setJavaClass(AggregateFilterResult.class);
        builder.setAbstract(false);
        builder.setStructureType(StructureSpecification.StructureType.NORMAL);
        builder.setBuilderSupplier(uaDataTypeSpecification -> new Builder((UaDataTypeSpecification)uaDataTypeSpecification, () -> new AggregateFilterResult((UaDataTypeSpecification)uaDataTypeSpecification)));
        SPECIFICATION = builder.build();
        InternalUaDataTypeSpecificationMappings.put(AggregateFilterResult.class, SPECIFICATION);
    }

    public static class Builder
    extends MonitoringFilterResult.Builder {
        protected Builder(UaDataTypeSpecification uaDataTypeSpecification, Supplier<? extends Structure> supplier) {
            super(uaDataTypeSpecification, supplier);
        }

        public DateTime getRevisedStartTime() {
            return (DateTime)this.indexGet(0);
        }

        public Builder setRevisedStartTime(DateTime dateTime) {
            this.indexSet(dateTime, 0);
            return this;
        }

        public Double getRevisedProcessingInterval() {
            return (Double)this.indexGet(1);
        }

        public Builder setRevisedProcessingInterval(Double d2) {
            this.indexSet(d2, 1);
            return this;
        }

        public AggregateConfiguration getRevisedAggregateConfiguration() {
            return (AggregateConfiguration)this.indexGet(2);
        }

        public Builder setRevisedAggregateConfiguration(AggregateConfiguration aggregateConfiguration) {
            this.indexSet(aggregateConfiguration, 2);
            return this;
        }

        @Override
        public AggregateFilterResult build() {
            return (AggregateFilterResult)super.build();
        }
    }

    public static enum Fields implements FieldSpecification
    {
        RevisedStartTime(0, "RevisedStartTime", DateTime.class, false, UaIds.UtcTime, -1, null, false, 0),
        RevisedProcessingInterval(1, "RevisedProcessingInterval", Double.class, false, UaIds.Duration, -1, null, false, 0),
        RevisedAggregateConfiguration(2, "RevisedAggregateConfiguration", AggregateConfiguration.class, false, UaIds.AggregateConfiguration, -1, null, false, 0);

        private final int fieldIndex;
        private final String name;
        private final Class<?> javaClass;
        private final boolean isOptional;
        private final UaNodeId dataTypeId;
        private final int valueRank;
        private final UaArrayDimensions arrayDimensions;
        private final boolean allowSubTypes;
        private final int javaClassDimensions;
        private final Class<?> compositeClass;
        private final UaNodeId encodeTypeId;

        private Fields(int n3, String string2, Class<?> clazz, boolean bl, UaNodeId uaNodeId, int n4, UaArrayDimensions uaArrayDimensions, boolean bl2, int n5) {
            this.fieldIndex = n3;
            this.name = string2;
            this.javaClass = clazz;
            this.isOptional = bl;
            this.dataTypeId = uaNodeId;
            this.valueRank = n4;
            this.arrayDimensions = uaArrayDimensions;
            this.allowSubTypes = bl2;
            this.javaClassDimensions = n5;
            this.compositeClass = MultiDimensionArrayUtils.getComponentType(clazz);
            this.encodeTypeId = InternalStructureUtils.encodeTypeFor(this.compositeClass, bl2, uaNodeId);
        }

        @Override
        public UaArrayDimensions getArrayDimensions() {
            return this.arrayDimensions;
        }

        @Override
        public Class<?> getCompositeClass() {
            return this.compositeClass;
        }

        @Override
        public UaNodeId getDataTypeId() {
            return this.dataTypeId;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public UaNodeId getEncodeTypeId() {
            return this.encodeTypeId;
        }

        @Override
        public int getFieldIndex() {
            return this.fieldIndex;
        }

        @Override
        public Class<?> getJavaClass() {
            return this.javaClass;
        }

        @Override
        public int getJavaClassDimensions() {
            return this.javaClassDimensions;
        }

        @Override
        public int getMaxStringLength() {
            return 0;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getValueRank() {
            return this.valueRank;
        }

        @Override
        public boolean isAllowSubTypes() {
            return this.allowSubTypes;
        }

        @Override
        public boolean isArray() {
            return this.javaClassDimensions != 0;
        }

        @Override
        public boolean isOptional() {
            return this.isOptional;
        }
    }
}

