/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.common;

import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.ServiceResult;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.StatusCodeDescriptions;
import com.prosysopc.ua.stack.core.StatusCodes;
import java.util.Arrays;
import java.util.Locale;

public class ServiceResultException
extends Exception {
    private static final long serialVersionUID = 988605552235028178L;
    protected final StatusCode statusCode;
    protected final String text;

    public ServiceResultException(int n2) {
        this(StatusCode.getFromBits(n2), StatusCodeDescriptions.getStatusCodeDescription(n2));
    }

    public ServiceResultException(int n2, String string) {
        this(StatusCode.getFromBits(n2), string);
    }

    public ServiceResultException(int n2, Throwable throwable, String string) {
        this(StatusCode.getFromBits(n2), throwable, string);
    }

    public ServiceResultException(StatusCode statusCode) {
        this(statusCode, statusCode.getDescription() != null ? statusCode.getDescription() : "");
    }

    public ServiceResultException(StatusCode statusCode, String string) {
        if (statusCode == null) {
            throw new IllegalArgumentException("statusCode is null");
        }
        this.statusCode = statusCode;
        this.text = string;
    }

    public ServiceResultException(StatusCode statusCode, Throwable throwable) {
        super(throwable.getMessage(), throwable);
        if (statusCode == null) {
            throw new IllegalArgumentException("statusCode is null");
        }
        this.statusCode = statusCode;
        this.text = statusCode.toString() + ", " + throwable.getMessage();
    }

    public ServiceResultException(StatusCode statusCode, Throwable throwable, String string) {
        super(string, throwable);
        if (statusCode == null) {
            throw new IllegalArgumentException("statusCode is null");
        }
        this.statusCode = statusCode;
        this.text = string;
    }

    public ServiceResultException(String string) {
        this(StatusCode.valueOf(StatusCodes.Bad_UnexpectedError), string);
    }

    public ServiceResultException(Throwable throwable) {
        super(throwable);
        this.statusCode = StatusCode.valueOf(StatusCodes.Bad_UnexpectedError);
        this.text = throwable.getMessage();
    }

    public ServiceResultException(UnsignedInteger unsignedInteger) {
        this(StatusCode.valueOf(unsignedInteger), StatusCodeDescriptions.getStatusCodeDescription(unsignedInteger.intValue()));
    }

    public ServiceResultException(UnsignedInteger unsignedInteger, String string) {
        this(StatusCode.valueOf(unsignedInteger), string);
    }

    public ServiceResultException(UnsignedInteger unsignedInteger, Throwable throwable) {
        super(throwable.getMessage(), throwable);
        if (unsignedInteger == null) {
            throw new IllegalArgumentException("statusCode is null");
        }
        this.statusCode = StatusCode.valueOf(unsignedInteger);
        this.text = unsignedInteger.toString() + ", " + throwable.getMessage();
    }

    public ServiceResultException(UnsignedInteger unsignedInteger, Throwable throwable, String string) {
        super(string, throwable);
        if (unsignedInteger == null) {
            throw new IllegalArgumentException("statusCode is null");
        }
        this.statusCode = StatusCode.valueOf(unsignedInteger);
        this.text = string;
    }

    public String getAdditionalTextField() {
        return this.text;
    }

    @Override
    public String getMessage() {
        if (this.text != null) {
            return String.format(Locale.ROOT, "%s (code=0x%08X, description=\"%s\")", this.statusCode.getName(), this.statusCode.getValueAsIntBits(), this.text);
        }
        return this.statusCode.toString();
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public ServiceResult toServiceResult() {
        ServiceResult serviceResult = new ServiceResult();
        serviceResult.setCode(this.statusCode);
        serviceResult.setSymbolicId(this.statusCode.toString());
        serviceResult.setLocalizedText(new LocalizedText(this.getMessage(), ""));
        serviceResult.setAdditionalInfo(Arrays.toString(this.getStackTrace()));
        return serviceResult;
    }
}

