/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.cert;

import com.prosysopc.ua.stack.cert.CertificateStore;
import com.prosysopc.ua.stack.cert.DefaultCertificateStoreListener;
import com.prosysopc.ua.stack.cert.ValidationResult;
import com.prosysopc.ua.stack.transport.security.Cert;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PkiDirectoryCertificateStore
implements CertificateStore {
    private static int sk = 100;
    private static final Logger logger = LoggerFactory.getLogger(PkiDirectoryCertificateStore.class);
    private static final String sl = ".der";
    private static final String sm = "0123456789ABCDEF";
    private final Map<String, Cert> sn = new ConcurrentHashMap<String, Cert>();
    private final Map<String, Cert> so = new ConcurrentHashMap<String, Cert>();
    private final Set<X509CRL> sp = new CopyOnWriteArraySet<X509CRL>();
    private final Map<Cert, String> sq = new ConcurrentHashMap<Cert, String>();
    private final File sr;
    private final File ss;
    private final File st;
    private final File su;
    private boolean sv = true;
    private int sw = sk;
    private List<String> sx = new ArrayList<String>();
    private final List<DefaultCertificateStoreListener> listeners = new ArrayList<DefaultCertificateStoreListener>();

    public static int getDefaultMaxStoredRejectedCertificates() {
        return sk;
    }

    public static void setDefaultMaxStoredRejectedCertificates(int n2) {
        if (n2 < -1) {
            throw new IllegalArgumentException("maxStoredRejectedCertificates cannot have any other negative value than -1");
        }
        sk = n2;
    }

    public PkiDirectoryCertificateStore() {
        this("PKI/CA", "certs", "rejected", "crl");
    }

    public PkiDirectoryCertificateStore(String string) {
        this(string, "certs", "rejected", "crl");
    }

    public PkiDirectoryCertificateStore(String string, String string2, String string3, String string4) {
        this.sr = new File(string);
        this.su = new File(string, string2);
        this.st = new File(string, string3);
        this.ss = new File(string, string4);
        this.init();
    }

    @Override
    public void addCertificate(ValidationResult validationResult, Cert cert) {
        if (validationResult == null) {
            throw new IllegalArgumentException("type cannot be null");
        }
        if (cert == null) {
            throw new IllegalArgumentException("certificate cannot be null");
        }
        switch (validationResult) {
            case AcceptPermanently: {
                this.addTrustedCertificate(cert);
                break;
            }
            case AcceptOnce: {
                if (!this.sv) break;
                this.addRejectedCertificate(cert);
                break;
            }
            case Reject: {
                this.addRejectedCertificate(cert);
                break;
            }
            default: {
                throw new IllegalArgumentException("encountered unknown type parameter: " + (Object)((Object)validationResult));
            }
        }
    }

    public void addListener(DefaultCertificateStoreListener defaultCertificateStoreListener) {
        if (defaultCertificateStoreListener != null && !this.listeners.contains(defaultCertificateStoreListener)) {
            this.listeners.add(defaultCertificateStoreListener);
        }
    }

    public synchronized void addRejectedCertificate(Cert cert) {
        if (this.sw == 0) {
            return;
        }
        String string = this.e(cert);
        this.a(this.sn, this.st, cert);
        this.b(this.so, this.su, cert);
        logger.info("Certificate '{}' added to rejected certificates.", (Object)string);
        if (this.sw > 0) {
            this.sx.add(string);
            logger.debug("addRejectedCertificate: rejectedCertificates.size()={}; maxStoredRejectedCertificates={}", (Object)this.sn.size(), (Object)this.sw);
            if (this.sn.size() > this.sw) {
                String string2 = this.sx.remove(0);
                Cert cert2 = this.sn.get(string2);
                logger.info("Pruning rejected certificate '{}'", (Object)string2);
                this.b(this.sn, this.st, cert2);
            }
        }
        this.c(cert);
    }

    public synchronized void addRevocationList(X509CRL x509CRL) {
        this.sp.add(x509CRL);
        this.a(x509CRL);
    }

    public synchronized void addTrustedCertificate(Cert cert) {
        String string = this.e(cert);
        logger.debug("addTrustedCertificate");
        this.a(this.so, this.su, cert);
        if (this.sw != 0) {
            this.b(this.sn, this.st, cert);
            if (this.sw > 0) {
                this.sx.remove(string);
            }
        }
        logger.info("Certificate '{}' added to trusted certificates.", (Object)string);
        this.d(cert);
    }

    public synchronized void removeCertificate(Cert cert) {
        String string = this.e(cert);
        if (this.so.containsKey(string)) {
            this.b(this.so, this.su, cert);
        } else {
            this.b(this.sn, this.st, cert);
        }
        logger.info("Certificate '{}' removed", (Object)string);
    }

    public synchronized void clear(boolean bl) {
        if (bl) {
            for (File file : this.su.listFiles()) {
                file.delete();
            }
            for (File file : this.st.listFiles()) {
                file.delete();
            }
            for (File file : this.ss.listFiles()) {
                file.delete();
            }
        }
        this.so.clear();
        this.sn.clear();
        this.sq.clear();
    }

    public File getBaseDir() {
        return this.sr;
    }

    public File getFileForCert(Cert cert) {
        if (cert == null) {
            return null;
        }
        if (this.so.containsKey(this.e(cert))) {
            return this.a(this.su, cert);
        }
        if (this.sn.containsKey(this.e(cert))) {
            return this.a(this.st, cert);
        }
        return null;
    }

    @Override
    public synchronized Set<Cert> getRejectedCerts() {
        this.init();
        HashSet<Cert> hashSet = new HashSet<Cert>();
        for (Map.Entry<String, Cert> entry : this.sn.entrySet()) {
            hashSet.add(entry.getValue());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public File getRejectedDir() {
        return this.st;
    }

    public File getRevocationDir() {
        return this.ss;
    }

    @Override
    public synchronized Set<X509CRL> getRevocationLists() {
        this.init();
        HashSet<X509CRL> hashSet = new HashSet<X509CRL>();
        for (X509CRL x509CRL : this.sp) {
            hashSet.add(x509CRL);
        }
        return Collections.unmodifiableSet(hashSet);
    }

    @Override
    public synchronized Set<Cert> getTrustedCerts() {
        this.init();
        HashSet<Cert> hashSet = new HashSet<Cert>();
        for (Map.Entry<String, Cert> entry : this.so.entrySet()) {
            hashSet.add(entry.getValue());
        }
        return Collections.unmodifiableSet(hashSet);
    }

    public File getTrustedDir() {
        return this.su;
    }

    public boolean isStoreAcceptOnceCertificates() {
        return this.sv;
    }

    public synchronized void refresh() {
        this.init();
    }

    public void removeListener(DefaultCertificateStoreListener defaultCertificateStoreListener) {
        if (defaultCertificateStoreListener != null) {
            this.listeners.remove(defaultCertificateStoreListener);
        }
    }

    public synchronized int getMaxStoredRejectedCertificates() {
        return this.sw;
    }

    public synchronized void setMaxStoredRejectedCertificates(int n2) {
        if (n2 < -1) {
            throw new IllegalArgumentException("maxStoredRejectedCertificates cannot have any other negative value than -1");
        }
        this.sw = n2;
    }

    public void setStoreAcceptOnceCertificates(boolean bl) {
        this.sv = bl;
    }

    private void c(Cert cert) {
        for (DefaultCertificateStoreListener defaultCertificateStoreListener : this.listeners) {
            defaultCertificateStoreListener.onRejectedCertificateAdded(cert);
        }
    }

    private void a(X509CRL x509CRL) {
        for (DefaultCertificateStoreListener defaultCertificateStoreListener : this.listeners) {
            defaultCertificateStoreListener.onRevokedListAdded(x509CRL);
        }
    }

    private void d(Cert cert) {
        for (DefaultCertificateStoreListener defaultCertificateStoreListener : this.listeners) {
            defaultCertificateStoreListener.onTrustedCertificateAdded(cert);
        }
    }

    private String e(Cert cert) {
        return this.a(cert.getEncodedThumbprint());
    }

    private File a(File file, Cert cert) {
        String string = this.sq.get(cert);
        if (string != null) {
            return new File(file, string);
        }
        return new File(file, this.e(cert) + sl);
    }

    private String a(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (byte by : byArray) {
            stringBuilder.append(sm.charAt((by & 0xF0) >> 4)).append(sm.charAt(by & 0xF));
        }
        return stringBuilder.toString();
    }

    private synchronized void init() {
        this.clear(false);
        this.a(this.so, this.su, this.sn);
        this.a(this.sn, this.st, this.so);
        if (!this.sn.isEmpty() && this.sw == 0) {
            for (Cert cert : this.sn.values()) {
                logger.info("Pruning rejected certificate '{}'", (Object)this.e(cert));
                this.b(this.sn, this.st, cert);
            }
            this.sx.clear();
        }
        this.ctj();
    }

    /*
     * WARNING - void declaration
     */
    private void a(Map<String, Cert> map, File file, Map<String, Cert> map2) {
        if (!file.exists()) {
            file.mkdirs();
        }
        ArrayList<Object> arrayList = null;
        if (map == this.sn && this.sw != 0 && this.sw > 0) {
            arrayList = new ArrayList<Object>();
        }
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                try {
                    Cert cert = Cert.load(file2);
                    String string = this.e(cert);
                    this.sq.put(cert, file2.getName());
                    this.a(map, file, cert);
                    logger.debug("Initialized cert from file: {}", (Object)file2);
                    if (map2 != null) {
                        map2.remove(string);
                    }
                    if (arrayList == null) continue;
                    arrayList.add(new Object[]{cert, string, file2.lastModified()});
                }
                catch (IOException iOException) {
                    logger.info("File '{}' is not a certificate: {}", (Object)file2, (Object)iOException.getMessage());
                }
                catch (CertificateException certificateException) {
                    logger.info("File '{}' is not a valid certificate: {}", (Object)file2, (Object)certificateException.getMessage());
                }
            }
        }
        if (arrayList != null) {
            arrayList.sort(Comparator.comparingLong(object -> (Long)((Object[])object)[2]).reversed());
            logger.debug("initCertificates: rejectedCertificates.size()={}; maxStoredRejectedCertificates={}", (Object)this.sn.size(), (Object)this.sw);
            if (this.sn.size() > this.sw) {
                int n2 = this.sn.size() - this.sw;
                int objectArray = arrayList.size() - 1;
                while (n2 > 0) {
                    void var6_9;
                    Object[] objectArray2 = (Object[])arrayList.remove((int)var6_9);
                    Cert cert = (Cert)objectArray2[0];
                    logger.info("Pruning rejected certificate '{}'", objectArray2[1]);
                    this.b(map, file, cert);
                    --n2;
                    --var6_9;
                }
            }
            this.sx.clear();
            for (Object[] objectArray : arrayList) {
                this.sx.add((String)objectArray[1]);
            }
        }
    }

    private void b(File file) {
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            FileInputStream fileInputStream = new FileInputStream(file);
            X509CRL x509CRL = (X509CRL)certificateFactory.generateCRL(fileInputStream);
            this.sp.add(x509CRL);
            logger.info("CRL initialized from " + file + ": " + (x509CRL.getRevokedCertificates() == null ? "no revoked certificates" : x509CRL.getRevokedCertificates().size() + " certificates revoked"));
        }
        catch (Exception exception) {
            logger.warn("Could not read CRL file {: {}", (Object)file, (Object)exception.getMessage());
        }
    }

    private void ctj() {
        if (!this.ss.exists()) {
            this.ss.mkdirs();
        }
        if (this.ss.isDirectory()) {
            for (File file : this.ss.listFiles()) {
                if (file.getName().endsWith(".crl")) {
                    this.b(file);
                    continue;
                }
                logger.warn("Revocation folder contains something else than .crl file, found: {}", (Object)file.getAbsolutePath());
            }
        } else {
            logger.warn("revocationDir: {} is not a directory", (Object)this.ss.getAbsolutePath());
        }
    }

    private void a(Map<String, Cert> map, File file, Cert cert) {
        String string = this.e(cert);
        logger.debug("listAdd: cert={}; dir={}", (Object)string, (Object)file);
        if (!map.containsKey(string)) {
            try {
                File file2 = this.a(file, cert);
                if (!file2.exists()) {
                    cert.save(file2);
                }
            }
            catch (IOException iOException) {
                logger.error("Cannot write to directory " + file, iOException);
            }
            map.put(string, cert);
        }
        logger.debug("certificates.size()={}", (Object)map.size());
    }

    private void b(Map<String, Cert> map, File file, Cert cert) {
        logger.debug("removeCertificate: cert={} dir={}", (Object)this.e(cert), (Object)file);
        logger.debug("certificates.size()={}", (Object)map.size());
        File file2 = this.a(file, cert);
        file2.delete();
        Cert cert2 = map.remove(this.e(cert));
        if (logger.isDebugEnabled()) {
            logger.debug("c=" + (cert2 == null ? "null" : (Object)cert2.getEncodedThumbprint()));
            logger.debug("certificates.size()={}", (Object)map.size());
        }
    }
}

