/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.cert;

import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.cert.CertificateCheck;
import com.prosysopc.ua.stack.cert.CertificateStore;
import com.prosysopc.ua.stack.cert.DefaultCertificateValidatorListener;
import com.prosysopc.ua.stack.cert.ValidationResult;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.utils.CertificateUtils;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCertificateValidator
implements CertificateValidator {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCertificateValidator.class);
    private static final String sa = "invalid URI name:";
    private static final int sc = 0;
    private static final int sd = 1;
    private volatile DefaultCertificateValidatorListener se;
    private final CertificateStore sf;
    private final CertificateStore sg;
    private final Set<IgnoredChecks> sh = new CopyOnWriteArraySet<IgnoredChecks>();

    public DefaultCertificateValidator(CertificateStore certificateStore) {
        this.sf = certificateStore;
        this.sg = null;
    }

    public DefaultCertificateValidator(CertificateStore certificateStore, CertificateStore certificateStore2) {
        this.sf = certificateStore;
        this.sg = certificateStore2;
    }

    public CertificateStore getCertificateStore() {
        return this.sf;
    }

    public Set<IgnoredChecks> getIgnoredChecks() {
        return this.sh;
    }

    public CertificateStore getIssuersCertificateStore() {
        return this.sg;
    }

    public DefaultCertificateValidatorListener getValidationListener() {
        return this.se;
    }

    @Deprecated
    public boolean isRevocationListsRequired() {
        return !this.a(IgnoredChecks.IGNORE_CA_MISSING_CRL);
    }

    @Deprecated
    public void setRevocationListsRequired(boolean bl) {
        if (bl) {
            this.getIgnoredChecks().remove((Object)IgnoredChecks.IGNORE_CA_MISSING_CRL);
        } else {
            this.getIgnoredChecks().add(IgnoredChecks.IGNORE_CA_MISSING_CRL);
        }
    }

    public void setValidationListener(DefaultCertificateValidatorListener defaultCertificateValidatorListener) {
        this.se = defaultCertificateValidatorListener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public StatusCode validateCertificate(ApplicationDescription applicationDescription, Cert cert) {
        try {
            Object object;
            boolean bl;
            boolean bl2;
            logger.debug("validateCertificate: applicationDescription={}", (Object)applicationDescription);
            logger.debug("cert={}", (Object)cert);
            if (cert.certificate.getVersion() != 3) {
                logger.error("Certificate Versions is {}, must be 3", (Object)cert.certificate.getVersion());
                return StatusCode.valueOf(StatusCodes.Bad_CertificateUseNotAllowed);
            }
            if (!this.a(IgnoredChecks.IGNORE_KEYUSAGE_CHECKS)) {
                if (cert.certificate.getKeyUsage() == null) {
                    logger.error("Cert has no key usage extension: {}", (Object)cert);
                    return StatusCode.valueOf(StatusCodes.Bad_CertificateInvalid);
                }
                bl2 = cert.certificate.getKeyUsage()[0];
                boolean bl3 = cert.certificate.getKeyUsage()[1];
                if (!bl2 || !bl3) {
                    logger.error("digitalSignature and/or nonRepudiation key usage bits are not set to true: {}", (Object)cert);
                    return StatusCode.valueOf(StatusCodes.Bad_CertificateUseNotAllowed);
                }
            } else if (cert.certificate.getKeyUsage() == null) {
                logger.warn("Cert has no key usage extension: {}", (Object)cert);
            }
            bl2 = this.a(cert);
            logger.debug("isRevoked={}", (Object)bl2);
            if (bl2) {
                return StatusCode.valueOf(StatusCodes.Bad_CertificateRevoked);
            }
            StatusCode statusCode = StatusCode.GOOD;
            EnumSet<CertificateCheck> enumSet = EnumSet.noneOf(CertificateCheck.class);
            Set<Cert> set = this.sf.getTrustedCerts();
            if (set != null && set.contains(cert)) {
                logger.debug("trusted=yes");
                enumSet.add(CertificateCheck.Trusted);
            }
            logger.debug("trusted={}", (Object)enumSet.contains((Object)CertificateCheck.Trusted));
            X509Certificate x509Certificate = cert.getCertificate();
            try {
                x509Certificate.checkValidity();
                logger.debug("valid=yes");
                enumSet.add(CertificateCheck.Validity);
            }
            catch (CertificateExpiredException certificateExpiredException) {
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                // empty catch block
            }
            logger.debug("valid={}", (Object)enumSet.contains((Object)CertificateCheck.Validity));
            try {
                x509Certificate.verify(x509Certificate.getPublicKey());
                logger.debug("signature=yes");
                logger.debug("self-signed=yes");
                enumSet.add(CertificateCheck.Signature);
                enumSet.add(CertificateCheck.SelfSigned);
            }
            catch (GeneralSecurityException generalSecurityException) {
                StatusCode statusCode2;
                PublicKey publicKey;
                bl = false;
                for (Cert cert2 : set) {
                    try {
                        publicKey = cert2.getCertificate().getPublicKey();
                        x509Certificate.verify(publicKey);
                        bl = true;
                        statusCode2 = this.b(cert2);
                        if (statusCode2.isStatusCode(StatusCodes.Bad_CertificateRevoked)) {
                            statusCode = StatusCode.valueOf(StatusCodes.Bad_CertificateIssuerRevoked);
                            continue;
                        }
                        if (statusCode2.isStatusCode(StatusCodes.Bad_CertificateTimeInvalid)) {
                            statusCode = StatusCode.valueOf(StatusCodes.Bad_CertificateIssuerTimeInvalid);
                            continue;
                        }
                        if (statusCode2.isStatusCode(StatusCodes.Bad_CertificateChainIncomplete) || statusCode2.isStatusCode(StatusCodes.Bad_CertificateIssuerRevoked) || statusCode2.isStatusCode(StatusCodes.Bad_CertificateIssuerTimeInvalid)) {
                            statusCode = statusCode2;
                            continue;
                        }
                        if (statusCode2.isStatusCode(StatusCodes.Bad_CertificateRevocationUnknown) || statusCode2.isStatusCode(StatusCodes.Bad_CertificateIssuerRevocationUnknown)) {
                            statusCode = statusCode2;
                            continue;
                        }
                        if (!statusCode2.isNotGood()) continue;
                        statusCode = StatusCode.valueOf(StatusCodes.Bad_CertificateInvalid);
                    }
                    catch (GeneralSecurityException generalSecurityException2) {}
                }
                if (this.sg != null && !bl) {
                    for (Cert cert3 : this.sg.getTrustedCerts()) {
                        try {
                            publicKey = cert3.getCertificate().getPublicKey();
                            x509Certificate.verify(publicKey);
                            bl = true;
                            statusCode2 = this.b(cert3);
                            if (statusCode2.isStatusCode(StatusCodes.Bad_CertificateRevoked)) {
                                statusCode = StatusCode.valueOf(StatusCodes.Bad_CertificateIssuerRevoked);
                                continue;
                            }
                            if (statusCode2.isStatusCode(StatusCodes.Bad_CertificateTimeInvalid)) {
                                statusCode = StatusCode.valueOf(StatusCodes.Bad_CertificateIssuerTimeInvalid);
                                continue;
                            }
                            if (statusCode2.isStatusCode(StatusCodes.Bad_CertificateChainIncomplete) || statusCode2.isStatusCode(StatusCodes.Bad_CertificateIssuerRevoked) || statusCode2.isStatusCode(StatusCodes.Bad_CertificateIssuerTimeInvalid)) {
                                statusCode = statusCode2;
                                continue;
                            }
                            if (statusCode2.isStatusCode(StatusCodes.Bad_CertificateRevocationUnknown) || statusCode2.isStatusCode(StatusCodes.Bad_CertificateIssuerRevocationUnknown)) {
                                statusCode = StatusCode.valueOf(StatusCodes.Bad_CertificateIssuerRevocationUnknown);
                                continue;
                            }
                            if (!statusCode2.isNotGood()) continue;
                            statusCode = StatusCode.valueOf(StatusCodes.Bad_CertificateInvalid);
                        }
                        catch (GeneralSecurityException generalSecurityException3) {}
                    }
                } else if (bl) {
                    enumSet.add(CertificateCheck.Trusted);
                }
                if (!bl) {
                    statusCode = StatusCode.valueOf(StatusCodes.Bad_CertificateChainIncomplete);
                }
                if (statusCode.isNotGood()) {
                    if (set == null) return statusCode;
                    if (set.contains(cert)) return statusCode;
                    this.sf.addCertificate(ValidationResult.Reject, cert);
                    return statusCode;
                }
                logger.debug("signature=yes");
                enumSet.add(CertificateCheck.Signature);
            }
            logger.debug("signature={}", (Object)enumSet.contains((Object)CertificateCheck.Signature));
            logger.debug("self-signed={}", (Object)enumSet.contains((Object)CertificateCheck.SelfSigned));
            String string = applicationDescription == null ? null : applicationDescription.getApplicationUri();
            boolean bl4 = bl = string == null;
            if (!bl) {
                try {
                    object = CertificateUtils.getApplicationUriOfCertificate(x509Certificate);
                    if (((String)object).equals(string)) {
                        bl = true;
                    }
                }
                catch (CertificateParsingException certificateParsingException) {
                    if (certificateParsingException.getCause().getMessage().contains(sa)) {
                        String[] stringArray = certificateParsingException.getCause().getMessage().split(sa);
                        if (stringArray.length == 2 && stringArray[1].equals(string)) {
                            logger.warn("The provided certificate contains an invalid ApplicationURI: {}", (Object)stringArray[1]);
                            enumSet.add(CertificateCheck.Uri);
                        } else {
                            logger.warn("The provided certificate does not define the ApplicationURI", certificateParsingException);
                        }
                    }
                    logger.warn("The provided certificate has an invalid SubjectAlternativeNames field", certificateParsingException);
                }
            }
            if (bl) {
                enumSet.add(CertificateCheck.Uri);
                enumSet.add(CertificateCheck.UriValid);
            }
            logger.debug("uri={}", (Object)enumSet.contains((Object)CertificateCheck.Uri));
            logger.debug("uriValid={}", (Object)enumSet.contains((Object)CertificateCheck.UriValid));
            object = this.a(cert, applicationDescription, enumSet);
            logger.debug("action={}", object);
            switch (1.si[((Enum)object).ordinal()]) {
                case 1: {
                    statusCode = StatusCode.GOOD;
                    this.sf.addCertificate(ValidationResult.AcceptPermanently, cert);
                    return statusCode;
                }
                case 2: {
                    statusCode = StatusCode.GOOD;
                    this.sf.addCertificate(ValidationResult.AcceptOnce, cert);
                    return statusCode;
                }
                case 3: {
                    if (!enumSet.contains((Object)CertificateCheck.Trusted)) {
                        statusCode = StatusCode.valueOf(StatusCodes.Bad_SecurityChecksFailed);
                    } else if (!enumSet.contains((Object)CertificateCheck.Signature)) {
                        statusCode = StatusCode.valueOf(StatusCodes.Bad_SecurityChecksFailed);
                    } else if (!enumSet.contains((Object)CertificateCheck.Validity)) {
                        statusCode = StatusCode.valueOf(StatusCodes.Bad_CertificateTimeInvalid);
                    } else if (!enumSet.contains((Object)CertificateCheck.Uri)) {
                        statusCode = StatusCode.valueOf(StatusCodes.Bad_CertificateUriInvalid);
                    } else {
                        logger.warn("Rejected a certificate which did contain passedchecks: {}", (Object)enumSet);
                        statusCode = StatusCode.valueOf(StatusCodes.Bad_SecurityChecksFailed);
                    }
                    if (set == null) return statusCode;
                    if (set.contains(cert)) return statusCode;
                    this.sf.addCertificate(ValidationResult.Reject, cert);
                    return statusCode;
                }
            }
            throw new RuntimeException("Encountered unknown enum value for ValidatiorResult: " + object);
        }
        catch (RuntimeException runtimeException) {
            logger.error("error while validating certificates", runtimeException);
            return StatusCode.valueOf(StatusCodes.Bad_InternalError);
        }
    }

    @Override
    public StatusCode validateCertificate(Cert cert) {
        logger.debug("validateCertificate: Cert={}", (Object)cert);
        if (cert == null) {
            return StatusCode.GOOD;
        }
        return this.validateCertificate(null, cert);
    }

    private ValidationResult a(Cert cert, ApplicationDescription applicationDescription, EnumSet<CertificateCheck> enumSet) {
        DefaultCertificateValidatorListener defaultCertificateValidatorListener = this.se;
        if (defaultCertificateValidatorListener != null) {
            return defaultCertificateValidatorListener.onValidate(cert, applicationDescription, enumSet);
        }
        if (enumSet.containsAll(CertificateCheck.COMPULSORY)) {
            return ValidationResult.AcceptPermanently;
        }
        return ValidationResult.Reject;
    }

    private boolean a(IgnoredChecks ignoredChecks) {
        return this.sh.contains((Object)ignoredChecks);
    }

    private boolean a(Cert cert) {
        Set<X509CRL> set = this.sf.getRevocationLists();
        for (X509CRL object : set) {
            if (!object.isRevoked(cert.getCertificate())) continue;
            return true;
        }
        if (this.sg != null) {
            Set<X509CRL> set2 = this.sg.getRevocationLists();
            Iterator iterator = set2.iterator();
            while (iterator.hasNext()) {
                X509CRL x509CRL = (X509CRL)iterator.next();
                if (!x509CRL.isRevoked(cert.getCertificate())) continue;
                return true;
            }
        }
        return false;
    }

    StatusCode b(Cert cert) {
        try {
            logger.debug("issuerCert={}", (Object)cert);
            if (cert.certificate.getVersion() == 3) {
                if (!this.a(IgnoredChecks.IGNORE_KEYUSAGE_CHECKS)) {
                    if (cert.certificate.getKeyUsage() == null) {
                        logger.error("Issuer Cert has no key usage extension: {}, cert");
                        return StatusCode.valueOf(StatusCodes.Bad_CertificateInvalid);
                    }
                } else if (cert.certificate.getKeyUsage() == null) {
                    logger.warn("Issuer Cert has no key usage extension: {}", (Object)cert);
                }
            } else {
                logger.error("Certificate Versions is {}, must be 3", (Object)cert.certificate.getVersion());
                return StatusCode.valueOf(StatusCodes.Bad_CertificateUseNotAllowed);
            }
            boolean bl = this.a(cert);
            logger.debug("isRevoked={}", (Object)bl);
            if (bl) {
                return StatusCode.valueOf(StatusCodes.Bad_CertificateIssuerRevoked);
            }
            StatusCode statusCode = StatusCode.GOOD;
            EnumSet<CertificateCheck> enumSet = EnumSet.noneOf(CertificateCheck.class);
            Set<Cert> set = this.sf.getTrustedCerts();
            if (set != null && set.contains(cert)) {
                logger.debug("trusted=yes");
                enumSet.add(CertificateCheck.Trusted);
            }
            logger.debug("trusted={}", (Object)enumSet.contains((Object)CertificateCheck.Trusted));
            X509Certificate x509Certificate = cert.getCertificate();
            try {
                x509Certificate.checkValidity();
                logger.debug("valid=yes");
                enumSet.add(CertificateCheck.Validity);
            }
            catch (CertificateExpiredException certificateExpiredException) {
                return StatusCode.valueOf(StatusCodes.Bad_CertificateTimeInvalid);
            }
            catch (CertificateNotYetValidException certificateNotYetValidException) {
                return StatusCode.valueOf(StatusCodes.Bad_CertificateTimeInvalid);
            }
            logger.debug("valid={}", (Object)enumSet.contains((Object)CertificateCheck.Validity));
            try {
                x509Certificate.verify(x509Certificate.getPublicKey());
                logger.debug("signature=yes");
                logger.debug("self-signed=yes");
                enumSet.add(CertificateCheck.Signature);
                enumSet.add(CertificateCheck.SelfSigned);
                boolean bl2 = false;
                if (this.sf.getTrustedCerts().contains(cert)) {
                    for (X509CRL x509CRL : this.sf.getRevocationLists()) {
                        if (!x509CRL.getIssuerDN().equals(cert.certificate.getIssuerDN())) continue;
                        bl2 = true;
                    }
                } else if (this.sg != null) {
                    for (X509CRL x509CRL : this.sg.getRevocationLists()) {
                        if (!x509CRL.getIssuerDN().equals(cert.certificate.getIssuerDN())) continue;
                        bl2 = true;
                    }
                }
                if (!bl2 && !this.a(IgnoredChecks.IGNORE_CA_MISSING_CRL)) {
                    statusCode = StatusCode.valueOf(StatusCodes.Bad_CertificateRevocationUnknown);
                    return statusCode;
                }
            }
            catch (GeneralSecurityException generalSecurityException) {
                StatusCode statusCode2;
                PublicKey publicKey;
                boolean bl3 = false;
                for (Cert cert2 : set) {
                    try {
                        publicKey = cert2.getCertificate().getPublicKey();
                        x509Certificate.verify(publicKey);
                        bl3 = true;
                        statusCode2 = this.b(cert2);
                        if (statusCode2.isStatusCode(StatusCodes.Bad_CertificateRevoked)) {
                            statusCode = StatusCode.valueOf(StatusCodes.Bad_CertificateIssuerRevoked);
                            continue;
                        }
                        if (statusCode2.isStatusCode(StatusCodes.Bad_CertificateTimeInvalid)) {
                            statusCode = StatusCode.valueOf(StatusCodes.Bad_CertificateIssuerTimeInvalid);
                            continue;
                        }
                        if (statusCode2.isStatusCode(StatusCodes.Bad_CertificateChainIncomplete) || statusCode2.isStatusCode(StatusCodes.Bad_CertificateIssuerRevoked) || statusCode2.isStatusCode(StatusCodes.Bad_CertificateIssuerTimeInvalid)) {
                            statusCode = statusCode2;
                            continue;
                        }
                        if (statusCode2.isStatusCode(StatusCodes.Bad_CertificateRevocationUnknown) || statusCode2.isStatusCode(StatusCodes.Bad_CertificateIssuerRevocationUnknown)) {
                            statusCode = statusCode2;
                            continue;
                        }
                        if (!statusCode2.isNotGood()) continue;
                        statusCode = StatusCode.valueOf(StatusCodes.Bad_CertificateInvalid);
                    }
                    catch (GeneralSecurityException generalSecurityException2) {}
                }
                if (this.sg != null && !bl3) {
                    for (Cert cert2 : this.sg.getTrustedCerts()) {
                        try {
                            publicKey = cert2.getCertificate().getPublicKey();
                            x509Certificate.verify(publicKey);
                            bl3 = true;
                            statusCode2 = this.b(cert2);
                            if (statusCode2.isStatusCode(StatusCodes.Bad_CertificateRevoked)) {
                                statusCode = StatusCode.valueOf(StatusCodes.Bad_CertificateIssuerRevoked);
                                continue;
                            }
                            if (statusCode2.isStatusCode(StatusCodes.Bad_CertificateTimeInvalid)) {
                                statusCode = StatusCode.valueOf(StatusCodes.Bad_CertificateIssuerTimeInvalid);
                                continue;
                            }
                            if (statusCode2.isStatusCode(StatusCodes.Bad_CertificateChainIncomplete) || statusCode2.isStatusCode(StatusCodes.Bad_CertificateIssuerRevoked) || statusCode2.isStatusCode(StatusCodes.Bad_CertificateIssuerTimeInvalid)) {
                                statusCode = statusCode2;
                                continue;
                            }
                            if (statusCode2.isStatusCode(StatusCodes.Bad_CertificateRevocationUnknown) || statusCode2.isStatusCode(StatusCodes.Bad_CertificateIssuerRevocationUnknown)) {
                                statusCode = StatusCode.valueOf(StatusCodes.Bad_CertificateIssuerRevocationUnknown);
                                continue;
                            }
                            if (!statusCode2.isNotGood()) continue;
                            statusCode = StatusCode.valueOf(StatusCodes.Bad_CertificateInvalid);
                        }
                        catch (GeneralSecurityException generalSecurityException3) {}
                    }
                    if (!bl3) {
                        statusCode = StatusCode.valueOf(StatusCodes.Bad_CertificateChainIncomplete);
                    }
                } else if (this.sg == null && !bl3) {
                    statusCode = StatusCode.valueOf(StatusCodes.Bad_CertificateChainIncomplete);
                } else if (bl3) {
                    enumSet.add(CertificateCheck.Trusted);
                }
                if (statusCode.isNotGood()) {
                    return statusCode;
                }
                logger.debug("signature=yes");
                enumSet.add(CertificateCheck.Signature);
                enumSet.add(CertificateCheck.Trusted);
            }
            logger.debug("issuer signature={}", (Object)enumSet.contains((Object)CertificateCheck.Signature));
            logger.debug("issuer self-signed={}", (Object)enumSet.contains((Object)CertificateCheck.SelfSigned));
            return statusCode;
        }
        catch (RuntimeException runtimeException) {
            logger.error("Error while validating certificate chain", runtimeException);
            return StatusCode.valueOf(StatusCodes.Bad_InternalError);
        }
    }

    public static enum IgnoredChecks {
        IGNORE_CA_MISSING_CRL,
        IGNORE_KEYUSAGE_CHECKS;

    }
}

