/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.BitField;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaNamespaceTranslateable;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.ValueRanks;
import com.prosysopc.ua.function.CheckedFunction;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.builtintypes.a;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.OptionSetStructure;
import com.prosysopc.ua.typedictionary.OptionSetStructureSpecification;
import com.prosysopc.ua.typedictionary.OptionSpecification;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Variant
implements UaNamespaceTranslateable<Variant>,
Cloneable {
    private static final Logger logger = LoggerFactory.getLogger(Variant.class);
    private static final Set<Class<?>> validFinalClasses;
    public static final Variant NULL;
    public static final Variant[] EMPTY_ARRAY;
    private Object value;
    private final Class<?> compositeClass;
    private final int valueClassDimensions;

    public static Object[] asObjectArray(Variant ... variantArray) {
        if (variantArray == null) {
            return null;
        }
        if (variantArray.length == 0) {
            return new Object[0];
        }
        Object[] objectArray = new Object[variantArray.length];
        for (int i2 = 0; i2 < variantArray.length; ++i2) {
            objectArray[i2] = variantArray[i2] == null ? null : variantArray[i2].getValue();
        }
        return objectArray;
    }

    public static Variant[] asVariantArray(Object ... objectArray) {
        if (objectArray == null) {
            return null;
        }
        if (objectArray.length == 0) {
            return new Variant[0];
        }
        Variant[] variantArray = new Variant[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            variantArray[i2] = new Variant(objectArray[i2]);
        }
        return variantArray;
    }

    public static Variant defaultValue(Class<?> clazz) {
        return Variant.defaultValue(clazz, -1);
    }

    public static Variant defaultValue(Class<?> clazz, int n2) {
        return new Variant(a.a(clazz, ValueRanks.minimumArrayDimensions(n2)));
    }

    public static Variant defaultValue(Class<?> clazz, UaArrayDimensions uaArrayDimensions) {
        return new Variant(a.a(clazz, uaArrayDimensions));
    }

    public static Variant defaultValue(Class<?> clazz, UnsignedInteger[] unsignedIntegerArray) {
        return Variant.defaultValue(clazz, UaArrayDimensions.valueOf(unsignedIntegerArray));
    }

    public static Variant defaultValue(EncoderContext encoderContext, UaNodeId uaNodeId) {
        return Variant.defaultValue(encoderContext, uaNodeId, -1);
    }

    public static Variant defaultValue(EncoderContext encoderContext, UaNodeId uaNodeId, int n2) {
        return new Variant(a.a(encoderContext, uaNodeId, ValueRanks.minimumArrayDimensions(n2)));
    }

    public static Variant defaultValue(EncoderContext encoderContext, UaNodeId uaNodeId, UaArrayDimensions uaArrayDimensions) {
        return new Variant(a.a(encoderContext, uaNodeId, uaArrayDimensions));
    }

    public static Variant defaultValue(EncoderContext encoderContext, UaNodeId uaNodeId, UnsignedInteger[] unsignedIntegerArray) {
        return Variant.defaultValue(encoderContext, uaNodeId, UaArrayDimensions.valueOf(unsignedIntegerArray));
    }

    private static Object byteArraysToByteStrings(Object object) {
        Class<?> clazz = object.getClass();
        if (byte[].class.isAssignableFrom(clazz)) {
            return ByteString.valueOf((byte[])object);
        }
        if (byte[][].class.isAssignableFrom(clazz)) {
            byte[][] byArray = (byte[][])object;
            ByteString[] byteStringArray = new ByteString[byArray.length];
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                byteStringArray[i2] = ByteString.valueOf(byArray[i2]);
            }
            return byteStringArray;
        }
        int[] nArray = Variant.calculateArrayDimensions(object, true);
        MultiDimensionArrayUtils.ArrayIterator arrayIterator = MultiDimensionArrayUtils.arrayIterator(object, nArray);
        ArrayList<ByteString> arrayList = new ArrayList<ByteString>();
        while (arrayIterator.hasNext()) {
            arrayList.add(ByteString.valueOf((byte[])arrayIterator.next()));
        }
        return MultiDimensionArrayUtils.demuxArray((Object)arrayList.toArray(), nArray, ByteString.class);
    }

    private static int[] calculateArrayDimensions(Object object, boolean bl) {
        int n2 = MultiDimensionArrayUtils.getDimension(object);
        if (bl) {
            --n2;
        }
        int[] nArray = new int[n2];
        if (n2 == 0) {
            return nArray;
        }
        Object object2 = object;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object[] objectArray = (Object[])object2;
            nArray[i2] = objectArray.length;
            if (objectArray.length == 0) break;
            object2 = objectArray[0];
        }
        return nArray;
    }

    private static Object enumsToInts(Object object) {
        Class<?> clazz = object.getClass();
        if (Enumeration.class.isAssignableFrom(clazz)) {
            return ((Enumeration)object).getValue();
        }
        if (Enumeration[].class.isAssignableFrom(clazz)) {
            Enumeration[] enumerationArray = (Enumeration[])object;
            Integer[] integerArray = new Integer[enumerationArray.length];
            for (int i2 = 0; i2 < enumerationArray.length; ++i2) {
                integerArray[i2] = enumerationArray[i2] == null ? null : Integer.valueOf(enumerationArray[i2].getValue());
            }
            return integerArray;
        }
        int[] nArray = Variant.calculateArrayDimensions(object, false);
        Enumeration[] enumerationArray = (Enumeration[])MultiDimensionArrayUtils.muxArray(object, nArray);
        Integer[] integerArray = new Integer[enumerationArray.length];
        for (int i3 = 0; i3 < enumerationArray.length; ++i3) {
            integerArray[i3] = enumerationArray[i3] == null ? null : Integer.valueOf(enumerationArray[i3].getValue());
        }
        return MultiDimensionArrayUtils.demuxArray(integerArray, nArray);
    }

    private static Class<?> numericOptionSetsToCompositeClass(Object object) {
        Class<?> clazz = object.getClass();
        if (UaOptionSet.class.isAssignableFrom(clazz)) {
            return ((UaOptionSet)object).getValue().getClass();
        }
        if (UaOptionSet[].class.isAssignableFrom(clazz)) {
            UaOptionSet[] uaOptionSetArray = (UaOptionSet[])object;
            for (int i2 = 0; i2 < uaOptionSetArray.length; ++i2) {
                if (uaOptionSetArray[i2] == null) continue;
                return uaOptionSetArray[i2].getValue().getClass();
            }
            throw new IllegalArgumentException("Variant cannot accept OptionSetDataType arrays that consists only of nulls");
        }
        int[] nArray = Variant.calculateArrayDimensions(object, false);
        UaOptionSet[] uaOptionSetArray = (UaOptionSet[])MultiDimensionArrayUtils.muxArray(object, nArray);
        for (int i3 = 0; i3 < uaOptionSetArray.length; ++i3) {
            if (uaOptionSetArray[i3] == null) continue;
            return uaOptionSetArray[i3].getValue().getClass();
        }
        throw new IllegalArgumentException("Variant cannot accept OptionSetDataType arrays that consists only of nulls");
    }

    private static Object numericOptionSetsToInts(Object object) {
        Class<?> clazz = object.getClass();
        if (UaOptionSet.class.isAssignableFrom(clazz)) {
            return ((UaOptionSet)object).getValue();
        }
        if (UaOptionSet[].class.isAssignableFrom(clazz)) {
            UaOptionSet[] uaOptionSetArray = (UaOptionSet[])object;
            Object[] objectArray = (Object[])Array.newInstance(Variant.numericOptionSetsToCompositeClass(object), uaOptionSetArray.length);
            for (int i2 = 0; i2 < uaOptionSetArray.length; ++i2) {
                objectArray[i2] = uaOptionSetArray[i2] == null ? null : uaOptionSetArray[i2].getValue();
            }
            return objectArray;
        }
        int[] nArray = Variant.calculateArrayDimensions(object, false);
        UaOptionSet[] uaOptionSetArray = (UaOptionSet[])MultiDimensionArrayUtils.muxArray(object, nArray);
        Object[] objectArray = (Object[])Array.newInstance(Variant.numericOptionSetsToCompositeClass(object), uaOptionSetArray.length);
        for (int i3 = 0; i3 < objectArray.length; ++i3) {
            objectArray[i3] = uaOptionSetArray[i3] == null ? null : uaOptionSetArray[i3].getValue();
        }
        return MultiDimensionArrayUtils.demuxArray(objectArray, nArray);
    }

    public Variant(Object object2) {
        int n2;
        if (object2 == null) {
            this.value = null;
            this.compositeClass = null;
            this.valueClassDimensions = MultiDimensionArrayUtils.getDimension(object2);
            return;
        }
        Class<?> clazz = MultiDimensionArrayUtils.getComponentType(object2.getClass());
        if (UaOptionSet.class.isAssignableFrom(clazz) && !OptionSetStructure.class.isAssignableFrom(clazz)) {
            this.compositeClass = Variant.numericOptionSetsToCompositeClass(object2);
            this.value = Variant.numericOptionSetsToInts(object2);
            this.valueClassDimensions = MultiDimensionArrayUtils.getDimension(object2);
            return;
        }
        if (Enumeration.class.isAssignableFrom(clazz)) {
            this.value = Variant.enumsToInts(object2);
            this.compositeClass = Integer.class;
            this.valueClassDimensions = MultiDimensionArrayUtils.getDimension(object2);
            return;
        }
        if (Byte.TYPE.isAssignableFrom(clazz)) {
            this.value = Variant.byteArraysToByteStrings(object2);
            this.compositeClass = ByteString.class;
            this.valueClassDimensions = MultiDimensionArrayUtils.getDimension(object2) - 1;
            return;
        }
        if (Object.class.equals(clazz) && MultiDimensionArrayUtils.getDimension(object2) > 0 && (n2 = MultiDimensionArrayUtils.getDimension(object2)) > 0) {
            this.value = MultiDimensionArrayUtils.map(object2, Object.class, Variant.class, object -> object instanceof Variant ? (Variant)object : new Variant(object));
            this.compositeClass = Variant.class;
            this.valueClassDimensions = n2;
            return;
        }
        this.f(clazz);
        this.value = object2;
        this.compositeClass = clazz;
        this.valueClassDimensions = MultiDimensionArrayUtils.getDimension(object2);
    }

    public <T> T asClass(Class<T> clazz, T t2) {
        if (this.value == null) {
            return t2;
        }
        try {
            return clazz.cast(this.value);
        }
        catch (ClassCastException classCastException) {
            return t2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public <T extends Enum<T>> Object asEnum(Class<T> clazz) {
        if (this.value == null) {
            return null;
        }
        if (!Integer.class.equals(this.compositeClass)) {
            throw new ClassCastException("Variant.asEnum can only be called on non-null Variants that have compositeClass of Integer, was: " + this.toStringWithType());
        }
        Enum[] enumArray2 = (Enum[])clazz.getEnumConstants();
        HashMap<Integer, Enum> hashMap = new HashMap<Integer, Enum>();
        for (Enum i2 : enumArray2) {
            hashMap.put(((Enumeration)((Object)i2)).getValue(), i2);
        }
        Class<?> clazz2 = this.value.getClass();
        if (Integer.class.equals(clazz2)) {
            Integer integerArray = (Integer)this.value;
            return hashMap.get(integerArray);
        }
        if (Integer[].class.equals(clazz2)) {
            void var7_15;
            Integer[] nArray = (Integer[])this.value;
            Enum[] integerArray = (Enum[])Array.newInstance(clazz, nArray.length);
            boolean bl = false;
            while (var7_15 < nArray.length) {
                integerArray[var7_15] = (Enum)hashMap.get(nArray[var7_15]);
                ++var7_15;
            }
            return integerArray;
        }
        int[] nArray = Variant.calculateArrayDimensions(this.value, false);
        Integer[] integerArray = (Integer[])MultiDimensionArrayUtils.muxArray(this.value, nArray);
        Enum[] enumArray = (Enum[])Array.newInstance(clazz, integerArray.length);
        for (int i2 = 0; i2 < enumArray.length; ++i2) {
            enumArray[i2] = (Enum)hashMap.get(integerArray[i2]);
        }
        return MultiDimensionArrayUtils.demuxArray(enumArray, nArray);
    }

    public Object asEnum(EnumerationSpecification enumerationSpecification) {
        if (this.value == null) {
            return null;
        }
        if (!Integer.class.equals(this.compositeClass)) {
            throw new ClassCastException("Variant.asEnum can only be called on non-null Variants that have compositeClass of Integer, was: " + this.toStringWithType());
        }
        Class<? extends Enumeration> clazz = enumerationSpecification.getJavaClass();
        return MultiDimensionArrayUtils.map(this.value, Integer.class, clazz, n2 -> enumerationSpecification.getByValue((Integer)n2));
    }

    public Object asOptionSet(final OptionSetSpecification optionSetSpecification) {
        if (this.value == null) {
            return null;
        }
        if (optionSetSpecification instanceof OptionSetStructureSpecification) {
            return this.value;
        }
        if (!optionSetSpecification.getBaseTypeJavaClass().isAssignableFrom(this.getCompositeClass())) {
            throw new ClassCastException("Expected " + optionSetSpecification.getBaseTypeJavaClass() + " but Variant composite class is " + this.getCompositeClass());
        }
        Object object = MultiDimensionArrayUtils.map(this.value, this.getCompositeClass(), optionSetSpecification.getBaseTypeJavaClass(), new CheckedFunction(){

            public Object apply(Object object) {
                if (object == null) {
                    return null;
                }
                BitField bitField = (BitField)object;
                UaOptionSet.Builder builder = optionSetSpecification.toInstanceBuilder();
                for (OptionSpecification optionSpecification : optionSetSpecification.getOptions()) {
                    if (!bitField.isBitSet(optionSpecification.getBitPosition())) continue;
                    builder.add(optionSpecification);
                }
                return builder.build();
            }
        });
        return object;
    }

    public boolean booleanValue() {
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        if (this.isNumber()) {
            return this.longValue() != 0L;
        }
        if (this.isEmpty()) {
            throw new ClassCastException("Variant null cannot be cast to boolean");
        }
        if (this.getCompositeClass().equals(String.class)) {
            String string = ((String)this.getValue()).toLowerCase(Locale.ROOT);
            if (string.equals("true") || string.equals("1")) {
                return true;
            }
            if (string.equals("false") || string.equals("0")) {
                return false;
            }
            throw new ClassCastException("Variant String cannot be cast to boolean: " + string);
        }
        return this.asClass(Boolean.class, false);
    }

    public byte byteValue() {
        return this.toNumber().byteValue();
    }

    public Variant clone() {
        try {
            Variant variant = (Variant)super.clone();
            variant.value = StructureUtils.clone(this.value);
            return variant;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            logger.error("Got a CloneNotSupportedException, should be impossible", cloneNotSupportedException);
            throw new Error("Variant.clone failed, even though it is marked Cloneable, shouldn't happen", cloneNotSupportedException);
        }
    }

    public double doubleValue() {
        return this.toNumber().doubleValue();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof Variant)) {
            return false;
        }
        Variant variant = (Variant)object;
        if (this.value == null || variant.value == null) {
            return this.value == variant.value;
        }
        Class<?> clazz = this.value.getClass();
        if (!clazz.equals(variant.value.getClass())) {
            return false;
        }
        if (!this.isArray()) {
            return this.value.equals(variant.value);
        }
        return Arrays.deepEquals((Object[])this.value, (Object[])variant.value);
    }

    public float floatValue() {
        return this.toNumber().floatValue();
    }

    public int[] getArrayDimensions() {
        return Variant.calculateArrayDimensions(this.value, false);
    }

    public Object getArrayElement(int ... nArray) {
        if (!this.isArray()) {
            throw new ArrayIndexOutOfBoundsException("Variant is not an array.");
        }
        int[] nArray2 = this.getArrayDimensions();
        if (nArray.length != nArray2.length) {
            this.throwArrayBoundsError(nArray2, nArray);
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray2[i2] <= 0 || nArray[i2] < nArray2[i2]) continue;
            this.throwArrayBoundsError(nArray2, nArray);
        }
        return MultiDimensionArrayUtils.deepGet(this.getValue(), nArray);
    }

    public Class<?> getCompositeClass() {
        return this.compositeClass;
    }

    public int getDimension() {
        return this.valueClassDimensions;
    }

    public Object getValue() {
        return this.value;
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        if (!this.isArray()) {
            return this.value.hashCode();
        }
        return Arrays.deepHashCode((Object[])this.value);
    }

    public int intValue() {
        return this.toNumber().intValue();
    }

    public boolean isArray() {
        if (this.value == null) {
            return false;
        }
        return this.valueClassDimensions > 0;
    }

    public boolean isComparable() {
        return this.value instanceof Comparable;
    }

    public boolean isEmpty() {
        return this.value == null;
    }

    public boolean isNumber() {
        return this.value instanceof Number || this.value instanceof Boolean;
    }

    public long longValue() {
        return this.toNumber().longValue();
    }

    public short shortValue() {
        return this.toNumber().shortValue();
    }

    public Number toNumber() {
        if (this.value instanceof Boolean) {
            return this.booleanValue() ? 1 : 0;
        }
        if (this.isNumber()) {
            return (Number)this.value;
        }
        throw new ClassCastException("Variant is not a Number; CompositeClass=" + this.getCompositeClass());
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean bl) {
        String string;
        if (this.value == null) {
            return "(null)";
        }
        String string2 = "";
        if (this.isArray()) {
            if (bl) {
                int[] nArray = this.getArrayDimensions();
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(nArray[0]);
                for (int i2 = 1; i2 < this.getDimension(); ++i2) {
                    stringBuilder.append(",").append(nArray[i2]);
                }
                string2 = String.format(Locale.ROOT, "(%s[%s]) ", this.compositeClassToString(), stringBuilder.toString());
            }
            string = MultiDimensionArrayUtils.toString(this.value);
        } else {
            if (bl) {
                string2 = String.format(Locale.ROOT, "(%s) ", this.compositeClassToString());
            }
            string = MultiDimensionArrayUtils.toString(this.value);
        }
        return string2 + string;
    }

    public String toStringWithType() {
        return this.toString(true);
    }

    public boolean valueEquals(Variant variant) {
        if (variant == null) {
            return false;
        }
        if (this.isEmpty() || variant.isEmpty()) {
            return false;
        }
        if (this.getCompositeClass().equals(variant.getCompositeClass())) {
            return this.equals(variant);
        }
        if (this.isNumber() && variant.isNumber()) {
            return this.floatValue() == variant.floatValue();
        }
        Object var2_2 = variant.asClass(this.getCompositeClass(), null);
        if (var2_2 != null) {
            return this.equals(new Variant(var2_2));
        }
        return variant.equals(this.asClass(variant.getCompositeClass(), null));
    }

    @Override
    public Variant withTranslatedNamespaces(UaNamespaceTranslateable.Context context) {
        Object object2 = MultiDimensionArrayUtils.map(this.value, this.getCompositeClass(), this.getCompositeClass(), object -> {
            if (object instanceof UaNamespaceTranslateable) {
                return ((UaNamespaceTranslateable)object).withTranslatedNamespaces(context);
            }
            return object;
        });
        return new Variant(object2);
    }

    private void throwArrayBoundsError(int[] nArray, int ... nArray2) {
        throw new ArrayIndexOutOfBoundsException(String.format(Locale.ROOT, "Array indices %s don't match. Dimensions=%s indices.", Arrays.toString(nArray2), Arrays.toString(nArray)));
    }

    protected String compositeClassToString() {
        String string = this.getCompositeClass().getSimpleName();
        return string;
    }

    void f(Class<?> clazz) {
        if (validFinalClasses.contains(clazz)) {
            return;
        }
        if (DateTime.class.isAssignableFrom(clazz)) {
            return;
        }
        if (ExtensionObject.class.isAssignableFrom(clazz)) {
            return;
        }
        if (DataValue.class.isAssignableFrom(clazz)) {
            return;
        }
        if (DiagnosticInfo.class.isAssignableFrom(clazz)) {
            return;
        }
        if (Variant.class.isAssignableFrom(clazz)) {
            return;
        }
        if (Structure.class.isAssignableFrom(clazz)) {
            return;
        }
        if (BigDecimal.class.isAssignableFrom(clazz)) {
            return;
        }
        throw new IllegalArgumentException("Variant cannot be " + clazz.getCanonicalName());
    }

    static {
        HashSet<Class> hashSet = new HashSet<Class>();
        hashSet.add(Boolean.class);
        hashSet.add(Byte.class);
        hashSet.add(UnsignedByte.class);
        hashSet.add(Short.class);
        hashSet.add(UnsignedShort.class);
        hashSet.add(Integer.class);
        hashSet.add(UnsignedInteger.class);
        hashSet.add(Long.class);
        hashSet.add(UnsignedLong.class);
        hashSet.add(Float.class);
        hashSet.add(Double.class);
        hashSet.add(String.class);
        hashSet.add(UUID.class);
        hashSet.add(XmlElement.class);
        hashSet.add(NodeId.class);
        hashSet.add(ExpandedNodeId.class);
        hashSet.add(StatusCode.class);
        hashSet.add(QualifiedName.class);
        hashSet.add(LocalizedText.class);
        hashSet.add(ByteString.class);
        validFinalClasses = Collections.unmodifiableSet(hashSet);
        NULL = new Variant(null);
        EMPTY_ARRAY = new Variant[0];
    }
}

