/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.BitField;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.utils.CryptoUtil;

public final class UnsignedShort
extends Number
implements BitField,
Comparable<UnsignedShort> {
    private static final long serialVersionUID = 921127710458932841L;
    private static final UnsignedShort[] CACHE;
    @Deprecated
    public static final NodeId ID;
    public static final long L_MAX_VALUE;
    public static final long L_MIN_VALUE;
    public static final UnsignedShort MAX_VALUE;
    public static final UnsignedShort MIN_VALUE;
    public static final UnsignedShort ZERO;
    public static final UnsignedShort ONE;
    public static final UnsignedShort[] EMPTY_ARRAY;
    private int value;

    public static UnsignedShort[] arrayOf() {
        return EMPTY_ARRAY;
    }

    public static UnsignedShort[] arrayOf(long ... lArray) {
        if (lArray == null) {
            return null;
        }
        if (lArray.length == 0) {
            return EMPTY_ARRAY;
        }
        UnsignedShort[] unsignedShortArray = new UnsignedShort[lArray.length];
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            unsignedShortArray[i2] = UnsignedShort.valueOf(lArray[i2]);
        }
        return unsignedShortArray;
    }

    public static UnsignedShort[] arrayOf(String ... stringArray) {
        if (stringArray == null) {
            return null;
        }
        if (stringArray.length == 0) {
            return EMPTY_ARRAY;
        }
        UnsignedShort[] unsignedShortArray = new UnsignedShort[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            unsignedShortArray[i2] = UnsignedShort.valueOf(stringArray[i2]);
        }
        return unsignedShortArray;
    }

    public static UnsignedShort getFromBits(short s2) {
        if (s2 >= 0 && s2 < CACHE.length) {
            return CACHE[s2];
        }
        UnsignedShort unsignedShort = new UnsignedShort(0);
        unsignedShort.value = s2 & 0xFFFF;
        return unsignedShort;
    }

    public static UnsignedShort max(UnsignedShort unsignedShort, UnsignedShort unsignedShort2) {
        return unsignedShort.intValue() < unsignedShort2.intValue() ? unsignedShort2 : unsignedShort;
    }

    public static UnsignedShort min(UnsignedShort unsignedShort, UnsignedShort unsignedShort2) {
        return unsignedShort.intValue() < unsignedShort2.intValue() ? unsignedShort : unsignedShort2;
    }

    public static UnsignedShort parseUnsignedShort(String string) throws NumberFormatException, IllegalArgumentException {
        return UnsignedShort.valueOf(Integer.parseInt(string));
    }

    public static UnsignedShort parseUnsignedShort(String string, int n2) throws NumberFormatException, IllegalArgumentException {
        return UnsignedShort.valueOf(Integer.parseInt(string, n2));
    }

    public static UnsignedShort valueOf(int n2) {
        if (n2 >= 0 && n2 < CACHE.length) {
            return CACHE[n2];
        }
        return new UnsignedShort(n2);
    }

    public static UnsignedShort valueOf(long l2) {
        if (l2 < 0L || l2 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Illegal value");
        }
        return UnsignedShort.valueOf((int)l2);
    }

    public static UnsignedShort valueOf(String string) {
        return UnsignedShort.parseUnsignedShort(string);
    }

    public static UnsignedShort valueOf(String string, int n2) {
        return UnsignedShort.parseUnsignedShort(string, n2);
    }

    @Deprecated
    public UnsignedShort() {
        this.value = 0;
    }

    @Deprecated
    public UnsignedShort(int n2) throws IllegalArgumentException {
        if (n2 < 0 || n2 >= 65536) {
            throw new IllegalArgumentException("Illegal value");
        }
        this.value = n2;
    }

    @Deprecated
    public UnsignedShort(Number number) {
        long l2 = number.longValue();
        if (l2 < 0L || l2 >= 65536L) {
            throw new IllegalArgumentException("Illegal value");
        }
        this.value = number.intValue();
    }

    @Deprecated
    public UnsignedShort(short s2) {
        if (s2 < 0) {
            throw new IllegalArgumentException("Value underflow");
        }
        this.value = s2;
    }

    @Deprecated
    public UnsignedShort(String string) throws IllegalArgumentException {
        int n2 = Integer.parseInt(string);
        if (n2 < 0 || n2 >= 65536) {
            throw new IllegalArgumentException("Illegal value");
        }
        this.value = n2;
    }

    public UnsignedShort add(int n2) {
        return UnsignedShort.valueOf(this.getValue() + n2);
    }

    public UnsignedShort add(UnsignedShort unsignedShort) {
        return UnsignedShort.valueOf(this.getValue() + unsignedShort.getValue());
    }

    @Override
    public byte byteValue() {
        return (byte)(this.value & 0xFF);
    }

    @Override
    public int compareTo(UnsignedShort unsignedShort) {
        return this.value - unsignedShort.value;
    }

    public UnsignedShort dec() {
        return UnsignedShort.valueOf(this.getValue() - 1);
    }

    public UnsignedShort decOrWrap() {
        if (this.equals(MIN_VALUE)) {
            return MAX_VALUE;
        }
        return this.dec();
    }

    public UnsignedShort decOrWrapTo(UnsignedShort unsignedShort) {
        if (this.equals(MIN_VALUE)) {
            return unsignedShort;
        }
        return this.dec();
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(UnsignedShort.class)) {
            return false;
        }
        UnsignedShort unsignedShort = (UnsignedShort)object;
        return unsignedShort.value == this.value;
    }

    @Override
    public float floatValue() {
        return this.value;
    }

    public int getValue() {
        return this.value;
    }

    public int hashCode() {
        return this.value;
    }

    public UnsignedShort inc() {
        return UnsignedShort.valueOf(this.getValue() + 1);
    }

    public UnsignedShort incOrWrap() {
        if (this.equals(MAX_VALUE)) {
            return MIN_VALUE;
        }
        return this.inc();
    }

    public UnsignedShort incOrWrapTo(UnsignedShort unsignedShort) {
        if (this.equals(MAX_VALUE)) {
            return unsignedShort;
        }
        return this.inc();
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public boolean isBitSet(int n2) {
        if (n2 < 0 || n2 > 15) {
            return false;
        }
        return (this.value >> n2 & 1) >= 1;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public short shortValue() {
        return (short)(this.value & 0xFFFF);
    }

    public UnsignedShort subtract(int n2) {
        return UnsignedShort.valueOf(this.getValue() - n2);
    }

    public UnsignedShort subtract(UnsignedShort unsignedShort) {
        return UnsignedShort.valueOf(this.getValue() - unsignedShort.getValue());
    }

    public String toHex() {
        return CryptoUtil.toHex(this.value);
    }

    public short toShortBits() {
        return (short)(this.value & 0xFFFF);
    }

    public String toString() {
        return Integer.toString(this.value);
    }

    static {
        ID = Identifiers.UInt16;
        EMPTY_ARRAY = new UnsignedShort[0];
        L_MIN_VALUE = 0L;
        L_MAX_VALUE = 65535L;
        ZERO = new UnsignedShort(0);
        ONE = new UnsignedShort(1);
        MIN_VALUE = ZERO;
        MAX_VALUE = new UnsignedShort(L_MAX_VALUE);
        CACHE = new UnsignedShort[1024];
        UnsignedShort.CACHE[0] = ZERO;
        UnsignedShort.CACHE[1] = ONE;
        for (int i2 = 2; i2 < CACHE.length; ++i2) {
            UnsignedShort.CACHE[i2] = new UnsignedShort(i2);
        }
    }
}

