/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.InternalArguments;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.core.Identifiers;
import java.text.ParseException;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;

public class DateTime
implements Comparable<DateTime> {
    public static final String DEFAULT_STR_FORMAT = "%TD %TT.%07d %TZ";
    public static final String ISO_8601_STR_FORMAT = "%TF %TT.%07d %TZ";
    private static String strFormat = "%TD %TT.%07d %TZ";
    private static boolean useLocalTimeInToString = false;
    public static final DateTime[] EMPTY_ARRAY = new DateTime[0];
    private static final long MIN_VALUE_UA_EPOCH_100_NANOSECONDS = 0L;
    private static final long MAX_VALUE_UA_EPOCH_100_NANOSECONDS = 2650153247990000000L;
    @Deprecated
    public static final NodeId ID = Identifiers.DateTime;
    private static final TimeZone UTC = TimeZone.getTimeZone("GMT");
    public static final long OffsetToGregorianCalendarZero = 116444736000000000L;
    public static final DateTime MIN_VALUE = DateTime.valueOf(0L);
    public static final DateTime MAX_VALUE = DateTime.valueOf(2650153247990000000L);
    public static final Instant MIN = MIN_VALUE.toInstant();
    public static final Instant MAX = MAX_VALUE.toInstant();
    private final long value;
    private final Instant instant;

    public static DateTime currentTime() {
        return new DateTime();
    }

    public static DateTime fromInstant(Instant instant) {
        if (instant == null) {
            return null;
        }
        if (instant.isBefore(MIN)) {
            return MIN_VALUE;
        }
        if (instant.isAfter(MAX)) {
            return MAX_VALUE;
        }
        long l2 = DateTime.instantToOpcUaEpoch100NanosecondsClampMinMax(instant);
        return new DateTime(l2, DateTime.uaEpoch100NanosecondsToInstant(l2));
    }

    public static DateTime fromMillis(long l2) {
        return new DateTime(l2 * 10000L + 116444736000000000L);
    }

    public static String getStrFormat() {
        return strFormat;
    }

    public static boolean isUseLocalTimeInToString() {
        return useLocalTimeInToString;
    }

    public static DateTime parseDateTime(String string) throws ParseException {
        int n2 = string.length();
        if (n2 < 10) {
            throw new ParseException("Cannot parse DateTime from " + string + " expecting format 'yyyy-MM-dd'T'hh:mm:ssZ', for example '2011-04-13T11:47:12Z' for UTC timezone", 0);
        }
        int n3 = Integer.parseInt(string.substring(0, 4));
        int n4 = Integer.parseInt(string.substring(5, 7));
        int n5 = Integer.parseInt(string.substring(8, 10));
        int n6 = n2 < 13 ? 0 : Integer.parseInt(string.substring(11, 13));
        int n7 = n2 < 16 ? 0 : Integer.parseInt(string.substring(14, 16));
        int n8 = n2 < 19 ? 0 : Integer.parseInt(string.substring(17, 19));
        TimeZone timeZone = UTC;
        if (n2 > 19) {
            String string2 = string.substring(19);
            if (string2.charAt(0) == '+' || string2.charAt(0) == '-') {
                string2 = "GMT" + string2;
            }
            timeZone = TimeZone.getTimeZone(string2);
        }
        return DateTime.valueOf(new DateTime(n3, n4 - 1, n5, n6, n7, n8, 0, timeZone).getValue());
    }

    public static void setStrFormat(String string) {
        strFormat = string;
    }

    public static void setUseLocalTimeInToString(boolean bl) {
        useLocalTimeInToString = bl;
    }

    public static DateTime valueOf(long l2) {
        if (l2 < 0L) {
            l2 = 0L;
        }
        if (l2 > 2650153247990000000L) {
            l2 = 2650153247990000000L;
        }
        return new DateTime(l2, DateTime.uaEpoch100NanosecondsToInstant(l2));
    }

    private static long instantToOpcUaEpoch100NanosecondsClampMinMax(Instant instant) {
        if (instant.isBefore(MIN)) {
            return MIN_VALUE.getValue();
        }
        if (instant.isAfter(MAX)) {
            return MAX_VALUE.getValue();
        }
        long l2 = instant.getEpochSecond();
        long l3 = instant.getNano();
        long l4 = l3 / 100L;
        long l5 = l2 * 1000L * 10000L + 116444736000000000L;
        return l5 + l4;
    }

    private static Instant uaEpoch100NanosecondsToInstant(long l2) {
        long l3 = (l2 - 116444736000000000L) / 10000000L;
        long l4 = (l2 - 116444736000000000L) % 10000000L;
        long l5 = l4 * 100L;
        return Instant.ofEpochSecond(l3, l5);
    }

    @Deprecated
    public DateTime() {
        this(System.currentTimeMillis() * 10000L + 116444736000000000L);
    }

    @Deprecated
    public DateTime(Calendar calendar) {
        this.value = calendar.getTimeInMillis() * 10000L + 116444736000000000L;
        this.instant = DateTime.uaEpoch100NanosecondsToInstant(this.value);
    }

    @Deprecated
    public DateTime(int n2, int n3, int n4, int n5, int n6, int n7) {
        this(n2, n3, n4, n5, n6, n7, 0, UTC);
    }

    @Deprecated
    public DateTime(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this(n2, n3, n4, n5, n6, n7, n8, UTC);
    }

    @Deprecated
    public DateTime(int n2, int n3, int n4, int n5, int n6, int n7, int n8, TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n2, n3, n4, n5, n6, n7);
        ((Calendar)gregorianCalendar).setTimeZone(timeZone);
        this.value = (long)(n8 / 100) + gregorianCalendar.getTimeInMillis() * 10000L + 116444736000000000L;
        this.instant = DateTime.uaEpoch100NanosecondsToInstant(this.value);
    }

    @Deprecated
    public DateTime(long l2) {
        this(l2, DateTime.uaEpoch100NanosecondsToInstant(l2));
    }

    private DateTime(long l2, Instant instant) {
        this.value = l2;
        if (instant == null) {
            throw new IllegalStateException("The instant was null");
        }
        this.instant = instant;
    }

    @Override
    public int compareTo(DateTime dateTime) {
        if (this == dateTime) {
            return 0;
        }
        if (this.value < dateTime.value) {
            return -1;
        }
        if (this.value > dateTime.value) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DateTime dateTime = (DateTime)object;
        return this.value == dateTime.value;
    }

    @Deprecated
    public GregorianCalendar getCalendar(TimeZone timeZone) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTimeInMillis(this.getTimeInMillis());
        return gregorianCalendar;
    }

    @Deprecated
    public GregorianCalendar getLocalCalendar() {
        return this.getCalendar(TimeZone.getDefault());
    }

    public long getTimeInMillis() {
        return this.instant.toEpochMilli();
    }

    @Deprecated
    public GregorianCalendar getUtcCalendar() {
        return this.getCalendar(UTC);
    }

    public long getValue() {
        return this.value;
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    public boolean isAfter(DateTime dateTime) {
        InternalArguments.checkNotNull(dateTime, "other");
        return this.instant.isAfter(dateTime.instant);
    }

    public boolean isAfterOrAt(DateTime dateTime) {
        InternalArguments.checkNotNull(dateTime, "other");
        return this.instant.equals(dateTime.instant) || this.instant.isAfter(dateTime.instant);
    }

    public boolean isBefore(DateTime dateTime) {
        InternalArguments.checkNotNull(dateTime, "other");
        return this.instant.isBefore(dateTime.instant);
    }

    public boolean isBeforeOrAt(DateTime dateTime) {
        InternalArguments.checkNotNull(dateTime, "other");
        return this.instant.equals(dateTime.instant) || this.instant.isBefore(dateTime.instant);
    }

    public DateTime minus(long l2, TemporalUnit temporalUnit) {
        return this.plus(-l2, temporalUnit);
    }

    public DateTime minus(long l2, TimeUnit timeUnit) {
        return this.plus(-l2, timeUnit);
    }

    public DateTime minus(TemporalAmount temporalAmount) {
        return this.plus(temporalAmount);
    }

    public DateTime minusMillis(double d2) {
        return this.plusMillis(-d2);
    }

    public DateTime minusMillis(long l2) {
        return this.plusMillis(-l2);
    }

    public DateTime minusNanos(long l2) {
        return this.plusNanos(-l2);
    }

    public DateTime plus(long l2, TemporalUnit temporalUnit) {
        return DateTime.fromInstant(this.toInstant().plus(l2, temporalUnit));
    }

    public DateTime plus(long l2, TimeUnit timeUnit) {
        switch (timeUnit) {
            case MICROSECONDS: 
            case NANOSECONDS: {
                return this.plusNanos(timeUnit.toNanos(l2));
            }
        }
        return this.plusMillis(timeUnit.toMillis(l2));
    }

    public DateTime plus(TemporalAmount temporalAmount) {
        return DateTime.fromInstant(this.toInstant().plus(temporalAmount));
    }

    public DateTime plusMillis(double d2) {
        return DateTime.valueOf(this.getValue() + Math.round(d2 * 10000.0));
    }

    public DateTime plusMillis(long l2) {
        return DateTime.valueOf(this.getValue() + l2 * 10000L);
    }

    public DateTime plusNanos(long l2) {
        return DateTime.valueOf(this.getValue() + l2 / 100L);
    }

    public Instant toInstant() {
        return this.instant;
    }

    public String toString() {
        GregorianCalendar gregorianCalendar = useLocalTimeInToString ? this.getLocalCalendar() : this.getUtcCalendar();
        long l2 = this.value % 10000000L;
        return String.format(Locale.ROOT, strFormat, gregorianCalendar, gregorianCalendar, l2, gregorianCalendar);
    }
}

