/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.builtintypes;

import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import java.util.Objects;

public class DataValue
implements Cloneable {
    @Deprecated
    public static final NodeId ID = Identifiers.DataValue;
    public static final DataValue[] EMPTY_ARRAY = new DataValue[0];
    Variant iZ;
    StatusCode statusCode;
    DateTime qK;
    UnsignedShort qQ;
    DateTime qP;
    UnsignedShort rD;

    public static DataValue defaultValue(Class<?> clazz) {
        return new DataValue(Variant.defaultValue(clazz));
    }

    public static DataValue defaultValue(Class<?> clazz, int n2) {
        return new DataValue(Variant.defaultValue(clazz, n2));
    }

    public static DataValue defaultValue(Class<?> clazz, UaArrayDimensions uaArrayDimensions) {
        return new DataValue(Variant.defaultValue(clazz, uaArrayDimensions));
    }

    public static DataValue defaultValue(Class<?> clazz, UnsignedInteger[] unsignedIntegerArray) {
        return new DataValue(Variant.defaultValue(clazz, unsignedIntegerArray));
    }

    public static DataValue defaultValue(EncoderContext encoderContext, UaNodeId uaNodeId) {
        return new DataValue(Variant.defaultValue(encoderContext, uaNodeId));
    }

    public static DataValue defaultValue(EncoderContext encoderContext, UaNodeId uaNodeId, int n2) {
        return new DataValue(Variant.defaultValue(encoderContext, uaNodeId, n2));
    }

    public static DataValue defaultValue(EncoderContext encoderContext, UaNodeId uaNodeId, UaArrayDimensions uaArrayDimensions) {
        return new DataValue(Variant.defaultValue(encoderContext, uaNodeId, uaArrayDimensions));
    }

    public static DataValue defaultValue(EncoderContext encoderContext, UaNodeId uaNodeId, UnsignedInteger[] unsignedIntegerArray) {
        return new DataValue(Variant.defaultValue(encoderContext, uaNodeId, unsignedIntegerArray));
    }

    public static boolean isArray(DataValue dataValue) {
        return dataValue != null && dataValue.isArray();
    }

    public static boolean isNull(DataValue dataValue) {
        return dataValue == null || dataValue.isNull();
    }

    public DataValue() {
        this(StatusCode.GOOD);
    }

    public DataValue(StatusCode statusCode) {
        this(Variant.NULL, statusCode);
    }

    public DataValue(Variant variant) {
        this(variant, StatusCode.GOOD);
    }

    public DataValue(Variant variant, StatusCode statusCode) {
        this(variant, statusCode, null, null, null, null);
    }

    public DataValue(Variant variant, StatusCode statusCode, DateTime dateTime, DateTime dateTime2) {
        this(variant, statusCode, dateTime, null, dateTime2, null);
    }

    public DataValue(Variant variant, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort, DateTime dateTime2, UnsignedShort unsignedShort2) {
        this.statusCode = statusCode == null ? StatusCode.GOOD : statusCode;
        this.qK = dateTime;
        this.qP = dateTime2;
        this.qQ = unsignedShort == null ? UnsignedShort.ZERO : unsignedShort;
        this.rD = unsignedShort2 == null ? UnsignedShort.ZERO : unsignedShort2;
        this.setValue(variant);
    }

    public DataValue clone() {
        try {
            DataValue dataValue = (DataValue)super.clone();
            dataValue.iZ = dataValue.iZ == null ? null : new Variant(StructureUtils.clone(dataValue.iZ.getValue()));
            return dataValue;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("Could not call super.clone on DataValue even when it implements Cloneable");
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof DataValue)) {
            return false;
        }
        DataValue dataValue = (DataValue)object;
        return Objects.equals(dataValue.iZ, this.iZ) && Objects.equals(dataValue.statusCode, this.statusCode) && Objects.equals(dataValue.qK, this.qK) && Objects.equals(dataValue.qP, this.qP) && Objects.equals(dataValue.qQ, this.qQ) && Objects.equals(dataValue.rD, this.rD);
    }

    public UnsignedShort getServerPicoseconds() {
        return this.rD;
    }

    public DateTime getServerTimestamp() {
        return this.qP;
    }

    public UnsignedShort getSourcePicoseconds() {
        return this.qQ;
    }

    public DateTime getSourceTimestamp() {
        return this.qK;
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public Variant getValue() {
        return this.iZ;
    }

    public int hashCode() {
        return Objects.hash(this.iZ, this.statusCode, this.qK, this.qQ, this.qP, this.rD);
    }

    public boolean isArray() {
        return !this.isNull() && this.getValue().isArray();
    }

    public boolean isNull() {
        return this.iZ.getValue() == null;
    }

    public void setServerPicoseconds(UnsignedShort unsignedShort) {
        this.rD = unsignedShort;
    }

    public void setServerTimestamp(DateTime dateTime) {
        this.qP = dateTime;
    }

    public void setSourcePicoseconds(UnsignedShort unsignedShort) {
        this.qQ = unsignedShort;
    }

    public void setSourceTimestamp(DateTime dateTime) {
        this.qK = dateTime;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode == null ? StatusCode.GOOD : statusCode;
    }

    public void setStatusCode(UnsignedInteger unsignedInteger) {
        if (unsignedInteger == null) {
            this.setStatusCode(StatusCode.GOOD);
        } else {
            this.setStatusCode(StatusCode.valueOf(unsignedInteger));
        }
    }

    public void setValue(Variant variant) {
        this.iZ = variant == null ? Variant.NULL : variant;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataValue(");
        stringBuilder.append("value=" + this.iZ);
        stringBuilder.append(", statusCode=" + this.statusCode);
        stringBuilder.append(", sourceTimestamp=" + this.qK);
        stringBuilder.append(", sourcePicoseconds=" + this.qQ);
        stringBuilder.append(", serverTimestamp=" + this.qP);
        stringBuilder.append(", serverPicoseconds=" + this.rD);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

