/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.application;

import com.prosysopc.ua.stack.application.Client;
import com.prosysopc.ua.stack.application.Session;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ActivateSessionRequest;
import com.prosysopc.ua.stack.core.ActivateSessionResponse;
import com.prosysopc.ua.stack.core.AnonymousIdentityToken;
import com.prosysopc.ua.stack.core.CloseSessionResponse;
import com.prosysopc.ua.stack.core.IssuedIdentityToken;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.SignatureData;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.core.UserNameIdentityToken;
import com.prosysopc.ua.stack.core.X509IdentityToken;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.stack.transport.ChannelService;
import com.prosysopc.ua.stack.transport.RequestChannel;
import com.prosysopc.ua.stack.transport.ResultListener;
import com.prosysopc.ua.stack.transport.SecureChannel;
import com.prosysopc.ua.stack.transport.impl.AsyncResultImpl;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.EndpointUtil;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferUtils;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import java.security.PrivateKey;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionChannel
extends ChannelService
implements RequestChannel {
    private static final Logger logger = LoggerFactory.getLogger(SessionChannel.class);
    private final Client gq;
    private Session gX;
    private SecureChannel rz;
    private final AtomicReference<RequestValidator> rA;

    static void a(Session session, UserIdentityToken userIdentityToken, SignatureData signatureData) throws ServiceResultException {
        UserIdentityToken userIdentityToken2;
        if (userIdentityToken instanceof AnonymousIdentityToken) {
            return;
        }
        if (userIdentityToken instanceof UserNameIdentityToken && (((UserNameIdentityToken)(userIdentityToken2 = (UserNameIdentityToken)userIdentityToken)).getEncryptionAlgorithm() == null || ((UserNameIdentityToken)userIdentityToken2).getEncryptionAlgorithm().isEmpty())) {
            return;
        }
        if (userIdentityToken instanceof X509IdentityToken && (signatureData.getAlgorithm() == null || signatureData.getAlgorithm().isEmpty())) {
            return;
        }
        if (userIdentityToken instanceof IssuedIdentityToken && (((IssuedIdentityToken)(userIdentityToken2 = (IssuedIdentityToken)userIdentityToken)).getEncryptionAlgorithm() == null || ((IssuedIdentityToken)userIdentityToken2).getEncryptionAlgorithm().isEmpty())) {
            return;
        }
        if (session.getServerNonce() == null || session.getServerNonce().getLength() < 32) {
            throw new ServiceResultException(StatusCodes.Bad_NonceInvalid, "ServerNonce from previous CreateSessionResponse or ActivateSessionResponse was not valid (must be at least 32 bytes): " + session.getServerNonce());
        }
        if (session.rr) {
            throw new ServiceResultException(StatusCodes.Bad_NonceInvalid, "ServerNonce based on previous CreateSessionResponse or ActivateSessionResponse is not unique, calling ActivateSession is not safe:" + session.getServerNonce());
        }
    }

    public SessionChannel(Client client, Session session, SecureChannel secureChannel) {
        this.gX = session;
        this.gq = client;
        this.rz = secureChannel;
        this.setRequestChannel(this);
        this.rA = new AtomicReference();
    }

    public ActivateSessionResponse activate() throws ServiceResultException {
        UserIdentityToken userIdentityToken = EndpointUtil.createAnonymousIdentityToken(this.gX.getEndpoint());
        return this.activate(userIdentityToken, null);
    }

    public ActivateSessionResponse activate(byte[] byArray) throws ServiceResultException {
        UserIdentityToken userIdentityToken = EndpointUtil.createIssuedIdentityToken(this.gX.getEndpoint(), this.gX.getServerNonce(), byArray);
        return this.activate(userIdentityToken, null);
    }

    public ActivateSessionResponse activate(String string, String string2) throws ServiceResultException {
        UserIdentityToken userIdentityToken = EndpointUtil.createUserNameIdentityToken(this.gX.getEndpoint(), this.gX.getServerNonce(), string, string2);
        return this.activate(userIdentityToken, null);
    }

    public ActivateSessionResponse activate(UserIdentityToken userIdentityToken, SignatureData signatureData) throws ServiceResultException {
        boolean bl;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        DynamicStructure dynamicStructure;
        if (this.rz == null || userIdentityToken == null) {
            throw new IllegalArgumentException("null arg");
        }
        String string = userIdentityToken.getPolicyId();
        if (string != null && (dynamicStructure = EndpointUtil.findUserTokenPolicy(this.gX.getEndpoint(), string)) == null) {
            throw new ServiceResultException("UserIdentityPolicy \"" + string + "\" is not supported by the given endpoint");
        }
        SessionChannel.a(this.gX, userIdentityToken, signatureData);
        dynamicStructure = null;
        if (!MessageSecurityMode.None.equals(this.rz.getMessageSecurityMode())) {
            object4 = this.rz.getSecurityPolicy();
            object3 = this.gX.getClientPrivateKey().getPrivateKey();
            object2 = ((SecurityPolicy)((Object)object4)).getAsymmetricSignatureAlgorithm();
            object = this.gX.getServerCertificate().getEncoded();
            if (this.gX.getServerNonce() != null) {
                object = ByteBufferUtils.concatenate(new byte[][]{object, this.gX.getServerNonce().getValue()});
            }
            dynamicStructure = new SignatureData(object2.getUri(), ByteString.valueOf(CryptoUtil.getCryptoProvider().signAsymm((PrivateKey)object3, (SecurityAlgorithm)((Object)object2), (byte[])object)));
        }
        object4 = new ActivateSessionRequest();
        ((ActivateSessionRequest)object4).setLocaleIds(this.gq.getApplication().getLocaleIds());
        ((ActivateSessionRequest)object4).setClientSoftwareCertificates(this.gq.getApplication().getSoftwareCertificates());
        ((ActivateSessionRequest)object4).setClientSignature((SignatureData)dynamicStructure);
        ((ActivateSessionRequest)object4).setUserIdentityToken(userIdentityToken);
        ((ActivateSessionRequest)object4).setUserTokenSignature(signatureData);
        object3 = this.ActivateSession((ActivateSessionRequest)object4);
        object2 = this.gX.getServerNonce();
        object = ((ActivateSessionResponse)object3).getServerNonce();
        boolean bl2 = Objects.equals(object2, object);
        if (bl2) {
            this.gX.rr = true;
        }
        boolean bl3 = bl = object == null || ((ByteString)object).getLength() < 32;
        if (MessageSecurityMode.None.equals(this.rz.getMessageSecurityMode()) && userIdentityToken instanceof AnonymousIdentityToken) {
            if (bl2) {
                logger.warn("ServerNonce from ActivateSessionResponse was not unique (equals to previous ServerNonce): {}", object);
            }
            if (bl) {
                logger.warn("ServerNonce from ActivateSessionResponse was not valid (must be at least 32 bytes): {}", object);
            }
        } else {
            if (bl) {
                throw new ServiceResultException(StatusCodes.Bad_NonceInvalid, "ServerNonce from ActivateSessionResponse was not valid (must be at least 32 bytes): " + object);
            }
            if (bl2) {
                if (MessageSecurityMode.SignAndEncrypt.equals(this.rz.getMessageSecurityMode()) || userIdentityToken instanceof AnonymousIdentityToken) {
                    throw new ServiceResultException(StatusCodes.Bad_NonceInvalid, "ServerNonce from ActivateSessionResponse was not unique (equals to previous ServerNonce): " + object);
                }
                throw new ServiceResultException(StatusCodes.Bad_NonceInvalid, "ServerNonce from ActivateSessionResponse was not unique (equals to previous ServerNonce): " + object + " WARNING, credentials might be compromized");
            }
        }
        this.gX.lG = ((ActivateSessionResponse)object3).getServerNonce();
        return object3;
    }

    public void close() throws ServiceFaultException, ServiceResultException {
        this.CloseSession(null, true);
        this.closeSecureChannel();
    }

    public AsyncResult<SecureChannel> closeAsync() {
        final AsyncResultImpl<SecureChannel> asyncResultImpl = new AsyncResultImpl<SecureChannel>();
        AsyncResult<CloseSessionResponse> asyncResult = this.CloseSessionAsync(null, true);
        asyncResult.setListener(new ResultListener<CloseSessionResponse>(){

            public void a(CloseSessionResponse closeSessionResponse) {
                AsyncResult<SecureChannel> asyncResult = SessionChannel.this.rz.closeAsync();
                asyncResultImpl.setSource(asyncResult);
            }

            @Override
            public void onError(ServiceResultException serviceResultException) {
                AsyncResult<SecureChannel> asyncResult = SessionChannel.this.rz.closeAsync();
                asyncResultImpl.setSource(asyncResult);
            }

            @Override
            public /* synthetic */ void onCompleted(Object object) {
                this.a((CloseSessionResponse)object);
            }
        });
        return asyncResultImpl;
    }

    public void closeSecureChannel() {
        this.rz.close();
    }

    public void closeUnsafe() {
        try {
            this.close();
        }
        catch (ServiceResultException serviceResultException) {
            logger.error("Failed to close session channel", serviceResultException);
        }
    }

    public void dispose() {
        this.rz.close();
        this.rz.dispose();
        this.rz = null;
        this.gX = null;
    }

    public RequestValidator getRequestValidator() {
        return this.rA.get();
    }

    public SecureChannel getSecureChannel() {
        return this.rz;
    }

    public Session getSession() {
        return this.gX;
    }

    @Override
    public <T extends ServiceResponse> T serviceRequest(ServiceRequest<T> serviceRequest) throws ServiceResultException {
        RequestValidator requestValidator;
        ServiceRequest<T> serviceRequest2 = serviceRequest;
        RequestHeader requestHeader = serviceRequest2.getRequestHeader();
        if (requestHeader == null) {
            requestHeader = new RequestHeader();
            serviceRequest2.setRequestHeader(requestHeader);
        }
        requestHeader.setAuthenticationToken(this.gX.getAuthenticationToken());
        requestHeader.setTimestamp(new DateTime());
        if (logger.isTraceEnabled()) {
            logger.trace("serviceRequest: Request={} SecureChannelId={}", (Object)serviceRequest.getClass().getSimpleName(), (Object)this.rz.getSecureChannelId());
        }
        if ((requestValidator = this.rA.get()) != null) {
            requestValidator.validateServiceRequest(this, serviceRequest2);
        }
        return this.rz.serviceRequest(serviceRequest2);
    }

    @Override
    public <T extends ServiceResponse> AsyncResult<T> serviceRequestAsync(ServiceRequest<T> serviceRequest) {
        RequestHeader requestHeader = serviceRequest.getRequestHeader();
        if (requestHeader == null) {
            requestHeader = new RequestHeader();
            serviceRequest.setRequestHeader(requestHeader);
        }
        requestHeader.setAuthenticationToken(this.gX.getAuthenticationToken());
        requestHeader.setTimestamp(new DateTime());
        RequestValidator requestValidator = this.rA.get();
        if (requestValidator != null) {
            try {
                requestValidator.validateServiceRequest(this, serviceRequest);
            }
            catch (ServiceResultException serviceResultException) {
                logger.trace("SessionChannel.RequestValidator rejected the request to be sent to the secure channel, returning as an error within the AsyncResult.");
                AsyncResultImpl asyncResultImpl = new AsyncResultImpl();
                asyncResultImpl.setErrorSync(serviceResultException);
                return asyncResultImpl;
            }
        }
        return this.rz.serviceRequestAsync(serviceRequest);
    }

    public RequestValidator setRequestValidator(RequestValidator requestValidator) {
        return this.rA.getAndSet(requestValidator);
    }

    public static interface RequestValidator {
        public <T extends ServiceResponse> void validateServiceRequest(SessionChannel var1, ServiceRequest<T> var2) throws ServiceResultException;
    }
}

