/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.application;

import com.prosysopc.ua.stack.application.AbstractServiceHandler;
import com.prosysopc.ua.stack.application.ServiceHandler;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ServiceFault;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.transport.endpoint.EndpointServiceRequest;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceHandlerComposition
implements ServiceHandler {
    static Logger rm = LoggerFactory.getLogger(ServiceHandlerComposition.class);
    Map<Class<? extends IEncodeable>, ServiceHandler> rn = new HashMap<Class<? extends IEncodeable>, ServiceHandler>();
    Map<Class<? extends IEncodeable>, Object> ro = new HashMap<Class<? extends IEncodeable>, Object>();
    ServiceHandler[] rp;

    public static final ServiceHandler of(Object ... objectArray) {
        if (objectArray.length == 1 && objectArray[0] instanceof ServiceHandler) {
            return (ServiceHandler)objectArray[0];
        }
        ServiceHandlerComposition serviceHandlerComposition = new ServiceHandlerComposition();
        for (Object object : objectArray) {
            serviceHandlerComposition.add(object);
        }
        return serviceHandlerComposition;
    }

    public static void readWithReflection(final Object object, ServiceHandlerComposition serviceHandlerComposition) {
        Class<?> clazz = object.getClass();
        for (final Method method : clazz.getMethods()) {
            ParameterizedType parameterizedType;
            Type[] typeArray;
            Class<?>[] classArray;
            if (method.getReturnType() != Void.TYPE || (classArray = method.getParameterTypes()) == null || classArray.length != 1 || !EndpointServiceRequest.class.isAssignableFrom(classArray[0]) || (typeArray = method.getGenericParameterTypes()) == null || typeArray.length != 1 || !(typeArray[0] instanceof ParameterizedType) || (typeArray = (parameterizedType = (ParameterizedType)typeArray[0]).getActualTypeArguments()) == null || typeArray.length != 2 || typeArray[0] == null || typeArray[1] == null || !(typeArray[0] instanceof Class) || !IEncodeable.class.isAssignableFrom((Class)typeArray[0]) || !(typeArray[1] instanceof Class) || !IEncodeable.class.isAssignableFrom((Class)typeArray[1])) continue;
            Class clazz2 = (Class)typeArray[0];
            AbstractServiceHandler abstractServiceHandler = new AbstractServiceHandler(clazz2){

                @Override
                public void serve(EndpointServiceRequest<?, ?> endpointServiceRequest) throws ServiceResultException {
                    try {
                        method.invoke(object, endpointServiceRequest);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new Error(illegalArgumentException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new Error(illegalAccessException);
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        Throwable throwable;
                        Throwable throwable2 = throwable = invocationTargetException.getCause() != null ? invocationTargetException.getCause() : invocationTargetException;
                        if (throwable instanceof ServiceResultException) {
                            throw (ServiceResultException)throwable;
                        }
                        throw new ServiceFaultException(throwable);
                    }
                }
            };
            serviceHandlerComposition.add(abstractServiceHandler);
            serviceHandlerComposition.ro.put(clazz2, object);
        }
    }

    public void add(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null");
        }
        if (object instanceof ServiceHandler) {
            ServiceHandler serviceHandler = (ServiceHandler)object;
            ArrayList<Class<? extends IEncodeable>> arrayList = new ArrayList<Class<? extends IEncodeable>>();
            serviceHandler.getSupportedServices(arrayList);
            for (Class<? extends IEncodeable> clazz : arrayList) {
                ServiceHandler serviceHandler2 = this.rn.get(clazz);
                if (serviceHandler2 != null && serviceHandler != serviceHandler2) {
                    throw new RuntimeException("ServiceHandlerComposition already handles " + clazz);
                }
                this.rn.put(clazz, serviceHandler);
                this.ro.put(clazz, object);
            }
        } else {
            ServiceHandlerComposition.readWithReflection(object, this);
        }
        this.rp = this.rn.values().toArray(new ServiceHandler[0]);
    }

    public <T> T getServiceHandlerByService(Class<? extends ServiceRequest> clazz) {
        return (T)this.ro.get(clazz);
    }

    public ServiceHandler[] getServiceHandlers() {
        return this.rp;
    }

    @Override
    public void getSupportedServices(Collection<Class<? extends IEncodeable>> collection) {
        collection.addAll(this.rn.keySet());
    }

    @Override
    public void serve(EndpointServiceRequest<?, ?> endpointServiceRequest) {
        if (rm.isDebugEnabled()) {
            rm.debug("serve: {}", (Object)endpointServiceRequest.getRequest().getClass().getSimpleName());
            rm.debug("serve: handlerMap={}", (Object)Arrays.toString(this.rn.keySet().toArray(new Class[0])));
        }
        ServiceHandler serviceHandler = this.rn.get(endpointServiceRequest.getRequest().getClass());
        rm.debug("serve: handler={}", (Object)serviceHandler);
        if (serviceHandler == null) {
            rm.info("Service {} is not supported", (Object)endpointServiceRequest.getRequest().getClass().getSimpleName());
            this.a(endpointServiceRequest, new ServiceResultException(StatusCodes.Bad_ServiceUnsupported, endpointServiceRequest.getRequest().getClass().getSimpleName()));
            return;
        }
        try {
            serviceHandler.serve(endpointServiceRequest);
        }
        catch (ServiceResultException serviceResultException) {
            rm.error("While handling " + endpointServiceRequest.getRequest(), serviceResultException);
            this.a(endpointServiceRequest, serviceResultException);
        }
    }

    @Override
    public boolean supportsService(Class<? extends IEncodeable> clazz) {
        return this.rn.containsKey(clazz);
    }

    private void a(EndpointServiceRequest<?, ?> endpointServiceRequest, ServiceResultException serviceResultException) {
        ServiceFault serviceFault = ServiceFaultException.toServiceFault(serviceResultException);
        endpointServiceRequest.sendFault(serviceFault);
    }
}

