/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.stack.application;

import com.prosysopc.ua.UaAddress;
import com.prosysopc.ua.server.ReverseConnectionParameters;
import com.prosysopc.ua.stack.application.Application;
import com.prosysopc.ua.stack.application.EndpointDiscoveryService;
import com.prosysopc.ua.stack.application.ServiceHandler;
import com.prosysopc.ua.stack.application.ServiceHandlerComposition;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.ApplicationType;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.UserTokenPolicy;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.IEncodeable;
import com.prosysopc.ua.stack.transport.Endpoint;
import com.prosysopc.ua.stack.transport.EndpointBinding;
import com.prosysopc.ua.stack.transport.EndpointServer;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.endpoint.EndpointBindingCollection;
import com.prosysopc.ua.stack.transport.https.HttpsServer;
import com.prosysopc.ua.stack.transport.security.CertificateValidator;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.nio.OpcTcpServer;
import com.prosysopc.ua.stack.utils.EndpointUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    @Deprecated
    public static final String SOAP_XML_TRANSPORT_PROFILE_URI = "http://opcfoundation.org/UA-Profile/Transport/soaphttp-wssc-uaxml-uabinary";
    @Deprecated
    public static final String UATCP_BINARY_TRANSPORT_PROFILE_URI = "http://opcfoundation.org/UA-Profile/Transport/uatcp-uasc-uabinary";
    @Deprecated
    public static final String HTTPS_BINARY_TRANSPORT_PROFILE_URI = "http://opcfoundation.org/UA-Profile/Transport/https-uabinary";
    static Logger logger = LoggerFactory.getLogger(Server.class);
    protected ServiceHandlerComposition serviceHandlers = new ServiceHandlerComposition();
    protected List<UserTokenPolicy> userTokenPolicies = new CopyOnWriteArrayList<UserTokenPolicy>();
    protected EndpointBindingCollection endpointBindings;
    protected EndpointDiscoveryService endpointDiscoveryService;
    protected Application application;
    HttpsServer rk;
    OpcTcpServer rl;
    protected List<EndpointServer.EndpointHandle> boundHandles = new CopyOnWriteArrayList<EndpointServer.EndpointHandle>();

    public static Server createServerApplication() {
        Application application = new Application();
        Server server = new Server(application);
        application.getOpctcpSettings().setCertificateValidator(CertificateValidator.ALLOW_ALL);
        application.getHttpsSettings().setCertificateValidator(CertificateValidator.ALLOW_ALL);
        return server;
    }

    public Server(Application application) {
        this.application = application;
        this.endpointBindings = new EndpointBindingCollection();
        this.endpointDiscoveryService = new EndpointDiscoveryService(this.endpointBindings);
        this.addServiceHandler(this.endpointDiscoveryService);
    }

    public void addServiceHandler(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null arg");
        }
        logger.debug("addServiceHandler: {}", object);
        if (logger.isTraceEnabled()) {
            logger.trace("addServiceHandler: from {}", (Object)Thread.currentThread().getStackTrace()[2]);
        }
        this.serviceHandlers.add(object);
    }

    public void addUserTokenPolicy(UserTokenPolicy userTokenPolicy) {
        this.userTokenPolicies.add(userTokenPolicy);
    }

    public List<EndpointServer.EndpointHandle> bind(String string, Endpoint endpoint) throws ServiceResultException {
        ArrayList<EndpointServer.EndpointHandle> arrayList = new ArrayList<EndpointServer.EndpointHandle>();
        String string2 = UriUtil.getTransportProtocol(string);
        List<SocketAddress> list = EndpointUtil.toSocketAddresses(string);
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        EndpointServer endpointServer = this.getOrCreateEndpointServer(string2);
        for (SocketAddress socketAddress : list) {
            EndpointBinding endpointBinding = new EndpointBinding(endpointServer, endpoint, this);
            EndpointServer.EndpointHandle endpointHandle = endpointServer.bind(socketAddress, endpointBinding);
            this.boundHandles.add(endpointHandle);
            arrayList.add(endpointHandle);
        }
        return arrayList;
    }

    public List<EndpointServer.EndpointHandle> bind(String string, String string2, Collection<SecurityMode> collection) throws ServiceResultException {
        Endpoint endpoint = new Endpoint(string2, collection.toArray(SecurityMode.EMPTY_ARRAY));
        return this.bind(string, endpoint);
    }

    public List<EndpointServer.EndpointHandle> bind(String string, String string2, SecurityMode ... securityModeArray) throws ServiceResultException {
        Endpoint endpoint = new Endpoint(string2, securityModeArray);
        return this.bind(string, endpoint);
    }

    public EndpointServer.ReverseEndpointHandle bindReverse(ReverseConnectionParameters reverseConnectionParameters, ScheduledExecutorService scheduledExecutorService) throws ServiceResultException {
        UaAddress uaAddress;
        String string = reverseConnectionParameters.getClientServerEndpointUrl();
        if (string.startsWith("inv+opc.tcp") || string.startsWith("rcp+opc.tcp")) {
            string = string.substring(4);
        }
        String string2 = reverseConnectionParameters.getEndpointUrlForClientConnection();
        String string3 = UriUtil.getTransportProtocol(string);
        if (!"opc.tcp".equals(string3)) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "ReverseHello is only supported for 'opc.tcp'");
        }
        try {
            uaAddress = UaAddress.parse(string);
        }
        catch (Exception exception) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, (Throwable)exception, "Cannot resolve the given URI: " + string + " as a valid OPC UA address");
        }
        String string4 = uaAddress.getHost();
        if (string4 == null) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot resolve host component of the given URI: " + string);
        }
        int n2 = uaAddress.getPort();
        if (n2 < 0) {
            throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot resolve port component of the given URI: " + string);
        }
        EndpointServer endpointServer = this.getOrCreateEndpointServer("opc.tcp");
        return endpointServer.bindReverse(new InetSocketAddress(string4, n2), reverseConnectionParameters, scheduledExecutorService);
    }

    public void close() {
        for (EndpointServer.EndpointHandle endpointHandle : this.boundHandles) {
            logger.debug("unbind: {}", (Object)endpointHandle);
            endpointHandle.close();
        }
        this.boundHandles.clear();
        if (this.rk != null) {
            this.rk.close();
            this.rk = null;
        }
        if (this.rl != null) {
            this.rl.close();
            this.rl = null;
        }
        logger.info("Server {} closed", (Object)this);
    }

    public ApplicationDescription createApplicationDescription() {
        ApplicationDescription applicationDescription = this.application.J.clone();
        applicationDescription.setApplicationType(ApplicationType.Server);
        return applicationDescription;
    }

    public Application getApplication() {
        return this.application;
    }

    public EndpointServer[] getBindings() {
        ArrayList<EndpointServer> arrayList = new ArrayList<EndpointServer>();
        for (EndpointBinding endpointBinding : this.endpointBindings.get(this)) {
            if (arrayList.contains(endpointBinding.endpointServer)) continue;
            arrayList.add(endpointBinding.endpointServer);
        }
        return arrayList.toArray(new EndpointServer[arrayList.size()]);
    }

    public EncoderContext getEncoderContext() {
        return this.application.getEncoderContext();
    }

    public EndpointBindingCollection getEndpointBindings() {
        return this.endpointBindings;
    }

    public Endpoint getEndpointByUri(String string) {
        List<EndpointBinding> list = this.endpointBindings.get(string);
        if (list.isEmpty()) {
            return null;
        }
        return list.get((int)0).endpointAddress;
    }

    public EndpointDescription[] getEndpointDescriptions() {
        return this.getEndpointDescriptions(null);
    }

    public EndpointDescription[] getEndpointDescriptions(SocketAddress socketAddress) {
        Object object;
        Object[] objectArray;
        Object object2;
        ArrayList<EndpointDescription> arrayList = new ArrayList<EndpointDescription>(this.endpointBindings.size());
        UserTokenPolicy[] userTokenPolicyArray = this.getUserTokenPolicies();
        ApplicationDescription applicationDescription = this.createApplicationDescription();
        ArrayList<Endpoint> arrayList2 = new ArrayList<Endpoint>();
        if (socketAddress != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Server.getEndpointDescriptions: requestAddress={}", (Object)socketAddress);
            }
            for (EndpointServer object3 : this.endpointBindings.getEndpointServers()) {
                int n2;
                int n3;
                boolean bl;
                Object object4;
                Object object5;
                if (logger.isTraceEnabled()) {
                    logger.trace("Server.getEndpointDescriptions: EndpointServer es={}", (Object)object3);
                }
                if (object3 instanceof OpcTcpServer) {
                    object2 = (OpcTcpServer)object3;
                    objectArray = ((OpcTcpServer)object2).socketHandleSnapshot();
                    for (Object object6 : objectArray) {
                        if (((OpcTcpServer.SocketHandle)object6).getBoundSocketAddress() instanceof InetSocketAddress && socketAddress instanceof InetSocketAddress) {
                            object5 = (InetSocketAddress)socketAddress;
                            object4 = ((OpcTcpServer.SocketHandle)object6).getBoundSocketAddress();
                            bl = ((InetSocketAddress)object4).getAddress().isAnyLocalAddress() && ((InetSocketAddress)object4).getPort() == ((InetSocketAddress)object5).getPort();
                        } else {
                            bl = false;
                        }
                        if (!bl && !socketAddress.equals(((OpcTcpServer.SocketHandle)object6).getBoundSocketAddress())) continue;
                        object4 = object5 = ((OpcTcpServer.SocketHandle)object6).endpointHandleSnapshot();
                        n3 = ((Object)object4).length;
                        for (n2 = 0; n2 < n3; ++n2) {
                            object = object4[n2];
                            arrayList2.add(((OpcTcpServer.OpcTcpEndpointHandle)object).endpointBinding().endpointAddress);
                        }
                    }
                }
                if (!(object3 instanceof HttpsServer)) continue;
                object2 = (HttpsServer)object3;
                objectArray = ((HttpsServer)object2).socketHandleSnapshot();
                for (Object object7 : objectArray) {
                    if (((HttpsServer.SocketHandle)object7).getBoundSocketAddress() instanceof InetSocketAddress && socketAddress instanceof InetSocketAddress) {
                        object5 = (InetSocketAddress)socketAddress;
                        object4 = ((HttpsServer.SocketHandle)object7).getBoundSocketAddress();
                        bl = ((InetSocketAddress)object4).getAddress().isAnyLocalAddress() && ((InetSocketAddress)object4).getPort() == ((InetSocketAddress)object5).getPort();
                    } else {
                        bl = false;
                    }
                    if (!bl && !socketAddress.equals(((HttpsServer.SocketHandle)object7).getBoundSocketAddress())) continue;
                    object4 = object5 = ((HttpsServer.SocketHandle)object7).endpointHandleSnapshot();
                    n3 = ((Object)object4).length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        object = object4[n2];
                        arrayList2.add(((HttpsServer.HttpsEndpointHandle)object).endpointBinding().endpointAddress);
                    }
                }
            }
        }
        for (Endpoint endpoint : this.endpointBindings.getEndpointAddresses()) {
            if (socketAddress != null && !arrayList2.contains(endpoint)) continue;
            object2 = endpoint.getEndpointUrl();
            objectArray = UriUtil.getTransportProtocol((String)object2).toLowerCase(Locale.ROOT);
            for (KeyPair keyPair : this.application.getApplicationInstanceCertificates()) {
                Object[] objectArray2 = endpoint.getSecurityModes();
                if (logger.isTraceEnabled()) {
                    logger.trace("getEndpointDescriptions: endpoint={}", (Object)endpoint);
                    logger.trace("getEndpointDescriptions: keyPair={}", (Object)keyPair);
                    logger.trace("getEndpointDescriptions: securityModes={}", (Object)Arrays.toString(objectArray2));
                }
                for (Object object8 : objectArray2) {
                    object = MessageSecurityMode.None;
                    String string = "";
                    String string2 = UATCP_BINARY_TRANSPORT_PROFILE_URI;
                    int n4 = 0;
                    if ("opc.https".equals(objectArray)) {
                        object = ((SecurityMode)object8).getMessageSecurityMode();
                        n4 = object == MessageSecurityMode.None ? 0 : (object == MessageSecurityMode.Sign ? 2 : -1);
                        string = ((SecurityMode)object8).getSecurityPolicy().getPolicyUri();
                        string2 = HTTPS_BINARY_TRANSPORT_PROFILE_URI;
                    } else if ("http".equals(objectArray)) {
                        n4 = 0;
                        string = SecurityPolicy.NONE.getPolicyUri();
                        string2 = HTTPS_BINARY_TRANSPORT_PROFILE_URI;
                    } else if ("opc.tcp".equals(objectArray)) {
                        object = ((SecurityMode)object8).getMessageSecurityMode();
                        n4 = object == MessageSecurityMode.None ? 0 : (object == MessageSecurityMode.Sign ? 1 : (object == MessageSecurityMode.SignAndEncrypt ? 2 : -1));
                        string = ((SecurityMode)object8).getSecurityPolicy().getPolicyUri();
                    }
                    if ((MessageSecurityMode.SignAndEncrypt == object || MessageSecurityMode.Sign == object) && !((SecurityMode)object8).getSecurityPolicy().isUsableWith(keyPair.certificate)) continue;
                    EndpointDescription endpointDescription = new EndpointDescription();
                    endpointDescription.setEndpointUrl(endpoint.getEndpointUrl());
                    endpointDescription.setSecurityMode((MessageSecurityMode)object);
                    endpointDescription.setSecurityLevel(UnsignedByte.valueOf(n4));
                    endpointDescription.setSecurityPolicyUri(string);
                    endpointDescription.setServer(applicationDescription);
                    endpointDescription.setServerCertificate(ByteString.valueOf(keyPair.getCertificate().getEncoded()));
                    endpointDescription.setTransportProfileUri(string2);
                    endpointDescription.setUserIdentityTokens(userTokenPolicyArray);
                    arrayList.add(endpointDescription);
                }
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("getEndpointDescriptions: result={}", (Object)arrayList);
        }
        return arrayList.toArray(new EndpointDescription[0]);
    }

    public Endpoint[] getEndpoints() {
        List<EndpointBinding> list = this.endpointBindings.get(this);
        List<Endpoint> list2 = EndpointBindingCollection.getEndpointAddresses(list);
        return list2.toArray(new Endpoint[list2.size()]);
    }

    public synchronized EndpointServer getOrCreateEndpointServer(String string) throws ServiceResultException {
        if (string.equals("opc.tcp")) {
            return this.getOrCreateOpcTcpServer();
        }
        if (string.equals("http") || string.equals("opc.https")) {
            return this.getOrCreateHttpsServer();
        }
        throw new ServiceResultException(StatusCodes.Bad_UnexpectedError, "Cannot find EndpointServer for scheme " + string);
    }

    public synchronized HttpsServer getOrCreateHttpsServer() throws ServiceResultException {
        if (this.rk == null) {
            this.rk = new HttpsServer(this.getApplication());
        }
        return this.rk;
    }

    public synchronized OpcTcpServer getOrCreateOpcTcpServer() throws ServiceResultException {
        if (this.rl == null) {
            this.rl = new OpcTcpServer(this.getApplication());
        }
        return this.rl;
    }

    public <T> T getServiceHandlerByService(Class<? extends ServiceRequest> clazz) {
        return this.serviceHandlers.getServiceHandlerByService(clazz);
    }

    public ServiceHandlerComposition getServiceHandlerComposition() {
        return this.serviceHandlers;
    }

    public ServiceHandler[] getServiceHandlers() {
        return this.serviceHandlers.getServiceHandlers();
    }

    public UserTokenPolicy[] getUserTokenPolicies() {
        return this.userTokenPolicies.toArray(new UserTokenPolicy[0]);
    }

    public boolean handlesService(Class<? extends IEncodeable> clazz) {
        return this.serviceHandlers.supportsService(clazz);
    }

    public boolean hasEndpoint(String string) {
        List<EndpointBinding> list = this.endpointBindings.get(string);
        return !list.isEmpty();
    }

    public void removeUserTokenPolicy(UserTokenPolicy userTokenPolicy) {
        this.userTokenPolicies.remove(userTokenPolicy);
    }

    public synchronized void setEndpointBindings(EndpointBindingCollection endpointBindingCollection) {
        this.endpointBindings = endpointBindingCollection;
        this.endpointDiscoveryService.endpointBindings = endpointBindingCollection;
    }

    public String toString() {
        return "Server " + this.application.getApplicationUri();
    }
}

