/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.ModelChangeType;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.StructureDataValue;
import com.prosysopc.ua.server.nodes.ReflectiveVariable;
import com.prosysopc.ua.server.nodes.UaInstanceNode;
import com.prosysopc.ua.server.nodes.UaVariableTypeNode;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.GenericAttributeValue;
import com.prosysopc.ua.stack.core.GenericAttributes;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.VariableAttributes;
import com.prosysopc.ua.stack.utils.AttributesUtil;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.OptionSetStructureSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UaVariableNode
extends UaInstanceNode
implements UaVariable {
    private static final Logger logger = LoggerFactory.getLogger(UaVariableNode.class);
    public static boolean synchronizeStructures = true;
    private volatile AccessLevelType ig = AccessLevelType.of(AccessLevelType.Options.CurrentRead, AccessLevelType.Options.CurrentWrite);
    private volatile UnsignedInteger[] bu = null;
    private volatile UaDataType ii;
    private volatile boolean il = false;
    private volatile double im = -1.0;
    private volatile int rg;
    private volatile AccessLevelType ik = AccessLevelType.of(AccessLevelType.Options.CurrentRead, AccessLevelType.Options.CurrentWrite);
    private volatile int valueRank = -1;

    public UaVariableNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
        this.init();
    }

    public UaVariableNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
        this.init();
    }

    protected UaVariableNode(UaNode.Parameters parameters) {
        super(parameters);
        this.init();
    }

    @Override
    public UaReference addProperty(UaProperty uaProperty) {
        return super.addProperty(uaProperty);
    }

    @Override
    public AccessLevelType getAccessLevel() {
        return this.ig;
    }

    @Override
    public UnsignedInteger[] getArrayDimensions() {
        if (this.bu != null) {
            return this.bu;
        }
        return UaVariableTypeNode.b(this.getValueRank());
    }

    @Override
    public NodeAttributes getAttributes() {
        return this.getAttributes(new VariableAttributes());
    }

    @Override
    public UaDataType getDataType() {
        return this.ii;
    }

    @Override
    public NodeId getDataTypeId() {
        UaDataType uaDataType = this.getDataType();
        return uaDataType == null ? NodeId.NULL : uaDataType.getNodeId();
    }

    @Override
    public Boolean getHistorizing() {
        return this.il;
    }

    @Override
    public Double getMinimumSamplingInterval() {
        return this.im;
    }

    @Override
    public final NodeClass getNodeClass() {
        return NodeClass.Variable;
    }

    @Override
    public UaProperty[] getProperties() {
        if (this.isPropertyType()) {
            return null;
        }
        return super.getProperties();
    }

    public StatusCode getStatus() {
        return this.getValue().getStatusCode();
    }

    @Override
    public AccessLevelType getUserAccessLevel() {
        return this.ik;
    }

    @Override
    public Integer getValueRank() {
        return this.valueRank;
    }

    @Override
    public boolean hasUserWriteAccess(UnsignedInteger unsignedInteger) {
        if (unsignedInteger.equals(Attributes.Value)) {
            return this.ik.contains(AccessLevelType.Options.CurrentWrite);
        }
        return super.hasUserWriteAccess(unsignedInteger);
    }

    @Override
    public boolean hasWriteAccess(UnsignedInteger unsignedInteger) {
        if (unsignedInteger.equals(Attributes.Value)) {
            return this.ig.contains(AccessLevelType.Options.CurrentWrite);
        }
        return super.hasWriteAccess(unsignedInteger);
    }

    public void notifyValueChanging(Object object) {
        this.notifyValueChanging(this.createDataValue(object));
    }

    @Override
    public void setAccessLevel(AccessLevelType accessLevelType) {
        this.ig = accessLevelType;
    }

    @Override
    public void setArrayDimensions(UnsignedInteger[] unsignedIntegerArray) {
        if (!Arrays.equals(this.bu, unsignedIntegerArray)) {
            this.bu = unsignedIntegerArray;
        }
    }

    @Override
    public void setAttributes(NodeAttributes nodeAttributes) {
        if (nodeAttributes instanceof VariableAttributes) {
            VariableAttributes variableAttributes = (VariableAttributes)nodeAttributes;
            this.setArrayDimensions(variableAttributes.getArrayDimensions());
            this.setDataTypeId(variableAttributes.getDataType());
            this.setHistorizing(variableAttributes.getHistorizing());
            this.setMinimumSamplingInterval(variableAttributes.getMinimumSamplingInterval());
            try {
                this.setValue(new DataValue(new Variant(variableAttributes.getValue()), StatusCode.GOOD, DateTime.currentTime(), DateTime.currentTime()));
            }
            catch (StatusException statusException) {
                logger.error("StatusException: ", statusException);
            }
            this.setValueRank(variableAttributes.getValueRank());
            this.setAccessLevel(AccessLevelType.of(variableAttributes.getAccessLevel()));
        } else if (nodeAttributes instanceof GenericAttributes) {
            GenericAttributes genericAttributes = (GenericAttributes)nodeAttributes;
            if (genericAttributes.getAttributeValues() != null) {
                block13: for (int i2 = 0; i2 < genericAttributes.getAttributeValues().length; ++i2) {
                    GenericAttributeValue genericAttributeValue = genericAttributes.getAttributeValues()[i2];
                    if (genericAttributeValue.getAttributeId() == null) continue;
                    switch (genericAttributeValue.getAttributeId().intValue()) {
                        case 16: {
                            this.setArrayDimensions((UnsignedInteger[])genericAttributeValue.getValue());
                            continue block13;
                        }
                        case 14: {
                            this.setDataTypeId((NodeId)genericAttributeValue.getValue());
                            continue block13;
                        }
                        case 20: {
                            this.setHistorizing((Boolean)genericAttributeValue.getValue());
                            continue block13;
                        }
                        case 19: {
                            this.setMinimumSamplingInterval((Double)genericAttributeValue.getValue());
                            continue block13;
                        }
                        case 13: {
                            try {
                                this.setValue(new DataValue((Variant)genericAttributeValue.getValue(), StatusCode.GOOD, DateTime.currentTime(), DateTime.currentTime()));
                            }
                            catch (StatusException statusException) {
                                logger.error("StatusException: ", statusException);
                            }
                            continue block13;
                        }
                        case 15: {
                            this.setValueRank((Integer)genericAttributeValue.getValue());
                            continue block13;
                        }
                        case 17: {
                            this.setAccessLevel(AccessLevelType.of((UnsignedByte)genericAttributeValue.getValue()));
                            continue block13;
                        }
                    }
                }
            }
        } else {
            throw new IllegalArgumentException("Incorrect NodeAttributes subtype given, was: " + nodeAttributes);
        }
        super.setAttributes(nodeAttributes);
    }

    @Override
    public void setDataType(UaDataType uaDataType) {
        if (uaDataType == null && this.ii == null) {
            return;
        }
        if (uaDataType == null || !uaDataType.equals(this.ii)) {
            this.ii = uaDataType;
            this.getNodeManager().getNodeManagerTable().getNodeManagerRoot().addModelChange(this, ModelChangeType.DataTypeChanged);
        }
    }

    @Override
    public void setDataTypeId(NodeId nodeId) {
        UaDataType uaDataType = NodeId.isNull(nodeId) ? null : (UaDataType)this.getNodeManager().getNodeOrExternal(nodeId);
        this.setDataType(uaDataType);
    }

    @Override
    public void setHistorizing(Boolean bl) {
        this.il = bl;
    }

    @Override
    public void setMinimumSamplingInterval(Double d2) {
        this.im = d2;
    }

    public void setStatus(StatusCode statusCode) {
        DataValue dataValue = this.getValue();
        if (dataValue != null && dataValue.getStatusCode().equals(statusCode)) {
            return;
        }
        DataValue dataValue2 = new DataValue(statusCode);
        if (dataValue != null) {
            if (!statusCode.isBad()) {
                dataValue2.setValue(dataValue.getValue());
            }
            dataValue2.setServerTimestamp(DateTime.currentTime());
            dataValue2.setSourcePicoseconds(dataValue.getSourcePicoseconds());
            dataValue2.setSourceTimestamp(dataValue.getSourceTimestamp());
        }
        try {
            this.setValue(dataValue2);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    @Override
    public void setTypeDefinition(UaType uaType) {
        this.checkPropertyType(uaType.getNodeId());
        super.setTypeDefinition(uaType);
    }

    @Override
    public void setTypeDefinitionId(ExpandedNodeId expandedNodeId) {
        this.checkPropertyType(expandedNodeId);
        super.setTypeDefinitionId(expandedNodeId);
    }

    @Override
    public void setUserAccessLevel(AccessLevelType accessLevelType) {
        this.ik = accessLevelType;
    }

    @Override
    public void setValue(DataValue dataValue) throws StatusException {
        DataValue dataValue2 = this.getValue();
        boolean bl = dataValue instanceof StructureDataValue;
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl) {
            bl2 = ((StructureDataValue)dataValue).isGoingToRoot();
            bl3 = ((StructureDataValue)dataValue).isGoingToLeaf();
        }
        if (!Objects.equals(dataValue, dataValue2)) {
            Object object;
            if (dataValue != null && bl) {
                object = new DataValue(dataValue.getValue(), dataValue.getStatusCode(), dataValue.getSourceTimestamp(), dataValue.getSourcePicoseconds(), dataValue.getServerTimestamp(), dataValue.getServerPicoseconds());
                this.doSetValue((DataValue)object);
            } else {
                this.doSetValue(dataValue);
            }
            if (this.rg != 0) {
                object = StatusCode.getFromBits(dataValue.getStatusCode().getValue().intValue() | this.rg);
                dataValue = new DataValue(dataValue.getValue(), (StatusCode)object, dataValue.getSourceTimestamp(), dataValue.getSourcePicoseconds(), dataValue.getServerTimestamp(), dataValue.getServerPicoseconds());
            }
            if (logger.isDebugEnabled()) {
                logger.debug("setValue: value={} getValue={}", (Object)dataValue, (Object)this.getValue());
            }
            if (synchronizeStructures && !bl3) {
                dataValue = StructureDataValue.from(dataValue, true);
            }
            this.dataChange(Attributes.Value, dataValue2, dataValue);
            this.rg = 0;
            if (synchronizeStructures && !bl2) {
                this.i(dataValue);
            }
            if (synchronizeStructures && !bl3) {
                this.j(dataValue);
            }
        }
    }

    @Override
    public void setValue(Object object) throws StatusException {
        this.updateValue(object);
    }

    @Override
    public void setValueRank(int n2) {
        if (n2 != this.valueRank) {
            this.valueRank = n2;
        }
    }

    @Override
    public String toString() {
        String string = "";
        if (this.bu != null && this.bu.length > 0) {
            string = "ArrayDImensions=" + Arrays.toString(this.bu);
        }
        return String.format(Locale.ROOT, "%s DataType=%s, ValueRank=%s%s, MinimumSamplingInterval=%f, AccessLevel=%s, UserAccessLevel=%s, Historizing=%s, Value=%s", super.toString(), this.getDataType(), this.valueRank, string, this.im, this.ig, this.ik, this.il, this.getValue());
    }

    public void updateValue(Object object) throws StatusException {
        Variant variant;
        StatusCode statusCode;
        StatusCode statusCode2 = statusCode = object == null ? StatusCode.BAD : StatusCode.GOOD;
        if (object instanceof Variant && (variant = (Variant)object).getValue() == null) {
            statusCode = StatusCode.BAD;
        }
        this.updateValue(object, statusCode, null, null);
    }

    private void init() {
        try {
            this.ii = this.getNodeManager().getDataType(Identifiers.BaseDataType);
        }
        catch (Exception exception) {
            logger.error("Could not set the initial DataType of UaVariableNode to BaseDataType", exception);
        }
    }

    private void a(UaVariableNode uaVariableNode, DataValue dataValue) {
        Object object;
        UaNode[] uaNodeArray;
        FieldSpecification fieldSpecification2;
        StructureSpecification structureSpecification;
        Object object2;
        if (dataValue instanceof StructureDataValue && ((StructureDataValue)dataValue).isGoingToLeaf()) {
            return;
        }
        if (this.getValueRank() != -1) {
            return;
        }
        if (this.getDataType() != null && this.getDataType().inheritsFrom(Identifiers.Structure)) {
            object2 = UaNodeId.fromLocal(this.getDataTypeId(), this.getNodeManager().getNamespaceTable());
            structureSpecification = this.getNodeManager().getNodeManagerTable().getEncoderContext().getStructureSpecification((UaNodeId)object2);
            if (structureSpecification == null) {
                logger.warn("Cannot get StructureSpecification for DataTypeId: {}, skipping component datachange in {}", object2, (Object)this.getNodeId());
                return;
            }
        } else {
            return;
        }
        object2 = uaVariableNode.getBrowseName().getName();
        try {
            fieldSpecification2 = structureSpecification.getField((String)object2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        DataValue dataValue2 = this.getValue();
        Structure structure = null;
        if (dataValue2 != null && !dataValue2.isNull() && (uaNodeArray = dataValue2.getValue().getValue()) instanceof Structure) {
            structure = (Structure)uaNodeArray;
        }
        if (structure == null) {
            try {
                structure = structureSpecification.toInstanceBuilder().build();
                try {
                    uaNodeArray = this.getComponents();
                    object = structureSpecification.getFields().stream().map(fieldSpecification -> fieldSpecification.getName()).collect(Collectors.toList());
                    for (UaNode uaNode : uaNodeArray) {
                        DataValue dataValue3;
                        if (!(uaNode instanceof UaVariable)) continue;
                        UaVariable uaVariable = (UaVariable)uaNode;
                        UaDataTypeSpecification uaDataTypeSpecification = this.getNodeManager().getNodeManagerTable().getEncoderContext().getDataTypeSpecification(UaNodeId.fromLocal(uaVariable.getDataTypeId(), this.getNodeManager().getNodeManagerTable().getNamespaceTable()));
                        if (!object.contains(uaVariable.getBrowseName().getName()) || DataValue.isNull(dataValue3 = uaVariable.getValue())) continue;
                        if (uaDataTypeSpecification instanceof EnumerationSpecification) {
                            structure.set(uaVariable.getBrowseName().getName(), uaVariable.getValue().getValue().asEnum((EnumerationSpecification)uaDataTypeSpecification));
                            continue;
                        }
                        if (uaDataTypeSpecification instanceof OptionSetSpecification && !(uaDataTypeSpecification instanceof OptionSetStructureSpecification)) {
                            structure.set(uaVariable.getBrowseName().getName(), uaVariable.getValue().getValue().asOptionSet((OptionSetSpecification)uaDataTypeSpecification));
                            continue;
                        }
                        structure.set(uaVariable.getBrowseName().getName(), uaVariable.getValue().getValue().getValue());
                    }
                }
                catch (Exception exception) {
                    logger.warn("Failed to initialize new Structure based on subnode values", exception);
                }
            }
            catch (Exception exception) {
                logger.error("Failed to instantiate new Structure, ignoring datachanges in lower nodes", exception);
                return;
            }
        }
        if (!(structure instanceof Cloneable)) {
            logger.error("The current Structure cannot be cloned");
            return;
        }
        try {
            uaNodeArray = structure.clone();
            if (dataValue == null || dataValue.isNull()) {
                uaNodeArray.set(fieldSpecification2, null);
            } else {
                object = dataValue.getValue().getValue();
                if (Enumeration.class.isAssignableFrom(fieldSpecification2.getJavaClass()) && object instanceof Integer) {
                    EnumerationSpecification enumerationSpecification = this.getNodeManager().getNodeManagerTable().getEncoderContext().getEnumerationSpecification(fieldSpecification2.getDataTypeId());
                    if (enumerationSpecification == null) {
                        logger.warn("Cannot get EnumerationSpecification for DataTypeId: {}, skipping sub-node generation in {}", (Object)fieldSpecification2.getDataTypeId(), (Object)this.getNodeId());
                        return;
                    }
                    uaNodeArray.set(fieldSpecification2, (Object)enumerationSpecification.toEnumerationBuilder().setValue((Integer)object).build());
                } else {
                    uaNodeArray.set(fieldSpecification2, object);
                }
            }
            object = new DataValue(dataValue.getValue(), dataValue.getStatusCode(), dataValue.getSourceTimestamp(), dataValue.getSourcePicoseconds(), dataValue.getServerTimestamp(), dataValue.getServerPicoseconds());
            ((DataValue)object).setValue(new Variant(uaNodeArray));
            this.setValue((DataValue)object);
        }
        catch (Exception exception) {
            logger.error("Could not set new Structure value", exception);
            return;
        }
    }

    private void i(DataValue dataValue) {
        UaDataType uaDataType = this.getDataType();
        if (uaDataType == null) {
            return;
        }
        if (Identifiers.Structure.equals(uaDataType.getNodeId())) {
            return;
        }
        if (DataValue.isNull(dataValue)) {
            if (uaDataType.inheritsFrom(Identifiers.Structure)) {
                UaNodeId uaNodeId = UaNodeId.fromLocal(this.getDataTypeId(), this.getNodeManager().getNamespaceTable());
                StructureSpecification structureSpecification = this.getNodeManager().getNodeManagerTable().getEncoderContext().getStructureSpecification(uaNodeId);
                if (structureSpecification == null) {
                    logger.warn("Cannot get StructureSpecification for DataTypeId: {}, skipping sub-node value setting in {}", (Object)uaNodeId, (Object)this.getNodeId());
                    return;
                }
                HashMap<String, FieldSpecification> hashMap = new HashMap<String, FieldSpecification>();
                for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
                    hashMap.put(fieldSpecification.getName(), fieldSpecification);
                }
                try {
                    for (UaNode uaNode : this.getComponents()) {
                        UaVariable uaVariable;
                        if (!(uaNode instanceof UaVariable) || !hashMap.containsKey((uaVariable = (UaVariable)uaNode).getBrowseName().getName())) continue;
                        uaVariable.setValue(StructureDataValue.from(dataValue, false));
                    }
                }
                catch (Exception exception) {
                    logger.error("Error while trying to write structru value to up/down parts", exception);
                }
            }
            return;
        }
        Object object2 = dataValue.getValue().getValue();
        if (!(object2 instanceof Structure)) {
            return;
        }
        UaNodeId uaNodeId = UaNodeId.fromLocal(this.getDataTypeId(), this.getNodeManager().getNamespaceTable());
        UaDataTypeSpecification uaDataTypeSpecification = this.getNodeManager().getNodeManagerTable().getEncoderContext().getDataTypeSpecification(uaNodeId);
        if (!(uaDataTypeSpecification instanceof StructureSpecification)) {
            logger.warn("Trying to synchronize Structure parts downstream, but didn't find StructureSpecification for DataTypeId: {}, skipping sub-node value setting in {}", (Object)uaNodeId, (Object)this.getNodeId());
            return;
        }
        logger.trace("Trying to set values from a Structure to components");
        Structure structure = (Structure)object2;
        try {
            UaNode[] uaNodeArray = this.getComponents();
            StructureSpecification structureSpecification = (StructureSpecification)uaDataTypeSpecification;
            HashMap<String, FieldSpecification> hashMap = new HashMap<String, FieldSpecification>();
            for (FieldSpecification uaNodeArray2 : structureSpecification.getFields()) {
                hashMap.put(uaNodeArray2.getName(), uaNodeArray2);
            }
            Map<String, Object> map = structure.toFieldNamesMap();
            for (UaNode uaNode : uaNodeArray) {
                Object object3;
                UaVariable uaVariable;
                if (!(uaNode instanceof UaVariable) || !hashMap.containsKey((uaVariable = (UaVariable)uaNode).getBrowseName().getName())) continue;
                Object object4 = map.get(uaVariable.getBrowseName().getName());
                FieldSpecification fieldSpecification = (FieldSpecification)hashMap.get(uaVariable.getBrowseName().getName());
                if (fieldSpecification == null) {
                    throw new IllegalStateException("No fieldSpecification for a field that is being processed");
                }
                if (object4 != null && fieldSpecification.isAllowSubTypes() && fieldSpecification.getJavaClassDimensions() > 0 && UaIds.BaseDataType.equals(fieldSpecification.getEncodeTypeId())) {
                    int n2;
                    object3 = MultiDimensionArrayUtils.getArrayLengths(object4);
                    int n3 = n2 = ((Object)object3).length == 0 ? 0 : MultiDimensionArrayUtils.getLength((int[])object3);
                    if (n2 == 0) {
                        object4 = null;
                    } else {
                        AtomicReference atomicReference = new AtomicReference();
                        MultiDimensionArrayUtils.forEach(object4, Object.class, object -> {
                            if (object != null) {
                                atomicReference.compareAndSet(null, object.getClass());
                            }
                        });
                        if (atomicReference.get() == null) {
                            object4 = null;
                        } else {
                            Object object5 = MultiDimensionArrayUtils.map(object4, Object.class, (Class)atomicReference.get(), object -> ((Class)atomicReference.get()).cast(object));
                            object4 = object5;
                        }
                    }
                }
                object3 = dataValue.clone();
                ((DataValue)object3).setValue(new Variant(object4));
                uaVariable.setValue(StructureDataValue.from((DataValue)object3, false));
            }
        }
        catch (Exception exception) {
            logger.error("Error while trying to write structure value to up/down parts", exception);
        }
    }

    private void j(DataValue dataValue) {
        for (UaReference uaReference : this.getReferences(Identifiers.HasComponent, true)) {
            UaNode uaNode = uaReference.getOppositeNode(this);
            if (!(uaNode instanceof UaVariableNode)) continue;
            ((UaVariableNode)uaNode).a(this, dataValue);
        }
    }

    protected ReflectiveVariable addReflectiveVariable(Object object, NodeId nodeId, String string, int n2, NodeId nodeId2) throws SecurityException, NoSuchMethodException {
        ReflectiveVariable reflectiveVariable = new ReflectiveVariable(this.getNodeManager(), nodeId, object, string, Locale.ENGLISH);
        reflectiveVariable.setBrowseName(new QualifiedName(n2, reflectiveVariable.getBrowseName().getName()));
        reflectiveVariable.setTypeDefinitionId(nodeId2);
        if (this.addComponent(reflectiveVariable) == null) {
            throw new RuntimeException("Component " + reflectiveVariable.getBrowseName() + " not added to " + this.getClass());
        }
        return reflectiveVariable;
    }

    @Override
    protected boolean beforeAddReference(UaReference uaReference) {
        if (this.isPropertyType() && !uaReference.getIsInverse(this) && uaReference.getReferenceTypeId().equals(Identifiers.HasProperty)) {
            throw new IllegalArgumentException("Cannot add property nodes to a Property node(BrowseName=" + this.getBrowseName() + " NodeId=" + this.getNodeId());
        }
        return super.beforeAddReference(uaReference);
    }

    protected void checkPropertyType(ExpandedNodeId expandedNodeId) {
        if (this.isPropertyType()) {
            try {
                this.checkPropertyType(this.nodeManager.getNamespaceTable().toNodeId(expandedNodeId));
            }
            catch (ServiceResultException serviceResultException) {
                throw new IllegalArgumentException("UaProperty must be of type PropertyType", serviceResultException);
            }
        }
    }

    protected void checkPropertyType(NodeId nodeId) {
        if (this.isPropertyType() && !Identifiers.PropertyType.equals(nodeId)) {
            throw new IllegalArgumentException("UaProperty must be of type PropertyType");
        }
    }

    protected DataValue createDataValue(Object object) {
        DataValue dataValue = new DataValue(new Variant(object));
        DateTime dateTime = DateTime.currentTime();
        dataValue.setServerTimestamp(dateTime);
        dataValue.setSourceTimestamp(dateTime);
        return dataValue;
    }

    protected abstract void doSetValue(DataValue var1) throws StatusException;

    protected void exposeStructureWithReflectiveVariables(Structure structure, int n2, NodeId nodeId) {
        for (Method method : structure.getClass().getDeclaredMethods()) {
            String string;
            if (Modifier.isStatic(method.getModifiers()) || !method.getName().startsWith("get") || (string = method.getName().substring(3)).equals("TypeId") || string.equals("XmlEncodeId") || string.equals("BinaryEncodeId")) continue;
            if (Structure.class.isAssignableFrom(method.getReturnType())) {
                try {
                    Structure structure2 = (Structure)method.invoke((Object)structure, new Object[0]);
                    if (structure2 != null) {
                        Field field = Identifiers.class.getDeclaredField(method.getReturnType().getSimpleName());
                        NodeId nodeId2 = (NodeId)field.get(null);
                        ReflectiveVariable reflectiveVariable = this.addReflectiveVariable(structure, NodeId.randomGUID(this.getNodeManager().getNamespaceIndex()), string, n2, nodeId2);
                        reflectiveVariable.exposeStructureWithReflectiveVariables(structure2, n2, nodeId);
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("internalStructure == null: {}", (Object)method.getName());
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new RuntimeException(illegalAccessException);
                }
                catch (SecurityException securityException) {
                    throw new RuntimeException(securityException);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    throw new RuntimeException(noSuchFieldException);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new RuntimeException(noSuchMethodException);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new RuntimeException(illegalArgumentException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new RuntimeException(invocationTargetException);
                }
            }
            try {
                this.addReflectiveVariable(structure, NodeId.randomGUID(this.getNodeManager().getNamespaceIndex()), string, n2, nodeId);
                logger.debug("{} added", (Object)string);
            }
            catch (SecurityException securityException) {
                throw new RuntimeException("Failed to create variable for " + structure.getClass() + " component " + string, securityException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                logger.warn("Failed to create variable for " + structure.getClass() + " component " + string + ": ", noSuchMethodException);
            }
        }
    }

    protected VariableAttributes getAttributes(VariableAttributes variableAttributes) {
        super.getAttributes(variableAttributes);
        variableAttributes.setAccessLevel((UnsignedByte)this.getAccessLevel().asBuiltInType());
        variableAttributes.setArrayDimensions(this.getArrayDimensions());
        variableAttributes.setDataType(this.getDataTypeId());
        variableAttributes.setHistorizing(this.getHistorizing());
        variableAttributes.setMinimumSamplingInterval(this.getMinimumSamplingInterval());
        variableAttributes.setUserAccessLevel((UnsignedByte)this.getUserAccessLevel().asBuiltInType());
        variableAttributes.setValue(this.getValue().getValue().getValue());
        variableAttributes.setValueRank(this.getValueRank());
        return variableAttributes;
    }

    @Override
    protected void getAttributesMap(Map<UnsignedInteger, Object> map) {
        super.getAttributesMap(map);
        map.put(Attributes.AccessLevel, this.getAccessLevel().asBuiltInType());
        map.put(Attributes.ArrayDimensions, this.getArrayDimensions());
        map.put(Attributes.DataType, this.getDataTypeId());
        map.put(Attributes.Historizing, this.getHistorizing());
        map.put(Attributes.MinimumSamplingInterval, this.getMinimumSamplingInterval());
        map.put(Attributes.UserAccessLevel, this.getUserAccessLevel().asBuiltInType());
        map.put(Attributes.Value, this.getValue().getValue().getValue());
        map.put(Attributes.ValueRank, this.getValueRank());
    }

    @Override
    protected ExpandedNodeId getDefaultTypeDefinition() {
        if (this.isPropertyType()) {
            return new ExpandedNodeId(Identifiers.PropertyType);
        }
        return new ExpandedNodeId(Identifiers.BaseDataVariableType);
    }

    @Override
    protected void initSupportedAttributes(List<UnsignedInteger> list) {
        super.initSupportedAttributes(list);
        list.add(Attributes.Value);
        list.add(Attributes.DataType);
        list.add(Attributes.ValueRank);
        list.add(Attributes.ArrayDimensions);
        list.add(Attributes.AccessLevel);
        list.add(Attributes.UserAccessLevel);
        list.add(Attributes.MinimumSamplingInterval);
        list.add(Attributes.Historizing);
    }

    protected boolean isPropertyType() {
        return UaProperty.class.isAssignableFrom(this.getClass());
    }

    protected void notifyValueChanging(DataValue dataValue) {
        DataValue dataValue2 = this.getValue();
        if (!Objects.equals(dataValue2.getValue().getValue(), dataValue.getValue().getValue())) {
            this.fireDataChange(dataValue2, dataValue);
        }
    }

    @Override
    protected void readAttributeValue(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        switch (unsignedInteger.intValue()) {
            case 14: {
                dataValue.setValue(new Variant(this.getDataTypeId()));
                break;
            }
            case 17: {
                dataValue.setValue(new Variant(this.getAccessLevel()));
                break;
            }
            case 18: {
                dataValue.setValue(new Variant(this.getUserAccessLevel()));
                break;
            }
            case 19: {
                dataValue.setValue(new Variant(this.getMinimumSamplingInterval()));
                break;
            }
            case 20: {
                dataValue.setValue(new Variant(this.getHistorizing()));
                break;
            }
            case 13: {
                DataValue dataValue2 = this.getValue();
                dataValue.setValue(dataValue2.getValue());
                dataValue.setSourceTimestamp(dataValue2.getSourceTimestamp());
                dataValue.setSourcePicoseconds(dataValue2.getSourcePicoseconds());
                dataValue.setServerTimestamp(dataValue2.getServerTimestamp());
                dataValue.setServerPicoseconds(dataValue2.getServerPicoseconds());
                dataValue.setStatusCode(dataValue2.getStatusCode());
                break;
            }
            case 15: {
                dataValue.setValue(new Variant(this.getValueRank()));
                break;
            }
            case 16: {
                dataValue.setValue(new Variant(this.getArrayDimensions()));
                break;
            }
            default: {
                super.readAttributeValue(unsignedInteger, dataValue);
            }
        }
    }

    protected void semanticsChanged() {
        if (logger.isDebugEnabled()) {
            logger.debug("semanticsChanged: node={}/{}", (Object)this.getNodeId(), (Object)this.getBrowseName());
        }
        this.nodeManager.getNodeManagerTable().getNodeManagerRoot().addSemanticChange(this);
        this.rg |= 0x4000;
    }

    protected void structureChanged() {
        if (logger.isDebugEnabled()) {
            logger.debug("structureChanged: node={}/{}", (Object)this.getNodeId(), (Object)this.getBrowseName());
        }
        this.nodeManager.getNodeManagerTable().getNodeManagerRoot().addSemanticChange(this);
        this.rg |= 0x8000;
    }

    protected void updateValue(Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        Variant variant;
        DataValue dataValue;
        logger.debug("updateValue: {}", object);
        DateTime dateTime2 = DateTime.currentTime();
        UnsignedShort unsignedShort2 = UnsignedShort.valueOf(0);
        if (object instanceof DataValue) {
            dataValue = (DataValue)object;
            variant = dataValue.getValue();
            statusCode = dataValue.getStatusCode();
            dateTime = dataValue.getSourceTimestamp();
            unsignedShort = dataValue.getSourcePicoseconds();
        } else {
            variant = object instanceof Variant ? (Variant)object : new Variant(object);
        }
        if (dateTime == null) {
            dateTime = dateTime2;
        }
        if (unsignedShort == null) {
            unsignedShort = unsignedShort2;
        }
        dataValue = this.getValue();
        logger.debug("updateValue: oldValue={}", (Object)dataValue);
        if (dataValue == null || dataValue.isNull() || !dataValue.getStatusCode().equals(statusCode) || !dataValue.getValue().equals(variant) || !dateTime.equals(this.getValue().getSourceTimestamp())) {
            this.setValue(new DataValue(variant, statusCode, dateTime, unsignedShort, dateTime2, unsignedShort2));
        } else {
            dataValue.setServerTimestamp(dateTime2);
        }
    }

    @Override
    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        block17: {
            try {
                if (unsignedInteger.equals(Attributes.Value)) {
                    this.updateValue(object, statusCode, dateTime, unsignedShort);
                    break block17;
                }
                if (unsignedInteger.equals(Attributes.AccessLevel)) {
                    this.ig = object instanceof AccessLevelType ? (AccessLevelType)object : AccessLevelType.of((UnsignedByte)object);
                    break block17;
                }
                if (unsignedInteger.equals(Attributes.UserAccessLevel)) {
                    this.ik = object instanceof AccessLevelType ? (AccessLevelType)object : AccessLevelType.of((UnsignedByte)object);
                    break block17;
                }
                if (unsignedInteger.equals(Attributes.MinimumSamplingInterval)) {
                    this.im = (Double)object;
                    break block17;
                }
                if (unsignedInteger.equals(Attributes.Historizing)) {
                    this.il = (Boolean)object;
                    break block17;
                }
                if (unsignedInteger.equals(Attributes.DataType)) {
                    if (object instanceof NodeId) {
                        this.setDataTypeId((NodeId)object);
                        break block17;
                    }
                    if (object instanceof ExpandedNodeId) {
                        try {
                            this.setDataTypeId(this.getNodeManager().getNamespaceTable().toNodeId((ExpandedNodeId)object));
                            break block17;
                        }
                        catch (ServiceResultException serviceResultException) {
                            throw new StatusException(StatusCodes.Bad_InvalidArgument, (Throwable)serviceResultException);
                        }
                    }
                    throw new StatusException("Cannot set NodeId to the specified value", StatusCodes.Bad_InvalidArgument);
                }
                if (unsignedInteger.equals(Attributes.ValueRank)) {
                    this.valueRank = (Integer)object;
                } else if (unsignedInteger.equals(Attributes.ArrayDimensions)) {
                    this.bu = (UnsignedInteger[])object;
                } else {
                    super.writeAttributeValue(unsignedInteger, object, statusCode, dateTime, unsignedShort);
                }
            }
            catch (RuntimeException runtimeException) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Cannot write attribute " + AttributesUtil.toString(unsignedInteger) + " Variable=" + this.getBrowseName() + " Value=" + object, runtimeException);
                }
                throw new StatusException("Cannot write value", StatusCodes.Bad_InvalidArgument, null, (Throwable)runtimeException);
            }
        }
    }
}

