/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.EventData;
import com.prosysopc.ua.EventListener;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaException;
import com.prosysopc.ua.nodes.AbstractUaNode;
import com.prosysopc.ua.nodes.DataChangeListener;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaObject;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.ModelChangeType;
import com.prosysopc.ua.server.NodeManagerRoot;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.UaExternalNode;
import com.prosysopc.ua.server.nodes.UaInstanceNode;
import com.prosysopc.ua.server.nodes.UaServerReference;
import com.prosysopc.ua.server.nodes.UaVariableNode;
import com.prosysopc.ua.server.nodes.a;
import com.prosysopc.ua.server.nodes.b;
import com.prosysopc.ua.server.nodes.c;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.BrowsePathTarget;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.RelativePath;
import com.prosysopc.ua.stack.core.RelativePathElement;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.utils.AttributesUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServerNode
extends AbstractUaNode {
    private static boolean qU = true;
    private static final Logger logger = LoggerFactory.getLogger(ServerNode.class);
    protected static final DateTime INITIALIZATION_TIME = DateTime.currentTime();
    protected static final Map<Class<? extends UaNode>, List<UnsignedInteger>> supportedAttributesMap = new HashMap<Class<? extends UaNode>, List<UnsignedInteger>>();
    private List<DataChangeListener> qV;
    private NodeId nodeId;
    private final Collection<UaReference> qW = new c();
    protected List<EventListener> eventListeners;
    protected final NodeManagerUaNode nodeManager;

    public static boolean isAddNotifierReferencesToServerObject() {
        return qU;
    }

    public static void setAddNotifierReferencesToServerObject(boolean bl) {
        qU = bl;
    }

    public ServerNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId) {
        this.nodeManager = nodeManagerUaNode;
        this.nodeId = nodeId;
    }

    protected ServerNode(UaNode.Parameters parameters) {
        try {
            NodeManagerUaNode nodeManagerUaNode;
            NodeManagerTable nodeManagerTable = (NodeManagerTable)parameters.getAddressSpace();
            NodeId nodeId = parameters.getNodeId().asNodeId(nodeManagerTable.getNamespaceTable());
            this.nodeManager = nodeManagerUaNode = (NodeManagerUaNode)nodeManagerTable.getNodeManager(nodeId);
            this.nodeId = nodeId;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("ServerNode creation failed", exception);
        }
    }

    @Override
    public UaReference addComponent(UaNode uaNode) {
        return this.addReference(uaNode, Identifiers.HasComponent, false);
    }

    public synchronized void addDataChangeListener(DataChangeListener dataChangeListener) {
        if (this.cte() == null) {
            this.qV = new CopyOnWriteArrayList<DataChangeListener>();
        }
        this.cte().add(dataChangeListener);
    }

    public synchronized void addEventListener(EventListener eventListener) {
        if (this.ctf() == null) {
            this.eventListeners = new CopyOnWriteArrayList<EventListener>();
        }
        this.ctf().add(eventListener);
    }

    public UaReference addNewReference(NodeId nodeId, NodeId nodeId2, boolean bl) {
        return this.addNewReference(this.nodeManager.getNodeOrExternal(nodeId), nodeId2, bl);
    }

    public UaReference addNewReference(UaNode uaNode, NodeId nodeId, boolean bl) {
        Object object;
        UaNode uaNode2 = bl ? uaNode : this;
        UaNode uaNode3 = bl ? this : uaNode;
        UaServerReference uaServerReference = new UaServerReference(nodeId, uaNode2, uaNode3);
        this.c(uaServerReference);
        if (uaNode instanceof ServerNode) {
            object = (ServerNode)uaNode;
            ((ServerNode)object).c(uaServerReference);
            ((ServerNode)object).getAddressSpace().addNode((UaNode)object);
        }
        if (uaServerReference.getTargetNode().equals(this)) {
            this.validateHasEventSourceChain(uaServerReference);
        }
        object = this.getNodeManager().getNodeManagerTable().getNodeManagerRoot();
        ((NodeManagerRoot)object).addModelChange(this, ModelChangeType.ReferenceAdded);
        return uaServerReference;
    }

    @Override
    public UaReference addOrganizes(UaNode uaNode) {
        return this.addReference(uaNode, Identifiers.Organizes, false);
    }

    public void addProperties(UaProperty[] uaPropertyArray) {
        for (UaProperty uaProperty : uaPropertyArray) {
            this.addProperty(uaProperty);
        }
    }

    @Override
    public UaReference addProperty(UaProperty uaProperty) {
        logger.debug("addProperty: property={}", (Object)uaProperty.getBrowseName());
        return this.addReference((UaNode)uaProperty, Identifiers.HasProperty, false);
    }

    @Override
    public UaReference addReference(ExpandedNodeId expandedNodeId, NodeId nodeId, boolean bl) {
        if (expandedNodeId != null && !expandedNodeId.isLocal()) {
            ExpandedNodeId expandedNodeId2 = this.getAddressSpace().getNamespaceTable().toExpandedNodeId(this.getNodeId());
            ExpandedNodeId expandedNodeId3 = bl ? expandedNodeId : expandedNodeId2;
            ExpandedNodeId expandedNodeId4 = bl ? expandedNodeId2 : expandedNodeId;
            return this.addReference(new b(nodeId, expandedNodeId3, expandedNodeId4, this.getAddressSpace()));
        }
        try {
            return this.addReference(this.getAddressSpace().getNamespaceTable().toNodeId(expandedNodeId), nodeId, bl);
        }
        catch (ServiceResultException serviceResultException) {
            throw new IllegalArgumentException("Given expanded nodeId cannot be converted to NodeId");
        }
    }

    @Override
    public UaReference addReference(NodeId nodeId, NodeId nodeId2, boolean bl) {
        UaNode uaNode = this.nodeManager.getNodeOrExternal(nodeId);
        return this.addReference(uaNode, nodeId2, bl);
    }

    public UaReference addReference(UaNode uaNode, ExpandedNodeId expandedNodeId, boolean bl) {
        NodeId nodeId;
        try {
            nodeId = this.getNodeManager().getNamespaceTable().toNodeId(expandedNodeId);
        }
        catch (ServiceResultException serviceResultException) {
            throw new IllegalArgumentException("Cannot convert referenceTypeId to NodeId", serviceResultException);
        }
        return this.addReference(uaNode, nodeId, bl);
    }

    @Override
    public UaReference addReference(UaNode uaNode, NodeId nodeId, boolean bl) {
        UaNode uaNode2 = bl ? uaNode : this;
        UaNode uaNode3 = bl ? this : uaNode;
        return this.addReference(UaServerReference.getReferenceInstance(nodeId, uaNode2, uaNode3));
    }

    public UaReference addReference(UaNode uaNode, UaReferenceType uaReferenceType, boolean bl) {
        UaNode uaNode2 = bl ? uaNode : this;
        UaNode uaNode3 = bl ? this : uaNode;
        return this.addReference(UaServerReference.getReferenceInstance(uaReferenceType, uaNode2, uaNode3));
    }

    @Override
    public UaReference deleteReference(ExpandedNodeId expandedNodeId, NodeId nodeId, boolean bl) {
        logger.debug("deleteReference targetNodeId : {}", (Object)expandedNodeId);
        for (UaReference uaReference : this.getReferenceList()) {
            Comparable<ExpandedNodeId> comparable;
            Comparable<ExpandedNodeId> comparable2 = bl ? this.getNodeId() : expandedNodeId;
            Comparable<ExpandedNodeId> comparable3 = comparable = bl ? expandedNodeId : this.getNodeId();
            if (!uaReference.getTargetId().equals(comparable2) || !uaReference.getSourceId().equals(comparable) || !uaReference.getReferenceTypeId().equals(nodeId)) continue;
            return this.doDeleteReference(uaReference);
        }
        return null;
    }

    @Override
    public UaReference deleteReference(NodeId nodeId, NodeId nodeId2, boolean bl) {
        return this.deleteReference(new ExpandedNodeId(nodeId), nodeId2, bl);
    }

    @Override
    public UaReference deleteReference(UaNode uaNode, NodeId nodeId, boolean bl) {
        return this.deleteReference(uaNode.getNodeId(), nodeId, bl);
    }

    @Override
    public UaReference deleteReference(UaReference uaReference) {
        return this.doDeleteReference(uaReference);
    }

    public void deleteReferences(NodeId nodeId) {
        logger.debug("deleteReferences targetNodeId : {}", (Object)nodeId);
        for (UaReference uaReference : this.getReferenceList()) {
            if (!nodeId.equals(uaReference.getTargetId())) continue;
            this.doDeleteReference(uaReference);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UaNode uaNode = (UaNode)object;
        if (NodeId.isNull(this.nodeId)) {
            return NodeId.isNull(uaNode.getNodeId());
        }
        return this.nodeId.equals(uaNode.getNodeId());
    }

    @Override
    public NodeManagerTable getAddressSpace() {
        return this.nodeManager.getNodeManagerTable();
    }

    @Override
    public NodeId getNodeId() {
        return this.nodeId;
    }

    public NodeManagerUaNode getNodeManager() {
        return this.nodeManager;
    }

    @Override
    public UaReference getReference(NodeId nodeId, boolean bl) {
        Collection<UaReference> collection = this.getReferenceList();
        if (collection != null) {
            for (UaReference uaReference : collection) {
                if (!NodeId.isNull(nodeId) && !uaReference.getReferenceTypeId().equals(nodeId) || uaReference.getIsInverse(this) != bl) continue;
                return uaReference;
            }
        }
        return null;
    }

    @Override
    public UaReference[] getReferences(NodeId nodeId, boolean bl) {
        List<UaReference> list = this.getReferencesAsList(bl, nodeId);
        return list.toArray(new UaReference[list.size()]);
    }

    @Override
    public UnsignedInteger[] getSupportedAttributes() {
        List<UnsignedInteger> list = this.cps();
        return list.toArray(new UnsignedInteger[list.size()]);
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.nodeId == null ? 0 : this.nodeId.hashCode());
        return n3;
    }

    public boolean isMandatory() {
        return this.a(this, new ArrayList<QualifiedName>());
    }

    @Override
    public UaNode removeComponent(UaNode uaNode) {
        UaReference uaReference = this.deleteReference(uaNode, Identifiers.HasComponent, false);
        return uaReference == null ? null : uaNode;
    }

    public synchronized void removeDataChangeListener(DataChangeListener dataChangeListener) {
        List<DataChangeListener> list = this.cte();
        if (list != null) {
            list.remove(dataChangeListener);
            if (list.isEmpty()) {
                this.qV = null;
            }
        }
    }

    public synchronized void removeEventListener(EventListener eventListener) {
        if (this.ctf() != null) {
            this.ctf().remove(eventListener);
            if (this.ctf().isEmpty()) {
                this.eventListeners = null;
            }
        }
    }

    @Override
    public void setReferences(UaReference[] uaReferenceArray) {
        ((c)this.qW).a(Arrays.asList(uaReferenceArray));
    }

    @Override
    public boolean supportsAttribute(UnsignedInteger unsignedInteger) {
        return this.cps().contains(unsignedInteger);
    }

    public String toString() {
        return String.format(Locale.ROOT, "NodeId=%s, NodeClass=%s", this.nodeId, this.getNodeClass());
    }

    private synchronized void c(UaReference uaReference) {
        this.qW.add(uaReference);
    }

    private synchronized List<DataChangeListener> cte() {
        return this.qV;
    }

    private synchronized List<EventListener> ctf() {
        return this.eventListeners;
    }

    private List<UnsignedInteger> cps() {
        List<UnsignedInteger> list = supportedAttributesMap.get(this.getClass());
        if (list == null) {
            list = new ArrayList<UnsignedInteger>();
            this.initSupportedAttributes(list);
            supportedAttributesMap.put(this.getClass(), list);
        }
        return list;
    }

    private boolean a(UaNode uaNode, List<QualifiedName> list) {
        Object object;
        if (uaNode == null) {
            return false;
        }
        if (uaNode instanceof UaInstance && !(uaNode instanceof UaProperty) && this.a((UaType)(object = ((UaInstance)uaNode).getTypeDefinition()), list)) {
            return true;
        }
        int n2 = 0;
        object = uaNode.getReferences(Identifiers.HierarchicalReferences, true);
        UaReference[] uaReferenceArray = object;
        int n3 = uaReferenceArray.length;
        if (n2 < n3) {
            UaReference uaReference = uaReferenceArray[n2];
            ArrayList<QualifiedName> arrayList = new ArrayList<QualifiedName>();
            arrayList.add(uaNode.getBrowseName());
            for (QualifiedName qualifiedName : list) {
                arrayList.add(qualifiedName);
            }
            return this.a(uaReference.getSourceNode(), arrayList);
        }
        return false;
    }

    private boolean a(UaType uaType, List<QualifiedName> list) {
        if (uaType == null) {
            return false;
        }
        NodeId[] nodeIdArray = this.translateBrowsePathToNodeIds(uaType.getNodeId(), list.toArray(new QualifiedName[0]));
        if (nodeIdArray.length == 0) {
            return false;
        }
        for (NodeId nodeId : nodeIdArray) {
            try {
                UaNode uaNode = this.getNodeManager().getNodeManagerTable().getNode(nodeId);
                UaReference uaReference = uaNode.getReference(Identifiers.HasModellingRule, false);
                if (uaReference == null || !uaReference.getTargetId().equals(Identifiers.ModellingRule_Mandatory)) continue;
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    protected final UaReference addReference(UaReference uaReference) {
        UaReference uaReference2 = this.hasReference(uaReference);
        if (uaReference2 != null) {
            return uaReference2;
        }
        if (!(uaReference instanceof UaServerReference) && !(uaReference instanceof b)) {
            throw new IllegalArgumentException("BaseNode.addReference() requires an instance of UaServerReference");
        }
        if (this.beforeAddReference(uaReference)) {
            this.c(uaReference);
        }
        this.afterAddReference(uaReference);
        return uaReference;
    }

    protected void afterAddReference(UaReference uaReference) {
        Object object;
        UaNode uaNode = uaReference.getOppositeNode(this);
        if (uaNode != null) {
            if (!uaReference.getIsInverse(this) && (object = uaReference.getReferenceType()) != null && object.inheritsFrom(Identifiers.HierarchicalReferences) && !(uaNode instanceof UaExternalNode) && !NodeId.isNull(uaNode.getNodeId())) {
                uaNode.getAddressSpace().addNode(uaNode);
            }
            if (!(uaReference instanceof a)) {
                if (uaReference instanceof UaServerReference && uaNode instanceof ServerNode && ((c)((ServerNode)uaNode).getReferenceList()).ctg()) {
                    ((ServerNode)uaNode).addReference(uaReference);
                } else {
                    uaNode.addReference(this, uaReference.getReferenceTypeId(), uaReference.getIsInverse(uaNode));
                }
            }
            if (uaReference.getTargetNode().equals(this)) {
                this.validateHasEventSourceChain(uaReference);
            }
        }
        object = this.getNodeManager().getNodeManagerTable().getNodeManagerRoot();
        ((NodeManagerRoot)object).addModelChange(this, ModelChangeType.ReferenceAdded);
    }

    protected void afterDeleteReference(UaReference uaReference) {
        NodeManagerRoot nodeManagerRoot = this.getNodeManager().getNodeManagerTable().getNodeManagerRoot();
        nodeManagerRoot.addModelChange(this, ModelChangeType.ReferenceDeleted);
        uaReference.getOppositeNode(this).deleteReference(uaReference);
    }

    protected boolean beforeAddReference(UaReference uaReference) {
        if (!uaReference.getIsInverse(this)) {
            UaNode uaNode = uaReference.getTargetNode();
            if (uaReference.getReferenceTypeId().equals(Identifiers.HasProperty)) {
                if (!(uaNode instanceof UaProperty)) {
                    logger.debug("could not cast to UaReference:{} ..with referenceId: {}", (Object)uaNode, uaReference.getReferenceTypeId().getValue());
                    throw new IllegalArgumentException("Target of HasProperty reference must be a UaProperty");
                }
                return this.doAddProperty((UaProperty)uaNode);
            }
        }
        return true;
    }

    protected void dataChange(UnsignedInteger unsignedInteger, DataValue dataValue, DataValue dataValue2) {
        if (!Attributes.Value.equals(unsignedInteger)) {
            return;
        }
        this.fireDataChange(dataValue, dataValue2);
        if (this instanceof UaVariable && ((UaVariable)((Object)this)).getAccessLevel().contains(AccessLevelType.Options.SemanticChange)) {
            if (dataValue != null && dataValue2 != null && Objects.equals(dataValue2.getValue(), dataValue.getValue()) && Objects.equals(dataValue2.getStatusCode(), dataValue.getStatusCode()) && Objects.equals(dataValue2.getSourceTimestamp(), dataValue.getSourceTimestamp()) && Objects.equals(dataValue2.getSourcePicoseconds(), dataValue.getSourcePicoseconds())) {
                return;
            }
            UaReference[] uaReferenceArray = this.getInverseReferences(Identifiers.HasProperty);
            if (uaReferenceArray != null && uaReferenceArray.length != 0) {
                this.getNodeManager().getNodeManagerTable().getNodeManagerRoot().beginSemanticChange();
                for (UaReference uaReference : uaReferenceArray) {
                    UaNode uaNode = uaReference.getSourceNode();
                    if (uaNode instanceof UaVariableNode) {
                        ((UaVariableNode)uaNode).semanticsChanged();
                    }
                    this.getNodeManager().getNodeManagerTable().getNodeManagerRoot().addSemanticChange(uaNode);
                }
                this.getNodeManager().getNodeManagerTable().getNodeManagerRoot().endSemanticChange();
            }
        }
    }

    protected boolean doAddProperty(UaProperty uaProperty) {
        return true;
    }

    protected UaReference doDeleteReference(UaReference uaReference) {
        Collection<UaReference> collection = this.getReferenceList();
        if (collection != null && collection.remove(uaReference)) {
            this.afterDeleteReference(uaReference);
            return uaReference;
        }
        return null;
    }

    protected <T extends UaNode> List<T> findPlaceholders(Class<T> clazz, ExpandedNodeId expandedNodeId, ExpandedNodeId expandedNodeId2) {
        try {
            NodeId nodeId;
            UaNode uaNode = this.getAddressSpace().getNode(expandedNodeId);
            NodeClass nodeClass = uaNode.getNodeClass();
            UaType uaType = null;
            if (uaNode instanceof UaInstance) {
                uaType = ((UaInstance)uaNode).getTypeDefinition();
            }
            try {
                nodeId = this.getAddressSpace().getNamespaceTable().toNodeId(expandedNodeId2);
            }
            catch (ServiceResultException serviceResultException) {
                throw new StatusException(serviceResultException);
            }
            UaReference[] uaReferenceArray = this.getForwardReferences(nodeId);
            ArrayList<T> arrayList = new ArrayList<T>();
            for (UaReference uaReference : uaReferenceArray) {
                UaType uaType2;
                UaNode uaNode2 = uaReference.getOppositeNode(this);
                if (uaNode2 == null) {
                    logger.debug("searchPlaceholders: Ignoring null UaNode reference target");
                    continue;
                }
                if (uaNode2.getNodeClass() != nodeClass || uaType != null && uaNode2 instanceof UaInstance && !(uaType2 = ((UaInstance)uaNode2).getTypeDefinition()).inheritsFrom(uaType) || !clazz.isAssignableFrom(uaNode2.getClass())) continue;
                arrayList.add(clazz.cast(uaNode2));
            }
            return Collections.unmodifiableList(arrayList);
        }
        catch (UaException uaException) {
            logger.warn("Unable to find nodes that are defined via a XXXHasPlaceHolder ModellingRule", uaException);
            return null;
        }
    }

    protected void fireDataChange(DataValue dataValue, DataValue dataValue2) {
        List<DataChangeListener> list = this.cte();
        if (list != null) {
            for (DataChangeListener dataChangeListener : list) {
                dataChangeListener.onDataChange(this, dataValue, dataValue2);
            }
        }
    }

    protected void fireEvent(EventData eventData, List<ServerNode> list) {
        if (!list.contains(this)) {
            List<EventListener> list2;
            if (logger.isDebugEnabled()) {
                logger.debug("fireEvent: Name={} ID={}", (Object)this.getBrowseName(), (Object)this.getNodeId());
            }
            if ((list2 = this.ctf()) != null) {
                for (EventListener eventListener : list2) {
                    eventListener.onEvent(this, eventData);
                }
            }
            list.add(this);
            this.fireEventInParents(eventData, list, Identifiers.HasEventSource, Identifiers.HasNotifier, Identifiers.HasCondition);
            this.getAddressSpace().getNodeManagerRoot().getServerData().fireEvent(eventData, list);
        }
    }

    protected final void fireEventInParents(EventData eventData, List<ServerNode> list, NodeId ... nodeIdArray) {
        for (UaReference uaReference : this.getReferences(true, nodeIdArray)) {
            if (!(uaReference.getSourceNode() instanceof UaInstanceNode)) continue;
            ((UaInstanceNode)uaReference.getSourceNode()).fireEvent(eventData, list);
        }
    }

    protected QualifiedName getDefaultBrowseName(NodeId nodeId, String string) {
        return new QualifiedName(nodeId == null ? 0 : nodeId.getNamespaceIndex(), string);
    }

    @Override
    protected synchronized Collection<UaReference> getReferenceList() {
        return this.qW;
    }

    protected List<UaNode> getTargetNodes(NodeId nodeId) {
        UaReference[] uaReferenceArray = this.getForwardReferences(nodeId);
        ArrayList<UaNode> arrayList = new ArrayList<UaNode>(uaReferenceArray.length);
        for (UaReference uaReference : uaReferenceArray) {
            arrayList.add(uaReference.getTargetNode());
        }
        return arrayList;
    }

    protected UaReference hasReference(UaReference uaReference) {
        Collection<UaReference> collection = this.getReferenceList();
        if (collection != null && collection.contains(uaReference)) {
            return uaReference;
        }
        return null;
    }

    protected void initSupportedAttributes(List<UnsignedInteger> list) {
        list.addAll(Arrays.asList(Attributes.NodeId, Attributes.NodeClass, Attributes.BrowseName, Attributes.DisplayName, Attributes.Description, Attributes.WriteMask, Attributes.UserWriteMask));
    }

    protected boolean isFalseOrNull(Boolean bl) {
        return bl == null || bl == false;
    }

    protected boolean isMonitoredForEvents(UaObject uaObject) {
        List<EventListener> list = this.ctf();
        if (list != null) {
            for (EventListener uaReferenceArray : list) {
                if (!uaReferenceArray.isMonitored(uaObject)) continue;
                return true;
            }
        }
        boolean bl = false;
        for (UaReference uaReference : this.getInverseReferences(Identifiers.HasEventSource, Identifiers.HasCondition)) {
            if (!((ServerNode)uaReference.getSourceNode()).isMonitoredForEvents(uaObject)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected boolean isTrueOrNull(Boolean bl) {
        return bl == null || bl != false;
    }

    protected final boolean isType() {
        return this.getNodeClass().equals(NodeClass.ObjectType) || this.getNodeClass().equals(NodeClass.VariableType) || this.getNodeClass().equals(NodeClass.DataType) || this.getNodeClass().equals(NodeClass.ReferenceType);
    }

    @Override
    protected boolean referenceTypeInherits(NodeId nodeId, NodeId ... nodeIdArray) {
        try {
            UaReferenceType uaReferenceType = (UaReferenceType)this.nodeManager.getType(nodeId);
            return this.referenceTypeInherits(uaReferenceType, nodeIdArray);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (StatusException statusException) {
            if (nodeIdArray == null || nodeIdArray.length == 0) {
                return true;
            }
            for (NodeId nodeId2 : nodeIdArray) {
                if (!nodeId.equals(nodeId2)) continue;
                return true;
            }
            return false;
        }
    }

    protected NodeId[] translateBrowsePathToNodeIds(NodeId nodeId, QualifiedName ... qualifiedNameArray) {
        BrowsePathTarget[] browsePathTargetArray;
        ArrayList<RelativePathElement> arrayList = new ArrayList<RelativePathElement>();
        if (qualifiedNameArray != null) {
            for (QualifiedName statusException : qualifiedNameArray) {
                arrayList.add(new RelativePathElement(Identifiers.HierarchicalReferences, false, true, statusException));
            }
        }
        RelativePath relativePath = new RelativePath(arrayList.toArray(new RelativePathElement[0]));
        ArrayList<NodeId> arrayList2 = new ArrayList<NodeId>();
        try {
            browsePathTargetArray = this.getNodeManager().getNodeManagerTable().translateBrowsePathToNodeIds(nodeId, relativePath);
        }
        catch (StatusException exception) {
            if (exception.getStatusCode().isStatusCode(StatusCodes.Bad_NoMatch)) {
                return new NodeId[0];
            }
            logger.warn("translateBrowsePathToNodeIds failed, startingNode=" + nodeId + " ,path=" + Arrays.toString(qualifiedNameArray), exception);
            return new NodeId[0];
        }
        catch (Exception exception) {
            logger.warn("translateBrowsePathToNodeIds failed, startingNode=" + nodeId + " ,path=" + Arrays.toString(qualifiedNameArray), exception);
            return new NodeId[0];
        }
        for (BrowsePathTarget browsePathTarget : browsePathTargetArray) {
            if (browsePathTarget.getRemainingPathIndex() != null && !browsePathTarget.getRemainingPathIndex().equals(UnsignedInteger.MAX_VALUE)) continue;
            ExpandedNodeId expandedNodeId = browsePathTarget.getTargetId();
            try {
                NodeId nodeId2 = this.getNodeManager().getNamespaceTable().toNodeId(expandedNodeId);
                arrayList2.add(nodeId2);
            }
            catch (ServiceResultException serviceResultException) {
                logger.warn("Could not translate ExpandedNodeId to NodeId: " + expandedNodeId, serviceResultException);
            }
        }
        return arrayList2.toArray(new NodeId[0]);
    }

    protected void validateHasEventSourceChain(Set<NodeId> set) {
        if (!set.contains(this.getNodeId())) {
            set.add(this.getNodeId());
            logger.trace("validateHasEventSourceChain: node={}", (Object)this);
            UaReference[] uaReferenceArray = this.getInverseReferences(Identifiers.HasEventSource, Identifiers.HasCondition);
            UaReference uaReference = null;
            for (UaReference uaReference2 : uaReferenceArray) {
                if (!uaReference2.getSourceId().equals(Identifiers.Server)) continue;
                uaReference = uaReference2;
            }
            if (uaReference != null && uaReferenceArray.length > 1) {
                uaReference.delete();
                uaReferenceArray = this.getInverseReferences(Identifiers.HasEventSource, Identifiers.HasCondition);
            }
            for (UaReference uaReference2 : uaReferenceArray) {
                ((ServerNode)uaReference2.getSourceNode()).validateHasEventSourceChain(set);
            }
            if (ServerNode.isAddNotifierReferencesToServerObject() && uaReferenceArray.length == 0 && !this.isType() && !this.getNodeId().equals(Identifiers.Server)) {
                logger.debug("validateHasEventSourceChain: addReference from Server to node={}", (Object)this);
                this.addReference(UaServerReference.getReferenceInstance(Identifiers.HasNotifier, this.nodeManager.getNodeOrExternal(Identifiers.Server), (UaNode)this));
            }
        }
    }

    protected void validateHasEventSourceChain(UaReference uaReference) {
        UaType uaType = null;
        uaType = (UaType)this.nodeManager.getNodeOrExternal(uaReference.getReferenceTypeId());
        if (uaType != null && !(uaType instanceof UaExternalNode) && uaType.inheritsFrom(Identifiers.HasEventSource)) {
            HashSet<NodeId> hashSet = new HashSet<NodeId>();
            this.validateHasEventSourceChain(hashSet);
        }
    }

    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        logger.debug("writeAttributeValue attributeId={}value={}", (Object)unsignedInteger, object);
        if (!unsignedInteger.equals(Attributes.NodeId)) {
            if (unsignedInteger.equals(Attributes.NodeClass)) {
                throw new StatusException(StatusCodes.Bad_WriteNotSupported);
            }
            logger.info("writeAttributeValue: Invalid attribute {{}}: {}", (Object)this.getClass(), (Object)AttributesUtil.toString(unsignedInteger));
            throw new StatusException(StatusCodes.Bad_AttributeIdInvalid);
        }
        this.nodeId = (NodeId)object;
    }
}

