/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.UaVariableCallback;
import com.prosysopc.ua.server.nodes.UaVariableNode;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CallbackVariable
extends UaVariableNode {
    private static final Logger logger = LoggerFactory.getLogger(CallbackVariable.class);
    private DateTime fH = null;
    protected UaVariableCallback callback;

    public CallbackVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        super(nodeManagerUaNode, nodeId, qualifiedName, localizedText);
    }

    public CallbackVariable(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        super(nodeManagerUaNode, nodeId, string, locale);
    }

    protected CallbackVariable(UaNode.Parameters parameters) {
        super(parameters);
    }

    public UaVariableCallback getCallback() {
        return this.callback;
    }

    @Override
    public DataValue getValue() {
        if (this.callback != null) {
            try {
                Object object = this.callback.getValue();
                DataValue dataValue = this.createDataValue(object);
                dataValue.setServerTimestamp(DateTime.currentTime());
                dataValue.setSourceTimestamp(this.getTimestamp());
                return dataValue;
            }
            catch (StatusException statusException) {
                logger.error("StatusException: ", statusException);
                return new DataValue(statusException.getStatusCode());
            }
        }
        return null;
    }

    public void setCallback(UaVariableCallback uaVariableCallback) {
        this.callback = uaVariableCallback;
    }

    private DateTime getTimestamp() {
        if (this.fH == null) {
            this.fH = DateTime.currentTime();
        }
        return this.fH;
    }

    @Override
    protected void doSetValue(DataValue dataValue) throws StatusException {
        if (this.callback != null) {
            this.callback.setValue(dataValue.getValue().getValue());
            this.fH = DateTime.currentTime();
        }
    }

    @Override
    protected void notifyValueChanging(DataValue dataValue) {
        super.notifyValueChanging(dataValue);
        this.fH = dataValue.getServerTimestamp();
    }
}

