/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.nodes;

import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.StructureUtils;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaVariable;
import com.prosysopc.ua.server.NodeManagerUaNode;
import com.prosysopc.ua.server.nodes.CacheProperty;
import com.prosysopc.ua.server.nodes.CallbackInstanceProperty;
import com.prosysopc.ua.server.nodes.PlainInstanceProperty;
import com.prosysopc.ua.server.nodes.PlainProperty;
import com.prosysopc.ua.server.nodes.PlainVariable;
import com.prosysopc.ua.server.nodes.ReflectiveInstanceProperty;
import com.prosysopc.ua.server.nodes.ReflectiveInstanceVariable;
import com.prosysopc.ua.server.nodes.ReflectiveProperty;
import com.prosysopc.ua.server.nodes.ReflectiveVariable;
import com.prosysopc.ua.server.nodes.ServerNode;
import com.prosysopc.ua.server.nodes.UaVariableCallback;
import com.prosysopc.ua.server.nodes.a;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.AttributeWriteMask;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.utils.AttributesUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseNode
extends ServerNode {
    private static final AttributeWriteMask hQ = AttributeWriteMask.of();
    public static final QualifiedName NODE_VERSION_PROPERTY_NAME = new QualifiedName("NodeVersion");
    @Deprecated
    public static boolean useQuickPropertyLookup = true;
    private static Map<Class<? extends BaseNode>, Map<String, NodeId>> qG = new HashMap<Class<? extends BaseNode>, Map<String, NodeId>>();
    private static final Logger logger = LoggerFactory.getLogger(BaseNode.class);
    private static final Map<String, QualifiedName> qH = new HashMap<String, QualifiedName>();
    private static final Map<String, LocalizedText> qI = new HashMap<String, LocalizedText>();
    private volatile QualifiedName hR;
    private volatile LocalizedText description = null;
    private volatile LocalizedText hS = null;
    private volatile AttributeWriteMask hW = hQ;
    private volatile AttributeWriteMask hX = hQ;
    Map<QualifiedName, UaProperty> properties = null;

    public static void setAccessLevelRecursively(UaNode uaNode, AccessLevelType accessLevelType, NodeId ... nodeIdArray) {
        if (uaNode instanceof UaVariable) {
            ((UaVariable)uaNode).setAccessLevel(accessLevelType);
        }
        if (nodeIdArray.length == 0) {
            nodeIdArray = new NodeId[]{Identifiers.Aggregates};
        }
        for (UaReference uaReference : uaNode.getForwardReferences(nodeIdArray)) {
            BaseNode.setAccessLevelRecursively(uaReference.getTargetNode(), accessLevelType, nodeIdArray);
        }
    }

    private static Map<String, NodeId> c(Class<? extends BaseNode> clazz) {
        return qG.get(clazz);
    }

    private static Map<String, NodeId> d(Class<? extends BaseNode> clazz) {
        Map<String, NodeId> map = BaseNode.c(clazz);
        if (map == null) {
            Class<? extends BaseNode> clazz2;
            Map<String, NodeId> map2;
            logger.debug("Creating InstanceProperties for {}", (Object)clazz);
            map = new HashMap<String, NodeId>();
            qG.put(clazz, map);
            if (BaseNode.class.isAssignableFrom(clazz.getSuperclass()) && (map2 = BaseNode.d(clazz2 = clazz.getSuperclass())) != null) {
                logger.debug("Adding entries from the superMap {}", (Object)clazz);
                map.putAll(map2);
            }
        }
        return map;
    }

    protected static QualifiedName getStandardBrowseName(String string2) {
        return qH.computeIfAbsent(string2, string -> new QualifiedName((String)string));
    }

    protected static LocalizedText getStandardDisplayText(String string2) {
        return qI.computeIfAbsent(string2, string -> new LocalizedText((String)string, Locale.ENGLISH));
    }

    public BaseNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText) {
        this(nodeManagerUaNode, nodeId);
        this.hR = qualifiedName;
        this.setDisplayName(localizedText);
    }

    public BaseNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId, String string, Locale locale) {
        this(nodeManagerUaNode, nodeId);
        this.hR = this.getDefaultBrowseName(nodeId, string);
        this.setDisplayName(new LocalizedText(string, locale));
    }

    protected BaseNode(NodeManagerUaNode nodeManagerUaNode, NodeId nodeId) {
        super(nodeManagerUaNode, nodeId);
    }

    protected BaseNode(UaNode.Parameters parameters) {
        super(parameters);
        try {
            this.hR = QualifiedName.from(parameters.getBrowseName(), parameters.getAddressSpace().getNamespaceTable());
            this.setDisplayName(parameters.getDisplayName());
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("ServerNode creation failed", exception);
        }
    }

    public NodeId createNodeId(UaNode uaNode, String string) {
        return this.nodeManager.createNodeId(uaNode, string);
    }

    @Override
    public UaReference deleteReference(ExpandedNodeId expandedNodeId, NodeId nodeId, boolean bl) {
        logger.debug("deleteReference targetNodeId : {}", (Object)expandedNodeId);
        if (this.properties != null && nodeId.equals(Identifiers.HasProperty) && !bl) {
            try {
                UaNode uaNode = this.getNodeManager().getNode(expandedNodeId);
                this.properties.remove(uaNode.getBrowseName());
            }
            catch (StatusException statusException) {
                throw new IllegalArgumentException(statusException);
            }
        }
        return super.deleteReference(expandedNodeId, nodeId, bl);
    }

    @Override
    public UaReference deleteReference(UaReference uaReference) {
        UaNode uaNode;
        UaReference uaReference2 = super.deleteReference(uaReference);
        if (this.properties != null && uaReference.getReferenceTypeId().equals(Identifiers.HasProperty) && (uaNode = uaReference.getTargetNode()) != null && this.properties.remove(uaNode.getBrowseName()) != null) {
            uaReference2 = uaReference;
        }
        return uaReference2;
    }

    @Override
    public abstract NodeAttributes getAttributes();

    @Override
    public Map<UnsignedInteger, Object> getAttributesMap() {
        HashMap<UnsignedInteger, Object> hashMap = new HashMap<UnsignedInteger, Object>();
        this.getAttributesMap(hashMap);
        hashMap.replaceAll((unsignedInteger, object) -> StructureUtils.clone(object));
        return Collections.unmodifiableMap(hashMap);
    }

    @Override
    public QualifiedName getBrowseName() {
        return this.hR;
    }

    @Override
    public UaNode getComponent(QualifiedName qualifiedName) {
        for (UaReference uaReference : this.getReferences(Identifiers.HasComponent, false)) {
            UaNode uaNode = uaReference.getTargetNode();
            if (uaNode == null || !qualifiedName.equals(uaNode.getBrowseName())) continue;
            return uaNode;
        }
        return null;
    }

    @Override
    public UaNode[] getComponents() {
        NodeId nodeId = Identifiers.HasComponent;
        return this.getTargetNodes(nodeId).toArray(new UaNode[0]);
    }

    @Override
    public LocalizedText getDescription() {
        return this.getDescription(null);
    }

    public LocalizedText getDescription(Locale locale) {
        return this.description;
    }

    @Override
    public LocalizedText getDisplayName() {
        return this.getDisplayName(null);
    }

    public LocalizedText getDisplayName(Locale locale) {
        return this.hS;
    }

    @Override
    public UaMethod getMethod(QualifiedName qualifiedName) {
        return (UaMethod)this.getComponent(qualifiedName);
    }

    @Override
    public NodeClass getNodeClass() {
        return null;
    }

    public String getNodeVersion() {
        UaProperty uaProperty = this.getNodeVersionNode();
        DataValue dataValue = uaProperty == null ? null : uaProperty.getValue();
        return dataValue == null || dataValue.isNull() ? null : dataValue.getValue().getValue().toString();
    }

    @Override
    public UaProperty getNodeVersionNode() {
        return this.getProperty(NODE_VERSION_PROPERTY_NAME);
    }

    @Override
    public UaProperty[] getProperties() {
        Collection<UaProperty> collection = this.f(new ArrayList<UaReference>());
        if (collection != null) {
            return collection.toArray(new UaProperty[0]);
        }
        return null;
    }

    @Override
    public UaProperty getProperty(QualifiedName qualifiedName) {
        if (qualifiedName == null) {
            return null;
        }
        logger.debug("getProperty:{}", (Object)qualifiedName);
        ReflectiveInstanceProperty reflectiveInstanceProperty = this.c(qualifiedName);
        if (reflectiveInstanceProperty != null) {
            return reflectiveInstanceProperty;
        }
        if (this.properties != null) {
            return this.properties.get(qualifiedName);
        }
        if (useQuickPropertyLookup) {
            return null;
        }
        UaReference uaReference = this.a(qualifiedName, Identifiers.HasProperty);
        if (uaReference != null) {
            return (UaProperty)uaReference.getTargetNode();
        }
        return null;
    }

    public DataValue getPropertyValue(QualifiedName qualifiedName) throws StatusException, IllegalArgumentException {
        UaProperty uaProperty = this.getProperty(qualifiedName);
        if (uaProperty == null) {
            throw new IllegalArgumentException("Property " + qualifiedName + " does not exist.");
        }
        return uaProperty.getValue();
    }

    @Override
    public AttributeWriteMask getUserWriteMask() {
        return this.hW;
    }

    @Override
    public AttributeWriteMask getWriteMask() {
        return this.hX;
    }

    public boolean hasProperty(QualifiedName qualifiedName) {
        return this.getProperty(qualifiedName) != null;
    }

    public boolean hasTypeDefinition() {
        return false;
    }

    @Override
    public boolean hasUserWriteAccess(UnsignedInteger unsignedInteger) {
        return AttributesUtil.hasAccessToAttribute(this.hW, unsignedInteger);
    }

    @Override
    public boolean hasWriteAccess(UnsignedInteger unsignedInteger) {
        return AttributesUtil.hasAccessToAttribute(this.hX, unsignedInteger);
    }

    public void incNodeVersion() throws NumberFormatException {
        String string = this.getNodeVersion();
        if (string != null) {
            string = Integer.toString(Integer.parseInt(string) + 1);
            logger.debug("incNodeVersion: node={} nodeVersion={}", (Object)this.getNodeId(), (Object)string);
            this.setNodeVersion(string);
        }
    }

    public void initNodeVersion() {
        if (this.getNodeVersion() == null) {
            this.setNodeVersion("1");
        }
    }

    @Override
    public DataValue readAttribute(UnsignedInteger unsignedInteger) {
        DataValue dataValue = new DataValue();
        this.readAttribute(unsignedInteger, dataValue, null);
        return dataValue;
    }

    @Override
    public final void readAttribute(UnsignedInteger unsignedInteger, DataValue dataValue, Locale locale) {
        try {
            this.a(unsignedInteger, dataValue, locale);
        }
        catch (StatusException statusException) {
            dataValue.setStatusCode(statusException.getStatusCode());
        }
    }

    @Override
    public UaProperty removeProperty(QualifiedName qualifiedName) {
        if (this.properties != null) {
            UaProperty uaProperty = this.getProperty(qualifiedName);
            this.deleteReference(uaProperty, Identifiers.HasProperty, false);
            return uaProperty;
        }
        return null;
    }

    @Override
    public void setAttribute(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (dataValue == null) {
            logger.warn("dataValue=null");
            this.writeAttributeValue(unsignedInteger, null, StatusCode.BAD, null, null);
        } else {
            Object object;
            Object object2 = object = dataValue.getStatusCode().isBad() || dataValue.isNull() ? null : dataValue.getValue().getValue();
            if (object instanceof DataValue) {
                DataValue dataValue2 = new DataValue(new Variant(object));
                dataValue2.setStatusCode(dataValue.getStatusCode());
                dataValue2.setSourceTimestamp(dataValue.getSourceTimestamp());
                dataValue2.setSourcePicoseconds(dataValue.getSourcePicoseconds());
                dataValue2.setServerTimestamp(dataValue.getServerTimestamp());
                dataValue2.setServerPicoseconds(dataValue.getServerPicoseconds());
                this.writeAttributeValue(unsignedInteger, dataValue2, dataValue.getStatusCode(), dataValue.getSourceTimestamp(), dataValue.getSourcePicoseconds());
            } else {
                this.writeAttributeValue(unsignedInteger, object, dataValue.getStatusCode(), dataValue.getSourceTimestamp(), dataValue.getSourcePicoseconds());
            }
        }
    }

    @Override
    public void setAttributes(NodeAttributes nodeAttributes) {
        this.setDescription(nodeAttributes.getDescription());
        if (nodeAttributes.getWriteMask() != null) {
            this.setWriteMask(AttributeWriteMask.of(nodeAttributes.getWriteMask()));
        }
    }

    @Override
    public void setBrowseName(QualifiedName qualifiedName) {
        this.hR = qualifiedName;
    }

    @Override
    public void setDescription(LocalizedText localizedText) {
        this.description = LocalizedText.merge(this.description, localizedText);
    }

    @Override
    public void setDisplayName(LocalizedText localizedText) {
        this.hS = LocalizedText.merge(this.hS, localizedText);
    }

    public void setNodeVersion(String string) {
        try {
            this.setPropertyValue(NODE_VERSION_PROPERTY_NAME, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            CacheProperty cacheProperty = new CacheProperty(this.nodeManager, this.createNodeId(this, NODE_VERSION_PROPERTY_NAME.getName()), NODE_VERSION_PROPERTY_NAME, new LocalizedText(NODE_VERSION_PROPERTY_NAME.getName(), Locale.ENGLISH));
            if (this.addProperty(cacheProperty) == null) {
                throw new IllegalArgumentException("Cannot add NodeVersion property to node " + this);
            }
            cacheProperty.setDataTypeId(Identifiers.String);
            this.setNodeVersion(string);
        }
        catch (StatusException statusException) {
            throw new RuntimeException(statusException);
        }
    }

    public void setPropertyValue(QualifiedName qualifiedName, Object object) throws StatusException, IllegalArgumentException {
        DataValue dataValue;
        UaProperty uaProperty = this.getProperty(qualifiedName);
        if (uaProperty == null) {
            throw new IllegalArgumentException("Property " + qualifiedName + " does not exist.");
        }
        if (object instanceof DataValue) {
            dataValue = (DataValue)object;
        } else {
            Variant variant = object instanceof Variant ? (Variant)object : new Variant(object);
            dataValue = new DataValue(variant);
        }
        uaProperty.setValue(dataValue);
    }

    @Override
    public void setUserWriteMask(AttributeWriteMask attributeWriteMask) {
        this.hW = attributeWriteMask;
    }

    @Override
    public void setWriteMask(AttributeWriteMask attributeWriteMask) {
        this.hX = attributeWriteMask;
    }

    @Override
    public String toString() {
        return super.toString() + ", BrowseName=" + this.hR;
    }

    @Override
    public final boolean writeAttribute(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        if (!this.supportsAttribute(unsignedInteger)) {
            throw new StatusException(String.format(Locale.ROOT, "Attribute '%s' not supported by node type '%s'", AttributesUtil.toString(unsignedInteger), this.getClass()), StatusCodes.Bad_AttributeIdInvalid);
        }
        if (!this.hasWriteAccess(unsignedInteger)) {
            throw new StatusException(String.format(Locale.ROOT, "Attribute '%s' not writable in node '%s(ID=%s)' WriteMask=%s", AttributesUtil.toString(unsignedInteger), this.getClass(), this.getNodeId(), this.getWriteMask()), StatusCodes.Bad_NotWritable);
        }
        try {
            this.setAttribute(unsignedInteger, dataValue);
        }
        catch (ClassCastException classCastException) {
            throw new StatusException("Write failed", StatusCodes.Bad_TypeMismatch);
        }
        return true;
    }

    private Map<String, NodeId> ctb() {
        return BaseNode.c(this.getClass());
    }

    private ReflectiveInstanceProperty c(QualifiedName qualifiedName) {
        Map<String, NodeId> map = BaseNode.c(this.getClass());
        if (map != null) {
            NodeId nodeId = map.get(qualifiedName.getName());
            logger.debug("getProperty: id={}", (Object)nodeId);
            if (nodeId != null) {
                try {
                    return this.createReflectiveInstanceProperty(qualifiedName.getName(), nodeId);
                }
                catch (Exception exception) {
                    logger.error("BaseNode.getInstanceProperty() Exception: ", exception);
                }
            }
        }
        return null;
    }

    private Collection<UaProperty> f(List<UaReference> list) {
        Map<String, NodeId> map = this.ctb();
        if (map != null) {
            logger.debug("getPropertiesAsList: instanceProperties.size()={}", (Object)map.size());
            ArrayList<String> arrayList = new ArrayList<String>();
            for (UaReference object : list) {
                QualifiedName qualifiedName = object.getTargetNode().getBrowseName();
                if (qualifiedName.getNamespaceIndex() != 0) continue;
                arrayList.add(qualifiedName.getName());
            }
            ArrayList arrayList2 = new ArrayList();
            for (Map.Entry<String, NodeId> entry : map.entrySet()) {
                String string = entry.getKey();
                if (arrayList.contains(string)) continue;
                NodeId nodeId = entry.getValue();
                try {
                    ReflectiveInstanceProperty reflectiveInstanceProperty = this.createReflectiveInstanceProperty(string, nodeId);
                    if (reflectiveInstanceProperty.getValue().isNull() && !reflectiveInstanceProperty.isMandatory()) continue;
                    arrayList2.add(reflectiveInstanceProperty);
                }
                catch (Exception exception) {
                    logger.error("While creating instanceProperty " + string + " id=" + nodeId, exception);
                }
            }
            if (this.properties != null) {
                arrayList2.addAll(this.properties.values());
            }
            logger.debug("getPropertiesAsList: p={}", (Object)arrayList2);
            return arrayList2;
        }
        if (this.properties != null) {
            return this.properties.values();
        }
        return null;
    }

    private void g(List<UaReference> list) {
        Collection<UaProperty> collection = this.f(list);
        if (collection != null) {
            for (UaProperty uaProperty : collection) {
                list.add(new a(Identifiers.HasProperty, (UaNode)this, (UaNode)uaProperty));
            }
        }
    }

    private UaReference a(QualifiedName qualifiedName, NodeId nodeId) {
        for (UaReference uaReference : this.getForwardReferences(nodeId)) {
            if (!qualifiedName.equals(uaReference.getTargetNode().getBrowseName())) continue;
            return uaReference;
        }
        return null;
    }

    private void a(UnsignedInteger unsignedInteger, DataValue dataValue, Locale locale) throws StatusException {
        if (unsignedInteger.equals(Attributes.DisplayName)) {
            dataValue.setValue(new Variant(this.getDisplayName(locale)));
        } else if (unsignedInteger.equals(Attributes.Description)) {
            dataValue.setValue(new Variant(this.getDescription(locale)));
        } else {
            this.readAttributeValue(unsignedInteger, dataValue);
        }
        if (dataValue.getServerTimestamp() == null) {
            dataValue.setServerTimestamp(new DateTime());
        }
    }

    protected <T> PlainProperty<T> addPlainProperty(NodeId nodeId, String string) {
        PlainProperty plainProperty = new PlainProperty(this.nodeManager, nodeId, string, LocalizedText.NO_LOCALE);
        this.addProperty(plainProperty);
        return plainProperty;
    }

    protected <T> PlainVariable<T> addPlainVariable(NodeId nodeId, String string) {
        PlainVariable plainVariable = new PlainVariable(this.nodeManager, nodeId, string, LocalizedText.NO_LOCALE);
        this.addComponent(plainVariable);
        return plainVariable;
    }

    protected void assertTypeSupport(ExpandedNodeId expandedNodeId) {
        if (expandedNodeId != null && this.getNodeClass() != NodeClass.Object && this.getNodeClass() != NodeClass.Variable) {
            throw new IllegalArgumentException("Type definitions are only available for the NodeClasses Object and Variable");
        }
    }

    protected void assertTypeSupport(NodeId nodeId) {
        if (nodeId != null && this.getNodeClass() != NodeClass.Object && this.getNodeClass() != NodeClass.Variable) {
            throw new IllegalArgumentException("Type definitions are only available for the NodeClasses Object and Variable");
        }
    }

    protected NodeId createNodeId(UaNode uaNode, String string, int n2) {
        return this.nodeManager.createNodeId(uaNode, string, n2);
    }

    protected ReflectiveInstanceProperty createReflectiveInstanceProperty(String string, NodeId nodeId) throws SecurityException, NoSuchMethodException, StatusException {
        boolean bl = this.isChildOfType();
        NodeId nodeId2 = bl ? nodeId : this.createNodeId(this, string);
        return this.createReflectiveInstanceProperty(string, nodeId, nodeId2);
    }

    protected ReflectiveInstanceProperty createReflectiveInstanceProperty(String string, NodeId nodeId, NodeId nodeId2) throws SecurityException, NoSuchMethodException, StatusException {
        ReflectiveInstanceProperty reflectiveInstanceProperty = new ReflectiveInstanceProperty(this.nodeManager, nodeId2, (Object)this, string, nodeId);
        reflectiveInstanceProperty.addReference(new a(Identifiers.HasProperty, (UaNode)this, (UaNode)reflectiveInstanceProperty));
        return reflectiveInstanceProperty;
    }

    @Override
    protected boolean doAddProperty(UaProperty uaProperty) {
        if (uaProperty != null) {
            logger.debug("doAddProperty: {}", (Object)uaProperty.getBrowseName());
            if (this.hasProperty(uaProperty.getBrowseName())) {
                logger.warn("Property exists, but adding a new reference! " + this.getBrowseName() + " - " + uaProperty.getBrowseName());
                return false;
            }
            if (this.properties == null) {
                this.properties = new ConcurrentHashMap<QualifiedName, UaProperty>(2, 0.9f, 1);
            }
            this.properties.put(uaProperty.getBrowseName(), uaProperty);
            return false;
        }
        return false;
    }

    protected NodeAttributes getAttributes(NodeAttributes nodeAttributes) {
        nodeAttributes.setDescription(this.getDescription());
        nodeAttributes.setDisplayName(this.getDisplayName());
        return nodeAttributes;
    }

    protected void getAttributesMap(Map<UnsignedInteger, Object> map) {
        map.put(Attributes.NodeId, this.getNodeId());
        map.put(Attributes.NodeClass, this.getNodeClass());
        map.put(Attributes.BrowseName, this.getBrowseName());
        map.put(Attributes.Description, this.getDescription());
        map.put(Attributes.DisplayName, this.getDisplayName());
    }

    protected UaReference getPropertyReference(QualifiedName qualifiedName) {
        UaProperty uaProperty = this.getProperty(qualifiedName);
        return uaProperty == null ? null : new a(Identifiers.HasProperty, (UaNode)this, (UaNode)uaProperty);
    }

    @Override
    protected List<UaReference> getReferencesAsList(Boolean bl, NodeId ... nodeIdArray) {
        List<UaReference> list = super.getReferencesAsList(bl, nodeIdArray);
        if (this.isFalseOrNull(bl) && this.referenceTypeInherits(Identifiers.HasProperty, nodeIdArray)) {
            this.g(list);
        }
        logger.debug("getReferencesAsList({}): list={}", (Object)bl, (Object)list);
        return list;
    }

    @Override
    protected UaReference hasReference(UaReference uaReference) {
        UaReference uaReference2;
        if (uaReference.getReferenceTypeId().equals(Identifiers.HasProperty) && !uaReference.getIsInverse(this) && (uaReference2 = this.getPropertyReference(uaReference.getTargetNode().getBrowseName())) != null) {
            return uaReference2;
        }
        return super.hasReference(uaReference);
    }

    protected boolean isChildOfType() {
        return false;
    }

    protected void readAttributeValue(UnsignedInteger unsignedInteger, DataValue dataValue) throws StatusException {
        switch (unsignedInteger.intValue()) {
            case 1: {
                dataValue.setValue(new Variant(this.getNodeId()));
                break;
            }
            case 2: {
                dataValue.setValue(new Variant(this.getNodeClass().getValue()));
                break;
            }
            case 3: {
                dataValue.setValue(new Variant(this.getBrowseName()));
                break;
            }
            case 4: {
                dataValue.setValue(new Variant(this.getDisplayName()));
                break;
            }
            case 5: {
                dataValue.setValue(new Variant(this.getDescription()));
                break;
            }
            case 6: {
                dataValue.setValue(new Variant(this.getWriteMask().asBuiltInType()));
                break;
            }
            case 7: {
                dataValue.setValue(new Variant(this.getUserWriteMask().asBuiltInType()));
                break;
            }
            default: {
                dataValue.setStatusCode(StatusCodes.Bad_AttributeIdInvalid);
                dataValue.setValue(null);
            }
        }
    }

    protected CallbackInstanceProperty registerCallbackProperty(String string, NodeId nodeId, NodeId nodeId2, UaVariableCallback uaVariableCallback) throws StatusException {
        CallbackInstanceProperty callbackInstanceProperty = new CallbackInstanceProperty(this.nodeManager, this.createNodeId(this, string), nodeId2);
        callbackInstanceProperty.setDataTypeId(nodeId);
        callbackInstanceProperty.setCallback(uaVariableCallback);
        this.addProperty(callbackInstanceProperty);
        return callbackInstanceProperty;
    }

    protected <T> PlainInstanceProperty<T> registerPlainInstanceProperty(String string, NodeId nodeId, NodeId nodeId2) throws StatusException {
        NodeId nodeId3 = this.createNodeId(this, string);
        PlainInstanceProperty plainInstanceProperty = new PlainInstanceProperty(this.nodeManager, nodeId3, nodeId);
        plainInstanceProperty.setDataTypeId(nodeId2);
        if (this.addProperty(plainInstanceProperty) == null) {
            throw new RuntimeException("Property " + plainInstanceProperty.getBrowseName() + " not added to " + this.getClass());
        }
        logger.debug("registerPlainInstanceProperty: {}", (Object)plainInstanceProperty.getBrowseName());
        return plainInstanceProperty;
    }

    protected <T> PlainInstanceProperty<T> registerPlainInstanceProperty(String string, NodeId nodeId, T t2) throws StatusException {
        UaDataType uaDataType = this.nodeManager.getNodeManagerTable().getNodeManagerRoot().getDataTypeConverter().getDataTypeForJavaClass(t2.getClass());
        PlainInstanceProperty<NodeId> plainInstanceProperty = this.registerPlainInstanceProperty(string, nodeId, (T)uaDataType.getNodeId());
        plainInstanceProperty.setCurrentValue((NodeId)t2);
        return plainInstanceProperty;
    }

    protected <T> PlainProperty<T> registerPlainProperty(String string, NodeId nodeId) {
        NodeId nodeId2 = this.createNodeId(this, string);
        PlainProperty plainProperty = new PlainProperty(this.nodeManager, nodeId2, BaseNode.getStandardBrowseName(string), BaseNode.getStandardDisplayText(string));
        plainProperty.setDataTypeId(nodeId);
        if (this.addProperty(plainProperty) == null) {
            throw new RuntimeException("Variable " + plainProperty.getBrowseName() + " not added to " + this.getClass());
        }
        logger.debug("registerPlainProperty: {}", (Object)plainProperty.getBrowseName());
        return plainProperty;
    }

    protected <T> PlainProperty<T> registerPlainProperty(String string, T t2) {
        UaDataType uaDataType = this.nodeManager.getNodeManagerTable().getNodeManagerRoot().getDataTypeConverter().getDataTypeForJavaClass(t2.getClass());
        PlainProperty<NodeId> plainProperty = this.registerPlainProperty(string, (T)uaDataType.getNodeId());
        plainProperty.setCurrentValue((NodeId)t2);
        return plainProperty;
    }

    protected <T> PlainVariable<T> registerPlainVariable(String string, NodeId nodeId, NodeId nodeId2) {
        NodeId nodeId3 = this.createNodeId(this, string);
        PlainVariable plainVariable = new PlainVariable(this.nodeManager, nodeId3, string, Locale.ENGLISH);
        plainVariable.setBrowseName(new QualifiedName(0, plainVariable.getBrowseName().getName()));
        plainVariable.setTypeDefinitionId(nodeId);
        plainVariable.setDataTypeId(nodeId2);
        if (this.addComponent(plainVariable) == null) {
            throw new RuntimeException("Variable " + plainVariable.getBrowseName() + " not added to " + this.getClass());
        }
        logger.debug("registerPlainVariable: {}", (Object)plainVariable.getBrowseName());
        return plainVariable;
    }

    protected <T> PlainVariable<T> registerPlainVariable(String string, NodeId nodeId, T t2) {
        UaDataType uaDataType = this.nodeManager.getNodeManagerTable().getNodeManagerRoot().getDataTypeConverter().getDataTypeForJavaClass(t2.getClass());
        PlainVariable<NodeId> plainVariable = this.registerPlainVariable(string, nodeId, (T)uaDataType.getNodeId());
        plainVariable.setCurrentValue((NodeId)t2);
        return plainVariable;
    }

    protected void registerReflectiveInstanceProperty(String string, NodeId nodeId, NodeId nodeId2) throws IllegalArgumentException {
        try {
            try {
                this.getNodeManager().getNode(nodeId);
                BaseNode.d(this.getClass()).put(string, nodeId);
            }
            catch (StatusException statusException) {
                this.registerReflectiveProperty(nodeId, string, nodeId2);
            }
        }
        catch (SecurityException securityException) {
            throw new RuntimeException(securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new RuntimeException(noSuchMethodException);
        }
    }

    protected ReflectiveInstanceVariable registerReflectiveInstanceVariable(NodeId nodeId, String string, NodeId nodeId2, NodeId nodeId3) throws SecurityException, NoSuchMethodException, StatusException {
        ReflectiveInstanceVariable reflectiveInstanceVariable = new ReflectiveInstanceVariable(this.nodeManager, nodeId, (Object)this, string, nodeId2);
        if (this.addComponent(reflectiveInstanceVariable) == null) {
            throw new RuntimeException("Component " + reflectiveInstanceVariable.getBrowseName() + " not added to " + this.getClass());
        }
        logger.debug("registerReflectiveInstanceVariable: {}", (Object)reflectiveInstanceVariable.getBrowseName());
        return reflectiveInstanceVariable;
    }

    protected ReflectiveProperty registerReflectiveProperty(NodeId nodeId, String string, NodeId nodeId2) throws SecurityException, NoSuchMethodException {
        ReflectiveProperty reflectiveProperty = new ReflectiveProperty(this.nodeManager, nodeId, this, string, Locale.ENGLISH);
        reflectiveProperty.setDataTypeId(nodeId2);
        if (this.addProperty(reflectiveProperty) == null) {
            throw new RuntimeException("Property " + reflectiveProperty.getBrowseName() + " not added to " + this.getClass());
        }
        logger.debug("registerReflectiveVariable: {}", (Object)reflectiveProperty.getBrowseName());
        return reflectiveProperty;
    }

    protected ReflectiveVariable registerReflectiveVariable(NodeId nodeId, String string, NodeId nodeId2) throws SecurityException, NoSuchMethodException {
        ReflectiveVariable reflectiveVariable = new ReflectiveVariable(this.nodeManager, nodeId, this, string, Locale.ENGLISH);
        reflectiveVariable.setDataTypeId(nodeId2);
        if (this.addComponent(reflectiveVariable) == null) {
            throw new RuntimeException("Component " + reflectiveVariable.getBrowseName() + " not added to " + this.getClass());
        }
        logger.debug("registerReflectiveVariable: {}", (Object)reflectiveVariable.getBrowseName());
        return reflectiveVariable;
    }

    protected void setAccessLevelRecursively(AccessLevelType accessLevelType) {
        BaseNode.setAccessLevelRecursively(this, accessLevelType, new NodeId[0]);
    }

    @Override
    protected void writeAttributeValue(UnsignedInteger unsignedInteger, Object object, StatusCode statusCode, DateTime dateTime, UnsignedShort unsignedShort) throws StatusException {
        logger.debug("writeAttributeValue attributeId={}value={}", (Object)unsignedInteger, object);
        if (unsignedInteger.equals(Attributes.BrowseName)) {
            this.hR = (QualifiedName)object;
        } else if (unsignedInteger.equals(Attributes.DisplayName)) {
            this.setDisplayName((LocalizedText)object);
        } else if (unsignedInteger.equals(Attributes.Description)) {
            this.setDescription((LocalizedText)object);
        } else if (unsignedInteger.equals(Attributes.WriteMask)) {
            this.hX = object == null ? hQ : (object.getClass().equals(AttributeWriteMask.class) ? (AttributeWriteMask)object : AttributeWriteMask.of((UnsignedInteger)object));
        } else if (unsignedInteger.equals(Attributes.UserWriteMask)) {
            this.hW = object == null ? hQ : (object.getClass().equals(AttributeWriteMask.class) ? (AttributeWriteMask)object : AttributeWriteMask.of((UnsignedInteger)object));
        } else {
            super.writeAttributeValue(unsignedInteger, object, statusCode, dateTime, unsignedShort);
        }
    }
}

