/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server.instantiation;

import com.prosysopc.ua.RelativeNamePath;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.server.instantiation.InstanceDeclaration;
import com.prosysopc.ua.server.instantiation.InstanceDeclarationHierarchy;
import com.prosysopc.ua.server.instantiation.InstanceDeclarationHierarchyException;
import com.prosysopc.ua.server.instantiation.InstantiationStrategy;
import com.prosysopc.ua.server.nodes.UaTypeNode;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaTypeInstanceDeclarationHierarchy {
    private static final Logger logger = LoggerFactory.getLogger(UaTypeInstanceDeclarationHierarchy.class);
    private final InstanceDeclaration qd;
    private InstantiationStrategy qB = null;
    private final Map<QualifiedName, UaTypeInstanceDeclarationHierarchy> map = new HashMap<QualifiedName, UaTypeInstanceDeclarationHierarchy>();
    private final HashSet<RelativeNamePath> qC = new HashSet();
    private final UaTypeNode qD;

    public static UaTypeInstanceDeclarationHierarchy fromUaType(UaTypeNode uaTypeNode) {
        InstanceDeclarationHierarchy instanceDeclarationHierarchy;
        try {
            instanceDeclarationHierarchy = uaTypeNode.getNodeManager().getNodeManagerTable().getInstanceDeclarationHierarchyCache().getForType(uaTypeNode);
        }
        catch (InstanceDeclarationHierarchyException instanceDeclarationHierarchyException) {
            throw new RuntimeException("Cannot get InstanceDeclarationHierarchy", instanceDeclarationHierarchyException);
        }
        return new UaTypeInstanceDeclarationHierarchy(uaTypeNode, instanceDeclarationHierarchy.getRoot());
    }

    private UaTypeInstanceDeclarationHierarchy(UaTypeNode uaTypeNode, InstanceDeclaration instanceDeclaration) {
        this.qD = uaTypeNode;
        this.qd = instanceDeclaration;
        this.expand();
    }

    public UaTypeInstanceDeclarationHierarchy addOptionalNodes(RelativeNamePath ... relativeNamePathArray) {
        for (RelativeNamePath relativeNamePath : relativeNamePathArray) {
            this.qC.add(relativeNamePath);
        }
        return this;
    }

    public UaTypeInstanceDeclarationHierarchy addOptionalNodes(NodeId ... nodeIdArray) {
        if (nodeIdArray != null) {
            for (NodeId nodeId : nodeIdArray) {
                UaNode uaNode = this.qD.getNodeManager().getNodeManagerTable().findNode(nodeId);
                if (uaNode != null) {
                    this.addOptionalNodes(uaNode.getBrowseName());
                    continue;
                }
                logger.error("Could not find UaNode for NodeId " + nodeId);
            }
        }
        return this;
    }

    public UaTypeInstanceDeclarationHierarchy addOptionalNodes(QualifiedName ... qualifiedNameArray) {
        if (qualifiedNameArray != null) {
            for (QualifiedName qualifiedName : qualifiedNameArray) {
                this.addOptionalNodes(RelativeNamePath.from(qualifiedName));
            }
        }
        return this;
    }

    public UaTypeInstanceDeclarationHierarchy addOptionalNodes(String ... stringArray) {
        if (stringArray != null && stringArray.length != 0) {
            for (String string : stringArray) {
                this.addOptionalNodes(new QualifiedName(string));
            }
        }
        return this;
    }

    public InstanceDeclaration getInstanceDeclaration() {
        return this.qd;
    }

    public InstantiationStrategy getInstantiationStrategy() {
        return this.qB;
    }

    public Collection<UaTypeInstanceDeclarationHierarchy> getNextLevel() {
        return this.map.values();
    }

    public void overrideInstantiationStrategy(RelativeNamePath relativeNamePath, InstantiationStrategy instantiationStrategy) {
        if (relativeNamePath == null || relativeNamePath.isEmpty()) {
            throw new IllegalArgumentException("BrowsePath given is null");
        }
        if (relativeNamePath.getSize() == 1) {
            this.qB = instantiationStrategy;
        } else {
            UaTypeInstanceDeclarationHierarchy uaTypeInstanceDeclarationHierarchy = this.map.get(relativeNamePath.getFirst());
            if (uaTypeInstanceDeclarationHierarchy == null) {
                throw new IllegalArgumentException("No UaTypeInstanceDeclaration found for BrowsePath given");
            }
            uaTypeInstanceDeclarationHierarchy.overrideInstantiationStrategy(relativeNamePath.removeFirst(), instantiationStrategy);
        }
    }

    public void overrideInstantiationStrategy(NodeId nodeId, InstantiationStrategy instantiationStrategy) {
        try {
            UaNode uaNode = this.qD.getNodeManager().getNodeManagerTable().getNode(nodeId);
            this.overrideInstantiationStrategy(uaNode.getBrowseName(), instantiationStrategy);
        }
        catch (StatusException statusException) {
            logger.error("Could not override instantiation strategy", statusException);
        }
    }

    public void overrideInstantiationStrategy(QualifiedName qualifiedName, InstantiationStrategy instantiationStrategy) {
        this.overrideInstantiationStrategy(RelativeNamePath.from(qualifiedName), instantiationStrategy);
    }

    public void overrideInstantiationStrategy(String string, InstantiationStrategy instantiationStrategy) {
        this.overrideInstantiationStrategy(new QualifiedName(string), instantiationStrategy);
    }

    public void setInstantiationStrategy(InstantiationStrategy instantiationStrategy) {
        this.qB = instantiationStrategy;
    }

    private void expand() {
        for (InstanceDeclaration instanceDeclaration : this.qd.getNextDeclarations()) {
            QualifiedName qualifiedName = instanceDeclaration.getNode().getBrowseName();
            this.map.put(qualifiedName, new UaTypeInstanceDeclarationHierarchy(this.qD, instanceDeclaration));
        }
    }
}

