/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.SecureIdentityException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.server.ServerUserIdentity;
import com.prosysopc.ua.server.Session;
import com.prosysopc.ua.server.SessionManagerListener;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.SignatureData;
import com.prosysopc.ua.stack.core.SignedSoftwareCertificate;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.core.UserTokenPolicy;
import com.prosysopc.ua.stack.transport.ServerSecureChannel;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.CertificateUtils;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.stack.utils.bytebuffer.ByteBufferUtils;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager {
    static Logger logger = LoggerFactory.getLogger(SessionManager.class);
    private UnsignedInteger mE;
    private int mF = 100;
    private double mG = 3600000.0;
    private double mH = 100.0;
    private volatile boolean mI;
    private final UaServer hF;
    private ScheduledExecutorService mJ;
    private final Map<NodeId, Session> mK = new ConcurrentHashMap<NodeId, Session>();
    protected List<SessionManagerListener> listeners = new CopyOnWriteArrayList<SessionManagerListener>();
    protected final Map<NodeId, Session> newSessions = new ConcurrentHashMap<NodeId, Session>();
    protected final Queue<NodeId> newSessionsQueue = new ConcurrentLinkedQueue<NodeId>();

    public SessionManager(UaServer uaServer) {
        this.hF = uaServer;
    }

    public void addListener(SessionManagerListener sessionManagerListener) {
        if (!this.hasListener(sessionManagerListener)) {
            this.listeners.add(sessionManagerListener);
        }
    }

    public void closeSession(Session session) throws ServiceException {
        if (session == null) {
            throw new IllegalArgumentException("The given Session cannot be null");
        }
        this.closeSession(session.getAuthenticationToken(), true);
    }

    public void closeSession(Session session, boolean bl) throws ServiceException {
        if (session == null) {
            throw new IllegalArgumentException("The given Session cannot be null");
        }
        this.closeSession(session.getAuthenticationToken(), bl);
    }

    public EndpointDescription[] getEndpoints() {
        return this.hF.getEndpoints();
    }

    public int getMaxBrowseContinuationPoints() {
        return this.hF.getNodeManagerRoot().getServerData().getServerCapabilitiesNode().getMaxBrowseContinuationPoints().intValue();
    }

    public int getMaxHistoryContinuationPoints() {
        return this.hF.getNodeManagerRoot().getServerData().getServerCapabilitiesNode().getMaxHistoryContinuationPoints().intValue();
    }

    public int getMaxQueryContinuationPoints() {
        return this.hF.getNodeManagerRoot().getServerData().getServerCapabilitiesNode().getMaxQueryContinuationPoints().intValue();
    }

    public UnsignedInteger getMaxRequestMessageSize() {
        return this.mE;
    }

    public int getMaxSessionCount() {
        return this.mF;
    }

    public double getMaxSessionTimeout() {
        return this.mG;
    }

    public double getMinSessionTimeout() {
        return this.mH;
    }

    public UaServer getServer() {
        return this.hF;
    }

    public Session getSession(NodeId nodeId) throws ServiceException {
        if (!this.isRunning()) {
            throw new ServiceException(StatusCodes.Bad_SessionClosed);
        }
        Session session = this.mK.get(nodeId);
        if (session == null) {
            if (this.newSessions.containsKey(nodeId)) {
                this.newSessions.remove(nodeId);
                this.newSessionsQueue.remove(nodeId);
                throw new ServiceException(StatusCodes.Bad_SessionNotActivated);
            }
            throw new ServiceException(StatusCodes.Bad_SessionClosed);
        }
        return session;
    }

    public int getSessionCount() {
        return this.mK.size() + this.newSessions.size();
    }

    public synchronized Collection<Session> getSessions() {
        LinkedHashSet<Session> linkedHashSet = new LinkedHashSet<Session>();
        linkedHashSet.addAll(this.mK.values());
        linkedHashSet.addAll(this.newSessions.values());
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public boolean hasListener(SessionManagerListener sessionManagerListener) {
        if (sessionManagerListener == null) {
            throw new NullPointerException("null listener not allowed");
        }
        return this.listeners.contains(sessionManagerListener);
    }

    public boolean isRunning() {
        boolean bl;
        boolean bl2 = bl = this.mI && this.hF.isRunning();
        if (!bl) {
            logger.debug("isRunning: running=" + this.mI + " server.isRunning()=" + this.hF.isRunning());
        }
        return bl;
    }

    public void removeListener(SessionManagerListener sessionManagerListener) {
        this.listeners.remove(sessionManagerListener);
    }

    public void setMaxBrowseContinuationPoints(int n2) {
        this.setMaxBrowseContinuationPoints(UnsignedShort.valueOf(n2));
    }

    public void setMaxBrowseContinuationPoints(UnsignedShort unsignedShort) {
        this.hF.getNodeManagerRoot().getServerData().getServerCapabilitiesNode().setMaxBrowseContinuationPoints(unsignedShort);
    }

    public void setMaxHistoryContinuationPoints(int n2) {
        this.setMaxHistoryContinuationPoints(UnsignedShort.valueOf(n2));
    }

    public void setMaxHistoryContinuationPoints(UnsignedShort unsignedShort) {
        this.hF.getNodeManagerRoot().getServerData().getServerCapabilitiesNode().setMaxHistoryContinuationPoints(unsignedShort);
    }

    public void setMaxQueryContinuationPoints(int n2) {
        this.setMaxQueryContinuationPoints(UnsignedShort.valueOf(n2));
    }

    public void setMaxQueryContinuationPoints(UnsignedShort unsignedShort) {
        this.hF.getNodeManagerRoot().getServerData().getServerCapabilitiesNode().setMaxQueryContinuationPoints(unsignedShort);
    }

    public void setMaxRequestMessageSize(int n2) {
        this.setMaxRequestMessageSize(UnsignedInteger.valueOf(n2));
    }

    public void setMaxRequestMessageSize(UnsignedInteger unsignedInteger) {
        this.mE = unsignedInteger;
    }

    public void setMaxSessionCount(int n2) {
        this.mF = n2;
        this.hF.updateServerCapabilities();
    }

    public void setMaxSessionTimeout(double d2) {
        this.mG = d2;
    }

    public void setMinSessionTimeout(double d2) {
        this.mH = d2;
    }

    private double a(Double d2) {
        if (d2 == null || d2 < this.getMinSessionTimeout()) {
            return this.getMinSessionTimeout();
        }
        if (d2 > this.getMaxSessionTimeout()) {
            return this.getMaxSessionTimeout();
        }
        return d2;
    }

    private void cru() {
        for (Session session : this.newSessions.values()) {
            if (!session.isTimeout()) continue;
            if (logger.isDebugEnabled()) {
                logger.debug("SessionMonitor: new session timeout {}", (Object)session.getSessionName());
            }
            this.newSessions.remove(session.getAuthenticationToken());
            this.newSessionsQueue.remove(session.getAuthenticationToken());
            this.hF.getDiagnosticsManager().removeSession(session);
            this.a(session, false);
        }
    }

    private void a(Session session, ServerUserIdentity serverUserIdentity) throws StatusException {
        for (SessionManagerListener sessionManagerListener : this.listeners) {
            try {
                if (sessionManagerListener.onActivateSession(session, serverUserIdentity)) continue;
                throw new StatusException("User identity rejected", StatusCodes.Bad_IdentityTokenRejected);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onActivateSession", sessionManagerListener, runtimeException);
            }
        }
    }

    private void a(Session session, UserIdentityToken userIdentityToken, Exception exception) {
        for (SessionManagerListener sessionManagerListener : this.listeners) {
            try {
                sessionManagerListener.onActivateSessionError(session, userIdentityToken, exception);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onActivateSessionError", sessionManagerListener, runtimeException);
            }
        }
    }

    private void a(Session session) {
        for (SessionManagerListener sessionManagerListener : this.listeners) {
            try {
                sessionManagerListener.onAfterActivateSession(session);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onAfterActivateSession", sessionManagerListener, runtimeException);
            }
        }
    }

    private void b(Session session) {
        for (SessionManagerListener sessionManagerListener : this.listeners) {
            try {
                sessionManagerListener.onCancelSession(session);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onCancelSession", sessionManagerListener, runtimeException);
            }
        }
    }

    private void a(Session session, boolean bl) {
        for (SessionManagerListener sessionManagerListener : this.listeners) {
            try {
                sessionManagerListener.onCloseSession(session, bl);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onCloseSession", sessionManagerListener, runtimeException);
            }
        }
    }

    private void c(Session session) throws StatusException {
        for (SessionManagerListener sessionManagerListener : this.listeners) {
            try {
                sessionManagerListener.onCreateSession(session);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onCreateSession", sessionManagerListener, runtimeException);
            }
        }
    }

    private void listenerError(String string, Object object, RuntimeException runtimeException) {
        logger.error("Exception while calling " + string + " on object " + object, runtimeException);
        throw runtimeException;
    }

    private void crv() {
        if (this.mJ == null) {
            this.mJ = Executors.newScheduledThreadPool(1, StackUtils.newNamedThreadFactory("SessionMonitor"));
            long l2 = 1000L;
            this.mJ.scheduleWithFixedDelay(new a(), 1000L, 1000L, TimeUnit.MILLISECONDS);
            logger.debug("sessionMonitorExecutor scheduled");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Session activateSession(ServerSecureChannel serverSecureChannel, NodeId nodeId, UserIdentityToken userIdentityToken, SignatureData signatureData, SignedSoftwareCertificate[] signedSoftwareCertificateArray, SignatureData signatureData2, String[] stringArray) throws ServiceException {
        Object object;
        boolean bl;
        Object object2;
        Session session;
        logger.debug("activateSession: serverSecureChannel={}", (Object)serverSecureChannel);
        Object object3 = this;
        synchronized (object3) {
            session = this.newSessions.remove(nodeId);
            this.newSessionsQueue.remove(nodeId);
            if (session == null) {
                try {
                    session = this.getSession(nodeId);
                }
                catch (ServiceException serviceException) {
                    logger.info("Session NOT Activated: Unknown Token={}", (Object)nodeId);
                    this.hF.getDiagnosticsManager().cpD();
                    throw new ServiceException(StatusCodes.Bad_SessionIdInvalid);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("activateSession: session.getChannel()={}", (Object)session.getChannel());
                }
                if (session.getChannel().getSecureChannelId() != serverSecureChannel.getSecureChannelId()) {
                    session.setChannel(serverSecureChannel);
                }
            } else {
                if (session.getChannel().getSecureChannelId() != serverSecureChannel.getSecureChannelId() && !session.isActive()) {
                    this.hF.getDiagnosticsManager().cpD();
                    throw new ServiceException(StatusCodes.Bad_SecureChannelIdInvalid);
                }
                Cert cert = serverSecureChannel.getRemoteCertificate();
                object2 = session.getChannel().getRemoteCertificate();
                if (object2 != null && !((Cert)object2).equals(cert)) {
                    logger.info("activateSession: Client certificate changed from the original. Cannot activate.");
                    this.hF.getDiagnosticsManager().cpD();
                    this.hF.getDiagnosticsManager().cpE();
                    throw new ServiceException(StatusCodes.Bad_SecurityChecksFailed);
                }
                session.setChannel(serverSecureChannel);
                this.mK.put(nodeId, session);
            }
        }
        object3 = serverSecureChannel.getLocalCertificate();
        if (object3 == null) {
            object3 = this.getServerIdentity().getKeys();
            bl = false;
        } else {
            bl = true;
        }
        try {
            object2 = session.getClientIdentity().getCertificate();
            object = object2 == null ? null : ((Cert)object2).getEncoded();
            Object object4 = object;
            if (!session.getSecurityMode().equals(SecurityMode.NONE) && !this.a(signatureData, ((KeyPair)object3).getCertificate(), session.getServerNonce(), session.getSecurityMode().getSecurityPolicy(), (byte[])object)) {
                session.deactivate();
                logger.info("Session NOT activated: {}", (Object)session.getSessionName());
                this.hF.getDiagnosticsManager().cpD();
                this.hF.getDiagnosticsManager().cpE();
                throw new ServiceException(StatusCodes.Bad_ApplicationSignatureInvalid);
            }
        }
        catch (SecureIdentityException secureIdentityException) {
            session.deactivate();
            logger.info("Session NOT activated: {} - {}", (Object)session.getSessionName(), (Object)secureIdentityException);
            logger.debug("SecureIdentityException: {}", secureIdentityException);
            this.hF.getDiagnosticsManager().cpD();
            this.hF.getDiagnosticsManager().cpE();
            throw new ServiceException(StatusCodes.Bad_ApplicationSignatureInvalid);
        }
        try {
            object2 = null;
            if (userIdentityToken != null) {
                object = null;
                for (UserTokenPolicy userTokenPolicy : this.hF.getUserTokenPolicies()) {
                    if (!userTokenPolicy.getPolicyId().equals(userIdentityToken.getPolicyId())) continue;
                    object = userTokenPolicy;
                    break;
                }
                if (object == null) {
                    this.hF.getDiagnosticsManager().cpD();
                    this.hF.getDiagnosticsManager().cpE();
                    throw new ServiceException("UserTokenPolicy unknown: " + userIdentityToken.getPolicyId(), StatusCodes.Bad_IdentityTokenInvalid);
                }
                object2 = object.getSecurityPolicyUri();
            }
            try {
                object = (Object)(object2 == null ? serverSecureChannel.getSecurityPolicy() : SecurityPolicy.getSecurityPolicy((String)object2));
            }
            catch (ServiceResultException serviceResultException) {
                this.hF.getDiagnosticsManager().cpD();
                this.hF.getDiagnosticsManager().cpE();
                throw new ServiceException("UserTokenPolicy unknown: " + (userIdentityToken == null ? "userToken is null" : userIdentityToken.getPolicyId()), StatusCodes.Bad_IdentityTokenInvalid);
            }
            ServerUserIdentity serverUserIdentity = bl ? new ServerUserIdentity(this, userIdentityToken, signatureData2, (KeyPair)object3, session.getServerNonce(), (SecurityPolicy)((Object)object)) : new ServerUserIdentity(this, userIdentityToken, signatureData2, this.getServerIdentity().getCertificates(), session.getServerNonce(), (SecurityPolicy)((Object)object));
            logger.debug("userIdentity: {}", (Object)serverUserIdentity);
            int n2 = 0;
            for (UserTokenPolicy userTokenPolicy : this.hF.getUserTokenPolicies()) {
                if (!userTokenPolicy.getTokenType().equals(serverUserIdentity.getType())) continue;
                n2 = 1;
                break;
            }
            if (n2 == 0) {
                this.hF.getDiagnosticsManager().cpD();
                this.hF.getDiagnosticsManager().cpE();
                throw new ServiceException(StatusCodes.Bad_IdentityTokenRejected);
            }
            this.a(session, serverUserIdentity);
            session.activate(serverUserIdentity);
            this.a(session);
            logger.info("Session activated: {}", (Object)session);
        }
        catch (SecureIdentityException secureIdentityException) {
            this.hF.getDiagnosticsManager().cpD();
            this.hF.getDiagnosticsManager().cpE();
            this.activateSessionError(session, userIdentityToken, secureIdentityException);
            object = secureIdentityException.getStatusCode();
            if (object == null) {
                object = StatusCodes.Bad_IdentityTokenInvalid;
            }
            throw new ServiceException((UnsignedInteger)object);
        }
        catch (StatusException statusException) {
            this.hF.getDiagnosticsManager().cpD();
            this.hF.getDiagnosticsManager().cpE();
            this.activateSessionError(session, userIdentityToken, statusException);
            throw new ServiceException(statusException.getStatusCode(), statusException.getDiagnosticInfo());
        }
        session.setLocaleIds(stringArray);
        return session;
    }

    protected void activateSessionError(Session session, UserIdentityToken userIdentityToken, Exception exception) {
        this.a(session, userIdentityToken, exception);
        logger.info("Session NOT activated: {} - {}", (Object)session.getSessionName(), (Object)exception);
        logger.debug("SessionManager.activateSessionError()", exception);
    }

    protected void cancelSession(NodeId nodeId) throws ServiceException {
        Session session = this.getSession(nodeId);
        this.b(session);
        session.cancel();
    }

    protected void close() {
        logger.debug("close");
        for (NodeId nodeId : this.mK.keySet()) {
            try {
                this.closeSession(nodeId, true);
            }
            catch (ServiceException serviceException) {
                logger.debug("While closing session " + nodeId + ": ", serviceException);
            }
        }
        if (this.mJ != null) {
            this.mJ.shutdownNow();
        }
        this.mJ = null;
        this.mI = false;
    }

    protected void closeSession(NodeId nodeId, boolean bl) throws ServiceException {
        logger.debug("closeSession: Token={}", (Object)nodeId);
        Session session = this.mK.remove(nodeId);
        if (session == null) {
            session = this.newSessions.remove(nodeId);
            this.newSessionsQueue.remove(nodeId);
            if (session == null) {
                throw new ServiceException(StatusCodes.Bad_SessionIdInvalid);
            }
        }
        this.a(session, bl);
        logger.info("Session closed: {}", (Object)session);
        this.hF.getDiagnosticsManager().removeSession(session);
        session.close(bl);
    }

    protected synchronized Session createSession(ServerSecureChannel serverSecureChannel, byte[] byArray, ApplicationDescription applicationDescription, UnsignedInteger unsignedInteger, Double d2, String string, SecurityMode securityMode) throws ServiceException {
        Object object;
        Object object2;
        if (logger.isDebugEnabled()) {
            logger.debug("createSession: serverSecureChannel={} clientDescription={} clientCertificate={}", serverSecureChannel, applicationDescription, Arrays.toString(byArray));
            logger.debug("createSession: sessionCount={} maxSessionCount={}", (Object)this.getSessionCount(), (Object)this.getMaxSessionCount());
        }
        if (!serverSecureChannel.getEndpoint().supportsSecurityPolicy(securityMode.getSecurityPolicy())) {
            logger.info("The requested SecurityPolicy(" + (Object)((Object)securityMode.getSecurityPolicy()) + ") is not supported by the endpoint. Client=" + applicationDescription.getApplicationUri());
            this.hF.getDiagnosticsManager().cpD();
            throw new ServiceException(StatusCodes.Bad_SecurityPolicyRejected);
        }
        if (!serverSecureChannel.getEndpoint().supportsSecurityMode(securityMode)) {
            logger.info("The requested SecurityMode(" + securityMode + ") is not supported by the endpoint. Client=" + applicationDescription.getApplicationUri());
            this.hF.getDiagnosticsManager().cpD();
            throw new ServiceException(StatusCodes.Bad_SecurityModeRejected);
        }
        if (this.getSessionCount() >= this.getMaxSessionCount()) {
            if (this.getSessionCount() == this.mK.size()) {
                logger.info("createSession: MaxSessionCount exceeded, rejecting connection from {}", (Object)applicationDescription.getApplicationUri());
                this.hF.getDiagnosticsManager().cpD();
                throw new ServiceException(StatusCodes.Bad_TooManySessions);
            }
            object2 = this.newSessionsQueue.poll();
            object = this.newSessions.remove(object2);
            logger.info("createSession: MaxSessionCount exceeded, removing the oldest non-activated Session :{}", object);
            if (object != null) {
                this.hF.getDiagnosticsManager().removeSession((Session)object);
                this.a((Session)object, false);
            }
        }
        try {
            Object object3 = object = byArray == null ? null : new Cert(byArray);
            if (object != null && !serverSecureChannel.needsCertificate()) {
                logger.info("Client sent a certificate, although SecurityPolicy NONE is used");
            }
            ApplicationIdentity applicationIdentity = new ApplicationIdentity((Cert)object, null);
            applicationIdentity.setApplicationDescription(applicationDescription);
            object2 = this.provideSession(string, applicationIdentity, securityMode);
        }
        catch (ServiceResultException serviceResultException) {
            logger.error(serviceResultException.getMessage());
            this.hF.getDiagnosticsManager().cpD();
            this.hF.getDiagnosticsManager().cpE();
            throw new ServiceException(StatusCodes.Bad_CertificateInvalid);
        }
        ((Session)object2).setMaxResponseMessageSize(unsignedInteger);
        double d3 = this.a(d2);
        if (logger.isTraceEnabled()) {
            logger.trace("createSession: requestedSessionTimeout=" + d2 + " revisedSessionTimeout=" + d3);
        }
        ((Session)object2).setSessionTimeout(d3);
        ((Session)object2).setChannel(serverSecureChannel);
        try {
            this.c((Session)object2);
        }
        catch (StatusException statusException) {
            this.hF.getDiagnosticsManager().cpD();
            this.hF.getDiagnosticsManager().cpE();
            throw new ServiceException(statusException.getStatusCode(), statusException.getDiagnosticInfo());
        }
        this.newSessions.put(((Session)object2).getAuthenticationToken(), (Session)object2);
        this.newSessionsQueue.add(((Session)object2).getAuthenticationToken());
        this.hF.getDiagnosticsManager().addSession((Session)object2);
        logger.info("Session created: " + object2);
        return object2;
    }

    protected Session provideSession(String string, ApplicationIdentity applicationIdentity, SecurityMode securityMode) {
        return new Session(this, applicationIdentity, string, securityMode);
    }

    protected void start() throws StatusException {
        if (logger.isDebugEnabled()) {
            logger.debug("start");
        }
        this.mI = true;
        this.crv();
    }

    ApplicationIdentity getServerIdentity() {
        return this.hF.getApplicationIdentity();
    }

    boolean a(SignatureData signatureData, Cert cert, ByteString byteString, SecurityPolicy securityPolicy, byte[] byArray) throws SecureIdentityException {
        if (signatureData == null || signatureData.getAlgorithm() == null || signatureData.getSignature() == null) {
            throw new SecureIdentityException("Signature invalid", StatusCodes.Bad_IdentityTokenInvalid);
        }
        if (securityPolicy.equals((Object)SecurityPolicy.NONE)) {
            return false;
        }
        if (!signatureData.getAlgorithm().equals(securityPolicy.getAsymmetricSignatureAlgorithm().getUri())) {
            logger.error("Client specified incorrect SignatureData algorithm: {}, expected: {}, using: {}", signatureData.getAlgorithm(), securityPolicy.getAsymmetricSignatureAlgorithm().getUri(), securityPolicy.getAsymmetricSignatureAlgorithm().getUri());
        }
        byte[] byArray2 = cert.getEncoded();
        if (byteString != null) {
            byArray2 = ByteBufferUtils.concatenate(byArray2, byteString.getValue());
        }
        try {
            X509Certificate x509Certificate = CertificateUtils.decodeX509Certificate(byArray);
            return CryptoUtil.verifyAsymm(x509Certificate, securityPolicy.getAsymmetricSignatureAlgorithm(), byArray2, ByteString.asByteArray(signatureData.getSignature()));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SecureIdentityException("Signature invalid", illegalArgumentException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new SecureIdentityException("Signature invalid", generalSecurityException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new SecureIdentityException("Signature invalid", serviceResultException);
        }
    }

    private class a
    implements Runnable {
        private a() {
        }

        @Override
        public void run() {
            if (logger.isTraceEnabled()) {
                logger.trace("SessionMonitor.run: sessions=" + Arrays.toString(SessionManager.this.mK.values().toArray()));
            }
            for (Session session : SessionManager.this.mK.values()) {
                if (!session.isTimeout()) continue;
                try {
                    if (logger.isDebugEnabled()) {
                        logger.debug("SessionMonitor: session timeout " + session.getSessionName());
                    }
                    SessionManager.this.closeSession(session.getAuthenticationToken(), false);
                    SessionManager.this.hF.getDiagnosticsManager().cpF();
                }
                catch (ServiceException serviceException) {
                    logger.warn("SessionMonitor: " + serviceException);
                }
            }
            SessionManager.this.cru();
        }
    }
}

