/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.server.AbstractContinuationPoint;
import com.prosysopc.ua.server.BrowseContinuationPoint;
import com.prosysopc.ua.server.DiagnosticsManager;
import com.prosysopc.ua.server.HistoryContinuationPoint;
import com.prosysopc.ua.server.ServerUserIdentity;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.SessionDiagnostics;
import com.prosysopc.ua.server.SessionListener;
import com.prosysopc.ua.server.SessionManager;
import com.prosysopc.ua.server.SessionSecurityDiagnostics;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.IdType;
import com.prosysopc.ua.stack.core.PublishRequest;
import com.prosysopc.ua.stack.core.PublishResponse;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.transport.ServerSecureChannel;
import com.prosysopc.ua.stack.transport.UriUtil;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.tcp.nio.OpcTcpServerSecureChannel;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Session {
    public static final Session INTERNAL_SESSION = new Session();
    private static long lv = 10000L;
    static final Logger logger = LoggerFactory.getLogger(Session.class);
    private volatile boolean active = false;
    private volatile boolean closed = false;
    private final NodeId lw;
    private final Map<Long, BrowseContinuationPoint> lx = new ConcurrentSkipListMap<Long, BrowseContinuationPoint>();
    private volatile ServerSecureChannel ly;
    private final ApplicationIdentity lz;
    private final SessionDiagnostics lA;
    private final SessionSecurityDiagnostics lB;
    private final Map<Long, HistoryContinuationPoint> lC = new ConcurrentSkipListMap<Long, HistoryContinuationPoint>();
    private volatile long lD = 0L;
    private volatile long lE;
    private final List<Locale> lF = new CopyOnWriteArrayList<Locale>();
    private volatile ByteString lG;
    private volatile SessionManager sessionManager;
    private volatile double lH;
    private final List<Subscription> hh = new CopyOnWriteArrayList<Subscription>();
    private final Queue<Subscription> lI = new ConcurrentLinkedQueue<Subscription>();
    private ServerUserIdentity lJ = null;
    protected List<SessionListener> listeners = new CopyOnWriteArrayList<SessionListener>();
    private final SecurityMode gP;

    public static long getActivationTimeout() {
        return lv;
    }

    public static void setActivationTimeout(long l2) {
        lv = l2;
    }

    private static NodeId cqu() {
        byte[] byArray = new byte[32];
        CryptoUtil.getRandom().nextBytes(byArray);
        return NodeId.get(IdType.Opaque, 0, ByteString.valueOf(byArray));
    }

    private Session() {
        this.sessionManager = null;
        this.lA = null;
        this.lB = null;
        this.lz = null;
        this.lw = null;
        this.gP = SecurityMode.NONE;
        this.active = true;
    }

    protected Session(SessionManager sessionManager, ApplicationIdentity applicationIdentity, String string, SecurityMode securityMode) {
        this.gP = securityMode;
        this.sessionManager = sessionManager;
        UaServer.NodeManagerUaServer nodeManagerUaServer = sessionManager.getServer().getNodeManagerUaServer();
        NodeId nodeId = NodeId.randomGUID(nodeManagerUaServer.getNamespaceIndex());
        if (string == null) {
            string = "ServerAssigned " + nodeId;
        }
        String string2 = null;
        DateTime dateTime = DateTime.currentTime();
        String string3 = null;
        String[] stringArray = null;
        DateTime dateTime2 = dateTime;
        Double d2 = null;
        UnsignedInteger unsignedInteger = null;
        this.lA = new SessionDiagnostics(nodeId, string, applicationIdentity.getApplicationDescription(), string2, string3, stringArray, d2, unsignedInteger, dateTime, dateTime2);
        Cert cert = applicationIdentity.getCertificate();
        ByteString byteString = cert != null ? ByteString.valueOf(cert.getEncoded()) : null;
        String string4 = null;
        String[] stringArray2 = new String[]{};
        String string5 = null;
        String string6 = null;
        String string7 = null;
        this.lB = new SessionSecurityDiagnostics(nodeId, string4, stringArray2, string5, string6, string7, securityMode.getMessageSecurityMode(), securityMode.getSecurityPolicy().getPolicyUri(), byteString);
        this.lz = applicationIdentity;
        this.lw = Session.cqu();
        this.lE = System.currentTimeMillis();
    }

    public void addSessionListener(SessionListener sessionListener) {
        if (!this.listeners.contains(sessionListener)) {
            this.listeners.add(sessionListener);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Session session = (Session)object;
        if (this.lw == null ? session.lw != null : !this.lw.equals(session.lw)) {
            return false;
        }
        return !(this.getSessionId() == null ? session.getSessionId() != null : !this.getSessionId().equals(session.getSessionId()));
    }

    public NodeId getAuthenticationToken() {
        return this.lw;
    }

    public ServerSecureChannel getChannel() {
        return this.ly;
    }

    public ApplicationIdentity getClientIdentity() {
        return this.lz;
    }

    public DateTime getClientLastContactTime() {
        return this.lA.cqI().get();
    }

    public Locale getDefaultLocale() {
        if (this.lF == null || this.lF.isEmpty()) {
            return Locale.ENGLISH;
        }
        return this.lF.get(0);
    }

    public List<Locale> getLocales() {
        return Collections.unmodifiableList(this.lF);
    }

    public UnsignedInteger getMaxResponseMessageSize() {
        return this.lA.cqW().get();
    }

    public SecurityMode getSecurityMode() {
        return this.gP;
    }

    public SessionDiagnostics getSessionDiagnostics() {
        return this.lA;
    }

    public NodeId getSessionId() {
        return this.lA == null ? null : this.lA.getSessionId();
    }

    public String getSessionName() {
        return this.lA == null ? "INTERNAL_SESSION" : this.lA.crg().get();
    }

    public SessionSecurityDiagnostics getSessionSecurityDiagnostics() {
        return this.lB;
    }

    public double getSessionTimeout() {
        return this.lH;
    }

    public int getSubscriptionCount() {
        return this.hh.size();
    }

    public ServerUserIdentity getUserIdentity() {
        return this.lJ;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.lw == null ? 0 : this.lw.hashCode());
        n3 = 31 * n3;
        if (this.lA != null) {
            n3 += this.getSessionId().hashCode();
        }
        return n3;
    }

    public boolean hasLocale(Locale locale) {
        return this.lF.contains(locale);
    }

    public boolean hasSessionListener(SessionListener sessionListener) {
        return this.listeners.contains(sessionListener);
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isTimeout() {
        long l2 = System.currentTimeMillis() - this.lE;
        double d2 = this.isActive() ? this.lH : (double)lv;
        logger.trace("isTimeout: timeout={} delay={}", (Object)d2, (Object)l2);
        return (double)l2 > d2;
    }

    public void removeSessionListener(SessionListener sessionListener) {
        this.listeners.remove(sessionListener);
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s (ID=%s Token=%s Channel=(%s))", this.getSessionName(), this.getSessionId(), this.getAuthenticationToken(), this.getChannel());
    }

    private Long c(ByteString byteString) throws StatusException {
        Long l2;
        if (byteString == null) {
            throw new StatusException("null", StatusCodes.Bad_ContinuationPointInvalid);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteString.getValue());
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        try {
            l2 = dataInputStream.readLong();
        }
        catch (IOException iOException) {
            throw new StatusException("Too short array: " + byteString, StatusCodes.Bad_ContinuationPointInvalid);
        }
        return l2;
    }

    private void cqv() {
        for (SessionListener sessionListener : this.listeners) {
            try {
                sessionListener.onSessionActivated(this);
            }
            catch (Exception exception) {
                logger.warn("Exception in SessionListener, onSessionActivated:", exception);
            }
        }
    }

    private void cqw() {
        for (SessionListener sessionListener : this.listeners) {
            try {
                sessionListener.onSessionChanged(this);
            }
            catch (Exception exception) {
                logger.warn("Exception in SessionListener, onSessionChanged:", exception);
            }
        }
    }

    private void cqx() {
        for (SessionListener sessionListener : this.listeners) {
            try {
                sessionListener.onSessionClosed(this);
            }
            catch (Exception exception) {
                logger.warn("Exception in SessionListener, onSessionClosed:", exception);
            }
        }
    }

    private AbstractContinuationPoint a(ByteString byteString, Map<Long, ? extends AbstractContinuationPoint> map) throws StatusException {
        Long l2 = this.c(byteString);
        AbstractContinuationPoint abstractContinuationPoint = map.remove(l2);
        logger.debug("getContinuationPoint: i={} result={}", (Object)l2, (Object)abstractContinuationPoint);
        if (abstractContinuationPoint == null) {
            throw new StatusException("Not found: " + byteString, StatusCodes.Bad_ContinuationPointInvalid);
        }
        return abstractContinuationPoint;
    }

    private DiagnosticsManager getDiagnosticsManager() {
        SessionManager sessionManager = this.getSessionManager();
        return sessionManager == null ? null : sessionManager.getServer().getDiagnosticsManager();
    }

    private boolean isDiagnosticsEnabled() {
        DiagnosticsManager diagnosticsManager = this.getDiagnosticsManager();
        return diagnosticsManager == null ? false : diagnosticsManager.isEnabled();
    }

    private boolean isInternal() {
        return this == INTERNAL_SESSION;
    }

    private ByteString a(Long l2) throws StatusException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
        try {
            dataOutputStream.writeLong(l2);
            dataOutputStream.flush();
        }
        catch (IOException iOException) {
            throw new StatusException("Cannot create long");
        }
        return ByteString.valueOf(byteArrayOutputStream.toByteArray());
    }

    private synchronized long cqy() {
        return ++this.lD;
    }

    private void a(ServiceContext serviceContext, Map<Long, ? extends AbstractContinuationPoint> map, int n2) throws StatusException {
        if (n2 == 0) {
            return;
        }
        Iterator<? extends AbstractContinuationPoint> iterator = map.values().iterator();
        try {
            while (map.size() >= n2) {
                AbstractContinuationPoint abstractContinuationPoint = iterator.next();
                if (abstractContinuationPoint.getServiceContext().equals(serviceContext)) continue;
                iterator.remove();
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new StatusException(StatusCodes.Bad_NoContinuationPoints);
        }
    }

    protected void activate(ServerUserIdentity serverUserIdentity) {
        this.lJ = serverUserIdentity;
        this.active = true;
        logger.debug("ServerUserIdentity: {}", (Object)serverUserIdentity);
        if (serverUserIdentity != null) {
            this.lB.crw().set(serverUserIdentity.getType().name());
            if (serverUserIdentity.getName() != null && serverUserIdentity.getName().length() > 0) {
                this.lB.crx().add(serverUserIdentity.getName());
            }
            this.lB.cry().set(serverUserIdentity.getName());
        }
        this.cqv();
    }

    protected ByteString addBrowseContinuationPoint(BrowseContinuationPoint browseContinuationPoint) throws StatusException {
        Object object;
        int n2;
        if (this.isInternal()) {
            n2 = Integer.MAX_VALUE;
        } else {
            object = this.getSessionManager();
            if (object == null) {
                throw new StatusException(StatusCodes.Bad_SessionClosed);
            }
            n2 = ((SessionManager)object).getMaxBrowseContinuationPoints();
        }
        this.a(browseContinuationPoint.getServiceContext(), this.lx, n2);
        object = this.cqy();
        logger.debug("addContinuationPoint: i={}", object);
        this.lx.put((Long)object, browseContinuationPoint);
        this.cqw();
        return this.a((Long)object);
    }

    protected ByteString addHistoryContinuationPoint(HistoryContinuationPoint historyContinuationPoint) throws StatusException {
        int n2;
        if (this.isInternal()) {
            n2 = Integer.MAX_VALUE;
        } else {
            SessionManager sessionManager = this.getSessionManager();
            if (sessionManager == null) {
                throw new StatusException(StatusCodes.Bad_SessionClosed);
            }
            n2 = sessionManager.getMaxHistoryContinuationPoints();
        }
        this.a(historyContinuationPoint.getServiceContext(), this.lC, n2);
        long l2 = this.cqy();
        this.lC.put(l2, historyContinuationPoint);
        this.cqw();
        return this.a(l2);
    }

    protected void addSubscription(Subscription subscription) {
        this.hh.add(subscription);
        this.cqw();
    }

    protected void cancel() {
    }

    protected void close(boolean bl) {
        logger.debug("close");
        this.cqx();
        this.listeners.clear();
        this.active = false;
        this.sessionManager = null;
        this.closed = true;
        this.lx.clear();
        this.lC.clear();
        ServerSecureChannel serverSecureChannel = this.getChannel();
        if (serverSecureChannel instanceof OpcTcpServerSecureChannel) {
            OpcTcpServerSecureChannel opcTcpServerSecureChannel = (OpcTcpServerSecureChannel)serverSecureChannel;
            opcTcpServerSecureChannel.getConnection().setActiveSession(false);
        }
    }

    protected void deactivate() {
        this.active = false;
        this.cqw();
    }

    protected BrowseContinuationPoint getBrowseContinuationPoint(ByteString byteString) throws StatusException {
        return (BrowseContinuationPoint)this.a(byteString, this.lx);
    }

    protected QualifiedName getDefaultEncoding() {
        return QualifiedName.DEFAULT_BINARY_ENCODING;
    }

    protected HistoryContinuationPoint getHistoryContinuationPoint(ByteString byteString) throws StatusException {
        return (HistoryContinuationPoint)this.a(byteString, this.lC);
    }

    protected ByteString getNewServerNonce(int n2) {
        this.lG = CryptoUtil.createNonce(n2);
        this.cqw();
        return this.lG;
    }

    protected ByteString getServerNonce() {
        return this.lG;
    }

    protected SessionManager getSessionManager() {
        return this.sessionManager;
    }

    protected Queue<Subscription> getTransferredSubscriptions() {
        return this.lI;
    }

    protected void removeSubscription(Subscription subscription) {
        this.hh.remove(subscription);
    }

    protected void resetDiagnostics() {
        this.lA.crq();
        this.cqw();
    }

    protected void setChannel(ServerSecureChannel serverSecureChannel) {
        Object object;
        ServerSecureChannel serverSecureChannel2 = this.ly;
        if (serverSecureChannel2 != null && serverSecureChannel2 instanceof OpcTcpServerSecureChannel) {
            object = (OpcTcpServerSecureChannel)serverSecureChannel2;
            ((OpcTcpServerSecureChannel)object).getConnection().setActiveSession(false);
        }
        this.ly = serverSecureChannel;
        logger.trace("setChannel: serverSecureChannel=" + (serverSecureChannel == null ? "null" : serverSecureChannel));
        if (serverSecureChannel != null) {
            object = serverSecureChannel.getEndpoint().getEndpointUrl();
            this.lA.cqS().set((String)object);
            this.lB.crz().set("UA Binary");
            this.lB.crC().set(UriUtil.getTransportProtocol((String)object).toLowerCase(Locale.ROOT));
            this.lB.crA().set(serverSecureChannel.getMessageSecurityMode());
            this.lB.crB().set(serverSecureChannel.getSecurityPolicy().getPolicyUri());
        }
        this.cqw();
    }

    protected void setLocaleIds(String[] stringArray) {
        if (stringArray != null) {
            this.lF.clear();
            for (String string : stringArray) {
                this.lF.add(LocalizedText.toLocale(string));
            }
        }
        this.lA.cqV().set(stringArray);
        this.cqw();
    }

    protected void setMaxResponseMessageSize(UnsignedInteger unsignedInteger) {
        this.lA.cqW().set(unsignedInteger);
        this.cqw();
    }

    protected void setSessionName(String string) {
        this.lA.crg().set(string);
        this.cqw();
    }

    protected void setSessionTimeout(double d2) {
        logger.debug("setSessionTimeout: {}", (Object)d2);
        this.lH = d2;
        this.lA.cqA().set(this.lH);
        this.cqw();
    }

    protected void updateDiagnostics() {
        SessionManager sessionManager = this.getSessionManager();
        if (sessionManager != null) {
            sessionManager.getServer().getDiagnosticsManager().updateSession(this);
        }
    }

    List<Subscription> cqz() {
        return this.hh;
    }

    void a(ServiceRequest serviceRequest) {
        this.lE = System.currentTimeMillis();
        if (this.isDiagnosticsEnabled()) {
            this.lA.cqI().set(DateTime.currentTime());
            String string = serviceRequest.getClass().getName().replace("Request", "").replaceAll(".*[.]", "");
            SessionDiagnostics.ServiceCounter serviceCounter = this.lA.s(string);
            if (serviceCounter != null) {
                serviceCounter.crs();
            }
            this.lA.crk().crs();
            if (serviceRequest instanceof PublishRequest) {
                this.lA.cqM().incrementAndGet();
            }
            this.updateDiagnostics();
        }
        this.cqw();
    }

    void a(ServiceResponse serviceResponse) {
        if (this.isDiagnosticsEnabled()) {
            StatusCode statusCode = serviceResponse.getResponseHeader().getServiceResult();
            if (statusCode.isBad()) {
                String string = serviceResponse.getClass().getName().replace("Response", "").replaceAll(".*[.]", "");
                SessionDiagnostics.ServiceCounter serviceCounter = this.lA.s(string);
                if (serviceCounter != null) {
                    serviceCounter.crr();
                }
                this.lA.crk().crr();
                if (statusCode.getValue().equals(StatusCodes.Bad_UserAccessDenied)) {
                    this.lA.crn().incrementAndGet();
                }
            }
            if (serviceResponse instanceof PublishResponse) {
                this.lA.cqM().decrementAndGet();
            }
            this.updateDiagnostics();
            this.cqw();
        }
    }
}

