/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaReferenceType;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.nodes.UaValueNode;
import com.prosysopc.ua.server.BrowseContinuationPoint;
import com.prosysopc.ua.server.EventManager;
import com.prosysopc.ua.server.HistoryManager;
import com.prosysopc.ua.server.IoManager;
import com.prosysopc.ua.server.MethodManager;
import com.prosysopc.ua.server.MethodManagerUaNode;
import com.prosysopc.ua.server.MonitoredDataItem;
import com.prosysopc.ua.server.MonitoredEventItem;
import com.prosysopc.ua.server.MonitoredItem;
import com.prosysopc.ua.server.NodeManagerListener;
import com.prosysopc.ua.server.NodeManagerTable;
import com.prosysopc.ua.server.ServiceContext;
import com.prosysopc.ua.server.ServiceManagerBase;
import com.prosysopc.ua.server.Subscription;
import com.prosysopc.ua.server.UaServer;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.AggregateFilterResult;
import com.prosysopc.ua.stack.core.BrowseDirection;
import com.prosysopc.ua.stack.core.BrowsePathTarget;
import com.prosysopc.ua.stack.core.BrowseResultMask;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.EventFilterResult;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.MonitoringFilter;
import com.prosysopc.ua.stack.core.MonitoringMode;
import com.prosysopc.ua.stack.core.MonitoringParameters;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.QueryFirstRequest;
import com.prosysopc.ua.stack.core.QueryFirstResponse;
import com.prosysopc.ua.stack.core.QueryNextRequest;
import com.prosysopc.ua.stack.core.QueryNextResponse;
import com.prosysopc.ua.stack.core.ReferenceDescription;
import com.prosysopc.ua.stack.core.RelativePath;
import com.prosysopc.ua.stack.core.RelativePathElement;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.ViewDescription;
import com.prosysopc.ua.stack.utils.NumericRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NodeManager
extends ServiceManagerBase {
    static Logger logger = LoggerFactory.getLogger(NodeManager.class);
    private Locale defaultLocale = LocalizedText.NO_LOCALE;
    private EventManager km;
    private HistoryManager kn;
    private IoManager ko;
    private final List<NodeManagerListener> listeners = new CopyOnWriteArrayList<NodeManagerListener>();
    private MethodManager kp;
    private final int namespaceIndex;
    private final String namespaceUri;
    protected boolean initialized = false;
    protected boolean started = false;

    public NodeManager(UaServer uaServer, String string) {
        super(uaServer);
        this.namespaceUri = string;
        NodeManagerTable nodeManagerTable = this.getNodeManagerTable();
        if (nodeManagerTable == null) {
            throw new IllegalStateException("UaServer.init must be called before creating NodeManager");
        }
        this.namespaceIndex = nodeManagerTable.addNodeManager(-1, this);
    }

    public void addListener(NodeManagerListener nodeManagerListener) {
        if (!this.hasListener(nodeManagerListener)) {
            this.listeners.add(nodeManagerListener);
        }
    }

    public UaNode addNode(UaNode uaNode) throws StatusException {
        throw new StatusException(StatusCodes.Bad_NotSupported);
    }

    public UaNode findNode(NodeId nodeId) {
        if (this.supportsUaNode()) {
            throw new Error("NodeManager findNode(NodeId) not implemented, even though the manager supportsUaNode: " + this.getClass());
        }
        return null;
    }

    public Locale getDefaultLocale() {
        return this.defaultLocale;
    }

    public EventManager getEventManager() {
        return this.km;
    }

    public HistoryManager getHistoryManager() {
        return this.kn;
    }

    public IoManager getIoManager() {
        return this.ko;
    }

    public MethodManager getMethodManager() throws StatusException {
        if (this.kp == null) {
            throw new StatusException(StatusCodes.Bad_NotSupported);
        }
        return this.kp;
    }

    public int getNamespaceIndex() {
        return this.namespaceIndex;
    }

    public NamespaceTable getNamespaceTable() {
        return this.getNodeManagerTable().getNamespaceTable();
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    @Override
    public UaNode getNode(ExpandedNodeId expandedNodeId) throws StatusException {
        try {
            return this.getNode(this.getNamespaceTable().toNodeId(expandedNodeId));
        }
        catch (ServiceResultException serviceResultException) {
            throw new StatusException(StatusCodes.Bad_ServerIndexInvalid, (Throwable)serviceResultException);
        }
    }

    @Override
    public UaNode getNode(NodeId nodeId) throws StatusException {
        return super.getNode(nodeId);
    }

    public NodeId getNodeId(String string, String string2) {
        int n2 = this.getNamespaceTable().getIndex(string);
        return NodeId.parseNodeId(String.format(Locale.ROOT, "ns=%d;%s", n2, string2));
    }

    public QualifiedName getQualifiedName(String string, String string2) {
        int n2 = this.getNamespaceTable().getIndex(string);
        return new QualifiedName(n2, string2);
    }

    public UaReference[] getReferences(NodeId nodeId) {
        return this.getReferences(nodeId, this.findNode(nodeId));
    }

    public abstract NodeId getVariableDataType(NodeId var1, UaValueNode var2) throws StatusException;

    public boolean hasListener(NodeManagerListener nodeManagerListener) {
        if (nodeManagerListener == null) {
            throw new NullPointerException("null listener not allowed");
        }
        return this.listeners.contains(nodeManagerListener);
    }

    public abstract boolean hasNode(NodeId var1);

    @Override
    public void invalidatePreviousNodeCache() {
        super.invalidatePreviousNodeCache();
        Optional.ofNullable(this.km).ifPresent(eventManager -> eventManager.invalidatePreviousNodeCache());
        Optional.ofNullable(this.kn).ifPresent(historyManager -> historyManager.invalidatePreviousNodeCache());
        Optional.ofNullable(this.ko).ifPresent(ioManager -> ioManager.invalidatePreviousNodeCache());
        Optional.ofNullable(this.kp).ifPresent(methodManager -> methodManager.invalidatePreviousNodeCache());
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public final boolean isOfType(NodeId nodeId, UaType uaType, NodeId nodeId2, UaType uaType2) throws StatusException {
        if (this.hasNode(nodeId)) {
            return this.getIsOfType(nodeId, uaType, nodeId2, uaType2);
        }
        return this.getNodeManagerTable().isTypeOf(nodeId, uaType, nodeId2, uaType2);
    }

    public boolean isStarted() {
        return this.started;
    }

    public void removeListener(NodeManagerListener nodeManagerListener) {
        this.listeners.remove(nodeManagerListener);
    }

    public void setDefaultLocale(Locale locale) {
        this.defaultLocale = locale;
    }

    public void setEventManager(EventManager eventManager) {
        if (this.kp instanceof MethodManagerUaNode) {
            MethodManagerUaNode methodManagerUaNode = (MethodManagerUaNode)this.kp;
            methodManagerUaNode.addCallListener(eventManager);
            methodManagerUaNode.removeCallListener(this.km);
        }
        this.km = eventManager;
    }

    public void setHistoryManager(HistoryManager historyManager) {
        this.kn = historyManager;
    }

    public void setIoManager(IoManager ioManager) {
        this.ko = ioManager;
    }

    public void setMethodManager(MethodManager methodManager) {
        if (this.kp instanceof MethodManagerUaNode) {
            ((MethodManagerUaNode)this.kp).removeCallListener(this.km);
        }
        if (methodManager instanceof MethodManagerUaNode) {
            ((MethodManagerUaNode)methodManager).addCallListener(this.km);
        }
        this.kp = methodManager;
    }

    public boolean supportsUaNode() {
        return false;
    }

    public String toString() {
        return this.getClass() + " namespaceUri=" + this.namespaceUri + " namespaceIndex=" + this.namespaceIndex;
    }

    protected NodeId addNode(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, QualifiedName qualifiedName, NodeClass nodeClass, ExpandedNodeId expandedNodeId, NodeAttributes nodeAttributes, NodeId nodeId3) throws StatusException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    protected void addReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, boolean bl, NodeClass nodeClass, String string) throws StatusException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    protected void afterCreateMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem) {
        this.fireAfterCreateMonitoredDataItem(serviceContext, subscription, monitoredDataItem);
    }

    protected void afterCreateMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) {
        EventManager eventManager = this.getEventManager(monitoredEventItem.getNodeId());
        if (eventManager != null) {
            eventManager.afterCreateMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
        }
    }

    protected void afterDeleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) {
        this.fireAfterDeleteMonitoredItem(serviceContext, subscription, monitoredItem);
    }

    protected void afterModifyMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem) {
        this.fireAfterModifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem);
    }

    protected void afterModifyMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem) {
        EventManager eventManager = this.getEventManager(monitoredEventItem.getNodeId());
        if (eventManager != null) {
            eventManager.afterModifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected BrowseContinuationPoint browseNode(ServiceContext serviceContext, List<ReferenceDescription> list, NodeId nodeId, int n2, BrowseDirection browseDirection, NodeId nodeId2, Boolean bl, QualifiedName qualifiedName, EnumSet<NodeClass> enumSet, EnumSet<BrowseResultMask> enumSet2, ViewDescription viewDescription, int n3) throws ServiceException, StatusException {
        if (logger.isDebugEnabled()) {
            logger.debug("browseNode: ReferenceTypeId={}", (Object)nodeId2);
            logger.debug("browseNode: NodeId={}", (Object)nodeId);
            logger.debug("browseNode: nodeClassSet={}", (Object)enumSet);
            logger.debug("browseNode: includeSubTypes={}", (Object)bl);
            logger.debug("browseNode: browseDirection={}", (Object)browseDirection);
        }
        UaReferenceType uaReferenceType = NodeId.isNull(nodeId2) ? null : this.getReferenceType(nodeId2);
        logger.debug("browseNode: referenceType={}", (Object)uaReferenceType);
        UaNode uaNode = this.getNode(nodeId);
        logger.debug("browseNode: node={}", (Object)uaNode);
        UaReference[] uaReferenceArray = this.getReferences(nodeId, uaNode);
        if (uaReferenceArray != null) {
            void var18_21;
            NodeClass exception;
            UaNode uaNode2;
            Object object;
            ExpandedNodeId expandedNodeId;
            boolean bl2;
            ArrayList<UaReference> arrayList = new ArrayList<UaReference>(Arrays.asList(uaReferenceArray));
            for (NodeManagerListener object2 : this.listeners) {
                object2.onGetReferences(serviceContext, viewDescription, nodeId, uaNode, arrayList);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("browseNode: references of node={}", (Object)Arrays.toString(arrayList.toArray()));
            }
            ArrayList arrayList2 = new ArrayList();
            for (UaReference uaReference : arrayList) {
                bl2 = uaReference.getIsInverse(nodeId);
                ExpandedNodeId expandedNodeId2 = expandedNodeId = bl2 ? uaReference.getSourceId() : uaReference.getTargetId();
                if (expandedNodeId != null && !expandedNodeId.isLocal()) {
                    if (uaReference.getReferenceTypeId() == null || nodeId2 == null || !uaReference.getReferenceTypeId().equals(nodeId2) && (!bl.booleanValue() || !uaReference.getReferenceType().inheritsFrom(uaReferenceType))) continue;
                    arrayList2.add(uaReference);
                    continue;
                }
                object = this.getNodeManagerTable().getNodeManager(expandedNodeId);
                if (!((NodeManager)object).referenceMatchesRequest(uaReference, browseDirection, nodeId2, uaReferenceType, bl, qualifiedName, nodeId)) continue;
                uaNode2 = null;
                try {
                    if (((NodeManager)object).supportsUaNode()) {
                        uaNode2 = ((NodeManager)object).getNode(expandedNodeId);
                    }
                }
                catch (Exception exception2) {
                    uaNode2 = null;
                    logger.trace("Could not get target node for id: {}", (Object)expandedNodeId, (Object)exception2);
                }
                exception = ((NodeManager)object).getNodeClass(expandedNodeId, uaNode2);
                logger.debug("browseNode: match found targetId={}; target={}; nodeClassSet={}; resultSet={}", expandedNodeId, uaNode2, enumSet, enumSet2);
                if (exception != null && (!enumSet.contains(exception) || !this.fireBrowseNode(serviceContext, viewDescription, nodeId, uaNode, uaReference))) continue;
                arrayList2.add(uaReference);
            }
            int n4 = n3;
            while (var18_21 < arrayList2.size()) {
                UaReference uaReference;
                uaReference = (UaReference)arrayList2.get((int)var18_21);
                bl2 = uaReference.getIsInverse(nodeId);
                expandedNodeId = this.getNamespaceTable().nodeIdEquals(nodeId, uaReference.getSourceId()) ? uaReference.getTargetId() : uaReference.getSourceId();
                if (expandedNodeId != null && !expandedNodeId.isLocal()) {
                    object = new ReferenceDescription(uaReference.getReferenceTypeId(), !bl2, expandedNodeId, null, null, null, null);
                    list.add((ReferenceDescription)object);
                    logger.debug("browseNode: added external reference");
                } else {
                    object = this.getNodeManagerTable().getNodeManager(expandedNodeId);
                    uaNode2 = null;
                    if (((NodeManager)object).supportsUaNode()) {
                        try {
                            uaNode2 = ((NodeManager)object).getNode(expandedNodeId);
                        }
                        catch (Exception exception3) {
                            uaNode2 = null;
                            logger.trace("Could not get target node for id: {}", (Object)expandedNodeId, (Object)exception3);
                        }
                    }
                    exception = ((NodeManager)object).getNodeClass(expandedNodeId, uaNode2);
                    ReferenceDescription referenceDescription = ((NodeManager)object).createReferenceDescription(uaReference.getReferenceTypeId(), expandedNodeId, uaNode2, bl2, exception, enumSet2);
                    logger.debug("browseNode: reference accepted");
                    list.add(referenceDescription);
                }
                if (list.size() == n2 && var18_21 + true < arrayList2.size()) {
                    object = new BrowseContinuationPoint(serviceContext);
                    ((BrowseContinuationPoint)object).setBrowseDirection(browseDirection);
                    ((BrowseContinuationPoint)object).setIncludeSubtypes(bl);
                    ((BrowseContinuationPoint)object).setIndex((int)(var18_21 + true));
                    ((BrowseContinuationPoint)object).setMaxResultsToReturn(n2);
                    ((BrowseContinuationPoint)object).setNodeClassMask(enumSet);
                    ((BrowseContinuationPoint)object).setNode(nodeId);
                    ((BrowseContinuationPoint)object).setResultMask(enumSet2);
                    ((BrowseContinuationPoint)object).setReferenceTypeId(nodeId2);
                    ((BrowseContinuationPoint)object).setView(viewDescription);
                    return object;
                }
                ++var18_21;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("browseNode: returning referenceDescriptions={}", (Object)list.size());
        }
        return null;
    }

    protected Variant[] callMethod(ServiceContext serviceContext, NodeId nodeId, NodeId nodeId2, Variant[] variantArray, StatusCode[] statusCodeArray, DiagnosticInfo[] diagnosticInfoArray) throws StatusException {
        if (this.getMethodManager() != null) {
            UaNode uaNode;
            try {
                uaNode = this.supportsUaNode() ? this.getNode(nodeId2) : null;
            }
            catch (StatusException statusException) {
                if (StatusCode.valueOf(StatusCodes.Bad_NodeIdUnknown).equals(statusException.getStatusCode())) {
                    logger.debug("No UaNode was found for the given methodId: {} in a NodeManager that supports UaNodes", (Object)nodeId2);
                    throw new StatusException(StatusCodes.Bad_MethodInvalid, (Throwable)statusException);
                }
                throw statusException;
            }
            try {
                UaMethod uaMethod = uaNode != null ? (UaMethod)uaNode : null;
                this.getNodeManagerTable().getIoManager(nodeId2).checkExecutable(serviceContext, null, nodeId2, uaMethod);
            }
            catch (ClassCastException classCastException) {
                logger.debug("Given methodId: {} does not result in a UaMethod in a NodeManager that supports UaNodes", (Object)nodeId2);
                throw new StatusException(StatusCodes.Bad_MethodInvalid, (Throwable)classCastException);
            }
            return this.getMethodManager().callMethod(serviceContext, nodeId, nodeId2, variantArray, statusCodeArray, diagnosticInfoArray);
        }
        return null;
    }

    protected void close() {
        this.initialized = false;
    }

    protected void createMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult, MonitoringMode monitoringMode) throws StatusException {
        this.fireCreateMonitoredDataItem(serviceContext, subscription, nodeId, null, unsignedInteger, numericRange, monitoringParameters, monitoringFilter, aggregateFilterResult, monitoringMode);
    }

    protected void createMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        EventManager eventManager = this.getEventManager(nodeId);
        if (eventManager != null) {
            eventManager.createMonitoredEventItem(serviceContext, subscription, nodeId, eventFilter, eventFilterResult);
        }
    }

    protected ReferenceDescription createReferenceDescription(NodeId nodeId, ExpandedNodeId expandedNodeId, UaNode uaNode, boolean bl, NodeClass nodeClass, EnumSet<BrowseResultMask> enumSet) {
        ReferenceDescription referenceDescription = new ReferenceDescription();
        referenceDescription.setNodeId(expandedNodeId);
        if (enumSet.contains(BrowseResultMask.ReferenceTypeId)) {
            referenceDescription.setReferenceTypeId(nodeId);
        } else {
            referenceDescription.setReferenceTypeId(NodeId.NULL);
        }
        if (enumSet.contains(BrowseResultMask.IsForward)) {
            referenceDescription.setIsForward(!bl);
        } else {
            referenceDescription.setIsForward(false);
        }
        if (enumSet.contains(BrowseResultMask.NodeClass)) {
            referenceDescription.setNodeClass(nodeClass);
        }
        if (enumSet.contains(BrowseResultMask.BrowseName)) {
            referenceDescription.setBrowseName(this.getBrowseName(expandedNodeId, uaNode));
        }
        if (enumSet.contains(BrowseResultMask.DisplayName)) {
            referenceDescription.setDisplayName(this.getDisplayName(expandedNodeId, uaNode, null));
        }
        if (enumSet.contains(BrowseResultMask.TypeDefinition)) {
            referenceDescription.setTypeDefinition(this.getTypeDefinition(expandedNodeId, uaNode));
        }
        return referenceDescription;
    }

    protected void deleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) throws StatusException {
        this.fireDeleteMonitoredItem(serviceContext, subscription, monitoredItem);
    }

    protected void deleteNode(ServiceContext serviceContext, NodeId nodeId, Boolean bl) throws StatusException {
        UaNode uaNode = this.findNode(nodeId);
        this.fireDeleteNode(serviceContext, nodeId, uaNode, bl);
        this.getNodeManagerTable().invalidatePreviousNodeCaches();
    }

    protected void deleteReference(ServiceContext serviceContext, NodeId nodeId, ExpandedNodeId expandedNodeId, NodeId nodeId2, Boolean bl, Boolean bl2) throws StatusException {
        UaNode uaNode = this.findNode(nodeId);
        UaNode uaNode2 = null;
        UaReferenceType uaReferenceType = null;
        try {
            uaReferenceType = (UaReferenceType)this.getNode(nodeId2);
        }
        catch (StatusException statusException) {
        }
        catch (ClassCastException classCastException) {
            throw new StatusException(StatusCodes.Bad_ReferenceTypeIdInvalid);
        }
        this.fireDeleteReference(serviceContext, nodeId, uaNode, expandedNodeId, uaNode2, nodeId2, uaReferenceType, bl, bl2);
    }

    protected UaNode findNode(ExpandedNodeId expandedNodeId) throws ServiceResultException {
        return this.findNode(this.getNamespaceTable().toNodeId(expandedNodeId));
    }

    protected NodeClass findNodeClass(ExpandedNodeId expandedNodeId, UaNode uaNode) {
        return this.getNodeManagerTable().getNodeClass(expandedNodeId, uaNode);
    }

    protected void fireAddNode(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, NodeId nodeId2, NodeClass nodeClass, QualifiedName qualifiedName, NodeAttributes nodeAttributes, UaReferenceType uaReferenceType, ExpandedNodeId expandedNodeId, UaNode uaNode2) throws StatusException {
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            try {
                nodeManagerListener.onAddNode(serviceContext, nodeId, uaNode, nodeId2, nodeClass, qualifiedName, nodeAttributes, uaReferenceType, expandedNodeId, uaNode2);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onBeforeAddNode", nodeManagerListener, runtimeException);
            }
        }
    }

    protected void fireAddReference(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, ExpandedNodeId expandedNodeId, UaNode uaNode2, NodeId nodeId2, UaReferenceType uaReferenceType, boolean bl) throws StatusException {
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            if (nodeManagerListener == null) continue;
            try {
                nodeManagerListener.onAddReference(serviceContext, nodeId, uaNode, expandedNodeId, uaNode2, nodeId2, uaReferenceType, bl);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onBeforeAddReference", nodeManagerListener, runtimeException);
            }
        }
    }

    protected void fireAfterAddNode(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, NodeId nodeId2, UaNode uaNode2, NodeClass nodeClass, QualifiedName qualifiedName, NodeAttributes nodeAttributes, UaReferenceType uaReferenceType, ExpandedNodeId expandedNodeId, UaNode uaNode3) throws StatusException {
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            try {
                nodeManagerListener.onAfterAddNode(serviceContext, nodeId, uaNode, nodeId2, uaNode2, nodeClass, qualifiedName, nodeAttributes, uaReferenceType, expandedNodeId, uaNode3);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onAfterAddNode", nodeManagerListener, runtimeException);
            }
        }
    }

    protected void fireAfterAddReference(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, ExpandedNodeId expandedNodeId, UaNode uaNode2, NodeId nodeId2, UaReferenceType uaReferenceType, boolean bl) throws StatusException {
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            if (nodeManagerListener == null) continue;
            try {
                nodeManagerListener.onAfterAddReference(serviceContext, nodeId, uaNode, expandedNodeId, uaNode2, nodeId2, uaReferenceType, bl);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onAfterAddReference", nodeManagerListener, runtimeException);
            }
        }
    }

    protected void fireAfterCreateMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem) {
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            if (nodeManagerListener == null) continue;
            try {
                nodeManagerListener.onAfterCreateMonitoredDataItem(serviceContext, subscription, monitoredDataItem);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onAfterCreateMonitoredDataItem", nodeManagerListener, runtimeException);
            }
        }
    }

    protected void fireAfterDeleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) {
        if (monitoredItem instanceof MonitoredEventItem) {
            EventManager eventManager = this.getEventManager(monitoredItem.getNodeId());
            if (eventManager != null) {
                eventManager.afterDeleteMonitoredEventItem(serviceContext, subscription, (MonitoredEventItem)monitoredItem);
            }
        } else {
            for (NodeManagerListener nodeManagerListener : this.listeners) {
                if (nodeManagerListener == null) continue;
                try {
                    nodeManagerListener.onAfterDeleteMonitoredDataItem(serviceContext, subscription, (MonitoredDataItem)monitoredItem);
                }
                catch (RuntimeException runtimeException) {
                    this.listenerError("onAfterDeleteMonitoredDataItem", nodeManagerListener, runtimeException);
                }
            }
        }
    }

    protected void fireAfterModifyMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem) {
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            if (nodeManagerListener == null) continue;
            try {
                nodeManagerListener.onAfterModifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onAfterModifyMonitoredDataItem", nodeManagerListener, runtimeException);
            }
        }
    }

    protected boolean fireBrowseNode(ServiceContext serviceContext, ViewDescription viewDescription, NodeId nodeId, UaNode uaNode, UaReference uaReference) {
        logger.debug("fireBrowseNode");
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            if (nodeManagerListener == null) continue;
            try {
                if (nodeManagerListener.onBrowseNode(serviceContext, viewDescription, nodeId, uaNode, uaReference)) continue;
                return false;
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onBrowseNode", nodeManagerListener, runtimeException);
            }
        }
        return true;
    }

    protected void fireCreateMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, NodeId nodeId, UaNode uaNode, UnsignedInteger unsignedInteger, NumericRange numericRange, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult, MonitoringMode monitoringMode) throws StatusException {
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            if (nodeManagerListener == null) continue;
            try {
                nodeManagerListener.onCreateMonitoredDataItem(serviceContext, subscription, nodeId, uaNode, unsignedInteger, numericRange, monitoringParameters, monitoringFilter, aggregateFilterResult, monitoringMode);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onCreateMonitoredDataItem", nodeManagerListener, runtimeException);
            }
        }
    }

    protected void fireDeleteMonitoredItem(ServiceContext serviceContext, Subscription subscription, MonitoredItem monitoredItem) {
        if (monitoredItem instanceof MonitoredEventItem) {
            EventManager eventManager = this.getEventManager(monitoredItem.getNodeId());
            if (eventManager != null) {
                eventManager.deleteMonitoredEventItem(serviceContext, subscription, (MonitoredEventItem)monitoredItem);
            }
        } else {
            for (NodeManagerListener nodeManagerListener : this.listeners) {
                if (nodeManagerListener == null) continue;
                try {
                    nodeManagerListener.onDeleteMonitoredDataItem(serviceContext, subscription, (MonitoredDataItem)monitoredItem);
                }
                catch (RuntimeException runtimeException) {
                    this.listenerError("onDeleteMonitoredDataItem", nodeManagerListener, runtimeException);
                }
            }
        }
    }

    protected void fireDeleteNode(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, boolean bl) throws StatusException {
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            if (nodeManagerListener == null) continue;
            try {
                nodeManagerListener.onDeleteNode(serviceContext, nodeId, uaNode, bl);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onDeleteNode", nodeManagerListener, runtimeException);
            }
        }
    }

    protected void fireDeleteReference(ServiceContext serviceContext, NodeId nodeId, UaNode uaNode, ExpandedNodeId expandedNodeId, UaNode uaNode2, NodeId nodeId2, UaReferenceType uaReferenceType, boolean bl, boolean bl2) throws StatusException {
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            if (nodeManagerListener == null) continue;
            try {
                nodeManagerListener.onDeleteReference(serviceContext, nodeId, uaNode, expandedNodeId, uaNode2, nodeId2, uaReferenceType, bl, bl2);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onDeleteReference", nodeManagerListener, runtimeException);
            }
        }
    }

    protected void fireModifyMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem, UaNode uaNode, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult) throws StatusException {
        for (NodeManagerListener nodeManagerListener : this.listeners) {
            if (nodeManagerListener == null) continue;
            try {
                nodeManagerListener.onModifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem, uaNode, monitoringParameters, monitoringFilter, aggregateFilterResult);
            }
            catch (RuntimeException runtimeException) {
                this.listenerError("onModifyMonitoredDataItem", nodeManagerListener, runtimeException);
            }
        }
    }

    protected abstract QualifiedName getBrowseName(ExpandedNodeId var1, UaNode var2);

    protected abstract LocalizedText getDisplayName(ExpandedNodeId var1, UaNode var2, Locale var3);

    protected EventManager getEventManager(NodeId nodeId) {
        return this.km;
    }

    protected boolean getIsOfType(NodeId nodeId, UaType uaType, NodeId nodeId2, UaType uaType2) throws StatusException {
        if (nodeId == null) {
            logger.debug("isOfType: typeDefinitionId == null: return=false");
            return false;
        }
        if (nodeId2 == null) {
            logger.debug("isOfType: expectedTypeId == null: return=false");
            return false;
        }
        if (nodeId.equals(nodeId2)) {
            logger.debug("isOfType: typeDefinitionId equals expectedTypeId: return=true");
            return true;
        }
        if (uaType2 != null && uaType != null) {
            if (uaType.inheritsFrom(uaType2)) {
                logger.debug("isOfType: typeDefinition inherits expectedType: return=true");
                return true;
            }
        } else {
            UaReference[] uaReferenceArray = this.getReferences(nodeId, uaType);
            if (uaReferenceArray != null) {
                for (UaReference uaReference : uaReferenceArray) {
                    if (!uaReference.getIsInverse(nodeId) || !uaReference.getReferenceTypeId().equals(Identifiers.HasSubtype)) continue;
                    try {
                        return this.isOfType(this.getNamespaceTable().toNodeId(uaReference.getSourceId()), uaType, nodeId2, uaType2);
                    }
                    catch (ServiceResultException serviceResultException) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("isOfType: cannot convert SourceId of reference inverse HasSubtype reference ({}) to NodeId: return=false", (Object)uaReference.getSourceId());
                        }
                        return false;
                    }
                }
            }
        }
        logger.debug("isOfType: return=false");
        return false;
    }

    protected NodeClass getNodeClass(ExpandedNodeId expandedNodeId, UaNode uaNode) {
        if (uaNode != null) {
            return this.getNodeClass(uaNode.getNodeId(), uaNode);
        }
        try {
            return this.getNodeClass(this.getNamespaceTable().toNodeId(expandedNodeId), uaNode);
        }
        catch (ServiceResultException serviceResultException) {
            return null;
        }
    }

    protected abstract NodeClass getNodeClass(NodeId var1, UaNode var2);

    protected abstract UaReference[] getReferences(NodeId var1, UaNode var2);

    protected UaReferenceType getReferenceType(NodeId nodeId) throws StatusException {
        UaReferenceType uaReferenceType;
        try {
            NodeClass nodeClass;
            uaReferenceType = (UaReferenceType)this.getNode(nodeId);
            if (uaReferenceType == null && !NodeClass.ReferenceType.equals(nodeClass = this.getNodeClass(nodeId, null))) {
                throw new StatusException(StatusCodes.Bad_ReferenceTypeIdInvalid);
            }
        }
        catch (StatusException statusException) {
            logger.debug("Failed to get the ReferenceType", statusException);
            throw new StatusException(StatusCodes.Bad_ReferenceTypeIdInvalid, (Throwable)statusException);
        }
        catch (ClassCastException classCastException) {
            logger.debug("Failed to get the ReferenceType", classCastException);
            throw new StatusException(StatusCodes.Bad_ReferenceTypeIdInvalid, (Throwable)classCastException);
        }
        return uaReferenceType;
    }

    protected abstract ExpandedNodeId getTypeDefinition(ExpandedNodeId var1, UaNode var2);

    protected void init() throws StatusException, UaNodeFactoryException {
        this.initialized = true;
    }

    protected void modifyMonitoredDataItem(ServiceContext serviceContext, Subscription subscription, MonitoredDataItem monitoredDataItem, MonitoringParameters monitoringParameters, MonitoringFilter monitoringFilter, AggregateFilterResult aggregateFilterResult) throws StatusException {
        UaNode uaNode = this.getNode(monitoredDataItem.getNodeId());
        this.fireModifyMonitoredDataItem(serviceContext, subscription, monitoredDataItem, uaNode, monitoringParameters, monitoringFilter, aggregateFilterResult);
    }

    protected void modifyMonitoredEventItem(ServiceContext serviceContext, Subscription subscription, MonitoredEventItem monitoredEventItem, EventFilter eventFilter, EventFilterResult eventFilterResult) throws StatusException {
        EventManager eventManager = this.getEventManager(monitoredEventItem.getNodeId());
        if (eventManager != null) {
            eventManager.modifyMonitoredEventItem(serviceContext, subscription, monitoredEventItem, eventFilter, eventFilterResult);
        }
    }

    protected void queryFirst(ServiceContext serviceContext, QueryFirstRequest queryFirstRequest, QueryFirstResponse queryFirstResponse) throws ServiceException {
        throw new ServiceException(StatusCodes.Bad_NotImplemented);
    }

    protected void queryNext(ServiceContext serviceContext, QueryNextRequest queryNextRequest, QueryNextResponse queryNextResponse) throws ServiceException {
        throw new ServiceException(StatusCodes.Bad_NotImplemented);
    }

    protected boolean referenceMatchesRequest(UaReference uaReference, BrowseDirection browseDirection, NodeId nodeId, UaReferenceType uaReferenceType, Boolean bl, QualifiedName qualifiedName, NodeId nodeId2) {
        Object object;
        logger.debug("referenceMatchesRequest: n={}", (Object)uaReference);
        logger.debug("referenceMatchesRequest: referenceType={}", (Object)uaReferenceType);
        if (uaReferenceType != null && !uaReferenceType.getNodeId().equals(uaReference.getReferenceTypeId())) {
            try {
                object = this.getReferenceType(uaReference.getReferenceTypeId());
                logger.debug("referenceMatchesRequest: r={}", object);
                if (bl != false ? !object.inheritsFrom(uaReferenceType) : !object.equals(uaReferenceType)) {
                    return false;
                }
            }
            catch (StatusException statusException) {
                return false;
            }
        }
        if (browseDirection == BrowseDirection.Forward && uaReference.getIsInverse(nodeId2)) {
            return false;
        }
        if (browseDirection == BrowseDirection.Inverse && !uaReference.getIsInverse(nodeId2)) {
            return false;
        }
        if (!QualifiedName.isNull(qualifiedName)) {
            NodeManager nodeManager;
            object = browseDirection == BrowseDirection.Forward ? uaReference.getTargetId() : uaReference.getSourceId();
            try {
                nodeManager = this.getNodeManagerTable().getNodeManager((ExpandedNodeId)object);
            }
            catch (StatusException statusException) {
                logger.debug("referenceMatchesRequest: targetNodeManager not found for targetId={}", object);
                return false;
            }
            UaNode uaNode = browseDirection == BrowseDirection.Forward ? uaReference.getTargetNode() : uaReference.getSourceNode();
            QualifiedName qualifiedName2 = nodeManager.getBrowseName((ExpandedNodeId)object, uaNode);
            if (!qualifiedName.equals(qualifiedName2)) {
                return false;
            }
        }
        logger.debug("referenceMatchesRequest: true");
        return true;
    }

    protected NodeId registerNode(ServiceContext serviceContext, NodeId nodeId) throws StatusException {
        this.getNode(nodeId);
        return nodeId;
    }

    protected void start() throws StatusException, UaNodeFactoryException {
        if (!this.initialized) {
            this.init();
        }
        this.started = true;
    }

    protected BrowsePathTarget[] translateBrowsePath(ServiceContext serviceContext, NodeId nodeId, RelativePath relativePath) throws StatusException, ServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug("translateBrowsePath: startingNodeId={}", (Object)nodeId);
            logger.debug("translateBrowsePath: relativePath={}", (Object)relativePath);
        }
        NodeId nodeId2 = nodeId;
        BrowsePathTarget[] browsePathTargetArray = new BrowsePathTarget[]{new BrowsePathTarget()};
        try {
            for (int i2 = 0; i2 < relativePath.getElements().length; ++i2) {
                RelativePathElement relativePathElement = relativePath.getElements()[i2];
                BrowseDirection browseDirection = relativePathElement.getIsInverse() != false ? BrowseDirection.Inverse : BrowseDirection.Forward;
                ArrayList<ReferenceDescription> arrayList = new ArrayList<ReferenceDescription>();
                NodeManager nodeManager = this.getNodeManagerTable().getNodeManager(nodeId2);
                try {
                    nodeManager.browseNode(serviceContext, arrayList, nodeId2, 1000, browseDirection, relativePathElement.getReferenceTypeId(), relativePathElement.getIncludeSubtypes(), relativePathElement.getTargetName(), NodeClass.ALL, EnumSet.of(BrowseResultMask.BrowseName), null, 0);
                }
                catch (StatusException statusException) {
                    if (statusException.getStatusCode().getValue().equals(StatusCodes.Bad_ReferenceTypeIdInvalid)) {
                        throw new StatusException("Reference Type Invalid", StatusCodes.Bad_NoMatch);
                    }
                    throw statusException;
                }
                if (arrayList.size() == 0) {
                    throw new StatusException("Target not found: " + relativePathElement.getTargetName(), StatusCodes.Bad_NoMatch);
                }
                for (ReferenceDescription referenceDescription : arrayList) {
                    if (relativePathElement.getTargetName() != null && !relativePathElement.getTargetName().equals(referenceDescription.getBrowseName())) continue;
                    try {
                        nodeId2 = this.getNamespaceTable().toNodeId(referenceDescription.getNodeId());
                        browsePathTargetArray[0].setTargetId(referenceDescription.getNodeId());
                    }
                    catch (ServiceResultException serviceResultException) {
                        throw new a(i2);
                    }
                }
                browsePathTargetArray[0].setRemainingPathIndex(UnsignedInteger.MAX_VALUE);
            }
        }
        catch (a a2) {
            browsePathTargetArray[0].setRemainingPathIndex(a2.getRemainingPathIndex());
        }
        return browsePathTargetArray;
    }

    protected void unregisterNode(ServiceContext serviceContext, NodeId nodeId) {
    }

    class a
    extends Exception {
        private final UnsignedInteger kq;

        public a(int n2) {
            this.kq = UnsignedInteger.valueOf(n2);
        }

        public UnsignedInteger getRemainingPathIndex() {
            return this.kq;
        }
    }
}

