/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.server;

import com.prosysopc.ua.EventData;
import com.prosysopc.ua.server.FilterOperatorDefinition;
import com.prosysopc.ua.server.NodeManagerRoot;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.ContentFilter;
import com.prosysopc.ua.stack.core.ContentFilterElement;
import com.prosysopc.ua.stack.core.ContentFilterElementResult;
import com.prosysopc.ua.stack.core.ContentFilterResult;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.EventFilterResult;
import com.prosysopc.ua.stack.core.SimpleAttributeOperand;
import com.prosysopc.ua.stack.core.StatusCodes;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContentFilterDefinition {
    private static Logger logger = LoggerFactory.getLogger(ContentFilterDefinition.class);
    private DiagnosticInfo[] iy;
    private ContentFilterElementResult[] iz;
    private FilterOperatorDefinition[] iA;

    public static void parseEventFilter(NodeManagerRoot nodeManagerRoot, EventFilter eventFilter, List<List<QualifiedName>> list, ContentFilterDefinition contentFilterDefinition, EventFilterResult eventFilterResult) {
        list.clear();
        SimpleAttributeOperand[] simpleAttributeOperandArray = eventFilter.getSelectClauses();
        if (simpleAttributeOperandArray != null) {
            for (SimpleAttributeOperand simpleAttributeOperand : simpleAttributeOperandArray) {
                if (simpleAttributeOperand == null) continue;
                Object[] objectArray = simpleAttributeOperand.getBrowsePath();
                logger.debug("BrowsePath={}", (Object)Arrays.toString(objectArray));
                if (simpleAttributeOperand.getAttributeId().equals(Attributes.Value)) {
                    if (objectArray == null) continue;
                    list.add(Arrays.asList(objectArray));
                    continue;
                }
                if (!simpleAttributeOperand.getAttributeId().equals(Attributes.NodeId)) continue;
                list.add(null);
                simpleAttributeOperand.getTypeDefinitionId();
            }
        }
        contentFilterDefinition.parse(eventFilter.getWhereClause(), nodeManagerRoot);
        eventFilterResult.setWhereClauseResult(new ContentFilterResult(contentFilterDefinition.getElementResults(), contentFilterDefinition.getElementDiagnosticInfos()));
    }

    public Boolean evaluate(EventData eventData, Boolean bl) {
        Boolean bl2;
        if (this.iA == null || this.iA.length == 0 || this.iA[0] == null) {
            return true;
        }
        try {
            bl2 = (Boolean)this.iA[0].evaluate(eventData, bl);
        }
        catch (ClassCastException classCastException) {
            bl2 = null;
        }
        logger.debug("evaluate: {}", (Object)bl2);
        return bl2;
    }

    public DiagnosticInfo[] getElementDiagnosticInfos() {
        return this.iy;
    }

    public ContentFilterElementResult[] getElementResults() {
        return this.iz;
    }

    public void parse(ContentFilter contentFilter, NodeManagerRoot nodeManagerRoot) {
        ContentFilterElement[] contentFilterElementArray;
        ContentFilterElement[] contentFilterElementArray2 = contentFilterElementArray = contentFilter == null ? null : contentFilter.getElements();
        if (contentFilterElementArray != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("parse: elements.length={}", (Object)contentFilterElementArray.length);
            }
            this.iA = new FilterOperatorDefinition[contentFilterElementArray.length];
            this.iz = new ContentFilterElementResult[contentFilterElementArray.length];
            this.iy = new DiagnosticInfo[contentFilterElementArray.length];
            for (int i2 = contentFilterElementArray.length - 1; i2 >= 0; --i2) {
                ContentFilterElement contentFilterElement = contentFilterElementArray[i2];
                logger.debug("parse: i={} element={}", (Object)i2, (Object)contentFilterElement);
                if (contentFilterElement == null) continue;
                this.iA[i2] = FilterOperatorDefinition.newOperator(contentFilterElement.getFilterOperator(), contentFilterElement.getFilterOperands(), nodeManagerRoot, this.iA);
                if (this.iA[i2] == null) {
                    this.iz[i2] = new ContentFilterElementResult(StatusCode.valueOf(StatusCodes.Bad_FilterOperatorUnsupported), null, null);
                } else {
                    this.iz[i2] = this.iA[i2].getElementResult();
                    this.iy[i2] = this.iA[i2].getElementDiagnosticInfo();
                }
                if (!logger.isDebugEnabled()) continue;
                logger.debug("parse: i={} operator={}", (Object)i2, (Object)this.iA[i2]);
            }
        }
    }
}

