/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.ApplicationIdentity;
import com.prosysopc.ua.DataTypeConversionException;
import com.prosysopc.ua.MethodCallStatusException;
import com.prosysopc.ua.OperationLimits;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.SessionActivationException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.SubscriptionBase;
import com.prosysopc.ua.UaAddress;
import com.prosysopc.ua.UaApplication;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UserIdentity;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.ClientCodegenModel;
import com.prosysopc.ua.client.ClientCodegenModelProvider;
import com.prosysopc.ua.client.ConnectException;
import com.prosysopc.ua.client.InvalidServerEndpointException;
import com.prosysopc.ua.client.ReconnectState;
import com.prosysopc.ua.client.ReconnectStatus;
import com.prosysopc.ua.client.ServerConnectionException;
import com.prosysopc.ua.client.ServerStatusListener;
import com.prosysopc.ua.client.Subscription;
import com.prosysopc.ua.client.UaClientListener;
import com.prosysopc.ua.client.h;
import com.prosysopc.ua.client.i;
import com.prosysopc.ua.stack.application.Application;
import com.prosysopc.ua.stack.application.Client;
import com.prosysopc.ua.stack.application.Session;
import com.prosysopc.ua.stack.application.SessionChannel;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.ServiceRequest;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ActivateSessionResponse;
import com.prosysopc.ua.stack.core.AggregateConfiguration;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.BuildInfo;
import com.prosysopc.ua.stack.core.CallMethodRequest;
import com.prosysopc.ua.stack.core.CallMethodResult;
import com.prosysopc.ua.stack.core.CallRequest;
import com.prosysopc.ua.stack.core.CallResponse;
import com.prosysopc.ua.stack.core.CreateSubscriptionResponse;
import com.prosysopc.ua.stack.core.DeleteAtTimeDetails;
import com.prosysopc.ua.stack.core.DeleteEventDetails;
import com.prosysopc.ua.stack.core.DeleteRawModifiedDetails;
import com.prosysopc.ua.stack.core.DeleteSubscriptionsResponse;
import com.prosysopc.ua.stack.core.EndpointConfiguration;
import com.prosysopc.ua.stack.core.EndpointDescription;
import com.prosysopc.ua.stack.core.EventFilter;
import com.prosysopc.ua.stack.core.GetEndpointsRequest;
import com.prosysopc.ua.stack.core.GetEndpointsResponse;
import com.prosysopc.ua.stack.core.HistoryData;
import com.prosysopc.ua.stack.core.HistoryEvent;
import com.prosysopc.ua.stack.core.HistoryEventFieldList;
import com.prosysopc.ua.stack.core.HistoryModifiedData;
import com.prosysopc.ua.stack.core.HistoryReadDetails;
import com.prosysopc.ua.stack.core.HistoryReadResponse;
import com.prosysopc.ua.stack.core.HistoryReadResult;
import com.prosysopc.ua.stack.core.HistoryReadValueId;
import com.prosysopc.ua.stack.core.HistoryUpdateDetails;
import com.prosysopc.ua.stack.core.HistoryUpdateResponse;
import com.prosysopc.ua.stack.core.HistoryUpdateResult;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.IssuedIdentityToken;
import com.prosysopc.ua.stack.core.MessageSecurityMode;
import com.prosysopc.ua.stack.core.ModificationInfo;
import com.prosysopc.ua.stack.core.ModifySubscriptionResponse;
import com.prosysopc.ua.stack.core.PerformUpdateType;
import com.prosysopc.ua.stack.core.PublishRequest;
import com.prosysopc.ua.stack.core.PublishResponse;
import com.prosysopc.ua.stack.core.ReadAtTimeDetails;
import com.prosysopc.ua.stack.core.ReadEventDetails;
import com.prosysopc.ua.stack.core.ReadProcessedDetails;
import com.prosysopc.ua.stack.core.ReadRawModifiedDetails;
import com.prosysopc.ua.stack.core.ReadRequest;
import com.prosysopc.ua.stack.core.ReadResponse;
import com.prosysopc.ua.stack.core.ReadValueId;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.ResponseHeader;
import com.prosysopc.ua.stack.core.ServerState;
import com.prosysopc.ua.stack.core.ServerStatusDataType;
import com.prosysopc.ua.stack.core.SetPublishingModeResponse;
import com.prosysopc.ua.stack.core.SignatureData;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.SubscriptionAcknowledgement;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.core.TransferResult;
import com.prosysopc.ua.stack.core.TransferSubscriptionsResponse;
import com.prosysopc.ua.stack.core.UpdateDataDetails;
import com.prosysopc.ua.stack.core.UpdateEventDetails;
import com.prosysopc.ua.stack.core.UpdateStructureDataDetails;
import com.prosysopc.ua.stack.core.UserIdentityToken;
import com.prosysopc.ua.stack.core.UserNameIdentityToken;
import com.prosysopc.ua.stack.core.UserTokenPolicy;
import com.prosysopc.ua.stack.core.UserTokenType;
import com.prosysopc.ua.stack.core.VariableIdentifiers;
import com.prosysopc.ua.stack.core.WriteRequest;
import com.prosysopc.ua.stack.core.WriteResponse;
import com.prosysopc.ua.stack.core.WriteValue;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.stack.transport.ChannelService;
import com.prosysopc.ua.stack.transport.Endpoint;
import com.prosysopc.ua.stack.transport.ResultListener;
import com.prosysopc.ua.stack.transport.ReverseConnectionListener;
import com.prosysopc.ua.stack.transport.ReverseTransportChannelSettings;
import com.prosysopc.ua.stack.transport.SecureChannel;
import com.prosysopc.ua.stack.transport.TransportChannelSettings;
import com.prosysopc.ua.stack.transport.https.HttpsSettings;
import com.prosysopc.ua.stack.transport.impl.AsyncResultImpl;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.HttpsSecurityPolicy;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.transport.tcp.io.TcpConnection;
import com.prosysopc.ua.stack.utils.EndpointUtil;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.NumericRange;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.typedictionary.DynamicStructure;
import com.prosysopc.ua.typedictionary.TypeDictionary;
import com.prosysopc.ua.typedictionary.TypeDictionaryException;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import com.prosysopc.ua.types.gds.client.GdsClientInformationModel;
import com.prosysopc.ua.types.opcua.client.ClientInformationModel;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Timer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaClient
extends UaApplication {
    public static final Double MAX_CACHE_AGE = new Double(2.147483647E9);
    private static UaApplication.Protocol cA = UaApplication.Protocol.OpcTcp;
    private static final Logger logger = LoggerFactory.getLogger(UaClient.class);
    private static Set<StatusCode> gh;
    private static boolean gi;
    private static final Map<UnsignedInteger, Class<?>> gj;
    private BlockingQueue<SubscriptionAcknowledgement> gk = new LinkedBlockingDeque<SubscriptionAcknowledgement>();
    private OperationLimits gl;
    private UaAddress gm = null;
    private AddressSpace addressSpace;
    private ApplicationIdentity applicationIdentity = new ApplicationIdentity();
    private String gn = null;
    private volatile boolean go = true;
    private final AtomicReference<SessionChannel> gp = new AtomicReference<Object>(null);
    private final Client gq = Client.createClientApplication(null);
    private int connectTimeout = 60000;
    private UnsignedInteger gr = UnsignedInteger.valueOf(0L);
    private EndpointDescription[] gs;
    private double gt = 0.0;
    private TimestampsToReturn gu = TimestampsToReturn.Both;
    private EndpointDescription gv;
    private final EndpointConfiguration gw = Endpoint.createDefaultEndpointConfiguration();
    private volatile boolean gx;
    private final HttpsSettings gy = new HttpsSettings();
    private boolean gz;
    private final AtomicReference<DiagnosticInfo[]> gA = new AtomicReference<Object>(null);
    private final AtomicLong gB = new AtomicLong();
    private final AtomicReference<ResponseHeader> gC = new AtomicReference<Object>(null);
    private final SessionChannel.RequestValidator gD = new SessionChannel.RequestValidator(){

        @Override
        public <T extends ServiceResponse> void validateServiceRequest(SessionChannel sessionChannel, ServiceRequest<T> serviceRequest) throws ServiceResultException {
            UaClient.this.validateServiceRequest(serviceRequest);
        }
    };
    private UaClientListener gE = null;
    private Locale locale = Locale.getDefault(Locale.Category.DISPLAY);
    private UnsignedInteger gF = UnsignedInteger.ZERO;
    private boolean gG;
    private EnumSet<UaApplication.DiagnosticMask> gH = EnumSet.noneOf(UaApplication.DiagnosticMask.class);
    private volatile double gI = 2.0;
    private final AtomicInteger gJ = new AtomicInteger(0);
    private UnsignedInteger gK = UnsignedInteger.MAX_VALUE;
    volatile f gL;
    private volatile Thread gM;
    private Timer gN;
    private SecureChannel gO;
    private SecurityMode gP = SecurityMode.BASIC128RSA15_SIGN_ENCRYPT;
    private ApplicationIdentity gQ = new ApplicationIdentity();
    private final AtomicReference<e> gR = new AtomicReference();
    private final List<ServerStatusListener> gS = new CopyOnWriteArrayList<ServerStatusListener>();
    private final AtomicBoolean gT = new AtomicBoolean(false);
    private boolean gU;
    private final AtomicLong gV = new AtomicLong(0L);
    private EnumSet<UaApplication.DiagnosticMask> gW = EnumSet.noneOf(UaApplication.DiagnosticMask.class);
    private volatile Session gX;
    private String gY;
    private Double gZ = 3600000.0;
    private long ha;
    private long hb = 1000L;
    private long hc = 10000L;
    private UnsignedInteger hd = null;
    private UserIdentity cw = new UserIdentity();
    private boolean he = true;
    private boolean hf = true;
    private TypeDictionary hg = new TypeDictionary(this);
    final List<Subscription> hh = new CopyOnWriteArrayList<Subscription>();
    private ReverseConnectionListener hi = null;
    private UaAddress hj = null;
    private boolean hk = true;
    private boolean hl = true;
    private TcpConnection.SocketFactory hm;

    public static Set<StatusCode> getCommErrorCodes() {
        return gh;
    }

    public static UaApplication.Protocol getDefaultProtocol() {
        return cA;
    }

    public static boolean isUseCommErrorCodes() {
        return gi;
    }

    public static void setDefaultProtocol(UaApplication.Protocol protocol) {
        cA = protocol;
    }

    public static void setUseCommErrorCodes(boolean bl) {
        gi = bl;
    }

    private static void a(UnsignedInteger unsignedInteger, Class<?> clazz) {
        Class<?> clazz2 = gj.put(unsignedInteger, clazz);
        if (clazz2 != null) {
            throw new Error("Duplication mapping for AttributeId " + unsignedInteger + " existing: " + clazz2 + ", new:" + clazz);
        }
    }

    public UaClient() {
    }

    public UaClient(String string) {
        this();
        this.setAddress(string);
    }

    public UaClient(UaAddress uaAddress) {
        this.setAddress(uaAddress);
    }

    public void addServerStatusListener(ServerStatusListener serverStatusListener) {
        if (!this.hasServerStatusListener(serverStatusListener)) {
            this.gS.add(serverStatusListener);
        }
    }

    public Subscription addSubscription(Subscription subscription) throws ServiceException, StatusException {
        logger.debug("addSubscription ID was:{}", (Object)subscription.getSubscriptionId());
        if (subscription.getClient() != null) {
            subscription.transferTo(this);
        } else {
            subscription.setClient(this);
            if (!this.hh.contains(subscription)) {
                this.hh.add(subscription);
            }
            if (this.isConnected()) {
                this.a(subscription, false);
            }
        }
        logger.debug("addSubscription: added subscription={}", (Object)subscription);
        this.coV();
        return subscription;
    }

    public CallResponse call(CallMethodRequest ... callMethodRequestArray) throws ServiceException {
        try {
            CallResponse callResponse = this.cnY().Call(this.getRequestHeader(), callMethodRequestArray);
            this.checkServiceResult(callResponse, callResponse.getDiagnosticInfos());
            return callResponse;
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    public Variant[] call(NodeId nodeId, NodeId nodeId2, Variant ... variantArray) throws ServiceException, MethodCallStatusException {
        CallMethodRequest callMethodRequest = new CallMethodRequest(nodeId, nodeId2, Variant.asObjectArray(variantArray));
        CallResponse callResponse = this.call(callMethodRequest);
        CallMethodResult callMethodResult = callResponse.getResults()[0];
        DiagnosticInfo[] diagnosticInfoArray = callResponse.getDiagnosticInfos();
        this.a(callMethodResult, diagnosticInfoArray == null || diagnosticInfoArray.length == 0 ? null : diagnosticInfoArray[0]);
        return Variant.asVariantArray(callMethodResult.getOutputArguments());
    }

    public AsyncResult<CallResponse> callAsync(CallMethodRequest ... callMethodRequestArray) {
        try {
            return this.cnY().CallAsync(new CallRequest(this.getRequestHeader(), callMethodRequestArray));
        }
        catch (ServerConnectionException serverConnectionException) {
            return AsyncResultImpl.failed(new ServiceResultException(StatusCodes.Bad_ServerNotConnected, (Throwable)serverConnectionException));
        }
    }

    public synchronized void connect() throws ServiceException, ConnectException, SessionActivationException, InvalidServerEndpointException {
        logger.debug("connect");
        if (this.gM != null) {
            if (this.go) {
                logger.warn("connect() should not be called after obtaining the initial connection. AutoReconnect is true, SDK is handling all reconnections.");
            } else {
                logger.warn("connect() should not be called after obtaining the initial connection. AutoReconnect is false, call reconnect() in a loop instead for making manual reconnection attempts.");
            }
        }
        if (!this.isConnected()) {
            try {
                this.coO();
                this.cpd();
                if (this.gv == null) {
                    this.coP();
                }
                this.coO();
                this.coN();
                this.coR();
                this.coD();
                this.coE();
                this.cox();
                DataValue dataValue = this.coQ();
                try {
                    logger.debug("NamespaceTable: {}", (Object)this.a(true, dataValue));
                }
                catch (StatusException statusException) {
                    logger.error("Cannot Read NamespaceArray from the server", statusException);
                }
                this.coS();
                this.coB();
                this.startPublishing();
            }
            catch (ServiceException serviceException) {
                this.disconnect();
                throw serviceException;
            }
            catch (RuntimeException runtimeException) {
                this.disconnect();
                throw runtimeException;
            }
        }
    }

    public void disconnect() {
        this.disconnect(60000L);
    }

    public void disconnect(long l2) {
        this.disconnect(UnsignedInteger.valueOf(l2));
    }

    public void disconnect(long l2, TimeUnit timeUnit) {
        this.disconnect(timeUnit.toMillis(l2));
    }

    public synchronized void disconnect(UnsignedInteger unsignedInteger) {
        this.stopPublishing();
        this.f(unsignedInteger);
        this.coz();
    }

    public EndpointDescription[] discoverEndpoints() throws InvalidServerEndpointException, ConnectException, ServiceException {
        return this.discoverEndpoints(this.coI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EndpointDescription[] discoverEndpoints(UaApplication.Protocol ... protocolArray) throws InvalidServerEndpointException, ConnectException, ServiceException {
        SecureChannel secureChannel;
        Object object;
        String string;
        this.coO();
        Client client = this.gq != null ? this.gq : Client.createClientApplication(null);
        String string2 = string = this.gm == null ? null : this.gm.getAddress();
        if (logger.isDebugEnabled()) {
            logger.debug("discoverEndpoints: connectUri=" + string + " protocols=" + Arrays.toString((Object[])protocolArray));
        }
        EndpointDescription endpointDescription = new EndpointDescription();
        endpointDescription.setEndpointUrl(string);
        endpointDescription.setSecurityMode(MessageSecurityMode.None);
        endpointDescription.setSecurityPolicyUri(SecurityPolicy.NONE.getPolicyUri());
        if (this.isInReverseMode()) {
            object = new ReverseTransportChannelSettings();
            ((ReverseTransportChannelSettings)object).setReverseConnectionListener(this.hi);
            ((TransportChannelSettings)object).setDescription(endpointDescription);
            ((TransportChannelSettings)object).setOpctcpSettings(null);
            secureChannel = client.createReverseSecureChannel(this.hj.getAddress(), (ReverseTransportChannelSettings)object);
            if (string == null) {
                string = endpointDescription.getEndpointUrl();
            }
        } else {
            object = new TransportChannelSettings();
            ((TransportChannelSettings)object).setDescription(endpointDescription);
            ((TransportChannelSettings)object).setOpctcpSettings(null);
            secureChannel = client.createSecureChannel(string, (TransportChannelSettings)object);
        }
        object = new ChannelService(secureChannel);
        try {
            EndpointDescription[] endpointDescriptionArray = this.a((ChannelService)object, string, protocolArray);
            if (endpointDescriptionArray == null || endpointDescriptionArray.length == 0) {
                endpointDescriptionArray = this.a((ChannelService)object, null, new UaApplication.Protocol[0]);
            }
            EndpointDescription[] endpointDescriptionArray2 = endpointDescriptionArray;
            secureChannel.close();
            secureChannel.dispose();
            return endpointDescriptionArray2;
        }
        catch (Throwable throwable) {
            try {
                secureChannel.close();
                secureChannel.dispose();
                throw throwable;
            }
            catch (ServiceResultException serviceResultException) {
                logger.debug("Connection failed", serviceResultException);
                if (serviceResultException.getStatusCode().getValue().equals(StatusCodes.Bad_ServerUriInvalid)) {
                    throw new InvalidServerEndpointException("Server URI invalid", this.coL(), null, serviceResultException);
                }
                throw new ConnectException("Failed to retrieve endpoints. The server is not available", this.coL(), null, serviceResultException);
            }
        }
    }

    public OperationLimits getActualOperationLimits() {
        return this.gl != null ? this.gl : this.getOperationLimits();
    }

    public int getActualPublishRequestSetpoint() {
        int n2 = this.gJ.get();
        if (n2 > 0) {
            return n2;
        }
        return (int)Math.ceil((double)this.hh.size() * this.getPublishRequestFactor());
    }

    public UaAddress getAddress() {
        return this.gm;
    }

    @Override
    public AddressSpace getAddressSpace() {
        if (this.addressSpace == null) {
            this.addressSpace = new AddressSpace(this);
        }
        return this.addressSpace;
    }

    @Override
    public ApplicationIdentity getApplicationIdentity() {
        return this.applicationIdentity;
    }

    public String getAuditEntryId() {
        return this.gn;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public double getDefaultMaxAge() {
        return this.gt;
    }

    public TimestampsToReturn getDefaultTimestampsToReturn() {
        return this.gu;
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.gq.getEncoderContext();
    }

    public EndpointDescription getEndpoint() {
        return this.gv;
    }

    public EndpointConfiguration getEndpointConfiguration() {
        return this.gw;
    }

    @Deprecated
    public String getHost() {
        return this.coH();
    }

    public HttpsSettings getHttpsSettings() {
        if (this.gq != null) {
            return this.gq.getApplicationHttpsSettings();
        }
        return this.gy;
    }

    public DiagnosticInfo[] getLastOperationDiagnostics() {
        return this.gA.get();
    }

    public DateTime getLastResponseTimestamp() {
        return this.gC.get().getTimestamp();
    }

    public DiagnosticInfo getLastServiceDiagnostics() {
        return this.gC.get().getServiceDiagnostics();
    }

    public StatusCode getLastServiceResult() {
        return this.gC.get().getServiceResult();
    }

    public UaClientListener getListener() {
        return this.gE;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public UnsignedInteger getMaxResponseMessageSize() {
        return this.gF;
    }

    @Override
    public NamespaceTable getNamespaceTable() {
        if (!this.gG) {
            try {
                this.b((DataValue)null);
            }
            catch (Exception exception) {
                logger.error("Could not get namespace table from server", exception);
            }
        }
        return super.getNamespaceTable();
    }

    public NamespaceTable getNamespaceTable(boolean bl) throws ServiceException, StatusException {
        if (!this.gG || bl) {
            this.b((DataValue)null);
        }
        return this.getNamespaceTable();
    }

    public EnumSet<UaApplication.DiagnosticMask> getOperationDiagnosticMask() {
        return this.gH;
    }

    @Deprecated
    public int getPort() {
        if (this.gm == null) {
            return 0;
        }
        return this.gm.getPort();
    }

    @Deprecated
    public UaApplication.Protocol getProtocol() {
        return this.coI();
    }

    public double getPublishRequestFactor() {
        return this.gI;
    }

    public int getPublishRequestSetpoint() {
        return this.gJ.get();
    }

    public UnsignedInteger getPublishRequestTimeout() {
        return this.gK;
    }

    public UaAddress getReverseAddress() {
        return this.hj;
    }

    public ReverseConnectionListener getReverseConnectionListener() {
        return this.hi;
    }

    public SecureChannel getSecureChannel() throws ServerConnectionException {
        return this.cnY().getSecureChannel();
    }

    public SecurityMode getSecurityMode() {
        return this.gP;
    }

    public ApplicationIdentity getServerIdentity() {
        return this.gQ;
    }

    @Deprecated
    public String getServerName() {
        if (this.gm == null) {
            return "";
        }
        return this.gm.getServerName();
    }

    public ServerState getServerState() {
        Optional<e> optional = Optional.ofNullable(this.gR.get());
        ServerStatusDataType serverStatusDataType = optional.map(e2 -> e2.hx).orElse(null);
        StatusCode statusCode = optional.map(e2 -> e2.hy).orElse(null);
        return serverStatusDataType != null ? serverStatusDataType.getState() : (statusCode == null || statusCode.equals(StatusCode.BAD) ? ServerState.Unknown : ServerState.CommunicationFault);
    }

    public ServerStatusDataType getServerStatus() throws StatusException, ServerConnectionException {
        if (!this.isConnected()) {
            throw new ServerConnectionException("Not connected to server", this.coL(), this.gP);
        }
        StatusCode statusCode = this.coJ();
        if (statusCode != null && statusCode.isBad()) {
            throw new StatusException("ServerStatus not available", statusCode);
        }
        if (this.hb > 0L) {
            int n2 = 0;
            try {
                while (this.coK() == null && this.isConnected() && n2++ < 10) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.coK();
    }

    public StatusCode getServerStatusError() {
        return this.coJ();
    }

    @Override
    public ServerTable getServerTable() {
        if (!this.gU) {
            try {
                this.coY();
            }
            catch (Exception exception) {
                logger.error("Could not get server table from server", exception);
            }
        }
        return this.getEncoderContext().getServerTable();
    }

    public ServerTable getServerTable(boolean bl) throws ServiceException, StatusException {
        if (!this.gU || bl) {
            this.coY();
        }
        return this.getEncoderContext().getServerTable();
    }

    public long getServerTimeDifference() {
        return this.gV.get();
    }

    public EnumSet<UaApplication.DiagnosticMask> getServiceDiagnosticMask() {
        return this.gW;
    }

    public Session getSession() {
        SessionChannel sessionChannel = this.gp.get();
        logger.trace("getSession: sessionChannel={}", (Object)sessionChannel);
        if (sessionChannel == null) {
            return null;
        }
        return sessionChannel.getSession();
    }

    public String getSessionName() {
        return this.gY;
    }

    public double getSessionTimeout() {
        return this.gZ;
    }

    public TcpConnection.SocketFactory getSocketFactory() {
        return this.hm;
    }

    public long getStatusCheckInterval() {
        return this.hb;
    }

    public long getStatusCheckTimeout() {
        return this.hc;
    }

    public Subscription getSubscription(int n2) {
        return this.hh.get(n2);
    }

    public Subscription getSubscriptionById(UnsignedInteger unsignedInteger) {
        if (unsignedInteger != null) {
            for (Subscription subscription : this.hh) {
                if (!unsignedInteger.equals(subscription.getSubscriptionId())) continue;
                return subscription;
            }
        }
        return null;
    }

    public int getSubscriptionCount() {
        return this.hh.size();
    }

    public Subscription[] getSubscriptions() {
        return this.hh.toArray(new Subscription[this.hh.size()]);
    }

    public List<SecurityMode> getSupportedSecurityModes() throws InvalidServerEndpointException, ServerConnectionException, ServiceException {
        EndpointDescription[] endpointDescriptionArray = this.discoverEndpoints();
        ArrayList<SecurityMode> arrayList = new ArrayList<SecurityMode>();
        for (EndpointDescription endpointDescription : endpointDescriptionArray) {
            try {
                SecurityMode securityMode = new SecurityMode(SecurityPolicy.getSecurityPolicy(endpointDescription.getSecurityPolicyUri()), endpointDescription.getSecurityMode());
                if (arrayList.contains(securityMode)) continue;
                arrayList.add(securityMode);
            }
            catch (ServiceResultException serviceResultException) {
                logger.info("Unknown security policy supported by the server.", serviceResultException);
            }
        }
        return arrayList;
    }

    public UserTokenPolicy[] getSupportedUserIdentityTokens() throws ServerConnectionException, ServiceException {
        EndpointDescription endpointDescription = this.gv;
        try {
            if (this.gv == null) {
                this.coP();
            }
            UserTokenPolicy[] userTokenPolicyArray = this.gv.getUserIdentityTokens();
            return userTokenPolicyArray;
        }
        finally {
            this.gv = endpointDescription;
        }
    }

    public int getTimeout() {
        if (this.hd == null) {
            return -1;
        }
        return this.hd.intValue();
    }

    public TypeDictionary getTypeDictionary() {
        return this.hg;
    }

    @Deprecated
    public String getUri() {
        return this.coL();
    }

    public UserIdentity getUserIdentity() {
        return this.cw;
    }

    public boolean hasServerStatusListener(ServerStatusListener serverStatusListener) {
        if (serverStatusListener == null) {
            throw new NullPointerException("null listener not allowed");
        }
        return this.gS.contains(serverStatusListener);
    }

    public boolean hasSubscription(UnsignedInteger unsignedInteger) {
        return this.getSubscriptionById(unsignedInteger) != null;
    }

    public HistoryUpdateResult historyDeleteAtTimes(NodeId nodeId, DateTime[] dateTimeArray) throws StatusException, ServerConnectionException, ServiceException {
        DeleteAtTimeDetails deleteAtTimeDetails = new DeleteAtTimeDetails(nodeId, dateTimeArray);
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(deleteAtTimeDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryUpdateResult historyDeleteEvents(NodeId nodeId, List<ByteString> list) throws StatusException, ServerConnectionException, ServiceException {
        DeleteEventDetails deleteEventDetails = new DeleteEventDetails(nodeId, list.toArray(new ByteString[list.size()]));
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(deleteEventDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryUpdateResult historyDeleteModified(NodeId nodeId, DateTime dateTime, DateTime dateTime2) throws StatusException, ServerConnectionException, ServiceException {
        DeleteRawModifiedDetails deleteRawModifiedDetails = new DeleteRawModifiedDetails(nodeId, true, dateTime, dateTime2);
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(deleteRawModifiedDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryUpdateResult historyDeleteRaw(NodeId nodeId, DateTime dateTime, DateTime dateTime2) throws StatusException, ServerConnectionException, ServiceException {
        DeleteRawModifiedDetails deleteRawModifiedDetails = new DeleteRawModifiedDetails(nodeId, false, dateTime, dateTime2);
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(deleteRawModifiedDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryReadResult[] historyRead(HistoryReadDetails historyReadDetails, TimestampsToReturn timestampsToReturn, Boolean bl, HistoryReadValueId ... historyReadValueIdArray) throws ServerConnectionException, ServiceException {
        if (historyReadDetails == null) {
            throw new NullPointerException("details");
        }
        if (historyReadValueIdArray == null) {
            throw new NullPointerException("nodesToRead");
        }
        try {
            HistoryReadResponse historyReadResponse = this.cnY().HistoryRead(this.getRequestHeader(), historyReadDetails, timestampsToReturn, bl, historyReadValueIdArray);
            this.checkServiceResult(historyReadResponse, historyReadResponse.getDiagnosticInfos());
            this.a(historyReadResponse.getResults(), historyReadValueIdArray);
            return historyReadResponse.getResults();
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (EncodingException encodingException) {
            throw new IllegalArgumentException(encodingException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    public AsyncResult<HistoryReadResponse> historyReadAsync(HistoryReadDetails historyReadDetails, TimestampsToReturn timestampsToReturn, Boolean bl, HistoryReadValueId ... historyReadValueIdArray) {
        if (historyReadDetails == null) {
            throw new NullPointerException("details");
        }
        if (historyReadValueIdArray == null) {
            throw new NullPointerException("nodesToRead");
        }
        try {
            return this.cnY().HistoryReadAsync(this.getRequestHeader(), historyReadDetails, timestampsToReturn, bl, historyReadValueIdArray);
        }
        catch (ServerConnectionException serverConnectionException) {
            return AsyncResultImpl.failed(new ServiceResultException(StatusCodes.Bad_ServerNotConnected, (Throwable)serverConnectionException));
        }
    }

    public DataValue[] historyReadAtTimes(NodeId nodeId, DateTime[] dateTimeArray, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws StatusException, ServerConnectionException, ServiceException, DecodingException {
        return this.historyReadAtTimes(nodeId, dateTimeArray, numericRange, timestampsToReturn, (Boolean)false);
    }

    public DataValue[] historyReadAtTimes(NodeId nodeId, DateTime[] dateTimeArray, NumericRange numericRange, TimestampsToReturn timestampsToReturn, Boolean bl) throws StatusException, ServerConnectionException, ServiceException, DecodingException {
        ReadAtTimeDetails readAtTimeDetails = new ReadAtTimeDetails(dateTimeArray, bl);
        return this.a(nodeId, numericRange, timestampsToReturn, (HistoryReadDetails)readAtTimeDetails);
    }

    public HistoryReadResult[] historyReadAtTimes(NodeId[] nodeIdArray2, DateTime[] dateTimeArray, NumericRange numericRange, TimestampsToReturn timestampsToReturn, Boolean bl) throws ServerConnectionException, ServiceException, DecodingException, EncodingException {
        ReadAtTimeDetails readAtTimeDetails = new ReadAtTimeDetails(dateTimeArray, bl);
        return this.a(nodeIdArray2, this.getActualOperationLimits().getMaxNodesHistoryReadData().intValue(), (NodeId[] nodeIdArray) -> this.a(nodeIdArray, numericRange, timestampsToReturn, readAtTimeDetails));
    }

    public HistoryEventFieldList[] historyReadEvents(NodeId nodeId, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, EventFilter eventFilter, TimestampsToReturn timestampsToReturn) throws StatusException, ServerConnectionException, ServiceException, DecodingException {
        ReadEventDetails readEventDetails = new ReadEventDetails(unsignedInteger, dateTime, dateTime2, eventFilter);
        return this.b(nodeId, null, timestampsToReturn, (HistoryReadDetails)readEventDetails);
    }

    public HistoryReadResult[] historyReadEvents(NodeId[] nodeIdArray2, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, EventFilter eventFilter, TimestampsToReturn timestampsToReturn) throws ServerConnectionException, ServiceException, DecodingException, EncodingException {
        ReadEventDetails readEventDetails = new ReadEventDetails(unsignedInteger, dateTime, dateTime2, eventFilter);
        return this.a(nodeIdArray2, this.getActualOperationLimits().getMaxNodesHistoryReadEvents().intValue(), (NodeId[] nodeIdArray) -> this.b(nodeIdArray, null, timestampsToReturn, readEventDetails));
    }

    public HistoryModifiedData historyReadModified(NodeId nodeId, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws StatusException, ServerConnectionException, ServiceException, DecodingException {
        ReadRawModifiedDetails readRawModifiedDetails = new ReadRawModifiedDetails(true, dateTime, dateTime2, unsignedInteger, false);
        return this.c(nodeId, numericRange, timestampsToReturn, (HistoryReadDetails)readRawModifiedDetails);
    }

    public HistoryReadResult[] historyReadModified(NodeId[] nodeIdArray2, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws ServerConnectionException, ServiceException, DecodingException, EncodingException {
        ReadRawModifiedDetails readRawModifiedDetails = new ReadRawModifiedDetails(true, dateTime, dateTime2, unsignedInteger, false);
        return this.a(nodeIdArray2, this.getActualOperationLimits().getMaxNodesHistoryReadData().intValue(), (NodeId[] nodeIdArray) -> this.c(nodeIdArray, numericRange, timestampsToReturn, readRawModifiedDetails));
    }

    public DataValue[] historyReadProcessed(NodeId nodeId, DateTime dateTime, DateTime dateTime2, Double d2, NodeId nodeId2, AggregateConfiguration aggregateConfiguration, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws ServerConnectionException, ServiceException, DecodingException, StatusException {
        ReadProcessedDetails readProcessedDetails = new ReadProcessedDetails(dateTime, dateTime2, d2, new NodeId[]{nodeId2}, aggregateConfiguration);
        return this.a(nodeId, numericRange, timestampsToReturn, (HistoryReadDetails)readProcessedDetails);
    }

    public HistoryReadResult[] historyReadProcessed(NodeId[] nodeIdArray2, DateTime dateTime, DateTime dateTime2, Double d2, NodeId nodeId, AggregateConfiguration aggregateConfiguration, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws ServerConnectionException, ServiceException, DecodingException, EncodingException {
        ReadProcessedDetails readProcessedDetails = new ReadProcessedDetails(dateTime, dateTime2, d2, new NodeId[]{nodeId}, aggregateConfiguration);
        return this.a(nodeIdArray2, this.getActualOperationLimits().getMaxNodesHistoryReadData().intValue(), (NodeId[] nodeIdArray) -> this.a(nodeIdArray, numericRange, timestampsToReturn, readProcessedDetails));
    }

    public DataValue[] historyReadRaw(NodeId nodeId, DateTime dateTime, DateTime dateTime2, long l2, Boolean bl, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws ServerConnectionException, DecodingException, ServiceException, StatusException {
        return this.historyReadRaw(nodeId, dateTime, dateTime2, UnsignedInteger.valueOf(l2), bl, numericRange, timestampsToReturn);
    }

    public DataValue[] historyReadRaw(NodeId nodeId, DateTime dateTime, DateTime dateTime2, UnsignedInteger unsignedInteger, Boolean bl, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws ServerConnectionException, ServiceException, DecodingException, StatusException {
        ReadRawModifiedDetails readRawModifiedDetails = new ReadRawModifiedDetails(false, dateTime, dateTime2, unsignedInteger, bl);
        return this.a(nodeId, numericRange, timestampsToReturn, (HistoryReadDetails)readRawModifiedDetails);
    }

    public HistoryReadResult[] historyReadRaw(NodeId[] nodeIdArray2, DateTime dateTime, DateTime dateTime2, long l2, Boolean bl, NumericRange numericRange, TimestampsToReturn timestampsToReturn) throws ServerConnectionException, ServiceException, DecodingException, EncodingException {
        ReadRawModifiedDetails readRawModifiedDetails = new ReadRawModifiedDetails(false, dateTime, dateTime2, UnsignedInteger.valueOf(l2), bl);
        return this.a(nodeIdArray2, this.getActualOperationLimits().getMaxNodesHistoryReadData().intValue(), (NodeId[] nodeIdArray) -> this.a(nodeIdArray, numericRange, timestampsToReturn, readRawModifiedDetails));
    }

    public HistoryUpdateResult[] historyUpdate(HistoryUpdateDetails ... historyUpdateDetailsArray) throws ServerConnectionException, ServiceException {
        if (historyUpdateDetailsArray == null) {
            throw new NullPointerException("details");
        }
        try {
            HistoryUpdateResponse historyUpdateResponse = this.cnY().HistoryUpdate(this.getRequestHeader(), historyUpdateDetailsArray);
            this.checkServiceResult(historyUpdateResponse, historyUpdateResponse.getDiagnosticInfos());
            this.a(historyUpdateResponse.getResults(), historyUpdateDetailsArray);
            return historyUpdateResponse.getResults();
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (EncodingException encodingException) {
            throw new IllegalArgumentException(encodingException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    public AsyncResult<HistoryUpdateResponse> historyUpdateAsync(HistoryUpdateDetails ... historyUpdateDetailsArray) throws ServerConnectionException {
        if (historyUpdateDetailsArray == null) {
            throw new NullPointerException("details");
        }
        return this.cnY().HistoryUpdateAsync(this.getRequestHeader(), historyUpdateDetailsArray);
    }

    public HistoryUpdateResult historyUpdateData(NodeId nodeId, PerformUpdateType performUpdateType, DataValue[] dataValueArray) throws StatusException, ServerConnectionException, ServiceException {
        UpdateDataDetails updateDataDetails = new UpdateDataDetails(nodeId, performUpdateType, dataValueArray);
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(updateDataDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryUpdateResult historyUpdateEvent(NodeId nodeId, PerformUpdateType performUpdateType, EventFilter eventFilter, HistoryEventFieldList[] historyEventFieldListArray) throws StatusException, ServerConnectionException, ServiceException {
        UpdateEventDetails updateEventDetails = new UpdateEventDetails(nodeId, performUpdateType, eventFilter, historyEventFieldListArray);
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(updateEventDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public HistoryUpdateResult historyUpdateStructureData(NodeId nodeId, PerformUpdateType performUpdateType, DataValue[] dataValueArray) throws StatusException, ServerConnectionException, ServiceException {
        UpdateStructureDataDetails updateStructureDataDetails = new UpdateStructureDataDetails(nodeId, performUpdateType, dataValueArray);
        HistoryUpdateResult[] historyUpdateResultArray = this.historyUpdate(updateStructureDataDetails);
        this.checkOperationResult(historyUpdateResultArray[0].getStatusCode());
        return historyUpdateResultArray[0];
    }

    public boolean isAutoReconnect() {
        return this.go;
    }

    public boolean isConnected() {
        return this.getSession() != null;
    }

    public boolean isInitTypeDictionaryAutoUsage() {
        return this.hl;
    }

    public boolean isInitTypeDictionaryOnConnect() {
        return this.hk;
    }

    public boolean isInReverseMode() {
        return this.hj != null;
    }

    public boolean isKeepSubscriptions() {
        return this.gz;
    }

    public boolean isValidateCreateSessionResponseCert() {
        return this.hf;
    }

    public boolean isValidateDiscoveredEndpoints() {
        return this.he;
    }

    public ReadResponse read(Double d2, TimestampsToReturn timestampsToReturn, ReadValueId ... readValueIdArray) throws ServiceException {
        int n2 = 0;
        if (readValueIdArray.length > 1 && this.getActualOperationLimits() != null) {
            try {
                n2 = this.getActualOperationLimits().getMaxNodesPerRead().intValue();
            }
            catch (Exception exception) {
                logger.debug("read: Failed to get operationLimits.MaxNodesPerRead: ", exception);
            }
        }
        if (n2 > 0 && n2 < readValueIdArray.length) {
            ResponseHeader responseHeader = null;
            DataValue[] dataValueArray = new DataValue[readValueIdArray.length];
            DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[readValueIdArray.length];
            for (int i2 = 0; i2 < readValueIdArray.length; i2 += n2) {
                int n3 = Math.min(n2, readValueIdArray.length - i2);
                ReadValueId[] readValueIdArray2 = Arrays.copyOfRange(readValueIdArray, i2, i2 + n3);
                ReadResponse readResponse = this.a(d2, timestampsToReturn, readValueIdArray2);
                responseHeader = readResponse.getResponseHeader();
                for (int i3 = 0; i3 < n3; ++i3) {
                    dataValueArray[i2 + i3] = readResponse.getResults()[i3];
                }
                DiagnosticInfo[] diagnosticInfoArray2 = readResponse.getDiagnosticInfos();
                if (diagnosticInfoArray2 == null) continue;
                for (int i4 = 0; i4 < n3 && i4 < diagnosticInfoArray2.length; ++i4) {
                    diagnosticInfoArray[i2 + i4] = diagnosticInfoArray2[i4];
                }
            }
            return new ReadResponse(responseHeader, dataValueArray, diagnosticInfoArray);
        }
        return this.a(d2, timestampsToReturn, readValueIdArray);
    }

    public AsyncResult<ReadResponse> readAsync(Double d2, TimestampsToReturn timestampsToReturn, ReadValueId ... readValueIdArray) {
        ReadRequest readRequest = new ReadRequest(this.getRequestHeader(), new Double(d2), timestampsToReturn, readValueIdArray);
        try {
            return this.cnY().ReadAsync(readRequest);
        }
        catch (ServerConnectionException serverConnectionException) {
            return AsyncResultImpl.failed(new ServiceResultException(StatusCodes.Bad_ServerNotConnected, (Throwable)serverConnectionException));
        }
    }

    public DataValue readAttribute(ExpandedNodeId expandedNodeId, UnsignedInteger unsignedInteger) throws ServiceException, StatusException {
        return this.readAttribute(this.toNodeId(expandedNodeId), unsignedInteger);
    }

    public DataValue readAttribute(ExpandedNodeId expandedNodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, Double d2) throws ServiceException, StatusException {
        return this.readAttribute(this.toNodeId(expandedNodeId), unsignedInteger, numericRange, d2);
    }

    public DataValue readAttribute(NodeId nodeId, UnsignedInteger unsignedInteger) throws ServiceException, StatusException {
        UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[]{unsignedInteger};
        DataValue dataValue = this.readAttributes(nodeId, unsignedIntegerArray)[0];
        this.checkOperationResult(dataValue.getStatusCode());
        return dataValue;
    }

    public DataValue readAttribute(NodeId nodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, Double d2) throws ServiceException, StatusException {
        NumericRange[] numericRangeArray;
        UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[]{unsignedInteger};
        if (numericRange == null) {
            numericRangeArray = null;
        } else {
            NumericRange[] numericRangeArray2 = new NumericRange[1];
            numericRangeArray = numericRangeArray2;
            numericRangeArray2[0] = numericRange;
        }
        NumericRange[] numericRangeArray3 = numericRangeArray;
        DataValue dataValue = this.readAttributes(nodeId, unsignedIntegerArray, numericRangeArray3, d2)[0];
        this.checkOperationResult(dataValue.getStatusCode());
        return dataValue;
    }

    public DataValue readAttribute(UaNodeId uaNodeId, UnsignedInteger unsignedInteger) throws ServiceException, StatusException {
        return this.readAttribute(this.e(uaNodeId), unsignedInteger);
    }

    public DataValue readAttribute(UaNodeId uaNodeId, UnsignedInteger unsignedInteger, NumericRange numericRange, Double d2) throws ServiceException, StatusException {
        return this.readAttribute(this.e(uaNodeId), unsignedInteger, numericRange, d2);
    }

    public DataValue[] readAttributes(ExpandedNodeId expandedNodeId, UnsignedInteger ... unsignedIntegerArray) throws ServiceException, StatusException {
        return this.readAttributes(this.toNodeId(expandedNodeId), unsignedIntegerArray);
    }

    public DataValue[] readAttributes(ExpandedNodeId expandedNodeId, UnsignedInteger[] unsignedIntegerArray, NumericRange[] numericRangeArray, Double d2) throws ServiceException, StatusException {
        return this.readAttributes(this.toNodeId(expandedNodeId), unsignedIntegerArray, numericRangeArray, d2);
    }

    public DataValue[] readAttributes(NodeId nodeId, UnsignedInteger ... unsignedIntegerArray) throws ServiceException {
        return this.readAttributes(nodeId, unsignedIntegerArray, null, (Double)this.getDefaultMaxAge());
    }

    public DataValue[] readAttributes(NodeId nodeId, UnsignedInteger[] unsignedIntegerArray, NumericRange[] numericRangeArray, Double d2) throws ServiceException {
        ReadValueId[] readValueIdArray = new ReadValueId[unsignedIntegerArray.length];
        for (int i2 = 0; i2 < unsignedIntegerArray.length; ++i2) {
            readValueIdArray[i2] = new ReadValueId(nodeId, unsignedIntegerArray[i2], numericRangeArray == null ? null : NumericRange.toString(numericRangeArray[i2]), null);
        }
        ReadResponse readResponse = this.read(d2, this.getDefaultTimestampsToReturn(), readValueIdArray);
        DataValue[] dataValueArray = readResponse.getResults();
        return dataValueArray;
    }

    public DataValue[] readAttributes(UaNodeId uaNodeId, UnsignedInteger ... unsignedIntegerArray) throws ServiceException, StatusException {
        return this.readAttributes(this.e(uaNodeId), unsignedIntegerArray);
    }

    public DataValue[] readAttributes(UaNodeId uaNodeId, UnsignedInteger[] unsignedIntegerArray, NumericRange[] numericRangeArray, Double d2) throws ServiceException, StatusException {
        return this.readAttributes(this.e(uaNodeId), unsignedIntegerArray, numericRangeArray, d2);
    }

    public DataValue readValue(ExpandedNodeId expandedNodeId) throws ServiceException, StatusException {
        return this.readValue(this.toNodeId(expandedNodeId));
    }

    public DataValue readValue(ExpandedNodeId expandedNodeId, Double d2) throws ServiceException, StatusException {
        return this.readValue(this.toNodeId(expandedNodeId), d2);
    }

    public DataValue readValue(ExpandedNodeId expandedNodeId, NumericRange numericRange) throws ServiceException, StatusException {
        return this.readValue(this.toNodeId(expandedNodeId), numericRange);
    }

    public DataValue readValue(ExpandedNodeId expandedNodeId, NumericRange numericRange, Double d2) throws ServiceException, StatusException {
        return this.readValue(this.toNodeId(expandedNodeId), numericRange, d2);
    }

    public DataValue readValue(NodeId nodeId) throws ServiceException, StatusException {
        return this.readAttribute(nodeId, Attributes.Value);
    }

    public DataValue readValue(NodeId nodeId, Double d2) throws ServiceException, StatusException {
        return this.readAttribute(nodeId, Attributes.Value, null, d2);
    }

    public DataValue readValue(NodeId nodeId, NumericRange numericRange) throws ServiceException, StatusException {
        return this.readValue(nodeId, numericRange, (Double)this.getDefaultMaxAge());
    }

    public DataValue readValue(NodeId nodeId, NumericRange numericRange, Double d2) throws ServiceException, StatusException {
        return this.readAttribute(nodeId, Attributes.Value, numericRange, d2);
    }

    public DataValue readValue(UaNodeId uaNodeId) throws ServiceException, StatusException {
        return this.readValue(this.e(uaNodeId));
    }

    public DataValue readValue(UaNodeId uaNodeId, Double d2) throws ServiceException, StatusException {
        return this.readValue(this.e(uaNodeId), d2);
    }

    public DataValue readValue(UaNodeId uaNodeId, NumericRange numericRange) throws ServiceException, StatusException {
        return this.readValue(this.e(uaNodeId), numericRange);
    }

    public DataValue readValue(UaNodeId uaNodeId, NumericRange numericRange, Double d2) throws ServiceException, StatusException {
        return this.readValue(this.e(uaNodeId), numericRange, d2);
    }

    public DataValue[] readValues(ExpandedNodeId[] expandedNodeIdArray) throws ServiceException, StatusException {
        return this.readValues(this.a(expandedNodeIdArray));
    }

    public DataValue[] readValues(ExpandedNodeId[] expandedNodeIdArray, NumericRange[] numericRangeArray) throws ServiceException, StatusException {
        return this.readValues(this.a(expandedNodeIdArray), numericRangeArray);
    }

    public DataValue[] readValues(ExpandedNodeId[] expandedNodeIdArray, NumericRange[] numericRangeArray, TimestampsToReturn timestampsToReturn) throws ServiceException, StatusException {
        return this.readValues(this.a(expandedNodeIdArray), numericRangeArray, timestampsToReturn);
    }

    public DataValue[] readValues(ExpandedNodeId[] expandedNodeIdArray, NumericRange[] numericRangeArray, TimestampsToReturn timestampsToReturn, Double d2) throws ServiceException, StatusException {
        return this.readValues(this.a(expandedNodeIdArray), numericRangeArray, timestampsToReturn, d2);
    }

    public DataValue[] readValues(ExpandedNodeId[] expandedNodeIdArray, TimestampsToReturn timestampsToReturn) throws ServiceException, StatusException {
        return this.readValues(this.a(expandedNodeIdArray), timestampsToReturn);
    }

    public DataValue[] readValues(NodeId[] nodeIdArray) throws ServiceException {
        return this.readValues(nodeIdArray, this.getDefaultTimestampsToReturn());
    }

    public DataValue[] readValues(NodeId[] nodeIdArray, NumericRange[] numericRangeArray) throws ServiceException {
        ReadValueId[] readValueIdArray = new ReadValueId[nodeIdArray.length];
        for (int i2 = 0; i2 < nodeIdArray.length; ++i2) {
            readValueIdArray[i2] = new ReadValueId(nodeIdArray[i2], Attributes.Value, numericRangeArray == null ? null : NumericRange.toString(numericRangeArray[i2]), null);
        }
        ReadResponse readResponse = this.read(this.getDefaultMaxAge(), this.getDefaultTimestampsToReturn(), readValueIdArray);
        DataValue[] dataValueArray = readResponse.getResults();
        return dataValueArray;
    }

    public DataValue[] readValues(NodeId[] nodeIdArray, NumericRange[] numericRangeArray, TimestampsToReturn timestampsToReturn) throws ServiceException {
        return this.readValues(nodeIdArray, numericRangeArray, timestampsToReturn, (Double)this.getDefaultMaxAge());
    }

    public DataValue[] readValues(NodeId[] nodeIdArray, NumericRange[] numericRangeArray, TimestampsToReturn timestampsToReturn, Double d2) throws ServiceException {
        ReadValueId[] readValueIdArray = new ReadValueId[nodeIdArray.length];
        for (int i2 = 0; i2 < nodeIdArray.length; ++i2) {
            readValueIdArray[i2] = new ReadValueId(nodeIdArray[i2], Attributes.Value, numericRangeArray == null ? null : NumericRange.toString(numericRangeArray[i2]), null);
        }
        ReadResponse readResponse = this.read(d2, timestampsToReturn, readValueIdArray);
        DataValue[] dataValueArray = readResponse.getResults();
        return dataValueArray;
    }

    public DataValue[] readValues(NodeId[] nodeIdArray, TimestampsToReturn timestampsToReturn) throws ServiceException {
        return this.readValues(nodeIdArray, null, timestampsToReturn);
    }

    public DataValue[] readValues(UaNodeId[] uaNodeIdArray) throws ServiceException, StatusException {
        return this.readValues(this.a(uaNodeIdArray));
    }

    public DataValue[] readValues(UaNodeId[] uaNodeIdArray, NumericRange[] numericRangeArray) throws ServiceException, StatusException {
        return this.readValues(this.a(uaNodeIdArray), numericRangeArray);
    }

    public DataValue[] readValues(UaNodeId[] uaNodeIdArray, NumericRange[] numericRangeArray, TimestampsToReturn timestampsToReturn) throws ServiceException, StatusException {
        return this.readValues(this.a(uaNodeIdArray), numericRangeArray, timestampsToReturn);
    }

    public DataValue[] readValues(UaNodeId[] uaNodeIdArray, NumericRange[] numericRangeArray, TimestampsToReturn timestampsToReturn, Double d2) throws ServiceException, StatusException {
        return this.readValues(this.a(uaNodeIdArray), numericRangeArray, timestampsToReturn, d2);
    }

    public DataValue[] readValues(UaNodeId[] uaNodeIdArray, TimestampsToReturn timestampsToReturn) throws ServiceException, StatusException {
        return this.readValues(this.a(uaNodeIdArray), timestampsToReturn);
    }

    public boolean reconnect() throws ServiceException, ConnectException, SessionActivationException {
        boolean bl;
        Consumer<ReconnectStatus> consumer = reconnectStatus -> Optional.ofNullable(this.getListener()).ifPresent(uaClientListener -> uaClientListener.onReconnect((ReconnectStatus)reconnectStatus));
        try {
            consumer.accept(ReconnectStatus.builder().setState(ReconnectState.CONNECTING).build());
            bl = this.coF();
            consumer.accept(ReconnectStatus.builder().setState(ReconnectState.CONNECTED).build());
        }
        catch (ServiceException serviceException) {
            consumer.accept(ReconnectStatus.builder().setState(ReconnectState.ERROR).setError(serviceException).build());
            throw serviceException;
        }
        return bl;
    }

    public void registerModel(ClientCodegenModel clientCodegenModel) {
        this.registerModelInternal(clientCodegenModel);
    }

    public boolean removeServerStatusListener(ServerStatusListener serverStatusListener) {
        return this.gS.remove(serverStatusListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusCode removeSubscription(Subscription subscription) throws ServiceException {
        StatusCode statusCode;
        block7: {
            logger.debug("removeSubscription: {}", (Object)subscription);
            if (subscription == null) {
                return StatusCode.valueOf(StatusCodes.Good_NoData);
            }
            statusCode = null;
            try {
                StatusCode[] statusCodeArray = this.a(new SubscriptionBase[]{subscription});
                if (statusCodeArray != null && statusCodeArray.length > 0) {
                    statusCode = statusCodeArray[0];
                }
                if (subscription.getClient() == this) {
                    subscription.reset();
                }
                boolean bl = this.hh.remove(subscription);
                logger.debug("removed: {}", (Object)bl);
                if (statusCode != null) break block7;
                statusCode = bl ? StatusCode.GOOD : StatusCode.valueOf(StatusCodes.Good_NoData);
            }
            catch (Throwable throwable) {
                if (subscription.getClient() == this) {
                    subscription.reset();
                }
                boolean bl = this.hh.remove(subscription);
                logger.debug("removed: {}", (Object)bl);
                if (statusCode == null) {
                    statusCode = bl ? StatusCode.GOOD : StatusCode.valueOf(StatusCodes.Good_NoData);
                }
                throw throwable;
            }
        }
        return statusCode;
    }

    public StatusCode[] removeSubscriptions(Subscription[] subscriptionArray) throws ServiceException {
        StatusCode[] statusCodeArray = this.a(subscriptionArray);
        if (statusCodeArray == null) {
            statusCodeArray = new StatusCode[subscriptionArray.length];
        }
        this.resetSubscriptionsAfterRemove(subscriptionArray, statusCodeArray);
        return statusCodeArray;
    }

    public AsyncResult<StatusCode[]> removeSubscriptionsAsync(final Subscription ... subscriptionArray) throws ServiceException {
        final AsyncResultImpl<StatusCode[]> asyncResultImpl = new AsyncResultImpl<StatusCode[]>();
        AsyncResult<DeleteSubscriptionsResponse> asyncResult = this.b(subscriptionArray);
        if (asyncResult == null) {
            StatusCode[] statusCodeArray = new StatusCode[subscriptionArray.length];
            this.resetSubscriptionsAfterRemove(subscriptionArray, statusCodeArray);
            asyncResultImpl.setResult(statusCodeArray);
        } else {
            asyncResult.setListener(new ResultListener<DeleteSubscriptionsResponse>(){

                public void a(DeleteSubscriptionsResponse deleteSubscriptionsResponse) {
                    StatusCode[] statusCodeArray = deleteSubscriptionsResponse.getResults();
                    UaClient.this.resetSubscriptionsAfterRemove(subscriptionArray, statusCodeArray);
                    asyncResultImpl.setResult(statusCodeArray);
                }

                @Override
                public void onError(ServiceResultException serviceResultException) {
                    asyncResultImpl.setError(serviceResultException);
                }

                @Override
                public /* synthetic */ void onCompleted(Object object) {
                    this.a((DeleteSubscriptionsResponse)object);
                }
            });
        }
        return asyncResultImpl;
    }

    public void resetEndpoint() {
        this.gv = null;
    }

    public <T extends ServiceResponse> T serviceRequest(ServiceRequest<T> serviceRequest) throws ServiceException {
        try {
            if (serviceRequest.getRequestHeader() == null) {
                serviceRequest.setRequestHeader(this.getRequestHeader());
            }
            T t2 = this.cnY().serviceRequest(serviceRequest);
            this.checkServiceResult((ServiceResponse)t2, null);
            return t2;
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    public <T extends ServiceResponse> AsyncResult<T> serviceRequestAsync(ServiceRequest<T> serviceRequest) throws ServiceException {
        if (serviceRequest.getRequestHeader() == null) {
            serviceRequest.setRequestHeader(this.getRequestHeader());
        }
        return this.cnY().serviceRequestAsync(serviceRequest);
    }

    public <T extends ServiceResponse> T sessionlessRequest(ServiceRequest<T> serviceRequest) throws InvalidServerEndpointException, ServerConnectionException, ServiceException {
        if (this.isConnected()) {
            return this.serviceRequest(serviceRequest);
        }
        if (this.gv == null) {
            this.coO();
            this.coP();
            this.coN();
        }
        this.coD();
        try {
            T t2 = this.gO.serviceRequest(serviceRequest);
            return t2;
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        finally {
            this.disconnect();
        }
    }

    public void setAddress(String string) {
        this.setAddress(UaAddress.parse(string));
    }

    public void setAddress(UaAddress uaAddress) {
        this.gm = uaAddress;
        this.coA();
    }

    public void setApplicationIdentity(ApplicationIdentity applicationIdentity) {
        this.applicationIdentity = applicationIdentity;
    }

    public void setAuditEntryId(String string) {
        this.gn = string;
    }

    public void setAutoReconnect(boolean bl) {
        this.go = bl;
    }

    public void setConnectTimeout(int n2) {
        this.connectTimeout = n2;
    }

    public void setConnectTimeout(int n2, TimeUnit timeUnit) {
        this.connectTimeout = (int)timeUnit.toMillis(n2);
    }

    public void setDefaultMaxAge(double d2) {
        if (d2 < 0.0) {
            throw new IllegalArgumentException("defaultMaxAge cannot be less than 0");
        }
        this.gt = d2;
    }

    public void setDefaultTimestampsToReturn(TimestampsToReturn timestampsToReturn) {
        this.gu = timestampsToReturn;
    }

    public void setEndpoint(EndpointDescription endpointDescription) {
        this.coy();
        if (endpointDescription != null) {
            this.setUri(endpointDescription.getEndpointUrl());
            try {
                SecurityPolicy securityPolicy = SecurityPolicy.getSecurityPolicy(endpointDescription.getSecurityPolicyUri());
                this.gP = new SecurityMode(securityPolicy, endpointDescription.getSecurityMode());
            }
            catch (ServiceResultException serviceResultException) {
                logger.error("Converting SecurityPolicyUri to SecurityPolicy failed", serviceResultException);
            }
        }
        this.gv = endpointDescription;
    }

    public void setInitTypeDictionaryAutoUsage(boolean bl) {
        this.hl = bl;
    }

    public void setInitTypeDictionaryOnConnect(boolean bl) {
        this.hk = bl;
    }

    public void setKeepSubscriptions(boolean bl) {
        this.gz = bl;
    }

    public void setListener(UaClientListener uaClientListener) {
        this.gE = uaClientListener;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setMaxResponseMessageSize(int n2) {
        this.setMaxResponseMessageSize(UnsignedInteger.valueOf(n2));
    }

    public void setMaxResponseMessageSize(UnsignedInteger unsignedInteger) {
        this.gF = unsignedInteger == null ? UnsignedInteger.ZERO : unsignedInteger;
    }

    public void setOperationDiagnosticMask(EnumSet<UaApplication.DiagnosticMask> enumSet) {
        this.gH = enumSet;
        this.cpb();
    }

    public synchronized void setPublishRequestFactor(double d2) {
        logger.debug("setPublishRequestFactor: {}", (Object)d2);
        this.gI = d2;
        this.resetPublishRequestSetpoint();
    }

    public void setPublishRequestSetpoint(int n2) {
        this.gJ.set(n2);
    }

    public void setPublishRequestTimeout(long l2) {
        this.setPublishRequestTimeout(UnsignedInteger.valueOf(l2));
    }

    public void setPublishRequestTimeout(long l2, TimeUnit timeUnit) {
        this.setPublishRequestTimeout(timeUnit.toMillis(l2));
    }

    public void setPublishRequestTimeout(UnsignedInteger unsignedInteger) {
        this.gK = unsignedInteger.getValue() == 0L ? UnsignedInteger.MAX_VALUE : unsignedInteger;
    }

    public void setReverseAddress(UaAddress uaAddress) {
        this.hj = uaAddress;
    }

    public void setReverseConnectionListener(ReverseConnectionListener reverseConnectionListener) {
        this.hi = reverseConnectionListener;
    }

    public void setReversePort(int n2) {
        this.setReverseAddress(UaAddress.wildcardOpcTcp(n2));
    }

    public void setSecurityMode(SecurityMode securityMode) {
        if (!securityMode.equals(this.gP)) {
            this.coy();
            this.gP = securityMode;
            this.resetEndpoint();
        }
    }

    public void setServiceDiagnosticMask(EnumSet<UaApplication.DiagnosticMask> enumSet) {
        this.gW = enumSet;
        this.cpb();
    }

    public void setSessionName(String string) {
        this.gY = string;
    }

    public void setSessionTimeout(double d2) {
        this.gZ = d2;
    }

    public void setSessionTimeout(long l2, TimeUnit timeUnit) {
        double d2;
        switch (timeUnit) {
            case MICROSECONDS: {
                d2 = (double)l2 / 1000.0;
                break;
            }
            case NANOSECONDS: {
                d2 = (double)l2 / 1000000.0;
                break;
            }
            default: {
                d2 = timeUnit.toMillis(l2);
            }
        }
        this.setSessionTimeout(d2);
    }

    public void setSocketFactory(TcpConnection.SocketFactory socketFactory) {
        this.hm = socketFactory;
    }

    public void setStatusCheckInterval(long l2) {
        if (l2 != this.hb) {
            this.hb = l2;
            this.coV();
        }
    }

    public void setStatusCheckInterval(long l2, TimeUnit timeUnit) {
        this.setStatusCheckInterval(timeUnit.toMillis(l2));
    }

    public void setStatusCheckTimeout(long l2) {
        this.hc = l2;
    }

    public void setStatusCheckTimeout(long l2, TimeUnit timeUnit) {
        this.hc = timeUnit.toMillis(l2);
    }

    public void setTimeout(long l2) {
        this.setTimeout(UnsignedInteger.valueOf(l2));
    }

    public void setTimeout(long l2, TimeUnit timeUnit) {
        this.setTimeout(timeUnit.toMillis(l2));
    }

    public void setTimeout(UnsignedInteger unsignedInteger) {
        this.hd = unsignedInteger;
    }

    @Deprecated
    public void setUri(String string) {
        this.setAddress(string);
        this.gs = null;
    }

    public void setUserIdentity(UserIdentity userIdentity) throws SessionActivationException {
        if (userIdentity == null) {
            userIdentity = new UserIdentity();
        }
        if (!this.cw.equals(userIdentity)) {
            this.cw = userIdentity;
            this.coM();
        }
    }

    public void setValidateCreateSessionResponseCert(boolean bl) {
        this.hf = bl;
    }

    public void setValidateDiscoveredEndpoints(boolean bl) {
        this.he = bl;
    }

    public void updateServerStatus() {
        Cloneable cloneable;
        ServerState serverState;
        ServerState serverState2;
        block16: {
            StatusCode statusCode = this.coJ();
            serverState2 = this.getServerState();
            logger.trace("updateServerStatus: oldState={} error={}", (Object)serverState2, (Object)statusCode);
            serverState = ServerState.Unknown;
            try {
                if (!this.gT.get()) {
                    cloneable = null;
                    ReadValueId readValueId = new ReadValueId(Identifiers.Server_ServerStatus, Attributes.Value, null, null);
                    RequestHeader requestHeader = this.a(UnsignedInteger.ZERO, UnsignedInteger.valueOf(this.hc), null);
                    ReadResponse readResponse = this.cnY().Read(requestHeader, 0.0, TimestampsToReturn.Both, readValueId);
                    this.checkServiceResult(readResponse, readResponse.getDiagnosticInfos());
                    if (readResponse.getResults().length > 0) {
                        cloneable = readResponse.getResults()[0];
                    }
                    if (cloneable == null) {
                        this.a(null, StatusCode.BAD);
                    } else {
                        ServerStatusDataType serverStatusDataType;
                        Object object;
                        Object object2 = object = ((DataValue)cloneable).isNull() ? null : ((DataValue)cloneable).getValue().getValue();
                        boolean bl = object != null && object instanceof ServerStatusDataType && ((DataValue)cloneable).getStatusCode() != null && ((DataValue)cloneable).getStatusCode().isGood() ? (serverStatusDataType = (ServerStatusDataType)object).getBuildInfo() != null || serverStatusDataType.getCurrentTime() != null || serverStatusDataType.getSecondsTillShutdown() != null || serverStatusDataType.getShutdownReason() != null || serverStatusDataType.getStartTime() != null || serverStatusDataType.getState() != null : false;
                        if (bl) {
                            this.a((ServerStatusDataType)object, ((DataValue)cloneable).getStatusCode());
                        } else {
                            this.coX();
                        }
                        serverStatusDataType = this.coK();
                        if (serverStatusDataType.getCurrentTime() != null) {
                            this.gV.set(serverStatusDataType.getCurrentTime().getTimeInMillis() - System.currentTimeMillis());
                        }
                        serverState = serverStatusDataType.getState();
                    }
                } else {
                    this.coX();
                    cloneable = this.coK();
                    if (((ServerStatusDataType)cloneable).getCurrentTime() != null) {
                        this.gV.set(((ServerStatusDataType)cloneable).getCurrentTime().getTimeInMillis() - System.currentTimeMillis());
                    }
                    serverState = ((ServerStatusDataType)cloneable).getState();
                }
            }
            catch (ServerConnectionException serverConnectionException) {
                logger.debug("updateServerStatus", serverConnectionException);
                this.a(null, StatusCodes.Bad_ServerNotConnected);
                serverState = ServerState.CommunicationFault;
            }
            catch (ServiceException serviceException) {
                logger.debug("updateServerStatus", serviceException);
                this.a(null, serviceException.getServiceResult());
                serverState = ServerState.CommunicationFault;
            }
            catch (ServiceResultException serviceResultException) {
                logger.debug("updateServerStatus", serviceResultException);
                this.a(null, serviceResultException.getStatusCode());
                if (serviceResultException.getStatusCode().getValue().equals(StatusCodes.Bad_SessionNotActivated)) break block16;
                serverState = ServerState.CommunicationFault;
            }
        }
        this.coG();
        if (!serverState.equals(serverState2)) {
            this.a(serverState2, serverState);
        }
        cloneable = this.coK();
        if (serverState.equals(ServerState.Shutdown)) {
            long l2;
            long l3 = l2 = cloneable == null ? 0L : ((ServerStatusDataType)cloneable).getSecondsTillShutdown().getValue();
            if (l2 > 0L) {
                this.a(l2, cloneable == null ? new LocalizedText("") : ((ServerStatusDataType)cloneable).getShutdownReason());
                this.f((UnsignedInteger)null);
                this.ha = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(l2 + 10L);
            }
        }
    }

    public WriteResponse write(WriteValue ... writeValueArray) throws ServiceException {
        int n2 = 0;
        if (writeValueArray.length > 1 && this.getActualOperationLimits() != null) {
            try {
                n2 = this.getActualOperationLimits().getMaxNodesPerWrite().intValue();
            }
            catch (Exception exception) {
                logger.debug("Error while parsing operation limits", exception);
            }
        }
        if (n2 > 0 && n2 < writeValueArray.length) {
            ResponseHeader responseHeader = null;
            StatusCode[] statusCodeArray = new StatusCode[writeValueArray.length];
            DiagnosticInfo[] diagnosticInfoArray = new DiagnosticInfo[writeValueArray.length];
            for (int i2 = 0; i2 < writeValueArray.length; i2 += n2) {
                int n3 = Math.min(n2, writeValueArray.length - i2);
                WriteValue[] writeValueArray2 = Arrays.copyOfRange(writeValueArray, i2, i2 + n3);
                WriteResponse writeResponse = this.a(writeValueArray2);
                responseHeader = writeResponse.getResponseHeader();
                for (int i3 = 0; i3 < n3; ++i3) {
                    statusCodeArray[i2 + i3] = writeResponse.getResults()[i3];
                }
                DiagnosticInfo[] diagnosticInfoArray2 = writeResponse.getDiagnosticInfos();
                if (diagnosticInfoArray2 != null && diagnosticInfoArray2.length == n3) {
                    for (int i4 = 0; i4 < n3; ++i4) {
                        diagnosticInfoArray[i2 + i4] = diagnosticInfoArray2[i4];
                    }
                    continue;
                }
                if (diagnosticInfoArray2 == null || diagnosticInfoArray2.length <= 0 || diagnosticInfoArray2.length == n3) continue;
                logger.warn("The length of the DiagnosticInfo array in WriteResponse was {}, but the expected length was {}, ignoring the DiagnosticInfo array", (Object)diagnosticInfoArray2.length, (Object)n3);
            }
            return new WriteResponse(responseHeader, statusCodeArray, diagnosticInfoArray);
        }
        return this.a(writeValueArray);
    }

    public AsyncResult<WriteResponse> writeAsync(WriteValue ... writeValueArray) {
        WriteRequest writeRequest = new WriteRequest(this.getRequestHeader(), writeValueArray);
        try {
            return this.cnY().WriteAsync(writeRequest);
        }
        catch (ServerConnectionException serverConnectionException) {
            return AsyncResultImpl.failed(new ServiceResultException(StatusCodes.Bad_ServerNotConnected, (Throwable)serverConnectionException));
        }
    }

    public boolean writeAttribute(NodeId nodeId, UnsignedInteger unsignedInteger, Object object) throws ServiceException, StatusException {
        WriteValue[] writeValueArray = new WriteValue[]{new WriteValue(nodeId, unsignedInteger, null, this.g(object))};
        WriteResponse writeResponse = this.write(writeValueArray);
        StatusCode statusCode = writeResponse.getResults()[0];
        this.checkOperationResult(statusCode);
        return statusCode.equals(StatusCode.GOOD);
    }

    public boolean writeAttribute(NodeId nodeId, UnsignedInteger unsignedInteger, Object object, boolean bl) throws DataTypeConversionException, ServiceException, StatusException {
        Object object2;
        if (bl) {
            if (Attributes.Value.equals(unsignedInteger)) {
                NodeId nodeId2;
                try {
                    nodeId2 = (NodeId)this.readAttribute(nodeId, Attributes.DataType).getValue().getValue();
                }
                catch (Exception exception) {
                    throw new DataTypeConversionException("Cannot resolve DataType of node with NodeId: " + nodeId);
                }
                if (object instanceof DataValue) {
                    DataValue dataValue = ((DataValue)object).clone();
                    dataValue.setValue(this.getAddressSpace().getDataTypeConverter().convert(dataValue.getValue(), nodeId2));
                    object2 = dataValue;
                }
                object2 = this.getAddressSpace().getDataTypeConverter().convert(this.h(object), nodeId2);
            } else {
                Class<?> clazz = gj.get(unsignedInteger);
                if (clazz == null) {
                    throw new DataTypeConversionException("This method does not support autoconversion for AttributeId: " + unsignedInteger);
                }
                if (object instanceof DataValue) {
                    DataValue dataValue = ((DataValue)object).clone();
                    dataValue.setValue(this.getAddressSpace().getDataTypeConverter().convert(dataValue.getValue(), clazz));
                    object2 = dataValue;
                }
                object2 = this.getAddressSpace().getDataTypeConverter().convert(this.h(object), clazz);
            }
        } else {
            object2 = object;
        }
        return this.writeAttribute(nodeId, unsignedInteger, object2);
    }

    public boolean writeAttribute(NodeId nodeId, UnsignedInteger unsignedInteger, Object object, NumericRange numericRange) throws ServiceException, StatusException {
        WriteValue[] writeValueArray = new WriteValue[]{new WriteValue(nodeId, unsignedInteger, NumericRange.toString(numericRange), this.g(object))};
        WriteResponse writeResponse = this.write(writeValueArray);
        StatusCode statusCode = writeResponse.getResults()[0];
        this.checkOperationResult(statusCode);
        return statusCode.equals(StatusCode.GOOD);
    }

    public boolean writeValue(NodeId nodeId, Object object) throws ServiceException, StatusException {
        return this.writeAttribute(nodeId, Attributes.Value, object);
    }

    public boolean writeValue(NodeId nodeId, Object object, boolean bl) throws DataTypeConversionException, ServiceException, StatusException {
        return this.writeAttribute(nodeId, Attributes.Value, object, bl);
    }

    public boolean writeValue(NodeId nodeId, Object object, NumericRange numericRange) throws ServiceException, StatusException {
        return this.writeAttribute(nodeId, Attributes.Value, object, numericRange);
    }

    public StatusCode[] writeValues(NodeId[] nodeIdArray, Object[] objectArray) throws ServiceException {
        WriteValue[] writeValueArray = new WriteValue[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            writeValueArray[i2] = new WriteValue(nodeIdArray[i2], Attributes.Value, null, this.g(objectArray[i2]));
        }
        WriteResponse writeResponse = this.write(writeValueArray);
        return writeResponse.getResults();
    }

    public StatusCode[] writeValues(NodeId[] nodeIdArray, Object[] objectArray, NumericRange[] numericRangeArray) throws ServiceException {
        WriteValue[] writeValueArray = new WriteValue[objectArray.length];
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            writeValueArray[i2] = new WriteValue(nodeIdArray[i2], Attributes.Value, NumericRange.toString(numericRangeArray[i2]), this.g(objectArray[i2]));
        }
        WriteResponse writeResponse = this.write(writeValueArray);
        return writeResponse.getResults();
    }

    private void cox() throws SessionActivationException {
        Object object;
        Object object2;
        Object object3 = null;
        logger.debug("activateSessionChannel: endpoint={}", (Object)this.getSession().getEndpoint().getEndpointUrl());
        SignatureData signatureData = null;
        try {
            object2 = null;
            switch (this.cw.getType()) {
                case Anonymous: {
                    object3 = EndpointUtil.createAnonymousIdentityToken(this.getSession().getEndpoint());
                    break;
                }
                case Certificate: {
                    signatureData = new SignatureData();
                    object3 = EndpointUtil.createX509IdentityToken(this.getSession().getEndpoint(), this.getSession().getServerNonce(), this.cw.getCertificate(), this.cw.getPrivateKey().getPrivateKey(), signatureData);
                    break;
                }
                case IssuedToken: {
                    object = (Locale[])EndpointUtil.createIssuedIdentityToken(this.getSession().getEndpoint(), this.getSession().getServerNonce(), this.cw.getIssuedIdentityToken());
                    object2 = ((IssuedIdentityToken)object).getEncryptionAlgorithm();
                    object3 = object;
                    break;
                }
                case UserName: {
                    UserNameIdentityToken userNameIdentityToken = (UserNameIdentityToken)EndpointUtil.createUserNameIdentityToken(this.getSession().getEndpoint(), this.getSession().getServerNonce(), this.cw.getName(), this.cw.getPassword());
                    object2 = userNameIdentityToken.getEncryptionAlgorithm();
                    object3 = userNameIdentityToken;
                    break;
                }
            }
            logger.debug("UserToken encryption algorithm: {}", object2);
            if (object2 != null && SecurityMode.NONE.equals(this.gP) && this.validateApplicationCertificate(this.getServerIdentity()).isNotGood()) {
                throw new SessionActivationException("User Token encryption cannot be done for SecurityMode NONE, server certificate is not trusted", this.cw, StatusCodes.Bad_CertificateUntrusted);
            }
        }
        catch (ServiceResultException serviceResultException) {
            logger.debug("ServiceResultException: ", serviceResultException);
            throw new SessionActivationException("Failed to initialize User Identity Token: " + serviceResultException.getMessage(), this.cw, serviceResultException);
        }
        try {
            object2 = this.gq.getApplication();
            for (Locale locale : ((Application)object2).getLocales()) {
                ((Application)object2).removeLocale(locale);
            }
            ((Application)object2).addLocale(this.locale);
            object = this.cnY().activate((UserIdentityToken)object3, signatureData);
            StatusCode statusCode = ((ActivateSessionResponse)object).getResponseHeader().getServiceResult();
            if (statusCode.isBad()) {
                throw new SessionActivationException("Failed to activate Session.", this.cw, statusCode);
            }
        }
        catch (ServiceResultException serviceResultException) {
            logger.debug("ServiceResultException: ", serviceResultException);
            throw new SessionActivationException("Failed to activate Session.", this.cw, serviceResultException);
        }
        catch (ServerConnectionException serverConnectionException) {
            logger.debug("ServerConnectionException: ", serverConnectionException);
            throw new SessionActivationException("Failed to activate Session; not connected to the Server", this.cw, serverConnectionException.getServiceResult());
        }
    }

    private void a(CallMethodResult callMethodResult, DiagnosticInfo diagnosticInfo) throws MethodCallStatusException {
        if (callMethodResult.getStatusCode().isBad()) {
            throw new MethodCallStatusException(callMethodResult.getStatusCode(), diagnosticInfo, callMethodResult.getInputArgumentResults(), callMethodResult.getInputArgumentDiagnosticInfos());
        }
    }

    private void coy() {
        if (this.isConnected()) {
            throw new IllegalStateException("Cannot change connection or security settings when connected");
        }
    }

    private void coz() {
        this.gR.set(null);
        this.gT.set(false);
        this.gV.set(0L);
        this.gQ = null;
        this.gl = null;
    }

    private void f(UnsignedInteger unsignedInteger) {
        SessionChannel sessionChannel = this.gp.get();
        if (sessionChannel != null && sessionChannel.getSession() != null) {
            try {
                sessionChannel.CloseSession(this.a(null, unsignedInteger, null), !this.gz);
            }
            catch (ServiceResultException serviceResultException) {
                logger.info("Failed to CloseSession: ", serviceResultException);
            }
            if (!this.gz) {
                this.a(null, this.hh);
            }
        }
        if (sessionChannel != null) {
            sessionChannel.closeSecureChannel();
        }
        this.a((SessionChannel)null);
        this.a((Session)null);
    }

    private void coA() {
        this.getAddressSpace().cnZ();
        TypeDictionary typeDictionary = this.getTypeDictionary();
        if (typeDictionary != null) {
            typeDictionary.clearCaches();
        }
        this.resetEndpoint();
        this.gs = null;
    }

    private void coB() throws ServiceException {
        logger.debug("connectSubscriptions");
        try {
            this.cpa();
        }
        catch (ServiceException serviceException) {
            logger.debug("transferSubscriptions: ", serviceException);
            this.a(null, this.hh);
        }
        this.a(true);
    }

    private void coC() throws ConnectException, SessionActivationException, ServiceException {
        logger.debug("createAndActivateSessionChannel: unable to activate old session");
        try {
            this.coE();
        }
        catch (Exception exception) {
            logger.debug("createAndActivateSessionChannel: re-init endpoint and retry.", exception);
            this.coP();
            if (this.gv == null) {
                throw new ConnectException("No endpoint found", this.coL(), this.gP);
            }
            this.coD();
            this.coE();
        }
        this.cox();
        this.coB();
        logger.debug("createAndActivateSessionChannel: New session created and activated");
        try {
            logger.debug("NamespaceTable: {}", (Object)this.getNamespaceTable(true));
        }
        catch (StatusException statusException) {
            logger.error("Cannot Read NamespaceArray from the server", statusException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void coD() throws ConnectException {
        SessionChannel sessionChannel = this.gp.get();
        this.a((SessionChannel)null);
        if (sessionChannel != null) {
            sessionChannel.closeSecureChannel();
        }
        UaClient uaClient = this;
        synchronized (uaClient) {
            try {
                if (this.isInReverseMode()) {
                    ReverseTransportChannelSettings reverseTransportChannelSettings = new ReverseTransportChannelSettings();
                    reverseTransportChannelSettings.setReverseConnectionListener(this.hi);
                    reverseTransportChannelSettings.setConfiguration(this.gw);
                    reverseTransportChannelSettings.setDescription(this.gv);
                    reverseTransportChannelSettings.setOpctcpSettings(null);
                    this.gO = this.gq.createReverseSecureChannel(this.hj.getAddress(), reverseTransportChannelSettings);
                } else {
                    TransportChannelSettings transportChannelSettings = new TransportChannelSettings();
                    transportChannelSettings.setConfiguration(this.gw);
                    transportChannelSettings.setDescription(this.gv);
                    transportChannelSettings.setOpctcpSettings(null);
                    UaAddress uaAddress = this.resolveConnectionAddress(this.gm, this.gv);
                    this.gO = this.gq.createSecureChannel(uaAddress.getAddress(), transportChannelSettings);
                }
            }
            catch (ServiceResultException serviceResultException) {
                this.gO = null;
                throw new ConnectException("Failed to create secure channel to server: ", this.gv.getEndpointUrl(), this.gP, serviceResultException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void coE() throws ServiceException {
        logger.debug("createSessionChannel");
        UaClient uaClient = this;
        synchronized (uaClient) {
            this.a((Session)null);
            try {
                Cert cert;
                Cert cert2 = null;
                if (this.gv.getServerCertificate() != null && this.gv.getServerCertificate().getLength() != 0) {
                    cert2 = new Cert(this.gv.getServerCertificate().getValue());
                }
                EndpointDescription[] endpointDescriptionArray = this.he ? this.gs : null;
                f f2 = this.gL;
                if (f2 != null) {
                    f2.cpm();
                }
                this.a(this.gq.createSession(this.gO, this.getMaxResponseMessageSize(), this.getSessionTimeout(), this.getSessionName(), endpointDescriptionArray));
                ByteString byteString = this.gX.getEndpoint().getServerCertificate();
                logger.debug("createSessionChannel: session.getEndpoint().getServerCertificate()={}", (Object)byteString);
                Cert cert3 = this.gX.getServerCertificate();
                if (!EndpointUtil.needsCertificate(this.getEndpoint()) && cert3 != null) {
                    logger.info("Server sent a certificate, although SecurityPolicy NONE is used");
                }
                if ((byteString == null || byteString.getLength() == 0) && cert3 != null) {
                    logger.debug("createSessionChannel: session.getServerCertificate().getEncoded()={}", (Object)cert3.getEncoded());
                    this.gX.getEndpoint().setServerCertificate(ByteString.valueOf(cert3.getEncoded()));
                } else if (!SecurityMode.NONE.equals(this.gP)) {
                    Cert cert4 = cert = this.gX.getEndpoint().getServerCertificate() == null ? null : new Cert(this.gX.getEndpoint().getServerCertificate().getValue());
                    if (this.hf && cert3 != null && !Objects.equals(cert, cert3)) {
                        throw new ServiceException("Different cert in CreateSessionResponse.serverCertificate and endpoints", StatusCodes.Bad_UnexpectedError);
                    }
                }
                if (!SecurityMode.NONE.equals(this.gP)) {
                    cert = cert3;
                    if (this.hf && !Objects.equals(cert2, cert)) {
                        throw new ServiceException("Certificates in endpoint and CreateSessionResponse not same", StatusCodes.Bad_UnexpectedError);
                    }
                }
            }
            catch (ServiceResultException serviceResultException) {
                logger.debug("createSessionChannel: serviceResult={}", (Object)serviceResultException.getStatusCode());
                this.gO.closeAsync();
                this.gO = null;
                if (StatusCodes.Bad_UnexpectedError.equals(serviceResultException.getStatusCode().getValue())) {
                    throw new InvalidServerEndpointException("Failed to create session channel to server: ", this.coL(), this.gP, serviceResultException);
                }
                throw new ConnectException("Failed to create session channel to server: ", this.coL(), this.gP, serviceResultException);
            }
        }
        this.a(this.gX.createSessionChannel(this.gO, this.gq));
        logger.debug("MessageSecurityMode: {}, SecurityPolicy: {}, UserIdentity type: {}", new Object[]{this.getSecurityMode().getMessageSecurityMode(), this.getSecurityMode().getSecurityPolicy(), this.getUserIdentity().getType()});
        if (MessageSecurityMode.None == this.getSecurityMode().getMessageSecurityMode() && SecurityPolicy.NONE == this.getSecurityMode().getSecurityPolicy() && UserTokenType.Anonymous == this.getUserIdentity().getType()) {
            logger.debug("SecurityMode NONE and UserTokenType Anonymous, skipping nonce checks");
        } else {
            logger.debug("Validating that the server send long enough nonce (min 32bytes), is: {}", (Object)this.gX.getServerNonce());
            if (this.gX.getServerNonce() == null || this.gX.getServerNonce().getLength() < 32) {
                throw new ConnectException("Received less than 32 byte nonce from the server, was:" + this.gX.getServerNonce(), this.coL(), this.gP);
            }
        }
        if (this.gE != null) {
            this.gE.onAfterCreateSessionChannel(this, this.getSession());
        }
    }

    private boolean a(Subscription subscription, boolean bl) throws ServiceException {
        CreateSubscriptionResponse createSubscriptionResponse;
        logger.debug("createSubscription: subscription={}, allowModification={}, isModified={}", subscription.getSubscriptionId(), bl, subscription.isModified());
        if (subscription.getSubscriptionId() != null && subscription.getSubscriptionId().getValue() != 0L) {
            try {
                if (bl && subscription.isModified()) {
                    this.a((SubscriptionBase)subscription);
                }
                return false;
            }
            catch (ServiceException serviceException) {
                logger.debug("createSubscription: cannot modify: invalid subscription={} Exception={}", (Object)subscription.getSubscriptionId(), (Object)serviceException);
                subscription.reset();
            }
        }
        try {
            logger.debug("createSubscription: subscription={}", (Object)subscription);
            createSubscriptionResponse = this.cnY().CreateSubscription(this.getRequestHeader(), subscription.getPublishingInterval(), UnsignedInteger.valueOf(subscription.getLifetimeCount()), UnsignedInteger.valueOf(subscription.getMaxKeepAliveCount()), UnsignedInteger.valueOf(subscription.getMaxNotificationsPerPublish()), subscription.isPublishingEnabled(), UnsignedByte.valueOf(subscription.getPriority()));
            logger.debug("createSubscription: reponse={}", (Object)createSubscriptionResponse.getResponseHeader().getServiceResult());
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult(createSubscriptionResponse, null);
        logger.debug("createSubscription: response SubscriptionId={}, RevisedPublishingInterval={}, RevisedMaxKeepAliveCount={}, RevisedLifetimeCount={}", createSubscriptionResponse.getSubscriptionId(), createSubscriptionResponse.getRevisedPublishingInterval(), createSubscriptionResponse.getRevisedMaxKeepAliveCount(), createSubscriptionResponse.getRevisedLifetimeCount());
        if (createSubscriptionResponse.getSubscriptionId() == null || UnsignedInteger.ZERO.equals(createSubscriptionResponse.getSubscriptionId())) {
            logger.error("CreateSubscriptionResponse returned SubscriptionId of 0 which is not valid id");
        }
        subscription.setSubscriptionId(createSubscriptionResponse.getSubscriptionId());
        subscription.setPublishingInterval(createSubscriptionResponse.getRevisedPublishingInterval());
        subscription.setLifetimeCount(createSubscriptionResponse.getRevisedLifetimeCount());
        subscription.setMaxKeepAliveCount(createSubscriptionResponse.getRevisedMaxKeepAliveCount());
        subscription.setClient(this);
        subscription.createItems();
        subscription.fireAfterCreate();
        return true;
    }

    private void a(boolean bl) {
        this.gx = false;
        int n2 = 0;
        for (Subscription subscription : this.hh) {
            try {
                this.a(subscription, bl);
            }
            catch (Exception exception) {
                ServiceException serviceException;
                logger.warn("Failed to create subscription to the server: {}", (Object)subscription, (Object)exception);
                this.gx = true;
                ++n2;
                if (!(exception instanceof ServiceException) || (serviceException = (ServiceException)exception).getServiceResult() == null || !StatusCodes.Bad_TooManySubscriptions.equals(serviceException.getServiceResult().getValue())) continue;
                logger.warn("Failure due to Bad_TooManySubscriptions, skipping rest of the subscriptions, total number of failures so far was: {}, total number of subscriptions: {}", (Object)n2, (Object)this.hh.size());
                return;
            }
        }
        if (n2 > 0) {
            logger.warn("Total {} failures for creating subscriptions to the server, total number of subscriptions: {}", (Object)n2, (Object)this.hh.size());
        }
    }

    private StatusCode[] a(SubscriptionBase ... subscriptionBaseArray) throws ServiceException {
        if (this.isConnected()) {
            DeleteSubscriptionsResponse deleteSubscriptionsResponse;
            UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[subscriptionBaseArray.length];
            for (int i2 = 0; i2 < subscriptionBaseArray.length; ++i2) {
                unsignedIntegerArray[i2] = subscriptionBaseArray[i2].getSubscriptionId();
            }
            try {
                deleteSubscriptionsResponse = this.cnY().DeleteSubscriptions(this.getRequestHeader(), unsignedIntegerArray);
                logger.debug("deleteSubscriptions: response={}", (Object)deleteSubscriptionsResponse);
            }
            catch (ServiceFaultException serviceFaultException) {
                throw new ServiceException(serviceFaultException);
            }
            catch (ServiceResultException serviceResultException) {
                throw new ServiceException(serviceResultException);
            }
            this.checkServiceResult(deleteSubscriptionsResponse, null);
            StatusCode[] statusCodeArray = deleteSubscriptionsResponse.getResults();
            if (statusCodeArray != null && statusCodeArray.length != subscriptionBaseArray.length && logger.isWarnEnabled()) {
                logger.warn("Received {} DeleteSubscriptions results when expecting {}, received StatusCodes: {}", statusCodeArray.length, subscriptionBaseArray.length, MultiDimensionArrayUtils.toString(statusCodeArray));
            }
            return statusCodeArray;
        }
        return null;
    }

    private AsyncResult<DeleteSubscriptionsResponse> b(SubscriptionBase ... subscriptionBaseArray) throws ServiceException {
        if (this.isConnected()) {
            UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[subscriptionBaseArray.length];
            for (int i2 = 0; i2 < subscriptionBaseArray.length; ++i2) {
                unsignedIntegerArray[i2] = subscriptionBaseArray[i2].getSubscriptionId();
            }
            return this.cnY().DeleteSubscriptionsAsync(this.getRequestHeader(), unsignedIntegerArray);
        }
        return null;
    }

    private void a(TransferResult[] transferResultArray, List<Subscription> list) {
        if (logger.isDebugEnabled()) {
            logger.debug("disconnectSubscriptions: " + Arrays.toString(transferResultArray));
        }
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (transferResultArray != null && transferResultArray[i2] != null && !transferResultArray[i2].getStatusCode().isBad()) continue;
            list.get(i2).reset();
        }
    }

    private EndpointDescription[] a(ChannelService channelService, String string, UaApplication.Protocol ... protocolArray) throws ServiceFaultException, ServiceResultException, ServiceException {
        String[] stringArray = new String[protocolArray.length];
        for (int i2 = 0; i2 < protocolArray.length; ++i2) {
            stringArray[i2] = protocolArray[i2].getTransportProfileUri();
        }
        GetEndpointsRequest getEndpointsRequest = new GetEndpointsRequest(this.getRequestHeader(), string, stringArray, stringArray);
        GetEndpointsResponse getEndpointsResponse = channelService.GetEndpoints(getEndpointsRequest);
        this.checkServiceResult(getEndpointsResponse, null);
        return getEndpointsResponse.getEndpoints();
    }

    private ReadResponse a(Double d2, TimestampsToReturn timestampsToReturn, ReadValueId ... readValueIdArray) throws ServiceException {
        try {
            ReadResponse readResponse = this.cnY().Read(this.getRequestHeader(), d2, timestampsToReturn, readValueIdArray);
            this.checkServiceResult(readResponse, readResponse.getDiagnosticInfos());
            this.a(readResponse.getResults(), readValueIdArray);
            return readResponse;
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    private boolean coF() throws ServiceException, ConnectException, SessionActivationException {
        logger.debug("reconnect: Reconnecting to server");
        if (this.go && !Thread.currentThread().equals(this.gM)) {
            throw new IllegalStateException("AutoReconnect is true, SDK is handling reconnections automatically, thus reconnect shall not be called manually");
        }
        try {
            this.coD();
        }
        catch (Exception exception) {
            logger.debug("Failed to create secure channel: {}", exception);
            if (exception.getCause() instanceof ServiceResultException) {
                throw new ServiceException((ServiceResultException)exception.getCause());
            }
            throw new ServiceException(exception.getMessage(), StatusCodes.Bad_ServerNotConnected, null, (Throwable)exception);
        }
        logger.debug("reconnect: secure channel created");
        boolean bl = false;
        if (this.gX == null) {
            this.coC();
        } else {
            this.a(this.gX.createSessionChannel(this.gO, this.gq));
            logger.debug("reconnect: setting channel ok");
            try {
                this.cox();
                logger.debug("reconnect: Old session re-activated");
                this.coZ();
                this.a(true);
                bl = true;
            }
            catch (SessionActivationException sessionActivationException) {
                this.coC();
            }
        }
        logger.info("reconnect: Reconnected to server " + (bl ? "(session reactivated)" : "(new session)"));
        return bl;
    }

    private WriteResponse a(WriteValue ... writeValueArray) throws ServiceException {
        try {
            WriteResponse writeResponse = this.cnY().Write(this.getRequestHeader(), writeValueArray);
            this.checkServiceResult(writeResponse, writeResponse.getDiagnosticInfos());
            this.a(writeResponse.getResults(), (Object[])writeValueArray);
            return writeResponse;
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    private void a(long l2, LocalizedText localizedText) {
        for (ServerStatusListener serverStatusListener : this.gS) {
            try {
                serverStatusListener.onShutdown(this, l2, localizedText);
            }
            catch (Exception exception) {
                logger.error("Exception in ServerStatusListener", exception);
            }
        }
    }

    private void a(ServerState serverState, ServerState serverState2) {
        for (ServerStatusListener serverStatusListener : this.gS) {
            try {
                serverStatusListener.onStateChange(this, serverState, serverState2);
            }
            catch (Exception exception) {
                logger.error("Exception in ServerStatusListener", exception);
            }
        }
    }

    private void coG() {
        for (ServerStatusListener serverStatusListener : this.gS) {
            try {
                Optional<e> optional = Optional.ofNullable(this.gR.get());
                ServerStatusDataType serverStatusDataType = optional.map(e2 -> e2.hx).orElse(null);
                StatusCode statusCode = optional.map(e2 -> e2.hy).orElse(null);
                StatusCode statusCode2 = statusCode == null ? StatusCode.GOOD : statusCode;
                serverStatusListener.onStatusChange(this, serverStatusDataType, statusCode2);
            }
            catch (Exception exception) {
                logger.error("Exception in ServerStatusListener", exception);
            }
        }
    }

    private EndpointDescription[] getEndpoints() throws InvalidServerEndpointException, ConnectException, ServiceException {
        this.gs = this.discoverEndpoints();
        if (logger.isDebugEnabled()) {
            logger.debug("endpoints:" + Arrays.toString(this.gs));
        }
        if (this.gs == null || this.gs.length == 0) {
            throw new ServiceException("GetEndpointsResponse, endpoint list received from the server is empty.", StatusCodes.Bad_UnexpectedError);
        }
        EndpointDescription[] endpointDescriptionArray = this.a(this.gs, this.coL());
        if (endpointDescriptionArray.length == 0 && this.coT()) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                endpointDescriptionArray = this.a(this.gs, this.coL().replaceFirst("localhost", inetAddress.getHostName()));
                endpointDescriptionArray = this.a(this.gs, this.coL().replaceFirst("localhost", inetAddress.getCanonicalHostName()));
            }
            catch (UnknownHostException unknownHostException) {
                logger.info("Cannot convert localhost to HostName: ", unknownHostException);
            }
        }
        if (endpointDescriptionArray.length == 0) {
            endpointDescriptionArray = this.a(this.gs, (String)null);
        }
        if (endpointDescriptionArray.length == 0) {
            throw new InvalidServerEndpointException("Requested endpoint not supported by the server", this.coL(), this.getSecurityMode());
        }
        endpointDescriptionArray = EndpointUtil.sortBySecurityLevel(endpointDescriptionArray);
        return endpointDescriptionArray;
    }

    private String coH() {
        if (this.gm == null) {
            return "";
        }
        return this.gm.getHost();
    }

    private UnsignedInteger a(Map<NodeId, DataValue> map, String string, NodeId nodeId, UnsignedInteger unsignedInteger) {
        try {
            DataValue dataValue = map.get(nodeId);
            if (dataValue.getStatusCode().isNotGood()) {
                throw new StatusException(dataValue.getStatusCode());
            }
            if (!(dataValue.getValue().getValue() instanceof UnsignedInteger)) {
                throw new IllegalStateException("OperationLimit value something else than UnsignedInteger");
            }
            return (UnsignedInteger)dataValue.getValue().getValue();
        }
        catch (Exception exception) {
            logger.warn("Could not Read OperationLimit: {} with NodeId: {}, either the server does not have the node or the read didn't return a Good value that can be interpreted as UnsignedInteger, value was: {}, using default value of {} instead (note that this will be overriden by clientside limits if lower)", string, nodeId, map.get(nodeId), unsignedInteger);
            return unsignedInteger;
        }
    }

    private UaApplication.Protocol coI() {
        if (this.gm == null) {
            return UaApplication.Protocol.OpcTcp;
        }
        return this.gm.getProtocol();
    }

    private RequestHeader a(UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2, String string) {
        RequestHeader requestHeader = new RequestHeader();
        requestHeader.setReturnDiagnostics(unsignedInteger);
        requestHeader.setTimeoutHint(unsignedInteger2);
        requestHeader.setAuditEntryId(string);
        requestHeader.setTimestamp(DateTime.currentTime());
        requestHeader.setRequestHandle(this.coU());
        return requestHeader;
    }

    private StatusCode coJ() {
        return Optional.ofNullable(this.gR.get()).map(e2 -> e2.hy).orElse(null);
    }

    private ServerStatusDataType coK() {
        return Optional.ofNullable(this.gR.get()).map(e2 -> e2.hx).orElse(null);
    }

    private SubscriptionAcknowledgement[] getSubscriptionAcknowledgements() {
        ArrayList arrayList = new ArrayList();
        this.gk.drainTo(arrayList);
        return arrayList.toArray(new SubscriptionAcknowledgement[0]);
    }

    private String coL() {
        if (this.gm == null) {
            return "";
        }
        return this.gm.getAddress();
    }

    private HistoryReadResult[] a(NodeId[] nodeIdArray, int n2, d d2) throws ServiceException, DecodingException, EncodingException {
        if (Integer.compareUnsigned(n2, Integer.MAX_VALUE) > 0) {
            n2 = Integer.MAX_VALUE;
        }
        if (n2 >= nodeIdArray.length) {
            return d2.read(nodeIdArray);
        }
        ArrayList<HistoryReadResult[]> arrayList = new ArrayList<HistoryReadResult[]>();
        for (int i2 = 0; i2 < nodeIdArray.length; i2 += n2) {
            int n3 = Math.min(n2, nodeIdArray.length - i2);
            NodeId[] nodeIdArray2 = new NodeId[n3];
            System.arraycopy(nodeIdArray, i2, nodeIdArray2, 0, n3);
            arrayList.add(d2.read(nodeIdArray2));
        }
        return (HistoryReadResult[])arrayList.stream().flatMap(Arrays::stream).toArray(HistoryReadResult[]::new);
    }

    private boolean a(PublishResponse publishResponse) throws ServiceException {
        logger.debug("handlePublishResponse: response={}", (Object)publishResponse.getNotificationMessage().getSequenceNumber());
        logger.trace("handlePublishResponse: response={}", (Object)publishResponse);
        if (this.isConnected()) {
            this.checkServiceResult(publishResponse, publishResponse.getDiagnosticInfos());
            if (this.gE != null && !this.gE.validatePublishResponse(this, publishResponse)) {
                return false;
            }
            Subscription subscription = this.getSubscriptionById(publishResponse.getSubscriptionId());
            if (subscription == null) {
                logger.info("handlePublishResponse: no subscription with ID={} SequenceNumber={}; response discarded", (Object)publishResponse.getSubscriptionId(), (Object)publishResponse.getNotificationMessage().getSequenceNumber());
                return false;
            }
            subscription.onPublishResponse(publishResponse);
            return true;
        }
        logger.debug("handlePublishResponse: not connected; response discarded");
        return false;
    }

    private DataValue[] a(NodeId nodeId, NumericRange numericRange, TimestampsToReturn timestampsToReturn, HistoryReadDetails historyReadDetails) throws ServiceException, StatusException, DecodingException {
        ByteString byteString;
        logger.debug("historyReadAll: nodeId: {}, indexRange: {}, timestampsToReturn: {}, historyReadDetails: {}", nodeId, numericRange, timestampsToReturn, historyReadDetails);
        HistoryReadValueId historyReadValueId = new HistoryReadValueId();
        historyReadValueId.setNodeId(nodeId);
        if (numericRange != null) {
            historyReadValueId.setIndexRange(numericRange.toString());
        }
        ArrayList<DataValue> arrayList = null;
        do {
            HistoryReadResult[] historyReadResultArray = this.historyRead(historyReadDetails, timestampsToReturn, false, historyReadValueId);
            this.checkOperationResult(historyReadResultArray[0].getStatusCode());
            logger.debug("historyReadAll: Got StatusCode: {}", (Object)historyReadResultArray[0].getStatusCode());
            if (historyReadResultArray[0].getStatusCode().getValue().equals(StatusCodes.Good_NoData)) {
                if (historyReadResultArray[0].getHistoryData() == null) break;
                logger.warn("historyReadAll: Received StatusCode Good_NoData, but also received HistoryData");
            }
            if (historyReadResultArray[0].getHistoryData() == null) {
                logger.debug("historyReadAll: HistoryData is null");
                break;
            }
            HistoryData historyData = (HistoryData)historyReadResultArray[0].getHistoryData();
            byteString = historyReadResultArray[0].getContinuationPoint();
            if (byteString == null && arrayList == null) {
                if (historyData.getDataValues() != null) {
                    logger.debug("historyReadAll: Read complete, returning {} values", (Object)historyData.getDataValues().length);
                } else {
                    logger.debug("historyReadAll: Read complete, returning null");
                }
                return historyData.getDataValues();
            }
            if (arrayList == null) {
                arrayList = new ArrayList<DataValue>();
            }
            arrayList.addAll(Arrays.asList(historyData.getDataValues()));
            historyReadValueId.setContinuationPoint(byteString);
            if (historyData.getDataValues().length == 0 && byteString != null) {
                logger.info("historyReadAll: Received empty HistoryData with continuationPoint");
                break;
            }
            logger.debug("historyReadAll: got {} values", (Object)historyData.getDataValues().length);
        } while (byteString != null);
        if (arrayList != null) {
            logger.debug("historyReadAll: Read complete, returning an array of {} DataValues", (Object)arrayList.size());
        } else {
            logger.debug("historyReadAll: Read complete, returning an empty DataValue array");
        }
        return arrayList == null ? new DataValue[]{} : arrayList.toArray(new DataValue[arrayList.size()]);
    }

    private HistoryReadResult[] a(NodeId[] nodeIdArray, final NumericRange numericRange, TimestampsToReturn timestampsToReturn, HistoryReadDetails historyReadDetails) throws ServiceException, DecodingException, EncodingException {
        HistoryData historyData;
        DataValue[] dataValueArray;
        Object object;
        DynamicStructure[] dynamicStructureArray;
        logger.debug("historyReadAll: nodeIds: {}, timestampsToReturn: {}, historyReadDetails: {}", nodeIdArray, timestampsToReturn, historyReadDetails);
        class A {
            private boolean ho = false;
            private StatusCode statusCode = null;
            private final List<DataValue> hp = new ArrayList<DataValue>();
            private final HistoryReadValueId hq = new HistoryReadValueId();

            public A(NodeId nodeId) {
                this.hq.setNodeId(nodeId);
                if (numericRange != null) {
                    this.hq.setIndexRange(numericRange.toString());
                }
            }

            public void setDone() {
                this.ho = true;
            }
        }
        A[] aArray = new A[nodeIdArray.length];
        ArrayList<A> arrayList = new ArrayList<A>(nodeIdArray.length);
        for (int i2 = 0; i2 < nodeIdArray.length; ++i2) {
            aArray[i2] = new A(nodeIdArray[i2]);
            arrayList.add(aArray[i2]);
        }
        do {
            dynamicStructureArray = (HistoryReadValueId[])arrayList.stream().map(a2 -> ((A)a2).hq).toArray(HistoryReadValueId[]::new);
            HistoryReadResult[] historyReadResultArray = this.historyRead(historyReadDetails, timestampsToReturn, false, (HistoryReadValueId[])dynamicStructureArray);
            for (int i3 = 0; i3 < historyReadResultArray.length; ++i3) {
                object = (A)arrayList.get(i3);
                dataValueArray = historyReadResultArray[i3];
                ((A)object).statusCode = dataValueArray.getStatusCode();
                logger.debug("historyReadAll: Got StatusCode: {}", (Object)dataValueArray.getStatusCode());
                if (dataValueArray.getStatusCode().isBad()) {
                    ((A)object).setDone();
                    continue;
                }
                if (dataValueArray.getStatusCode().getValue().equals(StatusCodes.Good_NoData)) {
                    if (dataValueArray.getHistoryData() != null) {
                        logger.warn("historyReadAll: Received StatusCode Good_NoData, but also received HistoryData");
                    } else {
                        ((A)object).setDone();
                        continue;
                    }
                }
                if (dataValueArray.getHistoryData() == null) {
                    logger.debug("historyReadAll: HistoryData is null");
                    ((A)object).setDone();
                    continue;
                }
                historyData = (HistoryData)dataValueArray.getHistoryData();
                ByteString byteString = dataValueArray.getContinuationPoint();
                if (byteString == null) {
                    ((A)object).setDone();
                }
                if (historyData.getDataValues() == null) {
                    ((A)object).setDone();
                    continue;
                }
                ((A)object).hp.addAll(Arrays.asList(historyData.getDataValues()));
                ((A)object).hq.setContinuationPoint(byteString);
                if (historyData.getDataValues().length == 0 && byteString != null) {
                    logger.info("historyReadAll: Received empty HistoryData with continuationPoint");
                    ((A)object).setDone();
                    continue;
                }
                logger.debug("historyReadAll: got {} values", (Object)historyData.getDataValues().length);
            }
            arrayList.removeIf(a2 -> ((A)a2).ho);
        } while (!arrayList.isEmpty());
        dynamicStructureArray = new HistoryReadResult[nodeIdArray.length];
        for (int i4 = 0; i4 < nodeIdArray.length; ++i4) {
            A a3 = aArray[i4];
            object = a3.hp;
            dataValueArray = object.toArray(new DataValue[object.size()]);
            historyData = new HistoryData(dataValueArray);
            dynamicStructureArray[i4] = new HistoryReadResult(a3.statusCode, null, historyData);
        }
        return dynamicStructureArray;
    }

    private HistoryEventFieldList[] b(NodeId nodeId, NumericRange numericRange, TimestampsToReturn timestampsToReturn, HistoryReadDetails historyReadDetails) throws ServiceException, StatusException, DecodingException {
        ByteString byteString;
        HistoryReadValueId historyReadValueId = new HistoryReadValueId();
        historyReadValueId.setNodeId(nodeId);
        if (numericRange != null) {
            historyReadValueId.setIndexRange(numericRange.toString());
        }
        ArrayList<HistoryEventFieldList> arrayList = null;
        do {
            HistoryReadResult[] historyReadResultArray = this.historyRead(historyReadDetails, timestampsToReturn, false, historyReadValueId);
            this.checkOperationResult(historyReadResultArray[0].getStatusCode());
            if (historyReadResultArray[0].getStatusCode().getValue().equals(StatusCodes.Good_NoData) || historyReadResultArray[0].getHistoryData() == null) break;
            HistoryEvent historyEvent = (HistoryEvent)historyReadResultArray[0].getHistoryData();
            byteString = historyReadResultArray[0].getContinuationPoint();
            if (byteString == null && arrayList == null) {
                return historyEvent.getEvents();
            }
            if (arrayList == null) {
                arrayList = new ArrayList<HistoryEventFieldList>();
            }
            arrayList.addAll(Arrays.asList(historyEvent.getEvents()));
            historyReadValueId.setContinuationPoint(byteString);
        } while (byteString != null);
        return arrayList == null ? new HistoryEventFieldList[]{} : arrayList.toArray(new HistoryEventFieldList[arrayList.size()]);
    }

    private HistoryReadResult[] b(NodeId[] nodeIdArray, final NumericRange numericRange, TimestampsToReturn timestampsToReturn, HistoryReadDetails historyReadDetails) throws ServiceException, DecodingException, EncodingException {
        HistoryEvent historyEvent;
        HistoryEventFieldList[] historyEventFieldListArray;
        Object object;
        DynamicStructure[] dynamicStructureArray;
        class B {
            private boolean ho = false;
            private StatusCode statusCode = null;
            private final List<HistoryEventFieldList> hp = new ArrayList<HistoryEventFieldList>();
            private final HistoryReadValueId hq = new HistoryReadValueId();

            public B(NodeId nodeId) {
                this.hq.setNodeId(nodeId);
                if (numericRange != null) {
                    this.hq.setIndexRange(numericRange.toString());
                }
            }

            public void setDone() {
                this.ho = true;
            }
        }
        B[] bArray = new B[nodeIdArray.length];
        ArrayList<B> arrayList = new ArrayList<B>(nodeIdArray.length);
        for (int i2 = 0; i2 < nodeIdArray.length; ++i2) {
            bArray[i2] = new B(nodeIdArray[i2]);
            arrayList.add(bArray[i2]);
        }
        do {
            dynamicStructureArray = (HistoryReadValueId[])arrayList.stream().map(b2 -> ((B)b2).hq).toArray(HistoryReadValueId[]::new);
            HistoryReadResult[] historyReadResultArray = this.historyRead(historyReadDetails, timestampsToReturn, false, (HistoryReadValueId[])dynamicStructureArray);
            for (int i3 = 0; i3 < historyReadResultArray.length; ++i3) {
                object = (B)arrayList.get(i3);
                historyEventFieldListArray = historyReadResultArray[i3];
                ((B)object).statusCode = historyEventFieldListArray.getStatusCode();
                if (historyEventFieldListArray.getStatusCode().isBad() || historyEventFieldListArray.getStatusCode().getValue().equals(StatusCodes.Good_NoData)) {
                    ((B)object).setDone();
                    continue;
                }
                if (historyEventFieldListArray.getHistoryData() == null) {
                    ((B)object).setDone();
                    continue;
                }
                historyEvent = (HistoryEvent)historyEventFieldListArray.getHistoryData();
                ByteString byteString = historyReadResultArray[0].getContinuationPoint();
                if (historyEvent.getEvents() != null) {
                    ((B)object).hp.addAll(Arrays.asList(historyEvent.getEvents()));
                }
                ((B)object).hq.setContinuationPoint(byteString);
                if (byteString != null) continue;
                ((B)object).setDone();
            }
            arrayList.removeIf(b2 -> ((B)b2).ho);
        } while (!arrayList.isEmpty());
        dynamicStructureArray = new HistoryReadResult[nodeIdArray.length];
        for (int i4 = 0; i4 < nodeIdArray.length; ++i4) {
            B b3 = bArray[i4];
            object = b3.hp;
            historyEventFieldListArray = object.toArray(new HistoryEventFieldList[object.size()]);
            historyEvent = new HistoryEvent(historyEventFieldListArray);
            dynamicStructureArray[i4] = new HistoryReadResult(b3.statusCode, null, historyEvent);
        }
        return dynamicStructureArray;
    }

    private HistoryModifiedData c(NodeId nodeId, NumericRange numericRange, TimestampsToReturn timestampsToReturn, HistoryReadDetails historyReadDetails) throws ServiceException, StatusException, DecodingException {
        ByteString byteString;
        HistoryReadValueId historyReadValueId = new HistoryReadValueId();
        historyReadValueId.setNodeId(nodeId);
        if (numericRange != null) {
            historyReadValueId.setIndexRange(numericRange.toString());
        }
        ArrayList<DataValue> arrayList = null;
        ArrayList<ModificationInfo> arrayList2 = null;
        do {
            HistoryReadResult[] historyReadResultArray = this.historyRead(historyReadDetails, timestampsToReturn, false, historyReadValueId);
            this.checkOperationResult(historyReadResultArray[0].getStatusCode());
            if (historyReadResultArray[0].getStatusCode().getValue().equals(StatusCodes.Good_NoData) || historyReadResultArray[0].getHistoryData() == null) break;
            HistoryModifiedData historyModifiedData = (HistoryModifiedData)historyReadResultArray[0].getHistoryData();
            byteString = historyReadResultArray[0].getContinuationPoint();
            if (byteString == null && arrayList == null) {
                return historyModifiedData;
            }
            if (arrayList == null) {
                arrayList = new ArrayList<DataValue>();
                arrayList2 = new ArrayList<ModificationInfo>();
            }
            arrayList.addAll(Arrays.asList(historyModifiedData.getDataValues()));
            arrayList2.addAll(Arrays.asList(historyModifiedData.getModificationInfos()));
            historyReadValueId.setContinuationPoint(byteString);
        } while (byteString != null);
        return arrayList == null ? new HistoryModifiedData(new DataValue[0], new ModificationInfo[0]) : new HistoryModifiedData(arrayList.toArray(new DataValue[arrayList.size()]), arrayList2.toArray(new ModificationInfo[arrayList2.size()]));
    }

    private HistoryReadResult[] c(NodeId[] nodeIdArray, final NumericRange numericRange, TimestampsToReturn timestampsToReturn, HistoryReadDetails historyReadDetails) throws ServiceException, DecodingException, EncodingException {
        ModificationInfo[] modificationInfoArray;
        Object object;
        DataValue[] dataValueArray;
        Object object2;
        DynamicStructure[] dynamicStructureArray;
        class C {
            private boolean ho = false;
            private StatusCode statusCode = null;
            private final List<DataValue> hp = new ArrayList<DataValue>();
            private final List<ModificationInfo> hw = new ArrayList<ModificationInfo>();
            private final HistoryReadValueId hq = new HistoryReadValueId();

            public C(NodeId nodeId) {
                this.hq.setNodeId(nodeId);
                if (numericRange != null) {
                    this.hq.setIndexRange(numericRange.toString());
                }
            }

            public void setDone() {
                this.ho = true;
            }
        }
        C[] cArray = new C[nodeIdArray.length];
        ArrayList<C> arrayList = new ArrayList<C>(nodeIdArray.length);
        for (int i2 = 0; i2 < nodeIdArray.length; ++i2) {
            cArray[i2] = new C(nodeIdArray[i2]);
            arrayList.add(cArray[i2]);
        }
        do {
            dynamicStructureArray = (HistoryReadValueId[])arrayList.stream().map(c2 -> ((C)c2).hq).toArray(HistoryReadValueId[]::new);
            HistoryReadResult[] historyReadResultArray = this.historyRead(historyReadDetails, timestampsToReturn, false, (HistoryReadValueId[])dynamicStructureArray);
            for (int i3 = 0; i3 < historyReadResultArray.length; ++i3) {
                object2 = (C)arrayList.get(i3);
                dataValueArray = historyReadResultArray[i3];
                ((C)object2).statusCode = dataValueArray.getStatusCode();
                if (dataValueArray.getStatusCode().isBad()) {
                    ((C)object2).setDone();
                    continue;
                }
                if (dataValueArray.getStatusCode().getValue().equals(StatusCodes.Good_NoData)) {
                    ((C)object2).setDone();
                    continue;
                }
                if (dataValueArray.getHistoryData() == null) {
                    ((C)object2).setDone();
                    continue;
                }
                object = (HistoryModifiedData)dataValueArray.getHistoryData();
                modificationInfoArray = dataValueArray.getContinuationPoint();
                if (((HistoryData)object).getDataValues() != null) {
                    ((C)object2).hp.addAll(Arrays.asList(((HistoryData)object).getDataValues()));
                }
                if (((HistoryModifiedData)object).getModificationInfos() != null) {
                    ((C)object2).hw.addAll(Arrays.asList(((HistoryModifiedData)object).getModificationInfos()));
                }
                ((C)object2).hq.setContinuationPoint((ByteString)modificationInfoArray);
                if (modificationInfoArray != null) continue;
                ((C)object2).setDone();
            }
            arrayList.removeIf(c2 -> ((C)c2).ho);
        } while (!arrayList.isEmpty());
        dynamicStructureArray = new HistoryReadResult[nodeIdArray.length];
        for (int i4 = 0; i4 < nodeIdArray.length; ++i4) {
            C c3 = cArray[i4];
            object2 = c3.hp;
            dataValueArray = object2.toArray(new DataValue[object2.size()]);
            object = c3.hw;
            modificationInfoArray = object.toArray(new ModificationInfo[object.size()]);
            HistoryModifiedData historyModifiedData = new HistoryModifiedData(dataValueArray, modificationInfoArray);
            dynamicStructureArray[i4] = new HistoryReadResult(c3.statusCode, null, historyModifiedData);
        }
        return dynamicStructureArray;
    }

    private void coM() throws SessionActivationException {
        if (this.isConnected()) {
            this.cox();
        }
    }

    private void coN() {
        Application application = this.gq.getApplication();
        application.setApplicationName(this.getApplicationIdentity().getApplicationDescription().getApplicationName());
        application.setApplicationUri(this.getApplicationIdentity().getApplicationDescription().getApplicationUri());
        application.setProductUri(this.getApplicationIdentity().getApplicationDescription().getProductUri());
    }

    private void coO() {
        this.gq.getApplication().setApplicationUri(this.applicationIdentity.getApplicationDescription().getApplicationUri());
        this.gq.getApplication().removeApplicationInstanceCertificates();
        if (this.applicationIdentity.getKeys() != null) {
            this.gq.getApplication().addApplicationInstanceCertificate(this.applicationIdentity.getKeys());
        }
        this.gq.getApplicationHttpsSettings().readFrom(this.gy);
        this.gq.getApplicationHttpsSettings().setKeyPair(this.applicationIdentity.getHttpsCertificate(), new Cert[0]);
        this.gq.getApplicatioOpcTcpSettings().setConnectTimeout(this.connectTimeout);
        this.gq.getApplicatioOpcTcpSettings().setReverseHelloAcceptTimeout(this.connectTimeout);
        this.gq.getApplicatioOpcTcpSettings().setSocketFactory(this.hm);
    }

    private void coP() throws InvalidServerEndpointException, ConnectException, ServiceException {
        if (this.coL() == null) {
            throw new NullPointerException("Uri not defined.");
        }
        EndpointDescription[] endpointDescriptionArray = this.getEndpoints();
        this.gv = endpointDescriptionArray[endpointDescriptionArray.length - 1];
        if (!this.gv.getEndpointUrl().equals(this.coL())) {
            logger.info("Using an alternate endpoint URL '{}' instead of the requested '{}'", (Object)this.gv.getEndpointUrl(), (Object)this.coL());
        }
        logger.debug("initEndpoint: endpoint={}", (Object)this.gv);
    }

    private DataValue coQ() {
        OperationLimits.Builder builder;
        Map<NodeId, DataValue> map;
        i i2;
        HashSet<NodeId> hashSet;
        try {
            hashSet = new HashSet<NodeId>();
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerRead);
            i2 = this.getAddressSpace().a(hashSet, Attributes.Value, TimestampsToReturn.Both, false);
            map = i2.d(Attributes.Value);
            builder = this.getOperationLimits().toBuilder();
            builder.setMaxNodesPerRead(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerRead", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerRead, UnsignedInteger.MAX_VALUE));
            this.gl = OperationLimits.min(this.getOperationLimits(), builder.build());
            logger.debug("MaxNodesPerRead OperationLimits: {}", (Object)this.gl.getMaxNodesPerRead());
        }
        catch (Exception exception) {
            this.gl = this.getOperationLimits();
            logger.warn("Could not read the MaxNodesPerRead OperationLimit, using default: {}", (Object)this.getActualOperationLimits().getMaxNodesPerRead(), (Object)exception);
        }
        try {
            hashSet = new HashSet();
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerBrowse);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds);
            hashSet.add(VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerWrite);
            hashSet.add(Identifiers.Server_NamespaceArray);
            i2 = this.getAddressSpace().a(hashSet, Attributes.Value, TimestampsToReturn.Both, false);
            map = i2.d(Attributes.Value);
            builder = OperationLimits.builder();
            builder.setMaxNodesPerRead(this.getActualOperationLimits().getMaxNodesPerRead());
            builder.setMaxMonitoredItemsPerCall(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxMonitoredItemsPerCall", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxMonitoredItemsPerCall, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerBrowse(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerBrowse", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerBrowse, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerHistoryReadData(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerHistoryReadData", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadData, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerHistoryReadEvents(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerHistoryReadEvents", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryReadEvents, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerHistoryUpdateData(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerHistoryUpdateData", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateData, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerHistoryUpdateEvents(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerHistoryUpdateEvents", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerHistoryUpdateEvents, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerMethodCall(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerMethodCall", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerMethodCall, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerNodeManagement(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerNodeManagement", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerNodeManagement, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerRegisterNodes(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerRegisterNodes", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerRegisterNodes, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerTranslateBrowsePathsToNodeIds(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerTranslateBrowsePathsToNodeIds", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerTranslateBrowsePathsToNodeIds, UnsignedInteger.MAX_VALUE));
            builder.setMaxNodesPerWrite(this.a(map, "Server/ServerCapabilities/OperationLimits/MaxNodesPerWrite", VariableIdentifiers.Server_ServerCapabilities_OperationLimits_MaxNodesPerWrite, UnsignedInteger.MAX_VALUE));
            OperationLimits operationLimits = builder.build();
            OperationLimits operationLimits2 = this.getOperationLimits();
            this.gl = OperationLimits.min(operationLimits, operationLimits2);
            logger.debug("Initialized OperationLimits to: {}, client side limits were: {} and serverside limits were: {}", this.gl, operationLimits2, operationLimits);
            logger.info("Using {}", (Object)this.gl);
            return map.get(Identifiers.Server_NamespaceArray);
        }
        catch (NullPointerException nullPointerException) {
            logger.info("Server doesn't support OperationLimits nodes or gives Null values, using client defaults: {}", (Object)this.getOperationLimits(), (Object)nullPointerException);
            this.gl = this.getOperationLimits();
            return null;
        }
        catch (Exception exception) {
            this.gl = this.getOperationLimits();
            logger.info("Failed to init OperationLimits from the server, using client defaults: {}", (Object)this.getOperationLimits(), (Object)exception);
            return null;
        }
    }

    private void coR() throws ServiceException {
        StatusCode statusCode;
        if (this.gv == null) {
            throw new IllegalStateException("Endpoint should not be null");
        }
        if (this.gv.getServerCertificate() == null && !this.gP.getMessageSecurityMode().equals(MessageSecurityMode.None)) {
            throw new ServiceException("Missing server certificate", StatusCodes.Bad_CertificateInvalid);
        }
        Cert cert = null;
        if (this.gv.getServerCertificate() != null && this.gv.getServerCertificate().getLength() != 0) {
            try {
                cert = new Cert(this.gv.getServerCertificate().getValue());
            }
            catch (ServiceResultException serviceResultException) {
                throw new ServiceException(serviceResultException);
            }
        }
        this.gQ = new ApplicationIdentity(cert, null);
        this.gQ.setApplicationDescription(this.gv.getServer(), false);
        if (!this.gP.getMessageSecurityMode().equals(MessageSecurityMode.None) && (statusCode = this.validateApplicationCertificate(this.gQ)).isBad()) {
            throw new ServiceException("Invalid server certificate", statusCode);
        }
    }

    private void coS() {
        if (this.hk) {
            try {
                this.hg.init();
            }
            catch (TypeDictionaryException typeDictionaryException) {
                logger.warn("Could not init TypeDictionary, decoding custom Structures might not work", typeDictionaryException);
            }
        }
        if (this.hl) {
            this.getEncoderContext().setDynamicDataTypeSpecificationProvider(uaNodeId -> {
                logger.debug("Trying to resolve id {} DataTypeSpecification", uaNodeId);
                UaDataTypeSpecification uaDataTypeSpecification = this.hg.getDataTypeSpecification((UaNodeId)uaNodeId);
                if (uaDataTypeSpecification == null) {
                    logger.debug("Could not resolve id {} DataTypeSpecification", uaNodeId);
                } else {
                    logger.debug("Resolved id {} DataTypeSpecification to: {}", uaNodeId, (Object)uaDataTypeSpecification);
                }
                return uaDataTypeSpecification;
            });
        }
    }

    private boolean coT() {
        return this.coH().isEmpty() || this.coH().toLowerCase(Locale.ROOT).equals("localhost");
    }

    private UnsignedInteger coU() {
        long l2 = 0L;
        while (l2 == 0L) {
            long l3 = this.gB.incrementAndGet();
            l2 = l3 & 0xFFFFFFFFL;
        }
        return UnsignedInteger.valueOf(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void coV() {
        if (this.isConnected() && this.gM != null) {
            UaClient uaClient = this;
            synchronized (uaClient) {
                this.notify();
            }
        }
    }

    private DataValue g(Object object) {
        DataValue dataValue;
        if (object instanceof DataValue) {
            dataValue = (DataValue)object;
        } else {
            Variant variant = this.h(object);
            dataValue = new DataValue(variant, StatusCode.GOOD);
        }
        return dataValue;
    }

    private Variant h(Object object) {
        Variant variant = object instanceof Variant ? (Variant)object : new Variant(object);
        return variant;
    }

    private BuildInfo coW() throws ServiceException {
        NodeId[] nodeIdArray = new NodeId[]{Identifiers.Server_ServerStatus_BuildInfo_ProductUri, Identifiers.Server_ServerStatus_BuildInfo_ManufacturerName, Identifiers.Server_ServerStatus_BuildInfo_ProductName, Identifiers.Server_ServerStatus_BuildInfo_SoftwareVersion, Identifiers.Server_ServerStatus_BuildInfo_BuildNumber, Identifiers.Server_ServerStatus_BuildInfo_BuildDate};
        DataValue[] dataValueArray = this.readValues(nodeIdArray, TimestampsToReturn.Neither);
        BuildInfo buildInfo = new BuildInfo(dataValueArray[0].getValue().asClass(String.class, null), dataValueArray[1].getValue().asClass(String.class, null), dataValueArray[2].getValue().asClass(String.class, null), dataValueArray[3].getValue().asClass(String.class, null), dataValueArray[4].getValue().asClass(String.class, null), dataValueArray[5].getValue().asClass(DateTime.class, null));
        return buildInfo;
    }

    private AsyncResult<i> a(boolean bl, final Map<NodeId, Set<UnsignedInteger>> map, final TimestampsToReturn timestampsToReturn) {
        if (!bl) {
            final AsyncResultImpl<i> asyncResultImpl = new AsyncResultImpl<i>();
            StackUtils.getBlockingWorkExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        asyncResultImpl.setResult(UaClient.this.b(false, map, timestampsToReturn));
                    }
                    catch (ServiceException serviceException) {
                        asyncResultImpl.setError(new ServiceResultException(serviceException.getServiceResult(), (Throwable)serviceException));
                    }
                }
            });
            return asyncResultImpl;
        }
        int n2 = this.getActualOperationLimits().getMaxNodesPerRead().intValue();
        Set<h> set = h.a(map, timestampsToReturn).b(n2);
        final HashSet<AsyncResult<i>> hashSet = new HashSet<AsyncResult<i>>();
        for (h h2 : set) {
            hashSet.add(this.a(false, h2.cop(), h2.getTimestampsToReturn()));
        }
        final AsyncResultImpl asyncResultImpl = new AsyncResultImpl();
        StackUtils.getBlockingWorkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                HashSet<i> hashSet2 = new HashSet<i>();
                for (AsyncResult asyncResult : hashSet) {
                    try {
                        hashSet2.add((i)asyncResult.waitForResult());
                    }
                    catch (ServiceResultException serviceResultException) {
                        asyncResultImpl.setError(serviceResultException);
                        break;
                    }
                }
                asyncResultImpl.setResult(i.c(hashSet2));
            }
        });
        return asyncResultImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void coX() throws ServiceException {
        NodeId[] nodeIdArray = new NodeId[]{Identifiers.Server_ServerStatus_StartTime, Identifiers.Server_ServerStatus_CurrentTime, Identifiers.Server_ServerStatus_State, Identifiers.Server_ServerStatus_SecondsTillShutdown, Identifiers.Server_ServerStatus_ShutdownReason, Identifiers.Server_ServerStatus_BuildInfo};
        DataValue[] dataValueArray = this.readValues(nodeIdArray, TimestampsToReturn.Neither);
        DateTime dateTime = null;
        DateTime dateTime2 = null;
        ServerState serverState = null;
        BuildInfo buildInfo = null;
        UnsignedInteger unsignedInteger = null;
        LocalizedText localizedText = null;
        try {
            dateTime = dataValueArray[0].getValue().asClass(DateTime.class, null);
            dateTime2 = dataValueArray[1].getValue().asClass(DateTime.class, null);
            serverState = dataValueArray[2].getValue().asClass(ServerState.class, null);
            if (serverState == null) {
                serverState = ServerState.valueOf(((Number)dataValueArray[2].getValue().asClass(Number.class, ServerState.Unknown.getValue())).intValue());
            }
            if ((unsignedInteger = (UnsignedInteger)dataValueArray[3].getValue().asClass(UnsignedInteger.class, null)) == null) {
                Number number = dataValueArray[3].getValue().asClass(Number.class, 0);
                unsignedInteger = UnsignedInteger.valueOf(number.intValue());
            }
            if ((localizedText = (LocalizedText)dataValueArray[4].getValue().asClass(LocalizedText.class, null)) == null) {
                localizedText = new LocalizedText((String)dataValueArray[4].getValue().asClass(String.class, null), Locale.getDefault());
            }
            if ((buildInfo = (BuildInfo)dataValueArray[5].getValue().asClass(BuildInfo.class, null)) == null) {
                buildInfo = this.coW();
            }
            this.a(new ServerStatusDataType(dateTime, dateTime2, serverState, buildInfo, unsignedInteger, localizedText), StatusCode.GOOD);
            this.gT.set(true);
        }
        catch (Exception exception) {
            logger.debug("Failure in readServerStatusElements", exception);
        }
        finally {
            this.a(new ServerStatusDataType(dateTime, dateTime2, serverState, buildInfo, unsignedInteger, localizedText), StatusCode.GOOD);
            this.gT.set(true);
        }
    }

    private synchronized void b(DataValue dataValue) throws ServiceException, StatusException {
        String[] stringArray = this.getEncoderContext().getNamespaceTable().toArray();
        DataValue dataValue2 = dataValue != null ? dataValue : this.readValue(Identifiers.Server_NamespaceArray);
        this.getEncoderContext().setNamespaceTable(NamespaceTable.createFromArray((String[])dataValue2.getValue().getValue()));
        this.gG = true;
        String[] stringArray2 = this.getEncoderContext().getNamespaceTable().toArray();
        if (stringArray2.length < stringArray.length) {
            logger.warn("refreshNamespaceTable, the old NamespaceArray: {} is not a subset of new NamespaceArray: {}, older NamespaceIndexes are obsolete", (Object)stringArray, (Object)stringArray2);
        } else {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (Objects.equals(stringArray[i2], stringArray2[i2])) continue;
                logger.warn("refreshNamespaceTable, the old NamespaceArray: {} is not a subset of new NamespaceArray: {}, older NamespaceIndexes are obsolete", (Object)stringArray, (Object)stringArray2);
                break;
            }
        }
        logger.debug("refreshNamespaceTable, old: {}, new: {}", (Object)stringArray, (Object)stringArray2);
    }

    private void coY() throws ServiceException, StatusException {
        DataValue dataValue = this.readValue(Identifiers.Server_ServerArray);
        this.getEncoderContext().setServerTable(ServerTable.createFromArray((String[])dataValue.getValue().getValue()));
        this.gU = true;
    }

    private void coZ() {
        for (Subscription subscription : this.hh) {
            try {
                subscription.republishAllAvailable();
            }
            catch (ServiceException serviceException) {
                logger.info("Subscription ID={} no longer valid (), recreating", (Object)subscription.getSubscriptionId(), (Object)serviceException.getServiceResult());
                subscription.reset();
            }
        }
    }

    private EndpointDescription[] a(EndpointDescription[] endpointDescriptionArray, String string) {
        return EndpointUtil.select(endpointDescriptionArray, string, this.coI().toString(), this.gP.getMessageSecurityMode(), this.gP.getSecurityPolicy(), null);
    }

    private void a(SessionChannel sessionChannel) {
        if (sessionChannel != null && Thread.currentThread().isInterrupted()) {
            sessionChannel.closeAsync();
            logger.debug("Closing SessionChannel due to Thread interruption");
            return;
        }
        SessionChannel sessionChannel2 = this.gp.getAndSet(sessionChannel);
        if (sessionChannel2 != null) {
            sessionChannel2.setRequestValidator(null);
        }
        if (sessionChannel != null) {
            sessionChannel.setRequestValidator(this.gD);
        }
    }

    private void a(ServerStatusDataType serverStatusDataType, StatusCode statusCode) {
        if (Thread.currentThread().isInterrupted()) {
            logger.trace("The current thread isInterruped() is true, skipping setting server status");
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("setServerStatusAndError: Status=" + (serverStatusDataType == null ? "null" : serverStatusDataType.getState()) + " Code=" + statusCode);
        }
        this.gR.set(new e(serverStatusDataType, statusCode));
    }

    private void a(ServerStatusDataType serverStatusDataType, UnsignedInteger unsignedInteger) {
        this.a(serverStatusDataType, StatusCode.valueOf(unsignedInteger));
    }

    private void a(Session session) {
        Session session2 = this.gX;
        this.gX = session;
    }

    private NodeId toNodeId(ExpandedNodeId expandedNodeId) throws StatusException {
        try {
            return this.getNamespaceTable().toNodeId(expandedNodeId);
        }
        catch (ServiceResultException serviceResultException) {
            throw new StatusException(serviceResultException);
        }
    }

    private NodeId[] a(ExpandedNodeId[] expandedNodeIdArray) throws StatusException {
        NodeId[] nodeIdArray = new NodeId[expandedNodeIdArray.length];
        for (int i2 = 0; i2 < expandedNodeIdArray.length; ++i2) {
            nodeIdArray[i2] = this.toNodeId(expandedNodeIdArray[i2]);
        }
        return nodeIdArray;
    }

    private NodeId e(UaNodeId uaNodeId) throws StatusException {
        try {
            return this.getNamespaceTable().toNodeId(uaNodeId.asLocalExpandedNodeId());
        }
        catch (ServiceResultException serviceResultException) {
            throw new StatusException(serviceResultException);
        }
    }

    private NodeId[] a(UaNodeId[] uaNodeIdArray) throws StatusException {
        NodeId[] nodeIdArray = new NodeId[uaNodeIdArray.length];
        for (int i2 = 0; i2 < uaNodeIdArray.length; ++i2) {
            nodeIdArray[i2] = this.e(uaNodeIdArray[i2]);
        }
        return nodeIdArray;
    }

    private TransferResult[] cpa() throws ServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug("transferSubscriptions: subscriptions.size()={}", (Object)this.hh.size());
        }
        if (this.hh.size() > 0) {
            TransferSubscriptionsResponse transferSubscriptionsResponse;
            ArrayList<Subscription> arrayList = new ArrayList<Subscription>();
            ArrayList<UnsignedInteger> arrayList2 = new ArrayList<UnsignedInteger>();
            for (Subscription transferResultArray2 : this.hh) {
                UnsignedInteger unsignedInteger = transferResultArray2.getSubscriptionId();
                if (unsignedInteger == null || UnsignedInteger.ZERO.equals(unsignedInteger)) continue;
                arrayList.add(transferResultArray2);
                arrayList2.add(unsignedInteger);
            }
            if (arrayList.isEmpty()) {
                return new TransferResult[0];
            }
            try {
                transferSubscriptionsResponse = this.cnY().TransferSubscriptions(this.getRequestHeader(), arrayList2.toArray(new UnsignedInteger[0]), true);
            }
            catch (ServiceFaultException serviceFaultException) {
                throw new ServiceException(serviceFaultException);
            }
            catch (ServiceResultException serviceResultException) {
                throw new ServiceException(serviceResultException);
            }
            this.checkServiceResult(transferSubscriptionsResponse, transferSubscriptionsResponse.getDiagnosticInfos());
            TransferResult[] transferResultArray = transferSubscriptionsResponse.getResults();
            this.a(transferResultArray, arrayList);
            return transferResultArray;
        }
        return new TransferResult[0];
    }

    private void cpb() {
        int n2 = 0;
        for (UaApplication.DiagnosticMask diagnosticMask : this.gH) {
            n2 += diagnosticMask.getValue();
        }
        n2 <<= 5;
        for (UaApplication.DiagnosticMask diagnosticMask : this.gW) {
            n2 += diagnosticMask.getValue();
        }
        this.gr = UnsignedInteger.valueOf(n2);
    }

    protected void addSubscriptionAck(SubscriptionAcknowledgement subscriptionAcknowledgement) {
        this.gk.add(subscriptionAcknowledgement);
    }

    protected HttpsSecurityPolicy[] getHttpsSecurityPolicies() {
        return this.getHttpsSettings().getHttpsSecurityPolicies();
    }

    protected void resetPublishRequestSetpoint() {
        this.gJ.set(0);
    }

    protected void resetSubscriptionsAfterRemove(Subscription[] subscriptionArray, StatusCode[] statusCodeArray) {
        for (int i2 = 0; i2 < subscriptionArray.length; ++i2) {
            if (subscriptionArray[i2].getClient() == this) {
                subscriptionArray[i2].reset();
            }
            boolean bl = this.hh.remove(subscriptionArray[i2]);
            if (statusCodeArray[i2] != null) continue;
            statusCodeArray[i2] = bl ? StatusCode.GOOD : StatusCode.valueOf(StatusCodes.Good_NoData);
        }
    }

    protected UaAddress resolveConnectionAddress(UaAddress uaAddress, EndpointDescription endpointDescription) {
        try {
            UaAddress uaAddress2 = UaAddress.parse(endpointDescription.getEndpointUrl());
            String string = uaAddress2.getServerName() == null ? "" : uaAddress2.getServerName();
            return UaAddress.fromComponents(uaAddress.getProtocol(), uaAddress.getHost(), uaAddress.getPort(), string);
        }
        catch (Exception exception) {
            logger.warn("Could not use ServerName component part from EndpointDescription: " + endpointDescription, exception);
            return uaAddress;
        }
    }

    protected void setHttpsSecurityPolicies(HttpsSecurityPolicy[] httpsSecurityPolicyArray) {
        this.getHttpsSettings().setHttpsSecurityPolicies(httpsSecurityPolicyArray);
    }

    protected <T extends ServiceResponse> void validateServiceRequest(ServiceRequest<T> serviceRequest) throws ServiceResultException {
    }

    void checkOperationResult(StatusCode statusCode) throws StatusException {
        if (statusCode.isBad()) {
            DiagnosticInfo[] diagnosticInfoArray = this.gA.get();
            if (diagnosticInfoArray == null || diagnosticInfoArray.length == 0) {
                throw new StatusException(statusCode);
            }
            throw new StatusException(statusCode, diagnosticInfoArray[0]);
        }
    }

    void a(Object[] objectArray, Object[] objectArray2) throws ServiceException {
        if (objectArray == null) {
            throw new ServiceException("Results == null");
        }
        if (objectArray.length != objectArray2.length) {
            throw new ServiceException("Size of results differs from requested");
        }
    }

    void checkServiceResult(ServiceResponse serviceResponse, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        ResponseHeader responseHeader = serviceResponse.getResponseHeader();
        this.gC.set(responseHeader);
        this.gA.set(diagnosticInfoArray);
        if (responseHeader.getServiceResult().isBad()) {
            throw new ServiceException(responseHeader.getServiceResult(), responseHeader.getServiceDiagnostics());
        }
    }

    SessionChannel cnY() throws ServerConnectionException {
        logger.trace("getChannel");
        return Optional.ofNullable(this.gp.get()).orElseThrow(() -> new ServerConnectionException("Server not connected", this.coL(), this.gP));
    }

    UnsignedInteger cpc() {
        return this.gr;
    }

    NamespaceTable a(boolean bl, DataValue dataValue) throws ServiceException, StatusException {
        if (!this.gG || bl) {
            this.b(dataValue);
        }
        return this.getNamespaceTable();
    }

    RequestHeader getRequestHeader() {
        return this.a(this.gr, this.hd, this.gn);
    }

    void cpd() {
        this.registerModel(ClientInformationModel.MODEL);
        this.registerModel(GdsClientInformationModel.MODEL);
        if (this.isAutoDiscoverCodegenModels()) {
            this.registerAutoDiscoveredModels(ClientCodegenModelProvider.class);
        }
    }

    SubscriptionBase a(SubscriptionBase subscriptionBase) throws ServiceException, ServerConnectionException {
        logger.debug("modifySubscription: isConnected={}", (Object)this.isConnected());
        if (this.isConnected()) {
            ModifySubscriptionResponse modifySubscriptionResponse;
            try {
                logger.debug("modifySubscription: subscription={}", (Object)subscriptionBase);
                modifySubscriptionResponse = this.cnY().ModifySubscription(this.getRequestHeader(), subscriptionBase.getSubscriptionId(), subscriptionBase.getPublishingInterval(), UnsignedInteger.valueOf(subscriptionBase.getLifetimeCount()), UnsignedInteger.valueOf(subscriptionBase.getMaxKeepAliveCount()), UnsignedInteger.valueOf(subscriptionBase.getMaxNotificationsPerPublish()), UnsignedByte.valueOf(subscriptionBase.getPriority()));
                logger.debug("modifySubscription: response={}", (Object)modifySubscriptionResponse.getResponseHeader().getServiceResult());
            }
            catch (ServiceFaultException serviceFaultException) {
                logger.debug("modifySubscription: exception={}", serviceFaultException);
                throw new ServiceException(serviceFaultException);
            }
            catch (ServiceResultException serviceResultException) {
                logger.debug("modifySubscription: exception={}", serviceResultException);
                throw new ServiceException(serviceResultException);
            }
            this.checkServiceResult(modifySubscriptionResponse, null);
            subscriptionBase.setPublishingInterval(modifySubscriptionResponse.getRevisedPublishingInterval());
            subscriptionBase.setLifetimeCount(modifySubscriptionResponse.getRevisedLifetimeCount());
            subscriptionBase.setMaxKeepAliveCount(modifySubscriptionResponse.getRevisedMaxKeepAliveCount());
        }
        return subscriptionBase;
    }

    i b(boolean bl, Map<NodeId, Set<UnsignedInteger>> map, TimestampsToReturn timestampsToReturn) throws ServiceException {
        Object object;
        int n2;
        DataValue[] dataValueArray;
        if (bl) {
            try {
                return this.a(true, map, timestampsToReturn).waitForResult();
            }
            catch (ServiceResultException serviceResultException) {
                if (serviceResultException.getCause() instanceof ServiceException) {
                    throw (ServiceException)serviceResultException.getCause();
                }
                throw new ServiceException("Could not Read", serviceResultException);
            }
        }
        Double d2 = 0.0;
        ArrayList<ReadValueId> arrayList = new ArrayList<ReadValueId>();
        HashMap hashMap = new HashMap();
        for (Map.Entry<NodeId, Set<UnsignedInteger>> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), new HashMap());
            for (UnsignedInteger unsignedInteger : entry.getValue()) {
                arrayList.add(new ReadValueId(entry.getKey(), unsignedInteger, null, null));
            }
        }
        ReadValueId[] readValueIdArray2 = arrayList.toArray(new ReadValueId[0]);
        int n3 = 0;
        if (readValueIdArray2.length > 1 && this.getActualOperationLimits() != null) {
            try {
                n3 = this.getActualOperationLimits().getMaxNodesPerRead().intValue();
            }
            catch (Exception exception) {
                logger.debug("read: Failed to get operationLimits.MaxNodesPerRead: ", exception);
            }
        }
        int n4 = 0;
        if (n3 > 0 && n3 < readValueIdArray2.length) {
            dataValueArray = new DataValue[readValueIdArray2.length];
            for (n2 = 0; n2 < readValueIdArray2.length; n2 += n3) {
                int n5 = Math.min(n3, readValueIdArray2.length - n2);
                ReadValueId[] readValueIdArray3 = Arrays.copyOfRange(readValueIdArray2, n2, n2 + n5);
                object = this.a(d2, timestampsToReturn, readValueIdArray3);
                ++n4;
                for (int i2 = 0; i2 < n5; ++i2) {
                    dataValueArray[n2 + i2] = ((ReadResponse)object).getResults()[i2];
                }
            }
        } else {
            ReadResponse readResponse = this.a(d2, timestampsToReturn, readValueIdArray2);
            ++n4;
            dataValueArray = readResponse.getResults();
        }
        for (n2 = 0; n2 < dataValueArray.length; ++n2) {
            DataValue dataValue = dataValueArray[n2];
            NodeId nodeId = ((ReadValueId)arrayList.get(n2)).getNodeId();
            object = ((ReadValueId)arrayList.get(n2)).getAttributeId();
            ((Map)hashMap.get(nodeId)).put(object, dataValue);
        }
        HashMap hashMap2 = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            hashMap2.put(entry.getKey(), Collections.unmodifiableMap((Map)entry.getValue()));
        }
        return i.b(Collections.unmodifiableMap(hashMap2), n4);
    }

    void g(UnsignedInteger unsignedInteger) {
        this.gr = unsignedInteger;
    }

    void b(SubscriptionBase subscriptionBase) throws ServiceException, StatusException {
        if (this.isConnected()) {
            SetPublishingModeResponse setPublishingModeResponse;
            try {
                setPublishingModeResponse = this.cnY().SetPublishingMode(this.getRequestHeader(), subscriptionBase.isPublishingEnabled(), subscriptionBase.getSubscriptionId());
            }
            catch (ServiceFaultException serviceFaultException) {
                throw new ServiceException(serviceFaultException);
            }
            catch (ServiceResultException serviceResultException) {
                throw new ServiceException(serviceResultException);
            }
            this.checkServiceResult(setPublishingModeResponse, setPublishingModeResponse.getDiagnosticInfos());
            this.checkOperationResult(setPublishingModeResponse.getResults()[0]);
        }
    }

    synchronized void startPublishing() {
        logger.debug("startPublishing");
        if (this.gM == null) {
            this.gL = new f(this);
            this.gM = new Thread(this.gL);
            this.gM.setName("PublishTask-" + this.toString());
            this.gM.start();
        }
        if (this.gN == null) {
            // empty if block
        }
    }

    synchronized void stopPublishing() {
        Thread thread = null;
        if (this.gM != null) {
            thread = this.gM;
            logger.debug("stopPublishing: interrupting publishThread");
            this.notify();
            this.gL.terminate();
            this.gM.interrupt();
            this.gL = null;
            this.gM = null;
        }
        if (this.gN != null) {
            logger.debug("canceling publishTimer");
            this.gN.cancel();
            this.gN = null;
        }
        if (thread != null && Thread.currentThread() != thread) {
            try {
                long l2 = System.currentTimeMillis();
                thread.join(60000L);
                long l3 = System.currentTimeMillis();
                if (l3 - l2 > 55000L) {
                    logger.warn("Potential internal error, PublishTask Thread join 60s wait elapsed");
                }
            }
            catch (InterruptedException interruptedException) {
                logger.debug("Interrupted while waiting for PublishTask Thread join");
            }
        }
    }

    static {
        gj = new HashMap();
        UaClient.a(Attributes.AccessLevel, UnsignedByte.class);
        UaClient.a(Attributes.ArrayDimensions, UnsignedInteger[].class);
        UaClient.a(Attributes.BrowseName, QualifiedName.class);
        UaClient.a(Attributes.ContainsNoLoops, Boolean.class);
        UaClient.a(Attributes.DataType, NodeId.class);
        UaClient.a(Attributes.Description, LocalizedText.class);
        UaClient.a(Attributes.DisplayName, LocalizedText.class);
        UaClient.a(Attributes.EventNotifier, UnsignedByte.class);
        UaClient.a(Attributes.Executable, Boolean.class);
        UaClient.a(Attributes.Historizing, Boolean.class);
        UaClient.a(Attributes.InverseName, LocalizedText.class);
        UaClient.a(Attributes.IsAbstract, Boolean.class);
        UaClient.a(Attributes.MinimumSamplingInterval, Double.class);
        UaClient.a(Attributes.NodeClass, Integer.class);
        UaClient.a(Attributes.NodeId, NodeId.class);
        UaClient.a(Attributes.Symmetric, Boolean.class);
        UaClient.a(Attributes.UserAccessLevel, UnsignedByte.class);
        UaClient.a(Attributes.UserExecutable, Boolean.class);
        UaClient.a(Attributes.UserWriteMask, UnsignedInteger.class);
        UaClient.a(Attributes.ValueRank, Integer.class);
        UaClient.a(Attributes.WriteMask, UnsignedInteger.class);
        gh = new HashSet<StatusCode>(Arrays.asList(StatusCode.valueOf(StatusCodes.Bad_ServerNotConnected), StatusCode.valueOf(StatusCodes.Bad_Timeout), StatusCode.valueOf(StatusCodes.Bad_SessionClosed), StatusCode.valueOf(StatusCodes.Bad_SecureChannelIdInvalid), StatusCode.valueOf(StatusCodes.Bad_SecureChannelClosed), StatusCode.valueOf(StatusCodes.Bad_SessionIdInvalid), StatusCode.valueOf(StatusCodes.Bad_SessionNotActivated)));
        gi = false;
    }

    static class f
    implements Runnable {
        private long hz;
        private final Logger logger = LoggerFactory.getLogger(f.class);
        private final AtomicInteger hA = new AtomicInteger(0);
        private volatile boolean hB = false;
        private final AtomicInteger hC = new AtomicInteger(0);
        private final UaClient eq;
        private volatile a hD;

        f(UaClient uaClient) {
            this.eq = uaClient;
            this.hD = new a(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.logger.debug("run");
            while (!this.hB) {
                this.cpi();
                this.cpn();
                this.cpj();
                if (!this.hB) {
                    this.cpg();
                }
                try {
                    this.logger.trace("sleep");
                    f f2 = this;
                    synchronized (f2) {
                        this.wait(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.logger.debug("interrupted");
                }
            }
            this.logger.debug("terminated");
        }

        public void terminate() {
            this.hD.terminate();
            this.hB = true;
        }

        private void cpg() {
            this.logger.trace("checkServerStatus: statusCheckInterval={}", (Object)this.eq.hb);
            if (this.eq.hb > 0L) {
                StatusCode statusCode;
                boolean bl = this.eq.coK() != null;
                ServerState serverState = this.eq.getServerState();
                boolean bl2 = serverState.equals(ServerState.CommunicationFault);
                if (bl2 && (statusCode = this.eq.coJ()) != null) {
                    if (gi) {
                        UnsignedInteger unsignedInteger = statusCode.getValue();
                        bl2 = this.h(unsignedInteger);
                    } else {
                        bl2 = statusCode.isBad() || statusCode.isUncertain();
                    }
                }
                boolean bl3 = bl2 || serverState.equals(ServerState.Shutdown) && System.currentTimeMillis() > this.eq.ha;
                boolean bl4 = System.currentTimeMillis() - this.hz > this.eq.hb;
                this.logger.trace("checkServerStatus: hasStatus={} commError={} isConnected={} timeToCheck={} timeToReconnect={}, status={}", bl, bl2, this.eq.isConnected(), bl4, bl3, this.eq.coJ());
                if (this.eq.isAutoReconnect() && bl3) {
                    try {
                        this.eq.reconnect();
                        bl4 = true;
                    }
                    catch (Exception exception) {
                        this.logger.debug("checkServerStatus: reconnect failed: ", exception);
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {
                            this.logger.debug("Interrupted", interruptedException);
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                }
                if (this.eq.isConnected() && (!bl || bl4)) {
                    if (this.eq.gx) {
                        this.eq.a(false);
                    }
                    for (Subscription subscription : this.eq.hh) {
                        subscription.recreateMonitoredItems();
                    }
                    this.eq.updateServerStatus();
                    this.hz = System.currentTimeMillis();
                }
            }
        }

        private void cph() {
            for (Subscription subscription : this.eq.hh) {
                subscription.checkTimeout();
            }
        }

        private int cpi() {
            int n2 = this.eq.gJ.get();
            int n3 = this.hA.get();
            int n4 = this.hC.getAndSet(0);
            if (n4 > 0) {
                this.logger.debug("decrementPublishRequestSetpoint: sp={} currentCount={} tooManyPublishRequests={}", n2, n3, n4);
                n2 = n2 == 0 || n3 > 0 && n2 > n3 ? n3 : (n2 > n4 ? (n2 -= n4) : 1);
                this.logger.debug("decrementPublishRequestSetpoint: sp={}", (Object)n2);
                this.eq.gJ.set(n2);
            }
            return n2;
        }

        private void a(Exception exception, UnsignedInteger unsignedInteger) {
            if (StatusCodes.Bad_TooManyPublishRequests.equals(unsignedInteger)) {
                this.hC.incrementAndGet();
                this.logger.debug("Got Bad_TooManyPublishRequest from the server. Current requests={}, toomanys={}", (Object)this.hA.get(), (Object)this.hC.get());
            } else if (StatusCodes.Bad_NoSubscription.equals(unsignedInteger)) {
                if (this.cpl()) {
                    this.logger.info("Got Bad_NoSubscription as a PublishResponse, although we have connected Subscriptions");
                }
            } else if (this.h(unsignedInteger)) {
                this.logger.debug("onError: {}", (Object)exception.getMessage());
            } else {
                this.logger.warn("onError: ", exception);
            }
        }

        private void cpj() {
            for (Subscription subscription : this.eq.hh) {
                try {
                    subscription.handleNotificationDatas();
                }
                catch (Exception exception) {
                    this.logger.error("handlePublishResponses", exception);
                }
            }
            this.cph();
        }

        private boolean cpk() {
            boolean bl = false;
            for (Subscription subscription : this.eq.getSubscriptions()) {
                UnsignedInteger unsignedInteger = subscription.getSubscriptionId();
                boolean bl2 = subscription.isConnected();
                boolean bl3 = subscription.isAlive();
                this.logger.trace("hasConnectedAliveSubscriptions: id:{}, connected:{}, alive:{}", unsignedInteger, bl2, bl3);
                if (!bl2 || !bl3) continue;
                bl = true;
                if (!this.logger.isTraceEnabled()) break;
            }
            return bl;
        }

        private boolean cpl() {
            boolean bl = false;
            for (Subscription subscription : this.eq.getSubscriptions()) {
                UnsignedInteger unsignedInteger = subscription.getSubscriptionId();
                boolean bl2 = subscription.isConnected();
                boolean bl3 = subscription.isTimeout();
                this.logger.trace("hasConnectedNonTimeoutedSubscriptions: id:{}, connected:{}, timeout:{}", unsignedInteger, bl2, bl3);
                if (!bl2 || bl3) continue;
                bl = true;
                if (!this.logger.isTraceEnabled()) break;
            }
            return bl;
        }

        private boolean hasPublishResponses() {
            for (Subscription subscription : this.eq.hh) {
                if (!subscription.hasPublishResponses()) continue;
                return true;
            }
            return false;
        }

        private boolean isActive() {
            ServerStatusDataType serverStatusDataType = null;
            try {
                serverStatusDataType = this.eq.getServerStatus();
                this.logger.trace("isActive: status={}", (Object)serverStatusDataType);
                if (serverStatusDataType == null && this.eq.hb == 0L) {
                    return true;
                }
                return serverStatusDataType != null && serverStatusDataType.getState().equals(ServerState.Running);
            }
            catch (ServerConnectionException serverConnectionException) {
                this.logger.trace("isActive: exception=", serverConnectionException);
                return false;
            }
            catch (StatusException statusException) {
                this.logger.trace("isActive: exception=", statusException);
                return false;
            }
        }

        private void cpm() {
            this.hD.terminate();
            this.hD = new a(this);
        }

        private void cpn() {
            boolean bl = this.cpk();
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("queuePublishRequests: subscription count:{}, hasConnectedAliveSubscriptions:{}", (Object)this.eq.hh.size(), (Object)bl);
            }
            if (bl) {
                for (int i2 = 0; i2 < 5 && this.cpp(); ++i2) {
                }
            }
        }

        private void cpo() {
            this.eq.a(null);
        }

        private synchronized boolean cpp() {
            int n2 = this.hA.get();
            int n3 = this.eq.getActualPublishRequestSetpoint();
            this.logger.trace("sendPublishRequest: requestCount={}, setPoint={}", (Object)n2, (Object)n3);
            if (this.isActive() && n2 < n3) {
                try {
                    SessionChannel sessionChannel = this.eq.cnY();
                    if (sessionChannel == null || sessionChannel.getSecureChannel() == null) {
                        this.logger.debug("sendPublishRequest: channel/secureChannel=null");
                    } else {
                        this.logger.debug("sendPublishRequest: channel={} secureChannel.isOpen={}", (Object)sessionChannel, (Object)sessionChannel.getSecureChannel().isOpen());
                    }
                    if (sessionChannel != null) {
                        RequestHeader requestHeader = this.eq.a(null, this.eq.getPublishRequestTimeout(), null);
                        PublishRequest publishRequest = new PublishRequest(requestHeader, this.eq.getSubscriptionAcknowledgements());
                        if (this.eq.gE != null) {
                            this.eq.gE.onBeforePublishRequest(this.eq, publishRequest);
                        }
                        AsyncResult<PublishResponse> asyncResult = sessionChannel.PublishAsync(publishRequest);
                        asyncResult.setListener(this.hD);
                        int n4 = this.hA.incrementAndGet();
                        this.logger.debug("sendPublishRequest, publishRequestCount: {}", (Object)n4);
                        return true;
                    }
                }
                catch (ServerConnectionException serverConnectionException) {
                    this.logger.debug("ServerConnectionException: ", serverConnectionException);
                }
            }
            return false;
        }

        protected boolean h(UnsignedInteger unsignedInteger) {
            return gh.contains(StatusCode.valueOf(unsignedInteger));
        }

        private static class a
        implements ResultListener<PublishResponse> {
            private final f gL;
            private final Logger logger;
            private final AtomicBoolean hE = new AtomicBoolean(false);

            private a(f f2) {
                this.gL = f2;
                this.logger = f2.logger;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void b(PublishResponse publishResponse) {
                f f2 = this.gL;
                synchronized (f2) {
                    this.logger.debug("onCompleted entering");
                    int n2 = this.gL.hA.decrementAndGet();
                    this.logger.debug("onCompleted publishRequestCount decremented, is={}", (Object)n2);
                    if (this.hE.get()) {
                        return;
                    }
                    try {
                        PublishResponse publishResponse2 = publishResponse;
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug("onCompleted: ServiceResult={} Results={}", (Object)publishResponse2.getResponseHeader().getServiceResult(), (Object)Arrays.toString(publishResponse2.getResults()));
                        }
                        if (this.gL.eq.a(publishResponse2)) {
                            this.gL.cpp();
                        }
                    }
                    catch (ServiceException serviceException) {
                        this.gL.a(serviceException, serviceException.getServiceResult().getValue());
                    }
                    catch (Exception exception) {
                        this.logger.error("Failed to handle a complete publish message", exception);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onError(ServiceResultException serviceResultException) {
                f f2 = this.gL;
                synchronized (f2) {
                    this.logger.debug("onError entering");
                    int n2 = this.gL.hA.decrementAndGet();
                    this.logger.debug("onError publishRequestCount decremented, is: {}", (Object)n2);
                    if (this.hE.get()) {
                        return;
                    }
                    this.gL.a(serviceResultException, serviceResultException.getStatusCode().getValue());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void terminate() {
                f f2 = this.gL;
                synchronized (f2) {
                    this.hE.set(true);
                }
            }

            @Override
            public /* synthetic */ void onCompleted(Object object) {
                this.b((PublishResponse)object);
            }
        }
    }

    private static class e {
        final ServerStatusDataType hx;
        final StatusCode hy;

        private e(ServerStatusDataType serverStatusDataType, StatusCode statusCode) {
            this.hx = serverStatusDataType;
            this.hy = statusCode;
        }
    }

    @FunctionalInterface
    private static interface d {
        public HistoryReadResult[] read(NodeId[] var1) throws ServiceException, DecodingException, EncodingException;
    }
}

