/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.UaAddress;
import com.prosysopc.ua.UaApplication;
import com.prosysopc.ua.client.ServerListBase;
import com.prosysopc.ua.client.ServerListException;
import com.prosysopc.ua.stack.application.Client;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.ServerOnNetwork;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerList
extends ServerListBase {
    private static Logger logger = LoggerFactory.getLogger(ServerList.class);

    public ServerList() {
    }

    public ServerList(String string) throws ServerListException {
        super(string);
    }

    public void discover(UaApplication.Protocol protocol, String string) throws ServerListException {
        this.discover(UaAddress.formatUri(protocol, string, 4840, null));
    }

    @Override
    public void discover(String string) throws ServerListException {
        ApplicationDescription[] applicationDescriptionArray;
        Client client = Client.createClientApplication(null);
        client.setTimeout(10000);
        try {
            applicationDescriptionArray = client.discoverApplications(string);
        }
        catch (ServiceFaultException serviceFaultException) {
            logger.debug("ServiceFaultException: ", serviceFaultException);
            throw new ServerListException("Cannot discover applications from " + string.toString(), serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            logger.debug("ServiceFaultException: ", serviceResultException);
            throw new ServerListException("Cannot discover applications from " + string.toString(), serviceResultException);
        }
        if (applicationDescriptionArray == null) {
            throw new ServerListException("Cannot discover applications from " + string.toString());
        }
        this.servers.addAll(Arrays.asList(applicationDescriptionArray));
        try {
            ServerOnNetwork[] serverOnNetworkArray = client.discoverServersOnNetwork(string);
            this.serversOnNetwork.addAll(Arrays.asList(serverOnNetworkArray));
        }
        catch (ServiceFaultException serviceFaultException) {
            logger.debug("ServiceFaultException: ", serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            logger.debug("ServiceFaultException: ", serviceResultException);
        }
    }
}

