/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.NodeMap;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaNamespaceTranslateable;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.client.AddressSpace;
import com.prosysopc.ua.client.a;
import com.prosysopc.ua.client.b;
import com.prosysopc.ua.client.d;
import com.prosysopc.ua.client.e;
import com.prosysopc.ua.client.nodes.InternalClientNodesAccessHelper;
import com.prosysopc.ua.client.nodes.UaDataTypeImpl;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactory;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.ReferenceDescription;
import com.prosysopc.ua.stack.core.ReferenceTypeIdentifiers;
import com.prosysopc.ua.stack.encoding.EncodeType;
import com.prosysopc.ua.types.opcua.VariableTypeIds;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeCache
extends NodeMap {
    private static Logger logger = LoggerFactory.getLogger(NodeCache.class);
    private int fC;
    private long fD;
    private final Map<NodeId, NodeCacheWrapper> fE;
    private final Queue<NodeCacheWrapper> queue;
    d fF = e.coh();

    private static void a(UaNode uaNode, Map.Entry<UnsignedInteger, DataValue> entry) {
        try {
            uaNode.setAttribute(entry.getKey(), entry.getValue());
        }
        catch (StatusException statusException) {
            if (entry.getKey().intValue() > Attributes.DataTypeDefinition.intValue()) {
                logger.debug("createNodesInternal, could not set Attribute:{} with value:{} to node:{}, reason: {}", entry.getKey(), entry.getValue(), uaNode.getNodeId(), statusException.getStatusCode());
            }
            logger.debug("createNodesInternal, could not set Attribute:{} with value:{} to node:{}, reason: {}", entry.getKey(), entry.getValue(), uaNode.getNodeId(), statusException.getStatusCode());
        }
    }

    private static void a(Set<Map.Entry<UnsignedInteger, DataValue>> set, UaNode uaNode) {
        for (Map.Entry<UnsignedInteger, DataValue> entry : set) {
            if (!Attributes.DataType.equals(entry.getKey())) continue;
            NodeCache.a(uaNode, entry);
        }
        for (Map.Entry<UnsignedInteger, DataValue> entry : set) {
            if (Attributes.NodeId.equals(entry.getKey()) || Attributes.NodeClass.equals(entry.getKey()) || Attributes.DataType.equals(entry.getKey())) continue;
            NodeCache.a(uaNode, entry);
        }
    }

    public NodeCache(UaNodeFactory uaNodeFactory, int n2, long l2) {
        super(uaNodeFactory);
        this.fE = new ConcurrentHashMap<NodeId, NodeCacheWrapper>(32, 1.0f, 2);
        this.queue = new ArrayDeque<NodeCacheWrapper>();
        this.fC = n2;
        this.fD = l2;
    }

    @Override
    public UaNode addNode(UaNode uaNode) {
        if (uaNode instanceof UaType) {
            return this.addPermanently(uaNode);
        }
        return this.addNode(uaNode, DateTime.fromMillis(this.fF.cof()));
    }

    public UaNode addPermanently(UaNode uaNode) {
        return this.addNode(uaNode, DateTime.MAX_VALUE);
    }

    @Override
    public void clear() {
        this.fE.clear();
        this.queue.clear();
    }

    public int getMaxQueueLength() {
        return this.fC;
    }

    @Override
    public UaNode getNode(NodeId nodeId) {
        if (this.fD == 0L) {
            return null;
        }
        NodeCacheWrapper nodeCacheWrapper = this.fE.get(nodeId);
        if (nodeCacheWrapper == null) {
            return null;
        }
        DateTime dateTime = DateTime.fromInstant(Instant.ofEpochMilli(this.fF.cof() - this.fD));
        if (nodeCacheWrapper.isValid(dateTime)) {
            UaNode uaNode = nodeCacheWrapper.getNode();
            if (uaNode == null) {
                this.fE.remove(nodeId);
                this.queue.remove(nodeCacheWrapper);
            }
            return uaNode;
        }
        return null;
    }

    public long getNodeMaxAgeInMillis() {
        return this.fD;
    }

    @Override
    public boolean hasNode(NodeId nodeId) {
        return this.fE.containsKey(nodeId);
    }

    @Override
    public UaNode remove(NodeId nodeId) {
        NodeCacheWrapper nodeCacheWrapper = this.fE.remove(nodeId);
        if (nodeCacheWrapper != null) {
            this.queue.remove(nodeCacheWrapper);
            return nodeCacheWrapper.getNode();
        }
        return null;
    }

    @Override
    public UaNode remove(UaNode uaNode) {
        return this.remove(uaNode.getNodeId());
    }

    public void setMaxQueueLength(int n2) {
        this.fC = n2;
        this.cou();
    }

    public void setNodeMaxAgeInMillis(long l2) {
        this.fD = l2;
    }

    public int size() {
        return this.fE.size();
    }

    private void cou() {
        NodeCacheWrapper nodeCacheWrapper;
        logger.debug("trimQueue");
        while (!(this.queue.size() <= this.fC || (nodeCacheWrapper = this.queue.peek()) != null && nodeCacheWrapper.isValid(new DateTime(System.currentTimeMillis() - this.fD)) && nodeCacheWrapper.getNode() == null)) {
            if (nodeCacheWrapper != null && nodeCacheWrapper.getNodeId() != null) {
                this.fE.remove(nodeCacheWrapper.getNodeId());
            }
            this.queue.poll();
        }
    }

    protected UaNode addNode(UaNode uaNode, DateTime dateTime) {
        logger.debug("addNode: node BrowseName:{}, NodeId={}, timestamp:{}", uaNode.getBrowseName(), uaNode.getNodeId(), dateTime);
        NodeCacheWrapper nodeCacheWrapper = new NodeCacheWrapper(uaNode, dateTime);
        NodeCacheWrapper nodeCacheWrapper2 = this.fE.put(uaNode.getNodeId(), nodeCacheWrapper);
        if (!this.isPermanentTimestamp(dateTime)) {
            this.queue.add(nodeCacheWrapper);
            this.queue.remove(nodeCacheWrapper2);
            this.cou();
        }
        return nodeCacheWrapper2 == null ? null : nodeCacheWrapper2.getNode();
    }

    protected synchronized UaNode createNode(NodeClass nodeClass, NodeId nodeId, QualifiedName qualifiedName, LocalizedText localizedText, ExpandedNodeId expandedNodeId) throws UaNodeFactoryException {
        UaNode uaNode = this.getNode(nodeId);
        if (uaNode != null) {
            return uaNode;
        }
        if (ExpandedNodeId.isNull(expandedNodeId) && (NodeClass.Object == nodeClass || NodeClass.Variable == nodeClass)) {
            logger.warn("Missing a TypeDefinition for NodeId: {}, NodeClass: {}, BrowseName: {}", nodeId, nodeClass, qualifiedName);
        }
        UaNode uaNode2 = this.nodeFactory.createNode(nodeClass, nodeId, qualifiedName, localizedText, expandedNodeId);
        this.addNode(uaNode2);
        return uaNode2;
    }

    protected boolean isPermanentTimestamp(DateTime dateTime) {
        return dateTime.compareTo(DateTime.MAX_VALUE) >= 0;
    }

    synchronized Map<NodeId, UaNode> a(AddressSpace addressSpace, b b2) {
        HashMap<NodeId, UaNode> hashMap = new HashMap<NodeId, UaNode>();
        List<NodeClass> list = Arrays.asList(NodeClass.ReferenceType, NodeClass.DataType, NodeClass.VariableType, NodeClass.ObjectType, NodeClass.Variable, NodeClass.Object, NodeClass.Method, NodeClass.View);
        for (NodeClass object : list) {
            this.a(object, addressSpace, b2.b(object), hashMap);
        }
        if (b2.cod() != null) {
            for (Map.Entry entry : b2.cod().asRawMap().entrySet()) {
                NodeCacheWrapper nodeCacheWrapper = this.fE.get(entry.getKey());
                if (nodeCacheWrapper == null) {
                    logger.warn("Could not find Property {}", entry.getKey());
                    continue;
                }
                UaNode uaNode = nodeCacheWrapper.getNode();
                for (ReferenceDescription referenceDescription : (List)entry.getValue()) {
                    uaNode.addReference(referenceDescription.getNodeId(), referenceDescription.getReferenceTypeId(), referenceDescription.getIsForward() == false);
                }
            }
        }
        return Collections.unmodifiableMap(hashMap);
    }

    void a(NodeClass nodeClass, AddressSpace addressSpace, Map<NodeId, a> map, Map<NodeId, UaNode> map2) {
        if (map.isEmpty()) {
            return;
        }
        for (Map.Entry<NodeId, a> entry : map.entrySet()) {
            Object object;
            NodeId nodeId = entry.getKey();
            a a2 = entry.getValue();
            UaNode uaNode = this.getNode(nodeId);
            if (uaNode != null) {
                map2.put(nodeId, uaNode);
                continue;
            }
            QualifiedName qualifiedName = (QualifiedName)a2.coa().get(Attributes.BrowseName).getValue().getValue();
            LocalizedText localizedText = (LocalizedText)a2.coa().get(Attributes.DisplayName).getValue().getValue();
            ExpandedNodeId expandedNodeId = a2.getTypeDefinition();
            UaNode uaNode2 = this.createNode(nodeClass, nodeId, qualifiedName, localizedText, expandedNodeId);
            NodeCache.a(a2.coa().entrySet(), uaNode2);
            if (a2.coc() != null && !a2.coc().isEmpty()) {
                for (Map.Entry<QualifiedName, Map<UnsignedInteger, DataValue>> entry2 : a2.coc().entrySet()) {
                    try {
                        UaNamespaceTranslateable<Structure> uaNamespaceTranslateable = (NodeId)entry2.getValue().get(Attributes.NodeId).getValue().getValue();
                        object = entry2.getKey();
                        LocalizedText localizedText2 = (LocalizedText)entry2.getValue().get(Attributes.DisplayName).getValue().getValue();
                        UaNode uaNode3 = this.createNode(NodeClass.Variable, (NodeId)uaNamespaceTranslateable, (QualifiedName)object, localizedText2, VariableTypeIds.PropertyType);
                        logger.debug("Setting Properties for node: {}", (Object)uaNode3);
                        NodeCache.a(entry2.getValue().entrySet(), uaNode3);
                    }
                    catch (Exception exception) {
                        logger.error("Cannot create Property", exception);
                    }
                }
            } else {
                logger.debug("No Properties data found, skipping Property creation");
            }
            boolean bl = false;
            if (uaNode2 instanceof UaDataTypeImpl) {
                bl = true;
            }
            for (UaNamespaceTranslateable<Structure> uaNamespaceTranslateable : a2.getReferences()) {
                uaNode2.addReference(((ReferenceDescription)uaNamespaceTranslateable).getNodeId(), ((ReferenceDescription)uaNamespaceTranslateable).getReferenceTypeId(), ((ReferenceDescription)uaNamespaceTranslateable).getIsForward() == false);
                if (!bl || !ReferenceTypeIdentifiers.HasEncoding.equals(((ReferenceDescription)uaNamespaceTranslateable).getReferenceTypeId()) || !Boolean.TRUE.equals(((ReferenceDescription)uaNamespaceTranslateable).getIsForward())) continue;
                object = (UaDataTypeImpl)uaNode2;
                try {
                    if ("Default Binary".equals(((ReferenceDescription)uaNamespaceTranslateable).getBrowseName().getName())) {
                        InternalClientNodesAccessHelper.internalUaDataTypeImplInitCachedEncodingsId((UaDataTypeImpl)object, EncodeType.Binary, UaNodeId.fromLocal(((ReferenceDescription)uaNamespaceTranslateable).getNodeId(), addressSpace.getNamespaceTable()));
                    }
                    if ("Default XML".equals(((ReferenceDescription)uaNamespaceTranslateable).getBrowseName().getName())) {
                        InternalClientNodesAccessHelper.internalUaDataTypeImplInitCachedEncodingsId((UaDataTypeImpl)object, EncodeType.Xml, UaNodeId.fromLocal(((ReferenceDescription)uaNamespaceTranslateable).getNodeId(), addressSpace.getNamespaceTable()));
                    }
                    if (!"Default JSON".equals(((ReferenceDescription)uaNamespaceTranslateable).getBrowseName().getName())) continue;
                    InternalClientNodesAccessHelper.internalUaDataTypeImplInitCachedEncodingsId((UaDataTypeImpl)object, EncodeType.Json, UaNodeId.fromLocal(((ReferenceDescription)uaNamespaceTranslateable).getNodeId(), addressSpace.getNamespaceTable()));
                }
                catch (Exception exception) {
                    logger.debug("Cannot cache Encoding information from References for ReferenceDescription: {}", (Object)uaNamespaceTranslateable, (Object)exception);
                }
            }
            try {
                if (a2.getTypeDefinition() != null) {
                    addressSpace.a(nodeId, uaNode2, a2.getTypeDefinition());
                }
            }
            catch (Exception exception) {
                logger.warn("Cannot set TypeDefinition for Node: {}", (Object)uaNode2, (Object)exception);
            }
            map2.put(nodeId, uaNode2);
        }
    }

    d cov() {
        return this.fF;
    }

    void a(d d2) {
        this.fF = d2;
    }

    public class NodeCacheWrapper {
        private final NodeId nodeId;
        private final Object fG;
        private final DateTime fH;

        public NodeCacheWrapper(UaNode uaNode, DateTime dateTime) {
            this.fG = NodeCache.this.isPermanentTimestamp(dateTime) ? uaNode : new SoftReference<UaNode>(uaNode);
            this.fH = dateTime;
            this.nodeId = uaNode.getNodeId();
        }

        public UaNode getNode() {
            return this.fG instanceof UaNode ? (UaNode)this.fG : (UaNode)((Reference)this.fG).get();
        }

        public NodeId getNodeId() {
            return this.nodeId;
        }

        public DateTime getTimestamp() {
            return this.fH;
        }

        public boolean isValid(DateTime dateTime) {
            return this.fH.compareTo(dateTime) >= 0;
        }
    }
}

