/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.client.AddressSpaceException;
import com.prosysopc.ua.client.ServerListBase;
import com.prosysopc.ua.client.ServerListException;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.ApplicationDescription;
import com.prosysopc.ua.stack.core.ApplicationType;
import com.prosysopc.ua.stack.core.BrowsePath;
import com.prosysopc.ua.stack.core.BrowsePathResult;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.RelativePath;
import com.prosysopc.ua.stack.core.RelativePathElement;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.transport.security.SecurityMode;
import com.prosysopc.ua.types.gds.DirectoryType;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalServerList
extends ServerListBase {
    private static final String eT = "http://opcfoundation.org/UA/GDS/";
    private static final ExpandedNodeId eU = new ExpandedNodeId(null, "http://opcfoundation.org/UA/GDS/", (Object)141);
    private static final String eV = "http://opcfoundation.org/UA/GDS/v1.0";
    private static Logger logger = LoggerFactory.getLogger(GlobalServerList.class);
    UaClient eq;

    public GlobalServerList() {
    }

    public GlobalServerList(String string) throws ServerListException {
        super(string);
    }

    @Override
    public void discover(String string) throws ServerListException {
        if (this.eq == null) {
            this.eq = new UaClient();
        }
        try {
            this.eq.setAddress(string);
            this.eq.setSecurityMode(SecurityMode.NONE);
            this.eq.getEndpointConfiguration().setOperationTimeout(10000);
            this.eq.connect();
            DirectoryType directoryType = this.eq.getAddressSpace().getNode(eU, DirectoryType.class);
            DirectoryType.QueryServersMethodOutputs queryServersMethodOutputs = directoryType.queryServers(UnsignedInteger.ZERO, UnsignedInteger.ZERO, "", "", "", new String[0]);
            this.lastCounterResetTime = queryServersMethodOutputs.getLastCounterResetTime();
            this.serversOnNetwork.addAll(Arrays.asList(queryServersMethodOutputs.getServers()));
        }
        catch (ServiceException serviceException) {
            logger.debug("ServiceException: ", serviceException);
            throw new ServerListException("Cannot discover applications from " + string.toString(), serviceException);
        }
        catch (StatusException statusException) {
            throw new ServerListException("Cannot discover applications from " + string.toString());
        }
        catch (AddressSpaceException addressSpaceException) {
            throw new ServerListException("Cannot discover applications from " + string.toString() + " - Cannot find 'Directory' Node");
        }
        finally {
            this.eq.disconnect(5000L);
        }
    }

    private ApplicationDescription a(UaNode uaNode, int n2) throws ServiceException, ServiceResultException, StatusException {
        ApplicationDescription applicationDescription = new ApplicationDescription();
        applicationDescription.setApplicationName(uaNode.getDisplayName());
        BrowsePath browsePath = this.createBrowsePath(uaNode, n2, "ApplicationType");
        BrowsePath browsePath2 = this.createBrowsePath(uaNode, n2, "ApplicationUri");
        BrowsePath browsePath3 = this.createBrowsePath(uaNode, n2, "MachineName");
        BrowsePath browsePath4 = this.createBrowsePath(uaNode, n2, "DiscoveryUrls");
        logger.debug("getApplicationDescription: appTypeName={} appUriName={}, machineNameName={}, discoveryUrisName={}s", browsePath, browsePath2, browsePath3, browsePath4);
        Object[] objectArray = this.eq.getAddressSpace().translateBrowsePathsToNodeIds(browsePath, browsePath2, browsePath3, browsePath4);
        if (logger.isDebugEnabled()) {
            logger.debug("getApplicationDescription: results={}", (Object)Arrays.toString(objectArray));
        }
        Object[] objectArray2 = this.eq.readValues(this.a((BrowsePathResult[])objectArray), TimestampsToReturn.Neither);
        if (logger.isDebugEnabled()) {
            logger.debug("getApplicationDescription: values={}", (Object)Arrays.toString(objectArray2));
        }
        applicationDescription.setApplicationType(ApplicationType.valueOf(this.getStringValue((DataValue[])objectArray2, 0)));
        applicationDescription.setApplicationUri(this.getStringValue((DataValue[])objectArray2, 1));
        String[] stringArray = ((DataValue)objectArray2[3]).getStatusCode().isGood() ? (String[])((DataValue)objectArray2[3]).getValue().getValue() : null;
        applicationDescription.setDiscoveryUrls(stringArray);
        return applicationDescription;
    }

    private NodeId[] a(BrowsePathResult[] browsePathResultArray) throws ServiceResultException, ServiceException, StatusException {
        NodeId[] nodeIdArray = new NodeId[browsePathResultArray.length];
        for (int i2 = 0; i2 < browsePathResultArray.length; ++i2) {
            nodeIdArray[i2] = this.getNodeId(browsePathResultArray, i2);
        }
        return nodeIdArray;
    }

    protected BrowsePath createBrowsePath(UaNode uaNode, int n2, String string) {
        return new BrowsePath(uaNode.getNodeId(), new RelativePath(new RelativePathElement[]{new RelativePathElement(Identifiers.HasProperty, false, false, new QualifiedName(n2, string))}));
    }

    protected NodeId getNodeId(BrowsePathResult[] browsePathResultArray, int n2) throws ServiceResultException, ServiceException, StatusException {
        return this.eq.getNamespaceTable().toNodeId(browsePathResultArray[n2].getTargets()[0].getTargetId());
    }

    protected String getStringValue(DataValue[] dataValueArray, int n2) {
        return dataValueArray[n2].getStatusCode().isGood() ? (String)dataValueArray[n2].getValue().getValue() : "";
    }
}

