/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua.client;

import com.prosysopc.ua.DataTypeConverter;
import com.prosysopc.ua.ModelException;
import com.prosysopc.ua.OperationLimits;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaAddressSpace;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.client.AddressSpaceException;
import com.prosysopc.ua.client.InternalAddressSpaceAccessHelper;
import com.prosysopc.ua.client.InternalBrowseResults;
import com.prosysopc.ua.client.InternalGetNodesResults;
import com.prosysopc.ua.client.ModelParser;
import com.prosysopc.ua.client.NodeCache;
import com.prosysopc.ua.client.ServerConnectionException;
import com.prosysopc.ua.client.UaClient;
import com.prosysopc.ua.client.a;
import com.prosysopc.ua.client.b;
import com.prosysopc.ua.client.c;
import com.prosysopc.ua.client.f;
import com.prosysopc.ua.client.g;
import com.prosysopc.ua.client.i;
import com.prosysopc.ua.client.nodes.UaClientNodeFactory;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaInstance;
import com.prosysopc.ua.nodes.UaMethod;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaNodeFactory;
import com.prosysopc.ua.nodes.UaNodeFactoryException;
import com.prosysopc.ua.nodes.UaProperty;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.nodes.UaType;
import com.prosysopc.ua.stack.application.SessionChannel;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DataValue;
import com.prosysopc.ua.stack.builtintypes.DiagnosticInfo;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.ServiceResponse;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.common.ServiceFaultException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.AddNodesItem;
import com.prosysopc.ua.stack.core.AddNodesResponse;
import com.prosysopc.ua.stack.core.AddNodesResult;
import com.prosysopc.ua.stack.core.AddReferencesItem;
import com.prosysopc.ua.stack.core.AddReferencesResponse;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.BrowseDescription;
import com.prosysopc.ua.stack.core.BrowseDirection;
import com.prosysopc.ua.stack.core.BrowseNextResponse;
import com.prosysopc.ua.stack.core.BrowsePath;
import com.prosysopc.ua.stack.core.BrowsePathResult;
import com.prosysopc.ua.stack.core.BrowsePathTarget;
import com.prosysopc.ua.stack.core.BrowseRequest;
import com.prosysopc.ua.stack.core.BrowseResponse;
import com.prosysopc.ua.stack.core.BrowseResult;
import com.prosysopc.ua.stack.core.BrowseResultMask;
import com.prosysopc.ua.stack.core.ContentFilter;
import com.prosysopc.ua.stack.core.DeleteNodesItem;
import com.prosysopc.ua.stack.core.DeleteNodesResponse;
import com.prosysopc.ua.stack.core.DeleteReferencesItem;
import com.prosysopc.ua.stack.core.DeleteReferencesResponse;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.NodeTypeDescription;
import com.prosysopc.ua.stack.core.QueryDataSet;
import com.prosysopc.ua.stack.core.QueryFirstRequest;
import com.prosysopc.ua.stack.core.QueryFirstResponse;
import com.prosysopc.ua.stack.core.QueryNextRequest;
import com.prosysopc.ua.stack.core.QueryNextResponse;
import com.prosysopc.ua.stack.core.ReferenceDescription;
import com.prosysopc.ua.stack.core.ReferenceTypeIdentifiers;
import com.prosysopc.ua.stack.core.RegisterNodesResponse;
import com.prosysopc.ua.stack.core.RelativePath;
import com.prosysopc.ua.stack.core.RelativePathElement;
import com.prosysopc.ua.stack.core.RequestHeader;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.TimestampsToReturn;
import com.prosysopc.ua.stack.core.TranslateBrowsePathsToNodeIdsResponse;
import com.prosysopc.ua.stack.core.ViewDescription;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.transport.AsyncResult;
import com.prosysopc.ua.stack.transport.impl.AsyncResultImpl;
import com.prosysopc.ua.stack.utils.AttributesUtil;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.StackUtils;
import com.prosysopc.ua.types.opcua.client.FolderTypeImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class AddressSpace
implements UaAddressSpace {
    static Logger logger = LoggerFactory.getLogger(AddressSpace.class);
    private BrowseDirection eo = BrowseDirection.Forward;
    private final NodeCache ep;
    private final UaClient eq;
    private final DataTypeConverter er;
    private Boolean es = true;
    private UnsignedInteger et = UnsignedInteger.valueOf(1000L);
    private UnsignedInteger eu = UnsignedInteger.valueOf(1000L);
    private EnumSet<NodeClass> ev = EnumSet.allOf(NodeClass.class);
    private final UaNodeFactory nodeFactory;
    private NodeId ew = Identifiers.HierarchicalReferences;
    private List<NodeId> ex = null;
    private EnumSet<BrowseResultMask> ey = EnumSet.allOf(BrowseResultMask.class);
    private final c ez = new c();
    private boolean eA = true;
    private ViewDescription eB = null;

    public AddressSpace(UaClient uaClient) {
        this.eq = uaClient;
        this.nodeFactory = new UaClientNodeFactory(this);
        this.ep = new NodeCache(this.nodeFactory, 5000, 1000L);
        this.er = new DataTypeConverter(this);
    }

    public NodeId addNode(AddNodesItem addNodesItem) throws ServiceException, StatusException {
        AddNodesResult addNodesResult = this.addNodes(addNodesItem)[0];
        this.checkOperationResult(addNodesResult.getStatusCode());
        return addNodesResult.getAddedNodeId();
    }

    public NodeId addNode(NodeId nodeId, NodeId nodeId2, NodeId nodeId3, QualifiedName qualifiedName, NodeClass nodeClass, NodeAttributes nodeAttributes, NodeId nodeId4) throws ServiceException, EncodingException, StatusException {
        AddNodesItem addNodesItem = new AddNodesItem(this.getNamespaceTable().toExpandedNodeId(nodeId), nodeId2, this.getNamespaceTable().toExpandedNodeId(nodeId3), qualifiedName, nodeClass, nodeAttributes, this.getNamespaceTable().toExpandedNodeId(nodeId4));
        return this.addNode(addNodesItem);
    }

    @Override
    public void addNode(UaNode uaNode) {
        this.ep.addNode(uaNode);
    }

    public AddNodesResult[] addNodes(AddNodesItem ... addNodesItemArray) throws ServiceException {
        AddNodesResponse addNodesResponse;
        try {
            addNodesResponse = this.cnY().AddNodes(this.getRequestHeader(), addNodesItemArray);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult(addNodesResponse, null);
        return addNodesResponse.getResults();
    }

    public void addReference(AddReferencesItem addReferencesItem) throws ServiceException, StatusException {
        StatusCode statusCode = this.addReferences(addReferencesItem)[0];
        this.checkOperationResult(statusCode);
    }

    public StatusCode[] addReferences(AddReferencesItem ... addReferencesItemArray) throws ServiceException {
        AddReferencesResponse addReferencesResponse;
        try {
            addReferencesResponse = this.cnY().AddReferences(this.getRequestHeader(), addReferencesItemArray);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult(addReferencesResponse, null);
        return addReferencesResponse.getResults();
    }

    public List<ReferenceDescription> browse(ExpandedNodeId expandedNodeId) throws ServiceException, StatusException {
        NodeId nodeId = this.toNodeId(expandedNodeId);
        return this.browse(nodeId);
    }

    public List<ReferenceDescription> browse(ExpandedNodeId expandedNodeId, BrowseDirection browseDirection, NodeId nodeId, boolean bl, NodeClass ... nodeClassArray) throws ServiceException, StatusException {
        NodeId nodeId2 = this.toNodeId(expandedNodeId);
        return this.browse(nodeId2, browseDirection, nodeId, bl, nodeClassArray);
    }

    public List<ReferenceDescription> browse(NodeId nodeId) throws ServiceException, StatusException {
        return this.browse(nodeId, this.defaultBrowseDescription(nodeId));
    }

    public List<ReferenceDescription> browse(NodeId nodeId, BrowseDirection browseDirection, NodeId nodeId2) throws ServiceException, StatusException {
        return this.browse(nodeId, new BrowseDescription(nodeId, browseDirection, nodeId2, this.es, NodeClass.getMask(this.ev), BrowseResultMask.getMask(this.ey)));
    }

    public List<ReferenceDescription> browse(NodeId nodeId, BrowseDirection browseDirection, NodeId nodeId2, boolean bl, EnumSet<BrowseResultMask> enumSet, NodeClass ... nodeClassArray) throws ServiceException, StatusException {
        return this.browse(nodeId, new BrowseDescription(nodeId, browseDirection, nodeId2, bl, NodeClass.getMask(nodeClassArray), BrowseResultMask.getMask(enumSet)));
    }

    public List<ReferenceDescription> browse(NodeId nodeId, BrowseDirection browseDirection, NodeId nodeId2, boolean bl, NodeClass ... nodeClassArray) throws ServiceException, StatusException {
        return this.browse(nodeId, new BrowseDescription(nodeId, browseDirection, nodeId2, bl, NodeClass.getMask(nodeClassArray), BrowseResultMask.getMask(this.ey)));
    }

    public List<ReferenceDescription> browse(UaNodeId uaNodeId) throws ServiceException, StatusException {
        NodeId nodeId = this.e(uaNodeId);
        return this.browse(nodeId);
    }

    public List<ReferenceDescription> browse(UaNodeId uaNodeId, BrowseDirection browseDirection, UaNodeId uaNodeId2, boolean bl, NodeClass ... nodeClassArray) throws ServiceException, StatusException {
        return this.browse(this.e(uaNodeId), browseDirection, this.e(uaNodeId2), bl, nodeClassArray);
    }

    public BrowseResult[] browse(ViewDescription viewDescription, int n2, BrowseDescription ... browseDescriptionArray) throws ServiceException {
        BrowseResponse browseResponse;
        try {
            browseResponse = this.cnY().Browse(this.getRequestHeader(), viewDescription, UnsignedInteger.valueOf(n2), browseDescriptionArray);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult(browseResponse, browseResponse.getDiagnosticInfos());
        return browseResponse.getResults();
    }

    public AsyncResult<BrowseResponse> browseAsync(ExpandedNodeId expandedNodeId) throws ServiceException {
        NodeId nodeId;
        try {
            nodeId = this.toNodeId(expandedNodeId);
        }
        catch (StatusException statusException) {
            throw new ServiceException(statusException.getStatusCode());
        }
        return this.browseAsync(nodeId);
    }

    public AsyncResult<BrowseResponse> browseAsync(NodeId nodeId) throws ServiceException {
        return this.browseAsync(null, 0, this.defaultBrowseDescription(nodeId));
    }

    public AsyncResult<BrowseResponse> browseAsync(UaNodeId uaNodeId) throws ServiceException {
        NodeId nodeId;
        try {
            nodeId = this.e(uaNodeId);
        }
        catch (StatusException statusException) {
            throw new ServiceException(statusException.getStatusCode());
        }
        return this.browseAsync(nodeId);
    }

    public AsyncResult<BrowseResponse> browseAsync(ViewDescription viewDescription, int n2, BrowseDescription ... browseDescriptionArray) throws ServiceException {
        BrowseRequest browseRequest = new BrowseRequest(this.getRequestHeader(), viewDescription, UnsignedInteger.valueOf(n2), browseDescriptionArray);
        return this.cnY().BrowseAsync(browseRequest);
    }

    public List<ReferenceDescription> browseMethods(ExpandedNodeId expandedNodeId) throws ServiceException, StatusException {
        return this.browseMethods(this.toNodeId(expandedNodeId));
    }

    public List<ReferenceDescription> browseMethods(NodeId nodeId) throws ServiceException, StatusException {
        List<ReferenceDescription> list = this.browse(nodeId, BrowseDirection.Forward, Identifiers.HierarchicalReferences, true, NodeClass.Method);
        return list;
    }

    public List<ReferenceDescription> browseMethods(UaNodeId uaNodeId) throws ServiceException, StatusException {
        return this.browseMethods(this.e(uaNodeId));
    }

    public BrowseResult[] browseNext(boolean bl, byte[] ... byArray) throws ServiceException {
        ArrayList<ByteString> arrayList = new ArrayList<ByteString>();
        for (byte[] byArray2 : byArray) {
            arrayList.add(ByteString.valueOf(byArray2));
        }
        return this.browseNext(bl, arrayList.toArray(new ByteString[0]));
    }

    public BrowseResult[] browseNext(boolean bl, ByteString ... byteStringArray) throws ServiceException {
        BrowseNextResponse browseNextResponse;
        try {
            browseNextResponse = this.cnY().BrowseNext(this.getRequestHeader(), bl, byteStringArray);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult(browseNextResponse, browseNextResponse.getDiagnosticInfos());
        return browseNextResponse.getResults();
    }

    public List<ReferenceDescription> browseUp(ExpandedNodeId expandedNodeId) throws ServerConnectionException, ServiceException, ServiceResultException, StatusException {
        return this.browseUp(this.getNamespaceTable().toNodeId(expandedNodeId));
    }

    public List<ReferenceDescription> browseUp(NodeId nodeId) throws ServerConnectionException, ServiceException {
        BrowseResult[] browseResultArray = this.browse(null, this.getMaxReferencesPerNode().intValue(), new BrowseDescription(nodeId, BrowseDirection.Inverse, Identifiers.HierarchicalReferences, true, NodeClass.getMask(NodeClass.ALL), BrowseResultMask.getMask(BrowseResultMask.ALL)));
        ReferenceDescription[] referenceDescriptionArray = browseResultArray[0].getReferences();
        return referenceDescriptionArray == null ? new ArrayList() : Arrays.asList(referenceDescriptionArray);
    }

    public List<ReferenceDescription> browseUp(UaNodeId uaNodeId) throws ServerConnectionException, ServiceException, ServiceResultException, StatusException {
        return this.browseUp(this.getNamespaceTable().toNodeId(uaNodeId.asLocalExpandedNodeId()));
    }

    public BrowseDescription defaultBrowseDescription(NodeId nodeId) {
        return new BrowseDescription(nodeId, this.eo, this.ew, this.es, this.getNodeClassMask(), this.getResultMask());
    }

    public void deleteNode(DeleteNodesItem deleteNodesItem) throws ServiceException, StatusException {
        StatusCode statusCode = this.deleteNodes(deleteNodesItem)[0];
        this.checkOperationResult(statusCode);
    }

    public StatusCode[] deleteNodes(DeleteNodesItem ... deleteNodesItemArray) throws ServiceException {
        DeleteNodesResponse deleteNodesResponse;
        try {
            deleteNodesResponse = this.cnY().DeleteNodes(this.getRequestHeader(), deleteNodesItemArray);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult(deleteNodesResponse, null);
        return deleteNodesResponse.getResults();
    }

    public void deleteReference(DeleteReferencesItem deleteReferencesItem) throws ServiceException, StatusException {
        StatusCode statusCode = this.deleteReferences(deleteReferencesItem)[0];
        this.checkOperationResult(statusCode);
    }

    public StatusCode[] deleteReferences(DeleteReferencesItem ... deleteReferencesItemArray) throws ServiceException {
        DeleteReferencesResponse deleteReferencesResponse;
        try {
            deleteReferencesResponse = this.cnY().DeleteReferences(this.getRequestHeader(), deleteReferencesItemArray);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult(deleteReferencesResponse, null);
        return deleteReferencesResponse.getResults();
    }

    @Override
    public UaNode findNode(NodeId nodeId) {
        try {
            return this.getNode(nodeId);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public BrowseDirection getBrowseDirection() {
        return this.eo;
    }

    public NodeCache getCache() {
        return this.ep;
    }

    public UaClient getClient() {
        return this.eq;
    }

    public UaDataType getDataType(NodeId nodeId) throws ServiceException, AddressSpaceException {
        UaNode uaNode = this.getNode(nodeId);
        if (uaNode instanceof UaDataType) {
            return (UaDataType)uaNode;
        }
        throw new AddressSpaceException("The given NodeId is not for a datatype (getNode does not return UaDataType)");
    }

    @Override
    public DataTypeConverter getDataTypeConverter() {
        return this.er;
    }

    @Override
    public EncoderContext getEncoderContext() {
        return this.eq.getEncoderContext();
    }

    public UnsignedInteger getMaxDataSetsPerQuery() {
        return this.et;
    }

    public UnsignedInteger getMaxReferencesPerNode() {
        return this.eu;
    }

    public UaMethod getMethod(ExpandedNodeId expandedNodeId) throws ServiceException, AddressSpaceException, StatusException, ServiceResultException {
        return this.getMethod(this.getNamespaceTable().toNodeId(expandedNodeId));
    }

    public UaMethod getMethod(NodeId nodeId) throws ServiceException, AddressSpaceException, StatusException {
        return (UaMethod)this.getNode(nodeId);
    }

    public UaMethod getMethod(UaNodeId uaNodeId) throws ServiceException, AddressSpaceException, StatusException, ServiceResultException {
        return this.getMethod(this.getNamespaceTable().toNodeId(uaNodeId.asLocalExpandedNodeId()));
    }

    public UaMethod getMethodByName(NodeId nodeId, QualifiedName qualifiedName) throws ServiceException, AddressSpaceException, StatusException, ServiceResultException {
        for (ReferenceDescription referenceDescription : this.browseMethods(nodeId)) {
            if (!qualifiedName.equals(referenceDescription.getBrowseName())) continue;
            return this.getMethod(referenceDescription.getNodeId());
        }
        return null;
    }

    public List<UaMethod> getMethods(NodeId nodeId) throws ServiceException, StatusException, AddressSpaceException {
        List<ReferenceDescription> list = this.browseMethods(nodeId);
        ArrayList<UaMethod> arrayList = new ArrayList<UaMethod>();
        for (ReferenceDescription referenceDescription : list) {
            arrayList.add((UaMethod)this.getNode(referenceDescription.getNodeId()));
        }
        return arrayList;
    }

    @Override
    public NamespaceTable getNamespaceTable() {
        return this.eq.getNamespaceTable();
    }

    @Override
    public UaNode getNode(ExpandedNodeId expandedNodeId) throws ServiceException, AddressSpaceException {
        if (ExpandedNodeId.isNull(expandedNodeId)) {
            return null;
        }
        try {
            return this.getNode(this.getNamespaceTable().toNodeId(expandedNodeId));
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    @Override
    public <T extends UaNode> T getNode(ExpandedNodeId expandedNodeId, Class<T> clazz) throws ServiceException, AddressSpaceException {
        try {
            UaNode uaNode = this.getNode(expandedNodeId);
            return (T)uaNode;
        }
        catch (ClassCastException classCastException) {
            throw new AddressSpaceException("NodeId " + expandedNodeId + " is not " + clazz, classCastException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UaNode getNode(NodeId nodeId) throws ServiceException, AddressSpaceException {
        Object object;
        if (NodeId.isNull(nodeId)) {
            return null;
        }
        if (this.ep == null) {
            throw new ServerConnectionException("Cannot use AddressSpace to retrieve nodes before the client is connected", "", null);
        }
        Object object2 = object = this.ez.d(nodeId);
        synchronized (object2) {
            UaNode uaNode;
            UaNode uaNode2 = this.ep.getNode(nodeId);
            logger.debug("getNode: nodeId={} node={}", (Object)nodeId, (Object)uaNode2);
            if (uaNode2 != null) {
                return uaNode2;
            }
            Object[] objectArray = this.eq.readAttributes(nodeId, Attributes.NodeClass, Attributes.BrowseName, Attributes.DisplayName);
            logger.debug("classValues: {}", (Object)Arrays.toString(objectArray));
            NodeClass nodeClass = ((DataValue)objectArray[0]).getStatusCode().isGood() ? NodeClass.valueOf((Integer)((DataValue)objectArray[0]).getValue().getValue()) : null;
            logger.debug("NodeClass: {}", (Object)nodeClass);
            if (nodeClass == null) {
                throw new AddressSpaceException("Cannot determine NodeClass for NodeId: " + nodeId + " because the value is not good: " + MultiDimensionArrayUtils.toString(objectArray[0]));
            }
            EnumSet<NodeClass[]> enumSet = EnumSet.of(NodeClass.ObjectType, new NodeClass[]{NodeClass.ReferenceType, NodeClass.VariableType, NodeClass.DataType, NodeClass.Method, NodeClass.View});
            ExpandedNodeId expandedNodeId = enumSet.contains(nodeClass) ? null : this.getTypeDefinition(nodeId);
            QualifiedName qualifiedName = ((DataValue)objectArray[1]).getStatusCode().isGood() ? (QualifiedName)((DataValue)objectArray[1]).getValue().getValue() : null;
            LocalizedText localizedText = ((DataValue)objectArray[2]).getStatusCode().isGood() ? (LocalizedText)((DataValue)objectArray[2]).getValue().getValue() : null;
            try {
                uaNode = this.ep.createNode(nodeClass, nodeId, qualifiedName, localizedText, expandedNodeId);
            }
            catch (UaNodeFactoryException uaNodeFactoryException) {
                logger.debug("UaNodeFactoryException: ", uaNodeFactoryException);
                throw new AddressSpaceException("Cannot create node of type " + nodeClass, uaNodeFactoryException);
            }
            UaNode uaNode3 = uaNode;
            synchronized (uaNode3) {
                this.a(nodeId, uaNode, expandedNodeId);
                this.readNode(uaNode);
                if (!nodeId.equals(Identifiers.PropertyType)) {
                    this.readReferences(uaNode, Identifiers.References, BrowseDirection.Both, true);
                    this.readProperties(uaNode);
                }
                logger.debug("getNode: node={}", (Object)uaNode);
                return uaNode;
            }
        }
    }

    @Override
    public <T extends UaNode> T getNode(NodeId nodeId, Class<T> clazz) throws ServiceException, AddressSpaceException {
        return this.getNode(this.getNamespaceTable().toExpandedNodeId(nodeId), clazz);
    }

    @Override
    public UaNode getNode(UaNodeId uaNodeId) throws ServiceException, AddressSpaceException {
        if (ExpandedNodeId.isNull(uaNodeId.asLocalExpandedNodeId())) {
            return null;
        }
        try {
            return this.getNode(this.getNamespaceTable().toNodeId(uaNodeId.asLocalExpandedNodeId()));
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
    }

    @Override
    public <T extends UaNode> T getNode(UaNodeId uaNodeId, Class<T> clazz) throws ServiceException, AddressSpaceException {
        try {
            UaNode uaNode = this.getNode(uaNodeId);
            return (T)uaNode;
        }
        catch (ClassCastException classCastException) {
            throw new AddressSpaceException("NodeId " + uaNodeId + " is not " + clazz, classCastException);
        }
    }

    public EnumSet<NodeClass> getNodeClassSet() {
        return this.ev;
    }

    public UaNode[] getNodes(NodeId ... nodeIdArray) throws AddressSpaceException, ServiceException {
        if (this.ep == null) {
            throw new ServerConnectionException("Cannot use AddressSpace to retrieve nodes before the client is connected", "", null);
        }
        boolean bl = false;
        InternalGetNodesResults internalGetNodesResults = this.a(false, new HashSet<NodeId>(Arrays.asList(nodeIdArray)), null);
        UaNode[] uaNodeArray = new UaNode[nodeIdArray.length];
        for (int i2 = 0; i2 < nodeIdArray.length; ++i2) {
            NodeId nodeId = nodeIdArray[i2];
            uaNodeArray[i2] = internalGetNodesResults.getNode(nodeId);
        }
        return uaNodeArray;
    }

    @Override
    public FolderTypeImpl getObjectsFolder() throws ServiceException, AddressSpaceException {
        return this.getNode(Identifiers.ObjectsFolder, FolderTypeImpl.class);
    }

    public NodeId getReferenceTypeId() {
        return this.ew;
    }

    public EnumSet<BrowseResultMask> getResultMaskSet() {
        return this.ey;
    }

    @Override
    public FolderTypeImpl getRoot() throws ServiceException, AddressSpaceException {
        return this.getNode(Identifiers.RootFolder, FolderTypeImpl.class);
    }

    public ServerTable getServerTable() {
        return this.eq.getServerTable();
    }

    public UaType getType(NodeId nodeId) throws ServiceException, AddressSpaceException {
        UaNode uaNode = this.getNode(nodeId);
        if (uaNode instanceof UaType) {
            return (UaType)uaNode;
        }
        throw new AddressSpaceException("The given NodeId is not for a type (getNode does not return UaType)");
    }

    public ExpandedNodeId getTypeDefinition(NodeId nodeId) throws ServerConnectionException {
        try {
            List<ReferenceDescription> list = this.browse(nodeId, BrowseDirection.Forward, Identifiers.HasTypeDefinition, true, new NodeClass[0]);
            if (list.size() > 0) {
                return list.get(0).getNodeId();
            }
        }
        catch (ServiceException serviceException) {
            logger.debug("ServiceException: ", serviceException);
        }
        catch (StatusException statusException) {
            logger.debug("StatusException: ", statusException);
        }
        return ExpandedNodeId.NULL;
    }

    public ViewDescription getView() {
        return this.eB;
    }

    public Boolean isIncludeSubTypes() {
        return this.es;
    }

    public boolean isRead104Attributes() {
        return this.eA;
    }

    @Override
    @Deprecated
    public void loadModel(InputStream inputStream) throws SAXException, IOException, ModelException, ServiceException {
        this.loadModel(inputStream, null, false);
    }

    @Deprecated
    public void loadModel(InputStream inputStream, Collection<ExpandedNodeId> collection, boolean bl) throws IOException, SAXException, ModelException, ServiceException {
        ModelParser modelParser = new ModelParser(this);
        modelParser.setIgnoredNodes(collection);
        modelParser.setFailOnFirstError(bl);
        modelParser.parseFile(inputStream);
        modelParser.createModel(false);
    }

    @Override
    @Deprecated
    public void loadModel(URI uRI) throws SAXException, IOException, ModelException, ServiceException {
        this.loadModel(uRI, null, false);
    }

    @Deprecated
    public void loadModel(URI uRI, Collection<ExpandedNodeId> collection, boolean bl) throws SAXException, IOException, ModelException, ServiceException {
        ModelParser modelParser = new ModelParser(this);
        modelParser.setIgnoredNodes(collection);
        modelParser.setFailOnFirstError(bl);
        modelParser.parseFile(uRI);
        modelParser.createModel(false);
    }

    public QueryDataSet[] query(NodeTypeDescription[] nodeTypeDescriptionArray, ContentFilter contentFilter) throws ServiceFaultException, ServerConnectionException, ServiceResultException {
        return this.query(nodeTypeDescriptionArray, contentFilter, this.getMaxDataSetsPerQuery(), this.getMaxReferencesPerNode());
    }

    public QueryDataSet[] query(NodeTypeDescription[] nodeTypeDescriptionArray, ContentFilter contentFilter, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) throws ServiceFaultException, ServerConnectionException, ServiceResultException {
        return this.query(this.eB, nodeTypeDescriptionArray, contentFilter, unsignedInteger, unsignedInteger2);
    }

    public QueryFirstResponse queryFirst(NodeTypeDescription[] nodeTypeDescriptionArray, ContentFilter contentFilter) throws ServiceFaultException, ServerConnectionException, ServiceResultException {
        return this.cnY().QueryFirst(this.getRequestHeader(), this.eB, nodeTypeDescriptionArray, contentFilter, this.getMaxDataSetsPerQuery(), this.getMaxReferencesPerNode());
    }

    public QueryFirstResponse queryFirst(QueryFirstRequest queryFirstRequest) throws ServiceFaultException, ServerConnectionException, ServiceResultException {
        return this.cnY().QueryFirst(queryFirstRequest);
    }

    public QueryNextResponse queryNext(boolean bl, byte[] byArray) throws ServiceFaultException, ServerConnectionException, ServiceResultException {
        return this.queryNext(bl, ByteString.valueOf(byArray));
    }

    public QueryNextResponse queryNext(boolean bl, ByteString byteString) throws ServiceFaultException, ServerConnectionException, ServiceResultException {
        return this.cnY().QueryNext(this.getRequestHeader(), bl, byteString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusCode[] readAttributes(UaNode uaNode, UnsignedInteger ... unsignedIntegerArray) throws ServiceException {
        UaNode uaNode2 = uaNode;
        synchronized (uaNode2) {
            int n2;
            if (logger.isDebugEnabled()) {
                logger.debug("readAttributes(" + uaNode + ", " + Arrays.toString(unsignedIntegerArray) + ")");
            }
            DataValue[] dataValueArray = this.eq.readAttributes(uaNode.getNodeId(), unsignedIntegerArray);
            StatusCode[] statusCodeArray = new StatusCode[unsignedIntegerArray.length];
            int n3 = -1;
            for (n2 = 0; n2 < unsignedIntegerArray.length; ++n2) {
                if (!Attributes.DataType.equals(unsignedIntegerArray[n2])) continue;
                n3 = n2;
            }
            if (n3 != -1) {
                n2 = n3;
                this.a(uaNode, dataValueArray, statusCodeArray, n2, unsignedIntegerArray);
            }
            for (n2 = 0; n2 < dataValueArray.length; ++n2) {
                if (n2 == n3) continue;
                this.a(uaNode, dataValueArray, statusCodeArray, n2, unsignedIntegerArray);
            }
            return statusCodeArray;
        }
    }

    public void readComponents(UaNode uaNode) throws ServiceException {
        this.readReferences(uaNode, Identifiers.HasComponent, BrowseDirection.Forward, false);
    }

    public void readNode(UaNode uaNode) throws ServiceException {
        logger.debug("readNode: node={}", (Object)uaNode);
        Object[] objectArray = uaNode.getSupportedAttributes();
        if (logger.isDebugEnabled()) {
            logger.debug("readNode: attributes=" + Arrays.toString(objectArray));
        }
        this.readAttributes(uaNode, (UnsignedInteger[])objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readProperties(UaNode uaNode) throws ServiceException {
        UaNode uaNode2 = uaNode;
        synchronized (uaNode2) {
            UaProperty[] uaPropertyArray = uaNode.getProperties();
            if (logger.isDebugEnabled()) {
                logger.debug("readProperties: node=" + uaNode.getBrowseName() + (uaPropertyArray == null ? " properties=null " : " properties.length " + uaPropertyArray.length));
            }
            if (uaPropertyArray != null && uaPropertyArray.length > 0) {
                NodeId[] nodeIdArray = new NodeId[uaPropertyArray.length];
                int n2 = 0;
                for (UaProperty uaProperty : uaPropertyArray) {
                    nodeIdArray[n2++] = uaProperty.getNodeId();
                }
                Object[] objectArray = this.eq.readValues(nodeIdArray, TimestampsToReturn.Both);
                n2 = 0;
                for (UaProperty uaProperty : uaPropertyArray) {
                    try {
                        logger.trace("readProperties: property={} value={}", (Object)uaProperty.getBrowseName(), objectArray[n2]);
                        uaProperty.setValue((DataValue)objectArray[n2++]);
                    }
                    catch (Exception exception) {
                        logger.warn("Failed to set value of property " + uaProperty, exception);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readReferences(UaNode uaNode, NodeId nodeId, BrowseDirection browseDirection, boolean bl) throws ServiceException {
        UaNode uaNode2 = uaNode;
        synchronized (uaNode2) {
            logger.debug("readReferences: node={}", (Object)uaNode.getBrowseName());
            try {
                List<ReferenceDescription> list = this.browse(uaNode.getNodeId(), browseDirection, nodeId, bl, new NodeClass[0]);
                if (logger.isDebugEnabled()) {
                    logger.debug("readReferences: references.size()={}", (Object)list.size());
                    for (ReferenceDescription cloneable2 : list) {
                        logger.debug("readReferences: (node={}) r={}", (Object)uaNode.getBrowseName(), (Object)cloneable2.getBrowseName());
                    }
                }
                ArrayList<UaReference> arrayList = new ArrayList<UaReference>();
                arrayList.addAll(Arrays.asList(uaNode.getReferences()));
                if (logger.isDebugEnabled()) {
                    logger.debug("readReferences: (node=" + uaNode.getBrowseName() + ") oldReferences.size()=" + arrayList.size());
                    logger.debug("readReferences: (node=" + uaNode.getBrowseName() + ") oldReferences=" + arrayList);
                }
                ArrayList<UaReference> arrayList2 = new ArrayList<UaReference>();
                for (ReferenceDescription referenceDescription : list) {
                    logger.debug("readReferences: (node={}) refDescription={}", (Object)uaNode.getBrowseName(), (Object)referenceDescription);
                    UaReference uaReference = uaNode.addReference(referenceDescription.getNodeId(), referenceDescription.getReferenceTypeId(), referenceDescription.getIsForward() == false);
                    arrayList2.add(uaReference);
                    arrayList.remove(uaReference);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("readReferences: (node=" + uaNode.getBrowseName() + ") newReferences.size()=" + arrayList2.size());
                    logger.debug("readReferences: (node=" + uaNode.getBrowseName() + ") newReferences=" + arrayList2);
                    logger.debug("readReferences: (node=" + uaNode.getBrowseName() + ") remaining oldReferences.size()=" + arrayList.size());
                    logger.debug("readReferences: (node=" + uaNode.getBrowseName() + ") remaining oldReferences=" + arrayList);
                }
                Iterator<ReferenceDescription> iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    UaReference uaReference = (UaReference)((Object)iterator.next());
                    uaNode.deleteReference(uaReference);
                }
            }
            catch (StatusException statusException) {
                if (statusException.getStatusCode().getValue().equals(StatusCodes.Bad_NodeIdUnknown)) {
                    logger.warn("readReferences, unknown node: " + uaNode.getNodeId(), statusException);
                }
                logger.error("readReferences", statusException);
            }
        }
    }

    public NodeId[] registerNodes(NodeId ... nodeIdArray) throws ServiceException {
        RegisterNodesResponse registerNodesResponse;
        try {
            registerNodesResponse = this.cnY().RegisterNodes(this.getRequestHeader(), nodeIdArray);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult(registerNodesResponse, null);
        Object[] objectArray = registerNodesResponse.getRegisteredNodeIds();
        this.a(objectArray, nodeIdArray);
        if (this.ex == null) {
            this.ex = new ArrayList<NodeId>();
        }
        for (Object object : objectArray) {
            if (this.ex.contains(object)) continue;
            this.ex.add((NodeId)object);
        }
        return objectArray;
    }

    public void setBrowseDirection(BrowseDirection browseDirection) {
        this.eo = browseDirection;
    }

    public void setIncludeSubTypes(Boolean bl) {
        this.es = bl;
    }

    public void setMaxDataSetsPerQuery(int n2) {
        this.et = UnsignedInteger.valueOf(n2);
    }

    public void setMaxReferencesPerNode(int n2) {
        this.eu = UnsignedInteger.valueOf(n2);
    }

    public void setNodeClassSet(EnumSet<NodeClass> enumSet) {
        this.ev = enumSet;
    }

    public void setRead104Attributes(boolean bl) {
        this.eA = bl;
    }

    public void setReferenceTypeId(NodeId nodeId) {
        this.ew = nodeId;
    }

    public void setResultMaskSet(EnumSet<BrowseResultMask> enumSet) {
        this.ey = enumSet;
    }

    public void setView(ViewDescription viewDescription) {
        this.eB = viewDescription;
    }

    public BrowsePathResult[] translateBrowsePathsToNodeIds(BrowsePath ... browsePathArray) throws ServiceException {
        TranslateBrowsePathsToNodeIdsResponse translateBrowsePathsToNodeIdsResponse;
        try {
            translateBrowsePathsToNodeIdsResponse = this.cnY().TranslateBrowsePathsToNodeIds(this.getRequestHeader(), browsePathArray);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        this.checkServiceResult(translateBrowsePathsToNodeIdsResponse, translateBrowsePathsToNodeIdsResponse.getDiagnosticInfos());
        this.a(translateBrowsePathsToNodeIdsResponse.getResults(), browsePathArray);
        return translateBrowsePathsToNodeIdsResponse.getResults();
    }

    public BrowsePathResult[] translateBrowsePathsToNodeIds(NodeId nodeId, RelativePath ... relativePathArray) throws ServiceException {
        BrowsePath[] browsePathArray = new BrowsePath[relativePathArray.length];
        for (int i2 = 0; i2 < relativePathArray.length; ++i2) {
            browsePathArray[i2] = new BrowsePath(nodeId, relativePathArray[i2]);
        }
        return this.translateBrowsePathsToNodeIds(browsePathArray);
    }

    public BrowsePathTarget[] translateBrowsePathToNodeId(NodeId nodeId, RelativePathElement ... relativePathElementArray) throws ServiceException, StatusException {
        RelativePath relativePath = new RelativePath(relativePathElementArray);
        BrowsePath browsePath = new BrowsePath(nodeId, relativePath);
        BrowsePathResult browsePathResult = this.translateBrowsePathsToNodeIds(browsePath)[0];
        this.checkOperationResult(browsePathResult.getStatusCode());
        return browsePathResult.getTargets();
    }

    @Override
    public BrowsePathTarget[] translateBrowsePathToNodeIds(NodeId nodeId, RelativePath relativePath) throws StatusException, ServiceException {
        return this.translateBrowsePathToNodeId(nodeId, relativePath.getElements());
    }

    public NodeId[] unregisterAllNodes() throws ServiceException {
        NodeId[] nodeIdArray = new NodeId[]{};
        if (this.ex != null) {
            nodeIdArray = this.ex.toArray(nodeIdArray);
            this.unregisterNodes(nodeIdArray);
        }
        return nodeIdArray;
    }

    public void unregisterNodes(NodeId ... nodeIdArray) throws ServiceException {
        try {
            NodeId[] nodeIdArray2 = this.cnY().UnregisterNodes(this.getRequestHeader(), nodeIdArray);
            this.checkServiceResult((ServiceResponse)nodeIdArray2, null);
        }
        catch (ServiceFaultException serviceFaultException) {
            throw new ServiceException(serviceFaultException);
        }
        catch (ServiceResultException serviceResultException) {
            throw new ServiceException(serviceResultException);
        }
        for (NodeId nodeId : nodeIdArray) {
            this.ex.remove(nodeId);
        }
    }

    private AsyncResult<InternalBrowseResults> a(boolean bl, final Set<NodeId> set, final BrowseDirection browseDirection, final NodeId nodeId, final boolean bl2, final EnumSet<NodeClass> enumSet, final EnumSet<BrowseResultMask> enumSet2) {
        if (!bl) {
            final AsyncResultImpl<InternalBrowseResults> asyncResultImpl = new AsyncResultImpl<InternalBrowseResults>();
            StackUtils.getBlockingWorkExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        asyncResultImpl.setResult(AddressSpace.this.a(set, browseDirection, nodeId, bl2, enumSet, enumSet2));
                    }
                    catch (ServiceException serviceException) {
                        asyncResultImpl.setError(new ServiceResultException(serviceException.getServiceResult(), (Throwable)serviceException));
                    }
                }
            });
            return asyncResultImpl;
        }
        int n2 = this.eq.getActualOperationLimits().getMaxNodesPerBrowse().intValue();
        Set<g> set2 = g.c(set, browseDirection, nodeId, bl2, enumSet, enumSet2).b(n2);
        final HashSet<AsyncResult<InternalBrowseResults>> hashSet = new HashSet<AsyncResult<InternalBrowseResults>>();
        for (g g2 : set2) {
            hashSet.add(this.a(false, g2.cok(), g2.coi(), g2.getReferenceType(), g2.col(), g2.coj(), g2.getResultMask()));
        }
        final AsyncResultImpl asyncResultImpl = new AsyncResultImpl();
        StackUtils.getBlockingWorkExecutor().execute(new Runnable(){

            @Override
            public void run() {
                HashSet<InternalBrowseResults> hashSet2 = new HashSet<InternalBrowseResults>();
                for (AsyncResult asyncResult : hashSet) {
                    try {
                        hashSet2.add((InternalBrowseResults)asyncResult.waitForResult());
                    }
                    catch (ServiceResultException serviceResultException) {
                        asyncResultImpl.setError(serviceResultException);
                        break;
                    }
                }
                asyncResultImpl.setResult(InternalBrowseResults.mergeOf(hashSet2));
            }
        });
        return asyncResultImpl;
    }

    private SessionChannel cnY() throws ServerConnectionException {
        return this.eq.cnY();
    }

    private UnsignedInteger getNodeClassMask() {
        return NodeClass.getMask(this.ev);
    }

    private UnsignedInteger getResultMask() {
        return BrowseResultMask.getMask(this.ey);
    }

    private void a(UaNode uaNode, DataValue[] dataValueArray, StatusCode[] statusCodeArray, int n2, UnsignedInteger ... unsignedIntegerArray) {
        if (dataValueArray[n2] != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("readAttributes: attribute=" + AttributesUtil.toString(unsignedIntegerArray[n2]) + " value=" + dataValueArray[n2]);
            }
            if (!unsignedIntegerArray[n2].equals(Attributes.NodeClass)) {
                try {
                    uaNode.setAttribute(unsignedIntegerArray[n2], dataValueArray[n2]);
                    statusCodeArray[n2] = StatusCode.GOOD;
                }
                catch (StatusException statusException) {
                    logger.debug("StatusException: ", statusException);
                    statusCodeArray[n2] = statusException.getStatusCode();
                }
            }
        }
    }

    private NodeId toNodeId(ExpandedNodeId expandedNodeId) throws StatusException {
        try {
            return this.getNamespaceTable().toNodeId(expandedNodeId);
        }
        catch (ServiceResultException serviceResultException) {
            throw new StatusException(serviceResultException);
        }
    }

    private NodeId e(UaNodeId uaNodeId) throws StatusException {
        try {
            return this.getNamespaceTable().toNodeId(uaNodeId.asLocalExpandedNodeId());
        }
        catch (ServiceResultException serviceResultException) {
            throw new StatusException(serviceResultException);
        }
    }

    protected List<ReferenceDescription> browse(NodeId nodeId, BrowseDescription browseDescription) throws ServerConnectionException, ServiceException, StatusException {
        if (nodeId == null) {
            throw new NullPointerException("nodeId");
        }
        ArrayList<ReferenceDescription> arrayList = new ArrayList<ReferenceDescription>();
        BrowseResult browseResult = this.browse(null, this.getMaxReferencesPerNode().intValue(), browseDescription)[0];
        while (true) {
            this.checkOperationResult(browseResult.getStatusCode());
            if (browseResult.getReferences() != null) {
                for (ReferenceDescription referenceDescription : browseResult.getReferences()) {
                    arrayList.add(referenceDescription);
                }
            }
            ByteString byteString = browseResult.getContinuationPoint();
            logger.debug("browse: c={}", (Object)byteString);
            if (byteString == null || byteString.getLength() == 0) break;
            browseResult = this.browseNext(false, byteString)[0];
        }
        return arrayList;
    }

    protected QueryDataSet[] query(ViewDescription viewDescription, NodeTypeDescription[] nodeTypeDescriptionArray, ContentFilter contentFilter, UnsignedInteger unsignedInteger, UnsignedInteger unsignedInteger2) throws ServiceFaultException, ServerConnectionException, ServiceResultException {
        ArrayList<QueryDataSet> arrayList;
        block3: {
            QueryNextResponse queryNextResponse;
            QueryFirstResponse queryFirstResponse = this.cnY().QueryFirst(this.getRequestHeader(), viewDescription, nodeTypeDescriptionArray, contentFilter, unsignedInteger, unsignedInteger2);
            arrayList = new ArrayList<QueryDataSet>();
            for (QueryDataSet queryDataSetArray : queryFirstResponse.getQueryDataSets()) {
                arrayList.add(queryDataSetArray);
            }
            Object object = queryFirstResponse.getContinuationPoint();
            if (object == null) break block3;
            do {
                QueryNextRequest queryNextRequest = new QueryNextRequest(this.getRequestHeader(), Boolean.FALSE, (ByteString)object);
                queryNextResponse = this.cnY().QueryNext(queryNextRequest);
                for (QueryDataSet queryDataSet : queryNextResponse.getQueryDataSets()) {
                    arrayList.add(queryDataSet);
                }
            } while ((object = queryNextResponse.getRevisedContinuationPoint()) != null && ((ByteString)object).getLength() != 0);
        }
        return arrayList.toArray(new QueryDataSet[0]);
    }

    InternalBrowseResults b(boolean bl, Set<NodeId> set, BrowseDirection browseDirection, NodeId nodeId, boolean bl2, EnumSet<NodeClass> enumSet, EnumSet<BrowseResultMask> enumSet2) throws ServiceException {
        if (bl) {
            try {
                return this.a(true, set, browseDirection, nodeId, bl2, enumSet, enumSet2).waitForResult();
            }
            catch (ServiceResultException serviceResultException) {
                if (serviceResultException.getCause() instanceof ServiceException) {
                    throw (ServiceException)serviceResultException.getCause();
                }
                throw new ServiceException("Could not Browse", serviceResultException);
            }
        }
        return this.a(set, browseDirection, nodeId, bl2, enumSet, enumSet2);
    }

    InternalBrowseResults a(Set<NodeId> set, BrowseDirection browseDirection, NodeId nodeId, boolean bl, EnumSet<NodeClass> enumSet, EnumSet<BrowseResultMask> enumSet2) throws ServiceException {
        Map.Entry entry4;
        Iterator iterator;
        Cloneable cloneable;
        HashMap hashMap = new HashMap();
        BrowseDescription browseDescription = new BrowseDescription(null, browseDirection, nodeId, bl, NodeClass.getMask(enumSet), BrowseResultMask.getMask(enumSet2));
        ArrayList<BrowseDescription> arrayList = new ArrayList<BrowseDescription>();
        HashSet<NodeId> hashSet = new HashSet<NodeId>();
        for (NodeId object2 : set) {
            BrowseDescription n2 = browseDescription.clone();
            n2.setNodeId(object2);
            arrayList.add(n2);
            hashSet.add(object2);
            hashMap.put(object2, new ArrayList());
        }
        HashMap hashMap2 = new HashMap();
        f f2 = this.b(hashSet, browseDirection, nodeId, bl, enumSet, enumSet2);
        int n2 = f2.getBrowseCalls();
        HashMap<NodeId, Object> hashMap3 = new HashMap<NodeId, Object>();
        for (Map.Entry<NodeId, BrowseResult> entry2 : f2.getData().entrySet()) {
            NodeId n3 = entry2.getKey();
            cloneable = entry2.getValue();
            iterator = ((BrowseResult)cloneable).getStatusCode();
            hashMap2.put(n3, iterator);
            entry4 = ((BrowseResult)cloneable).getContinuationPoint();
            if (((BrowseResult)cloneable).getReferences() != null && ((BrowseResult)cloneable).getReferences().length != 0) {
                ((List)hashMap.get(entry2.getKey())).addAll(Arrays.asList(((BrowseResult)cloneable).getReferences()));
            }
            if (entry4 == null || ((ByteString)((Object)entry4)).getLength() == 0) continue;
            hashMap3.put(n3, entry4);
        }
        long l2 = this.eq.getActualOperationLimits().getMaxNodesPerBrowse().longValue();
        int n3 = 0;
        while (!hashMap3.isEmpty()) {
            cloneable = new ArrayList();
            iterator = new ArrayList();
            entry4 = hashMap3.entrySet().iterator();
            int n4 = 0;
            while ((long)n4 < l2 && entry4.hasNext()) {
                Map.Entry entry3 = (Map.Entry)entry4.next();
                cloneable.add(entry3.getKey());
                iterator.add(entry3.getValue());
                entry4.remove();
                ++n4;
            }
            BrowseResult[] n42 = this.browseNext(false, iterator.toArray((ByteString[])new ByteString[0]));
            ++n3;
            for (int entry3 = 0; entry3 < n42.length; ++entry3) {
                BrowseResult browseResult = n42[entry3];
                NodeId nodeId2 = (NodeId)cloneable.get(entry3);
                StatusCode statusCode = browseResult.getStatusCode();
                hashMap2.put(nodeId2, statusCode);
                ByteString byteString = browseResult.getContinuationPoint();
                if (browseResult.getReferences() != null && browseResult.getReferences().length != 0) {
                    ((List)hashMap.get(nodeId2)).addAll(Arrays.asList(browseResult.getReferences()));
                }
                if (byteString == null || byteString.getLength() == 0) continue;
                hashMap3.put(nodeId2, byteString);
            }
        }
        cloneable = new HashMap();
        for (Map.Entry entry4 : hashMap.entrySet()) {
            cloneable.put(entry4.getKey(), Collections.unmodifiableList((List)entry4.getValue()));
        }
        return InternalBrowseResults.a(Collections.unmodifiableMap(cloneable), hashMap2, n2, n3);
    }

    f b(Set<NodeId> set, BrowseDirection browseDirection, NodeId nodeId, boolean bl, EnumSet<NodeClass> enumSet, EnumSet<BrowseResultMask> enumSet2) throws ServiceException {
        long l2 = this.eq.getActualOperationLimits().getMaxNodesPerBrowse().longValue();
        if (l2 != 0L && (long)set.size() > l2) {
            HashSet<NodeId> hashSet = new HashSet<NodeId>();
            HashSet<NodeId> hashSet2 = new HashSet<NodeId>();
            NodeId[] nodeIdArray = set.toArray(new NodeId[0]);
            for (int i2 = 0; i2 < nodeIdArray.length; ++i2) {
                if ((long)i2 < l2) {
                    hashSet.add(nodeIdArray[i2]);
                    continue;
                }
                hashSet2.add(nodeIdArray[i2]);
            }
            f f2 = this.b(hashSet, browseDirection, nodeId, bl, enumSet, enumSet2);
            f f3 = this.b(hashSet2, browseDirection, nodeId, bl, enumSet, enumSet2);
            return f.b(Arrays.asList(f2, f3));
        }
        BrowseDescription browseDescription = new BrowseDescription(null, browseDirection, nodeId, bl, NodeClass.getMask(enumSet), BrowseResultMask.getMask(enumSet2));
        ArrayList<BrowseDescription> arrayList = new ArrayList<BrowseDescription>();
        ArrayList<NodeId> arrayList2 = new ArrayList<NodeId>();
        for (NodeId object2 : set) {
            BrowseDescription i3 = browseDescription.clone();
            i3.setNodeId(object2);
            arrayList.add(i3);
            arrayList2.add(object2);
        }
        BrowseResult[] browseResultArray = this.browse(null, this.eu.intValue(), arrayList.toArray(new BrowseDescription[0]));
        HashMap hashMap = new HashMap();
        for (int i2 = 0; i2 < browseResultArray.length; ++i2) {
            hashMap.put(arrayList2.get(i2), browseResultArray[i2]);
        }
        return f.a(Collections.unmodifiableMap(hashMap), 1);
    }

    BrowseResult[] a(ViewDescription viewDescription, int n2, BrowseDescription ... browseDescriptionArray) throws ServiceException {
        int n3 = 0;
        int n4 = browseDescriptionArray.length;
        if (n4 == 0) {
            return null;
        }
        OperationLimits operationLimits = this.getClient().getActualOperationLimits();
        n3 = operationLimits.getMaxNodesPerBrowse().intValue();
        BrowseResult[] browseResultArray = new BrowseResult[n4];
        int n5 = 0;
        while (n5 < n4) {
            BrowseResponse browseResponse;
            int n6 = Math.min(n5 + n3, n4);
            try {
                browseResponse = this.cnY().Browse(this.getRequestHeader(), viewDescription, UnsignedInteger.valueOf(n2), Arrays.copyOfRange(browseDescriptionArray, n5, n6));
            }
            catch (ServiceFaultException serviceFaultException) {
                throw new ServiceException(serviceFaultException);
            }
            catch (ServiceResultException serviceResultException) {
                throw new ServiceException(serviceResultException);
            }
            this.checkServiceResult(browseResponse, browseResponse.getDiagnosticInfos());
            BrowseResult[] browseResultArray2 = browseResponse.getResults();
            ArrayList<ByteString> arrayList = new ArrayList<ByteString>();
            int n7 = 0;
            for (BrowseResult browseResult : browseResultArray2) {
                ByteString byteString = browseResult.getContinuationPoint();
                if (byteString != null) {
                    arrayList.add(byteString);
                    continue;
                }
                browseResultArray[n5 + n7] = browseResult;
            }
            int n8 = arrayList.size();
            while (n8 > 0) {
                n8 = 0;
                ByteString[] byteStringArray = new ByteString[arrayList.size()];
                arrayList.toArray(byteStringArray);
                arrayList.clear();
                for (BrowseResult browseResult : browseResultArray2 = this.browseNext(false, byteStringArray)) {
                    ByteString byteString = browseResult.getContinuationPoint();
                    if (byteString != null) {
                        arrayList.add(byteString);
                        ++n8;
                        continue;
                    }
                    for (BrowseResult browseResult2 : browseResultArray) {
                        if (browseResult2 != null) continue;
                        browseResult2 = browseResult;
                    }
                }
            }
            System.arraycopy(browseResponse.getResults(), 0, browseResultArray, n5, n6 - n5);
            n5 = n6;
        }
        return browseResultArray;
    }

    void checkOperationResult(StatusCode statusCode) throws StatusException {
        this.eq.checkOperationResult(statusCode);
    }

    void a(Object[] objectArray, Object[] objectArray2) throws ServiceException {
        this.eq.a(objectArray, objectArray2);
    }

    void checkServiceResult(ServiceResponse serviceResponse, DiagnosticInfo[] diagnosticInfoArray) throws ServiceException {
        this.eq.checkServiceResult(serviceResponse, diagnosticInfoArray);
    }

    InternalGetNodesResults a(boolean bl, Set<NodeId> set, InternalBrowseResults internalBrowseResults) throws AddressSpaceException, ServerConnectionException {
        InternalBrowseResults internalBrowseResults2;
        i i2;
        Object object;
        Object object2;
        Object object3;
        Object object42;
        Object object9;
        Object object52;
        if (this.ep == null) {
            throw new ServerConnectionException("Cannot use AddressSpace to retrieve nodes before the client is connected", "", null);
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        HashMap<NodeId, StatusCode> hashMap = new HashMap<NodeId, StatusCode>();
        HashMap<NodeId, UaNode> hashMap2 = new HashMap<NodeId, UaNode>();
        HashMap hashMap3 = new HashMap();
        HashSet<NodeId> hashSet2 = new HashSet<NodeId>();
        for (NodeId hashSet3 : set) {
            object52 = this.getCache().getNode(hashSet3);
            if (object52 != null) {
                hashMap2.put(hashSet3, (UaNode)object52);
                continue;
            }
            hashSet2.add(hashSet3);
            hashMap3.put(hashSet3, new HashMap());
            ((Map)hashMap3.get(hashSet3)).put(Attributes.NodeId, new DataValue(new Variant(hashSet3)));
        }
        if (hashSet2.isEmpty()) {
            object9 = Collections.emptyMap();
            return InternalGetNodesResults.a(Collections.unmodifiableMap(hashMap2), (Map<NodeId, StatusCode>)object9, 0, 0, 0);
        }
        try {
            if (internalBrowseResults != null) {
                object9 = internalBrowseResults;
            } else {
                object9 = this.b(bl, hashSet2, BrowseDirection.Both, ReferenceTypeIdentifiers.References, true, NodeClass.ALL, BrowseResultMask.ALL);
                n3 += ((InternalBrowseResults)object9).getNumberOfBrowseRequests();
                n4 += ((InternalBrowseResults)object9).getNumberOfBrowseNextRequests();
            }
        }
        catch (ServiceException serviceException) {
            throw new AddressSpaceException("Could not Browse all nodes", serviceException);
        }
        hashMap.putAll(((InternalBrowseResults)object9).con());
        hashSet2.removeAll(hashMap.keySet());
        for (Object object52 : hashMap.keySet()) {
            hashMap3.remove(object52);
        }
        logger.debug("getNodes, failed NodeIds: {}", (Object)((InternalBrowseResults)object9).com());
        HashSet<NodeId> hashSet = new HashSet<NodeId>();
        hashSet.addAll(hashSet2);
        object52 = new HashMap<Object, Object>();
        for (List<ReferenceDescription> list : ((InternalBrowseResults)object9).asRawMap().values()) {
            for (ReferenceDescription referenceDescription : list) {
                Object object6;
                if (!referenceDescription.getNodeId().isLocal()) continue;
                try {
                    object6 = this.getNamespaceTable().toNodeId(referenceDescription.getNodeId());
                }
                catch (ServiceResultException serviceResultException) {
                    logger.error("Cannot convert {} to NodeId", (Object)referenceDescription.getNodeId(), (Object)serviceResultException);
                    continue;
                }
                if (!hashSet.contains(object6)) continue;
                Map map = (Map)hashMap3.get(object6);
                map.put(Attributes.NodeClass, new DataValue(new Variant(referenceDescription.getNodeClass())));
                map.put(Attributes.BrowseName, new DataValue(new Variant(referenceDescription.getBrowseName())));
                map.put(Attributes.DisplayName, new DataValue(new Variant(referenceDescription.getDisplayName())));
                hashSet.remove(object6);
                if (NodeClass.Variable != referenceDescription.getNodeClass() && NodeClass.Object != referenceDescription.getNodeClass() || !referenceDescription.getTypeDefinition().isLocal()) continue;
                try {
                    object42 = this.getNamespaceTable().toNodeId(referenceDescription.getTypeDefinition());
                    object52.put(object6, object42);
                }
                catch (ServiceResultException serviceResultException) {
                    logger.error("Cannot convert {} to NodeId", (Object)referenceDescription.getTypeDefinition(), (Object)serviceResultException);
                }
            }
        }
        if (!hashSet.isEmpty()) {
            Map<NodeId, Map<UnsignedInteger, DataValue>> map;
            object3 = new HashSet();
            object3.add((UnsignedInteger)Attributes.NodeClass);
            object3.add((UnsignedInteger)Attributes.BrowseName);
            object3.add(Attributes.DisplayName);
            try {
                object2 = this.a(hashSet, (Set<UnsignedInteger>)object3, TimestampsToReturn.Neither, bl);
                map = ((i)object2).asRawMap();
            }
            catch (ServiceException serviceException) {
                throw new AddressSpaceException("Could not Read all required Attributes witin getNodes", serviceException);
            }
            n2 += ((i)object2).coq();
            for (Object object6 : map.entrySet()) {
                ((Map)hashMap3.get(object6.getKey())).putAll((Map)object6.getValue());
            }
        }
        for (Map.Entry entry : hashMap3.entrySet()) {
            NodeClass nodeClass;
            object2 = (NodeId)entry.getKey();
            if (object52.containsKey(object2) || NodeClass.Variable != (nodeClass = NodeClass.valueOf(((DataValue)((Map)entry.getValue()).get(Attributes.NodeClass)).getValue().intValue())) && NodeClass.Object != nodeClass) continue;
            boolean bl2 = false;
            for (Object object42 : ((InternalBrowseResults)object9).getReferences((NodeId)object2)) {
                if (!Boolean.TRUE.equals(((ReferenceDescription)object42).getIsForward()) || !ReferenceTypeIdentifiers.HasTypeDefinition.equals(((ReferenceDescription)object42).getReferenceTypeId())) continue;
                if (((ReferenceDescription)object42).getNodeId().isLocal()) {
                    try {
                        if (ExpandedNodeId.isNull(((ReferenceDescription)object42).getNodeId())) continue;
                        object = this.getNamespaceTable().toNodeId(((ReferenceDescription)object42).getNodeId());
                        object52.put(object2, object);
                        bl2 = true;
                        logger.debug("Found TypeDefinition: {}, for NodeId: {}", object, object2);
                        break;
                    }
                    catch (ServiceResultException serviceResultException) {
                        logger.error("Cannot convert {} to NodeId", (Object)((ReferenceDescription)object42).getNodeId(), (Object)serviceResultException);
                        continue;
                    }
                }
                logger.info("Encountered non-local TypeDefinition: {}, skipping node {} from getNodes", (Object)((ReferenceDescription)object42).getNodeId(), object2);
            }
            if (bl2) continue;
            logger.warn("Could not find TypeDefinition for {} NodeId: {}", (Object)nodeClass, object2);
        }
        object3 = new HashMap();
        EnumMap<NodeClass, Cloneable> enumMap = new EnumMap<NodeClass, Cloneable>(NodeClass.class);
        for (NodeClass nodeClass : NodeClass.values()) {
            object42 = new HashSet<UnsignedInteger>(AttributesUtil.getSupportedAttributes(nodeClass));
            object42.removeAll(Arrays.asList(Attributes.NodeId, Attributes.NodeClass, Attributes.BrowseName, Attributes.DisplayName));
            enumMap.put(nodeClass, (Cloneable)object42);
        }
        for (Map.Entry entry : hashMap3.entrySet()) {
            NodeClass nodeClass = (NodeClass)((DataValue)((Map)entry.getValue()).get(Attributes.NodeClass)).getValue().asEnum(NodeClass.class);
            object3.put(entry.getKey(), enumMap.get(nodeClass));
        }
        try {
            i2 = this.a((Map<NodeId, Set<UnsignedInteger>>)object3, TimestampsToReturn.Both, bl);
            object2 = i2.asRawMap();
        }
        catch (ServiceException serviceException) {
            throw new AddressSpaceException("Could not Read all required Attributes witin getNodes", serviceException);
        }
        n2 += i2.coq();
        for (Map.Entry entry : object2.entrySet()) {
            ((Map)hashMap3.get(entry.getKey())).putAll((Map)entry.getValue());
        }
        Object object7 = internalBrowseResults == null ? object9 : InternalBrowseResults.mergeOf(Arrays.asList(internalBrowseResults, object9));
        Map<NodeId, Map<QualifiedName, NodeId>> map = this.a((InternalBrowseResults)object7);
        object = new AtomicInteger(0);
        try {
            object42 = this.a(map, (AtomicInteger)object, bl);
        }
        catch (ServiceException serviceException) {
            throw new AddressSpaceException("Could not resolve all required Properties witin getNodes", serviceException);
        }
        n2 += ((AtomicInteger)object).get();
        HashSet<NodeId> hashSet3 = new HashSet<NodeId>();
        for (Map.Entry<NodeId, Map<QualifiedName, NodeId>> entry : map.entrySet()) {
            hashSet3.addAll(entry.getValue().values());
        }
        try {
            internalBrowseResults2 = !hashSet3.isEmpty() ? InternalAddressSpaceAccessHelper.internalBrowseAllDataWithNodeIds(bl, this, hashSet3) : null;
        }
        catch (ServiceException serviceException) {
            throw new AddressSpaceException("Could not resolve all required Properties witin getNodes", serviceException);
        }
        HashMap<NodeId, a> hashMap4 = new HashMap<NodeId, a>();
        for (Map.Entry entry : hashMap3.entrySet()) {
            NodeId nodeId = (NodeId)entry.getKey();
            ExpandedNodeId expandedNodeId = null;
            if (object52.containsKey(nodeId)) {
                expandedNodeId = this.getNamespaceTable().toExpandedNodeId((NodeId)object52.get(nodeId));
            }
            a a2 = a.a((Map)entry.getValue(), ((InternalBrowseResults)object9).getReferences(nodeId), map.get(nodeId), (Map)object42.get(nodeId), expandedNodeId);
            hashMap4.put(nodeId, a2);
        }
        hashMap2.putAll(this.ep.a(this, b.a(hashMap4, internalBrowseResults2)));
        HashMap hashMap5 = new HashMap();
        return InternalGetNodesResults.a(hashMap2, hashMap5, n2, n3, n4);
    }

    RequestHeader getRequestHeader() {
        return this.eq.getRequestHeader();
    }

    i a(Map<NodeId, Set<UnsignedInteger>> map, TimestampsToReturn timestampsToReturn, boolean bl) throws ServiceException {
        return this.eq.b(bl, map, timestampsToReturn);
    }

    i a(Set<NodeId> set, Set<UnsignedInteger> set2, TimestampsToReturn timestampsToReturn, boolean bl) throws ServiceException {
        HashMap<NodeId, Set<UnsignedInteger>> hashMap = new HashMap<NodeId, Set<UnsignedInteger>>();
        for (NodeId nodeId : set) {
            hashMap.put(nodeId, set2);
        }
        return this.a(hashMap, timestampsToReturn, bl);
    }

    i a(Set<NodeId> set, UnsignedInteger unsignedInteger, TimestampsToReturn timestampsToReturn, boolean bl) throws ServiceException {
        return this.a(set, new HashSet<UnsignedInteger>(Arrays.asList(unsignedInteger)), timestampsToReturn, bl);
    }

    void cnZ() {
        this.ep.clear();
    }

    Map<NodeId, Map<QualifiedName, NodeId>> a(InternalBrowseResults internalBrowseResults) {
        HashMap hashMap = new HashMap();
        for (Map.Entry<NodeId, List<ReferenceDescription>> object : internalBrowseResults.asRawMap().entrySet()) {
            NodeId nodeId = object.getKey();
            HashMap<QualifiedName, NodeId> hashMap2 = new HashMap<QualifiedName, NodeId>();
            for (ReferenceDescription referenceDescription : object.getValue()) {
                if (!ReferenceTypeIdentifiers.HasProperty.equals(referenceDescription.getReferenceTypeId()) || !referenceDescription.getIsForward().booleanValue() || referenceDescription.getNodeId() == null || !referenceDescription.getNodeId().isLocal()) continue;
                try {
                    hashMap2.put(referenceDescription.getBrowseName(), this.getNamespaceTable().toNodeId(referenceDescription.getNodeId()));
                }
                catch (ServiceResultException serviceResultException) {
                    logger.warn("Could not convert ExpandedNodeId: {} to NodeId in the context of NamespaceTable: {}", (Object)referenceDescription.getNodeId(), (Object)this.getNamespaceTable());
                }
            }
            hashMap.put(nodeId, hashMap2);
        }
        HashMap hashMap3 = new HashMap();
        for (Map.Entry entry : hashMap.entrySet()) {
            hashMap3.put(entry.getKey(), Collections.unmodifiableMap((Map)entry.getValue()));
            logger.debug("Found {} Properties for NodeId: {}, properties: {}", ((Map)entry.getValue()).size(), entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(hashMap3);
    }

    Map<NodeId, Map<QualifiedName, Map<UnsignedInteger, DataValue>>> a(Map<NodeId, Map<QualifiedName, NodeId>> map, AtomicInteger atomicInteger, boolean bl) throws ServiceException {
        HashMap hashMap = new HashMap();
        if (map.isEmpty()) {
            return Collections.unmodifiableMap(hashMap);
        }
        HashSet<NodeId> hashSet = new HashSet<NodeId>();
        for (Map.Entry<NodeId, Map<QualifiedName, NodeId>> object2 : map.entrySet()) {
            for (Map.Entry<QualifiedName, NodeId> entry : object2.getValue().entrySet()) {
                hashSet.add(entry.getValue());
            }
        }
        if (hashSet.isEmpty()) {
            return Collections.unmodifiableMap(hashMap);
        }
        i i2 = this.a(hashSet, AttributesUtil.getSupportedAttributes(NodeClass.Variable), TimestampsToReturn.Both, bl);
        Map<NodeId, Map<UnsignedInteger, DataValue>> map2 = i2.asRawMap();
        int n2 = atomicInteger.get();
        atomicInteger.set(n2 + i2.coq());
        for (Map.Entry<NodeId, Map<QualifiedName, NodeId>> entry : map.entrySet()) {
            HashMap<QualifiedName, Map<UnsignedInteger, DataValue>> hashMap2 = new HashMap<QualifiedName, Map<UnsignedInteger, DataValue>>();
            for (Map.Entry<QualifiedName, NodeId> entry2 : entry.getValue().entrySet()) {
                hashMap2.put(entry2.getKey(), map2.get(entry2.getValue()));
            }
            hashMap.put(entry.getKey(), hashMap2);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(NodeId nodeId, UaNode uaNode, ExpandedNodeId expandedNodeId) {
        UaNode uaNode2 = uaNode;
        synchronized (uaNode2) {
            if (!ExpandedNodeId.isNull(expandedNodeId)) {
                if (expandedNodeId.isLocal()) {
                    try {
                        logger.debug("getNode() typeDefinition: {}", (Object)expandedNodeId);
                        NodeId nodeId2 = this.getNamespaceTable().toNodeId(expandedNodeId);
                        if (!nodeId2.equals(nodeId) && uaNode instanceof UaInstance) {
                            ((UaInstance)uaNode).setTypeDefinition(this.getType(nodeId2));
                        }
                    }
                    catch (Exception exception) {
                        logger.warn(String.format(Locale.ROOT, "Cannot set the type corresponding to the typeDefinition (%s) of node %s (%s)", expandedNodeId, uaNode.getBrowseName(), nodeId), exception);
                    }
                } else {
                    logger.debug("typeDefinition not local:{}", (Object)expandedNodeId);
                }
            }
        }
    }
}

