/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.InternalArguments;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaQualifiedName;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.RelativePathElement;
import java.util.Objects;

public final class UaRelativePathElement {
    private final UaNodeId eh;
    private final Boolean ei;
    private final Boolean ej;
    private final UaQualifiedName ek;

    public static Builder builder() {
        return new Builder();
    }

    public static UaRelativePathElement from(RelativePathElement relativePathElement, NamespaceTable namespaceTable) {
        InternalArguments.checkNotNull(namespaceTable, "namespaceTable");
        if (relativePathElement == null) {
            return null;
        }
        Builder builder = UaRelativePathElement.builder();
        builder.setIncludeSubtypes(relativePathElement.getIncludeSubtypes());
        builder.setIsInverse(relativePathElement.getIsInverse());
        builder.setReferenceTypeId(UaNodeId.fromLocal(relativePathElement.getReferenceTypeId(), namespaceTable));
        builder.setTargetName(UaQualifiedName.from(relativePathElement.getTargetName(), namespaceTable));
        return builder.build();
    }

    private UaRelativePathElement(UaNodeId uaNodeId, Boolean bl, Boolean bl2, UaQualifiedName uaQualifiedName) {
        this.eh = uaNodeId;
        this.ei = bl;
        this.ej = bl2;
        this.ek = uaQualifiedName;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof UaRelativePathElement)) {
            return false;
        }
        UaRelativePathElement uaRelativePathElement = (UaRelativePathElement)object;
        return Objects.equals(this.ej, uaRelativePathElement.ej) && Objects.equals(this.ei, uaRelativePathElement.ei) && Objects.equals(this.eh, uaRelativePathElement.eh) && Objects.equals(this.ek, uaRelativePathElement.ek);
    }

    public Boolean getIncludeSubtypes() {
        return this.ej;
    }

    public Boolean getIsInverse() {
        return this.ei;
    }

    public UaNodeId getReferenceTypeId() {
        return this.eh;
    }

    public UaQualifiedName getTargetName() {
        return this.ek;
    }

    public int hashCode() {
        return Objects.hash(this.ej, this.ei, this.eh, this.ek);
    }

    public Builder toBuilder() {
        Builder builder = UaRelativePathElement.builder();
        builder.setIncludeSubtypes(this.ej);
        builder.setIsInverse(this.ei);
        builder.setReferenceTypeId(this.eh);
        builder.setTargetName(this.ek);
        return builder;
    }

    public RelativePathElement toRelativePathElement(NamespaceTable namespaceTable) {
        RelativePathElement.Builder builder = RelativePathElement.builder();
        builder.setIncludeSubtypes(this.ej);
        builder.setIsInverse(this.ei);
        builder.setReferenceTypeId(NodeId.from(this.eh, namespaceTable));
        builder.setTargetName(QualifiedName.from(this.ek, namespaceTable));
        return builder.build();
    }

    public String toString() {
        return "UaRelativePathElement [referenceTypeId=" + this.eh + ", isInverse=" + this.ei + ", includeSubtypes=" + this.ej + ", targetName=" + this.ek + "]";
    }

    public static final class Builder {
        private UaNodeId eh;
        private Boolean ei;
        private Boolean ej;
        private UaQualifiedName ek;

        private Builder() {
        }

        public UaRelativePathElement build() {
            return new UaRelativePathElement(this.eh, this.ei, this.ej, this.ek);
        }

        public Boolean getIncludeSubtypes() {
            return this.ej;
        }

        public Boolean getIsInverse() {
            return this.ei;
        }

        public UaNodeId getReferenceTypeId() {
            return this.eh;
        }

        public UaQualifiedName getTargetName() {
            return this.ek;
        }

        public Builder setIncludeSubtypes(Boolean bl) {
            this.ej = bl;
            return this;
        }

        public Builder setIsInverse(Boolean bl) {
            this.ei = bl;
            return this;
        }

        public Builder setReferenceTypeId(UaNodeId uaNodeId) {
            this.eh = uaNodeId;
            return this;
        }

        public Builder setTargetName(UaQualifiedName uaQualifiedName) {
            this.ek = uaQualifiedName;
            return this;
        }
    }
}

