/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNamespace;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaNodeSetException;
import com.prosysopc.ua.UaQualifiedName;
import com.prosysopc.ua.d;
import com.prosysopc.ua.e;
import com.prosysopc.ua.internal.InternalDefinitionXMLDataContainer;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.core.AddNodesItem;
import com.prosysopc.ua.stack.core.AddReferencesItem;
import com.prosysopc.ua.stack.core.Attributes;
import com.prosysopc.ua.stack.core.GenericAttributeValue;
import com.prosysopc.ua.stack.core.GenericAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.xml.XmlDecoder;
import com.prosysopc.ua.stack.utils.BijectionMap;
import com.prosysopc.ua.stack.utils.XMLFactoryCache;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class UaNodeSet {
    private static final Logger logger = LoggerFactory.getLogger(UaNodeSet.class);
    static final Set<NodeData.Attribute<?>> dj = Collections.unmodifiableSet(new HashSet<NodeData.Attribute>(Arrays.asList(NodeData.Attribute.NODE_CLASS, NodeData.Attribute.NODE_ID, NodeData.Attribute.BROWSE_NAME, NodeData.Attribute.DISPLAY_NAME, NodeData.Attribute.DESCRIPTION, NodeData.Attribute.WRITE_MASK, NodeData.Attribute.USER_WRITE_MASK)));
    static final Set<NodeData.Attribute<?>> dk = Collections.unmodifiableSet(new HashSet<NodeData.Attribute>(Arrays.asList(NodeData.Attribute.IS_ABSTRACT)));
    static final String UTF8_BOM = "\ufeff";
    final Set<NodeData> dl;
    final Set<ReferenceData> references;
    final List<UaNamespace> dm;
    final List<ModelInfo> dn;
    final Map<String, String> aj;
    final Set<UaNamespace> do;
    final Set<UaNamespace> dp;
    final Log dq;

    public static UaNodeSet parseXml(InputStream inputStream) throws UaNodeSetException {
        return UaNodeSet.parseXml(inputStream, StandardCharsets.UTF_8);
    }

    public static UaNodeSet parseXml(InputStream inputStream, Charset charset) throws UaNodeSetException {
        Object object;
        Object object2;
        Object object3;
        if (inputStream == null) {
            throw new UaNodeSetException("Null modelSource not allowed");
        }
        if (charset == null) {
            charset = StandardCharsets.UTF_8;
        }
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        inputStream.mark(10);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
        try {
            logger.debug("encoding={}", (Object)inputStreamReader.getEncoding());
            object3 = new char[2];
            inputStreamReader.read((char[])object3, 0, inputStreamReader.getEncoding().equals("UTF8") ? 1 : 2);
            if (logger.isDebugEnabled()) {
                logger.debug(String.format(Locale.ROOT, "cbuf=%04x %04x bom=%04x", (int)object3[0], (int)object3[1], (int)UTF8_BOM.charAt(0)));
            }
            if (object3[0] != UTF8_BOM.charAt(0)) {
                inputStream.reset();
                inputStreamReader = new InputStreamReader(inputStream, charset);
            }
        }
        catch (IOException iOException) {
            throw new UaNodeSetException("Could not check does Byte Order Mark exist in the stream", iOException);
        }
        try {
            object2 = XMLFactoryCache.getDocumentBuilderFactory();
            object = ((DocumentBuilderFactory)object2).newDocumentBuilder();
            object3 = ((DocumentBuilder)object).parse(new InputSource(inputStreamReader));
        }
        catch (Exception exception) {
            throw new UaNodeSetException("Cannot low-level parse the NodeSet XML file (or it is not a NodeSet file)", exception);
        }
        object2 = new d((Document)object3);
        object = ((d)object2).parse();
        logger.debug("Parsed UaNodeSet with {} Infos, {} Warnings, {} Errors", ((UaNodeSet)object).dq.du, ((UaNodeSet)object).dq.dv, ((UaNodeSet)object).dq.dw);
        return object;
    }

    static a qR() {
        return new a();
    }

    UaNodeSet(Map<String, String> map, List<UaNamespace> list, Set<NodeData> set, Set<ReferenceData> set2, List<ModelInfo> list2, Log log) {
        this.dn = Collections.unmodifiableList(new ArrayList<ModelInfo>(list2));
        this.aj = Collections.unmodifiableMap(new HashMap<String, String>(map));
        this.dm = Collections.unmodifiableList(new ArrayList<UaNamespace>(list));
        this.dl = Collections.unmodifiableSet(new HashSet<NodeData>(set));
        this.references = Collections.unmodifiableSet(new HashSet<ReferenceData>(set2));
        this.dq = log;
        if (this.dm.isEmpty() || !this.dm.get(0).equals(UaNamespace.STANDARD)) {
            throw new IllegalStateException("A NodeSet always must have the core namespace " + UaNamespace.STANDARD.getURI() + " entry in index 0");
        }
        if (this.dl.isEmpty() && this.dm.size() == 1) {
            throw new IllegalStateException("Modelling core namespace " + UaNamespace.STANDARD.getURI() + " without any nodes is not supported");
        }
        if (this.dl.isEmpty()) {
            this.dp = Collections.unmodifiableSet(new HashSet<UaNamespace>(Arrays.asList(UaNamespace.STANDARD)));
            this.do = Collections.unmodifiableSet(this.dm.stream().skip(1L).collect(Collectors.toSet()));
        } else {
            this.do = Collections.unmodifiableSet(this.dl.stream().map(nodeData -> nodeData.getNodeId().getNamespace()).collect(Collectors.toSet()));
            this.dp = Collections.unmodifiableSet(this.dm.stream().filter(uaNamespace -> !this.do.contains(uaNamespace)).collect(Collectors.toSet()));
        }
    }

    public Map<String, String> getAliases() {
        return this.aj;
    }

    public Set<UaNamespace> getDependencyNamespaces() {
        return this.dp;
    }

    public Log getLog() {
        return this.dq;
    }

    public List<ModelInfo> getModelInfos() {
        return this.dn;
    }

    public List<UaNamespace> getNamespaces() {
        return this.dm;
    }

    public Set<NodeData> getNodes() {
        return this.dl;
    }

    public Map<NodeClass, List<NodeData>> getNodesByNodeClass() {
        return Collections.unmodifiableMap(this.dl.stream().collect(Collectors.groupingBy(nodeData -> nodeData.getNodeClass(), Collectors.collectingAndThen(Collectors.toList(), list -> Collections.unmodifiableList(list)))));
    }

    public Set<NodeData> getNodesWithLogLevels(Log.Event.Level ... levelArray) {
        HashSet hashSet = new HashSet();
        this.getNodes().stream().filter(nodeData -> nodeData.getLog().a(levelArray) > 0L).forEach(nodeData -> hashSet.add(nodeData));
        return Collections.unmodifiableSet(hashSet);
    }

    public Set<UaNamespace> getProvidedNamespaces() {
        return this.do;
    }

    public Set<ReferenceData> getReferences() {
        return this.references;
    }

    public Set<AddNodesItem> nodesToAddNodesItem(EncoderContext encoderContext) {
        logger.trace("Resolving all nodes to AddNodesItem(s), in the context of :{}", (Object)encoderContext.getNamespaceTable());
        HashMap hashMap = new HashMap();
        this.references.stream().filter(referenceData -> UaIds.HasTypeDefinition.equals(referenceData.ed)).forEach(referenceData -> {
            if (referenceData.ec) {
                hashMap.put(referenceData.eb, referenceData.ee);
            } else {
                hashMap.put(referenceData.ee, referenceData.eb);
            }
        });
        HashSet hashSet = new HashSet();
        HashMap hashMap2 = new HashMap();
        this.dl.forEach(nodeData -> {
            try {
                Object object2;
                AddNodesItem.Builder builder = AddNodesItem.builder();
                builder.setRequestedNewNodeId(nodeData.getNodeId().asExpandedNodeId());
                builder.setNodeClass(nodeData.getNodeClass());
                builder.setBrowseName(nodeData.getBrowseName().toQualifiedName(encoderContext.getNamespaceTable()));
                if (NodeClass.Variable == nodeData.getNodeClass() || NodeClass.Object == nodeData.getNodeClass()) {
                    object2 = (UaNodeId)hashMap.get(nodeData.getNodeId());
                    if (object2 == null) {
                        logger.debug("Cannot find HasTypeDefinition Reference for {}, id: {}", (Object)nodeData.getBrowseName(), (Object)nodeData.getNodeId());
                    } else {
                        builder.setTypeDefinition(((UaNodeId)object2).asExpandedNodeId());
                    }
                }
                object2 = GenericAttributes.builder();
                ((GenericAttributes.Builder)object2).setDescription(nodeData.getDescription());
                ((GenericAttributes.Builder)object2).setDisplayName(nodeData.getDisplayName());
                ((GenericAttributes.Builder)object2).setUserWriteMask(nodeData.qX());
                ((GenericAttributes.Builder)object2).setWriteMask(nodeData.qY());
                ArrayList<GenericAttributeValue> arrayList = new ArrayList<GenericAttributeValue>();
                HashSet<NodeData.Attribute<Object>> hashSet = new HashSet<NodeData.Attribute<Object>>();
                hashSet.add(NodeData.Attribute.NODE_ID);
                hashSet.add(NodeData.Attribute.NODE_CLASS);
                hashSet.add(NodeData.Attribute.BROWSE_NAME);
                hashSet.add(NodeData.Attribute.DESCRIPTION);
                hashSet.add(NodeData.Attribute.DISPLAY_NAME);
                hashSet.add(NodeData.Attribute.USER_WRITE_MASK);
                hashSet.add(NodeData.Attribute.WRITE_MASK);
                hashSet.add(NodeData.Attribute.VALUE_XML);
                hashSet.add(NodeData.Attribute.DEFINITION_XML);
                hashSet.add(NodeData.Attribute.dE);
                ((NodeData)nodeData).attributes.forEach((attribute, object) -> {
                    if (!hashSet.contains(attribute)) {
                        if (NodeData.Attribute.ARRAY_DIMENSIONS == attribute) {
                            if (object != null) {
                                arrayList.add(new GenericAttributeValue(((NodeData.Attribute)attribute).dG, ((UaArrayDimensions)object).toArray()));
                            } else {
                                arrayList.add(new GenericAttributeValue(((NodeData.Attribute)attribute).dG, null));
                            }
                        } else {
                            if (object instanceof UaNodeId) {
                                object = ((UaNodeId)object).asNodeId(encoderContext.getNamespaceTable());
                            }
                            arrayList.add(new GenericAttributeValue(((NodeData.Attribute)attribute).dG, object));
                        }
                    }
                });
                if (((NodeData)nodeData).attributes.containsKey(NodeData.Attribute.VALUE_XML)) {
                    String string = (String)nodeData.getAttributes().get(NodeData.Attribute.VALUE_XML);
                    if (string != null) {
                        String string3 = string.trim();
                        Variant variant = hashMap2.computeIfAbsent(string3, string2 -> {
                            try {
                                XmlDecoder xmlDecoder = new XmlDecoder(new XmlElement(string3), encoderContext);
                                NamespaceTable namespaceTable = new NamespaceTable();
                                if (this.dm.size() > 1) {
                                    this.dm.subList(1, this.dm.size()).forEach(uaNamespace -> namespaceTable.add(uaNamespace.getURI()));
                                }
                                xmlDecoder.setNamespaceTable(namespaceTable);
                                Variant variant = xmlDecoder.getVariant("");
                                logger.trace("Parsed value: {}", (Object)variant);
                                return variant;
                            }
                            catch (Exception exception) {
                                logger.warn("Cannot parse Value Attribute: '{}', first seen in node: {} id: {}", string3, nodeData.getBrowseName(), nodeData.getNodeId(), exception);
                                return null;
                            }
                        });
                        if (variant != null) {
                            arrayList.add(new GenericAttributeValue(Attributes.Value, variant.clone()));
                        }
                    } else {
                        arrayList.add(new GenericAttributeValue(Attributes.Value, Variant.NULL));
                    }
                }
                ((GenericAttributes.Builder)object2).setAttributeValues(arrayList.toArray(new GenericAttributeValue[0]));
                builder.setNodeAttributes(((GenericAttributes.Builder)object2).build());
                hashSet.add(builder.build());
            }
            catch (Exception exception) {
                logger.warn("Could not convert: {} to AddNodesItem", (Object)nodeData.getNodeId(), (Object)exception);
            }
        });
        return Collections.unmodifiableSet(hashSet);
    }

    public Set<AddReferencesItem> referencesToAddReferencesItem(EncoderContext encoderContext) {
        return Collections.unmodifiableSet(this.references.stream().map(referenceData -> referenceData.toAddReferencesItem(encoderContext.getNamespaceTable())).collect(Collectors.toSet()));
    }

    public String toXml() {
        e e2;
        try {
            e2 = new e(this);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Internal error, cannot generate XML", exception);
        }
        Document document = e2.c();
        document.normalizeDocument();
        return e.b(document);
    }

    static class a
    implements Log.b<a> {
        private static final Logger logger = LoggerFactory.getLogger(a.class);
        private final Set<NodeData> dl = new HashSet<NodeData>();
        private final Set<ReferenceData> references = new HashSet<ReferenceData>();
        private final List<UaNamespace> dr = new ArrayList<UaNamespace>();
        private final List<ModelInfo> dn = new ArrayList<ModelInfo>();
        private final Map<String, String> aj = new HashMap<String, String>();
        private final Log.a ds = new Log.a();

        private a() {
            this.dr.add(UaNamespace.STANDARD);
        }

        public a a(String string, String string2) {
            this.aj.put(string, string2);
            return this;
        }

        public a a(ModelInfo modelInfo) {
            this.dn.add(modelInfo);
            this.ds.dx.addAll(modelInfo.dq.dt);
            return this;
        }

        public a f(UaNamespace uaNamespace) {
            if (UaNamespace.STANDARD.equals(uaNamespace)) {
                throw new IllegalArgumentException("The core namespace must not be added manually. It is automatically in the index 0");
            }
            if (this.dr.contains(uaNamespace)) {
                logger.warn("The namespace {} was already part of the namespaces", (Object)uaNamespace);
            } else {
                this.dr.add(uaNamespace);
            }
            return this;
        }

        public a g(UaNamespace uaNamespace) {
            if (!this.dr.contains(uaNamespace)) {
                this.dr.add(uaNamespace);
            }
            return this;
        }

        public a c(NodeData nodeData) {
            this.dl.add(nodeData);
            this.ds.dx.addAll(nodeData.dq.dt);
            return this;
        }

        public a e(ReferenceData referenceData) {
            this.references.add(referenceData);
            return this;
        }

        public a a(Iterable<ReferenceData> iterable) {
            iterable.forEach(referenceData -> this.e((ReferenceData)referenceData));
            return this;
        }

        public a a(Log.Event.Level level, String string, String string2, Exception exception) {
            this.ds.c(level, string, string2, exception);
            return this;
        }

        UaNodeSet qS() {
            return new UaNodeSet(this.aj, this.dr, this.dl, this.references, this.dn, this.ds.qT());
        }

        List<UaNamespace> getNamespaces() {
            return this.dr;
        }

        @Override
        public /* synthetic */ Object b(Log.Event.Level level, String string, String string2, Exception exception) {
            return this.a(level, string, string2, exception);
        }
    }

    public static class ReferenceData {
        final UaNodeId eb;
        final boolean ec;
        final UaNodeId ed;
        final UaNodeId ee;
        final int hash;

        static ReferenceData a(UaNodeId uaNodeId, boolean bl, UaNodeId uaNodeId2, UaNodeId uaNodeId3) {
            return new ReferenceData(uaNodeId, bl, uaNodeId2, uaNodeId3);
        }

        ReferenceData(UaNodeId uaNodeId, boolean bl, UaNodeId uaNodeId2, UaNodeId uaNodeId3) {
            this.eb = uaNodeId;
            this.ec = bl;
            this.ed = uaNodeId2;
            this.ee = uaNodeId3;
            this.hash = Objects.hash(bl, uaNodeId, uaNodeId3, uaNodeId2);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ReferenceData)) {
                return false;
            }
            ReferenceData referenceData = (ReferenceData)object;
            return this.ec == referenceData.ec && Objects.equals(this.eb, referenceData.eb) && Objects.equals(this.ee, referenceData.ee) && Objects.equals(this.ed, referenceData.ed);
        }

        public UaNodeId getReferenceSource() {
            return this.eb;
        }

        public UaNodeId getReferenceTarget() {
            return this.ee;
        }

        public UaNodeId getReferenceType() {
            return this.ed;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean isForward() {
            return this.ec;
        }

        public AddReferencesItem toAddReferencesItem(NamespaceTable namespaceTable) {
            AddReferencesItem.Builder builder = AddReferencesItem.builder();
            builder.setIsForward(this.ec);
            builder.setReferenceTypeId(NodeId.from(this.ed, namespaceTable));
            builder.setSourceNodeId(NodeId.from(this.eb, namespaceTable));
            builder.setTargetNodeId(new ExpandedNodeId(NodeId.from(this.ee, namespaceTable)));
            builder.setTargetNodeClass(null);
            builder.setTargetServerUri(null);
            return builder.build();
        }

        public String toString() {
            return "ReferenceData [referenceSource=" + this.eb + ", referenceTarget=" + this.ee + ", isForward=" + this.ec + ", referenceType=" + this.ed + "]";
        }
    }

    public static class NodeData {
        private final Map<Attribute<?>, Object> attributes;
        private final Log dq;
        private final String dC;
        private final int hash;

        static a p(String string) {
            return new a(string);
        }

        private NodeData(Map<Attribute<?>, Object> map, String string, Log log) {
            this.attributes = Collections.unmodifiableMap(new HashMap(map));
            this.dq = log;
            this.dC = string;
            this.hash = Objects.hash(this.attributes);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof NodeData)) {
                return false;
            }
            NodeData nodeData = (NodeData)object;
            return Objects.equals(this.attributes, nodeData.attributes);
        }

        public <T> T get(Attribute<T> attribute) {
            Object object = this.attributes.get(attribute);
            return (T)object;
        }

        public UaQualifiedName getBrowseName() {
            return (UaQualifiedName)this.attributes.get(Attribute.BROWSE_NAME);
        }

        public LocalizedText getDescription() {
            return (LocalizedText)this.attributes.get(Attribute.DESCRIPTION);
        }

        public LocalizedText getDisplayName() {
            return (LocalizedText)this.attributes.get(Attribute.DISPLAY_NAME);
        }

        public Log getLog() {
            return this.dq;
        }

        public NodeClass getNodeClass() {
            return (NodeClass)this.attributes.get(Attribute.NODE_CLASS);
        }

        public UaNodeId getNodeId() {
            return (UaNodeId)this.attributes.get(Attribute.NODE_ID);
        }

        public String getRawXml() {
            return this.dC;
        }

        public int hashCode() {
            return this.hash;
        }

        Map<Attribute<?>, Object> getAttributes() {
            return this.attributes;
        }

        b qW() {
            return b.dY.getRight(this.getNodeClass());
        }

        UnsignedInteger qX() {
            return (UnsignedInteger)this.attributes.get(Attribute.USER_WRITE_MASK);
        }

        UnsignedInteger qY() {
            return (UnsignedInteger)this.attributes.get(Attribute.WRITE_MASK);
        }

        a qZ() {
            a a2 = NodeData.p(this.dC);
            a2.attributes.putAll(this.attributes);
            a2.ds.dx.addAll(this.dq.getEvents());
            return a2;
        }

        static enum b {
            dP(false, "UAObject", NodeClass.Object, Attribute.EVENT_NOTIFIER),
            dQ(false, "UAVariable", NodeClass.Variable, Attribute.DATA_TYPE, Attribute.HISTORIZING, Attribute.VALUE_XML, Attribute.ACCESS_LEVEL, Attribute.USER_ACCESS_LEVEL, Attribute.MINIMUM_SAMPLING_INTERVAL, Attribute.VALUE_RANK, Attribute.ARRAY_DIMENSIONS),
            dR(false, "UAMethod", NodeClass.Method, Attribute.EXECUTABLE, Attribute.USER_EXECUTABLE),
            dS(true, "UAObjectType", NodeClass.ObjectType, new Attribute[0]),
            dT(true, "UAVariableType", NodeClass.VariableType, Attribute.VALUE_XML, Attribute.DATA_TYPE, Attribute.VALUE_RANK, Attribute.ARRAY_DIMENSIONS),
            dU(true, "UAReferenceType", NodeClass.ReferenceType, Attribute.SYMMETRIC, Attribute.INVERSE_NAME),
            dV(true, "UADataType", NodeClass.DataType, Attribute.dE, Attribute.DEFINITION_XML),
            dW(false, "UAView", NodeClass.View, Attribute.CONTAINS_NO_LOOPS, Attribute.EVENT_NOTIFIER);

            static final Map<String, b> dX;
            static final BijectionMap<NodeClass, b> dY;
            private final NodeClass dZ;
            private final Set<Attribute<?>> attributes;
            private final String tagName;

            public static b a(NodeClass nodeClass) {
                if (nodeClass == null) {
                    return null;
                }
                return dY.getRight(nodeClass);
            }

            private b(boolean bl, String string2, NodeClass nodeClass, Attribute<?> ... attributeArray) {
                this.tagName = string2;
                this.dZ = nodeClass;
                HashSet hashSet = new HashSet();
                hashSet.addAll(dj);
                if (bl) {
                    hashSet.addAll(dk);
                }
                hashSet.addAll(Arrays.asList(attributeArray));
                this.attributes = Collections.unmodifiableSet(hashSet);
            }

            public NodeClass getNodeClass() {
                return this.dZ;
            }

            Set<Attribute<?>> getAttributes() {
                return this.attributes;
            }

            String getTagName() {
                return this.tagName;
            }

            static {
                dY = new BijectionMap();
                HashMap<String, b> hashMap = new HashMap<String, b>();
                for (b b2 : b.values()) {
                    hashMap.put(b2.tagName, b2);
                    dY.map(b2.getNodeClass(), b2);
                }
                dX = Collections.unmodifiableMap(hashMap);
            }
        }

        static class a
        implements Log.b<a> {
            private final Map<Attribute<?>, Object> attributes = new HashMap();
            private final Log.a ds = new Log.a();
            private String dC;

            private a(String string) {
                this.dC = string;
            }

            public a a(Attribute<?> attribute, Object object) {
                this.attributes.put(attribute, object);
                return this;
            }

            public NodeData rb() {
                return new NodeData(this.attributes, this.dC, this.ds.qT());
            }

            public a e(Log.Event.Level level, String string, String string2, Exception exception) {
                if (string2 == null) {
                    string2 = this.dC;
                }
                this.ds.c(level, string, string2, exception);
                return this;
            }

            @Override
            public /* synthetic */ Object b(Log.Event.Level level, String string, String string2, Exception exception) {
                return this.e(level, string, string2, exception);
            }
        }

        public static class Attribute<T> {
            static final Map<UnsignedInteger, Attribute<?>> dD = new HashMap();
            public static final Attribute<UaNodeId> NODE_ID = new Attribute<UaNodeId>("NodeId", Attributes.NodeId, UaNodeId.class, true, a.dM, null, -1);
            public static final Attribute<NodeClass> NODE_CLASS = new Attribute<NodeClass>("NodeClass", Attributes.NodeClass, NodeClass.class, true, a.dM, null, -1);
            public static final Attribute<UaQualifiedName> BROWSE_NAME = new Attribute<UaQualifiedName>("BrowseName", Attributes.BrowseName, UaQualifiedName.class, true, a.dM, null, -1);
            public static final Attribute<LocalizedText> DISPLAY_NAME = new Attribute<LocalizedText>("DisplayName", Attributes.DisplayName, LocalizedText.class, true, a.dN, null, 1);
            public static final Attribute<LocalizedText> DESCRIPTION = new Attribute<LocalizedText>("Description", Attributes.Description, LocalizedText.class, true, a.dN, null, 2);
            public static final Attribute<LocalizedText> INVERSE_NAME = new Attribute<LocalizedText>("InverseName", Attributes.InverseName, LocalizedText.class, true, a.dN, null, 6);
            public static final Attribute<UnsignedByte> ACCESS_LEVEL = new Attribute<UnsignedByte>("AccessLevel", Attributes.AccessLevel, UnsignedByte.class, true, a.dM, "1", -1);
            public static final Attribute<UnsignedByte> USER_ACCESS_LEVEL = new Attribute<UnsignedByte>("UserAccessLevel", Attributes.UserAccessLevel, UnsignedByte.class, true, a.dM, "1", -1);
            public static final Attribute<UaArrayDimensions> ARRAY_DIMENSIONS = new Attribute<UaArrayDimensions>("ArrayDimensions", Attributes.ArrayDimensions, UaArrayDimensions.class, true, a.dM, "", -1);
            public static final Attribute<UnsignedByte> EVENT_NOTIFIER = new Attribute<UnsignedByte>("EventNotifier", Attributes.EventNotifier, UnsignedByte.class, true, a.dM, "0", -1);
            public static final Attribute<Integer> VALUE_RANK = new Attribute<Integer>("ValueRank", Attributes.ValueRank, Integer.class, true, a.dM, "-1", -1);
            public static final Attribute<UnsignedInteger> WRITE_MASK = new Attribute<UnsignedInteger>("WriteMask", Attributes.WriteMask, UnsignedInteger.class, true, a.dM, "0", -1);
            public static final Attribute<UnsignedInteger> USER_WRITE_MASK = new Attribute<UnsignedInteger>("UserWriteMask", Attributes.UserWriteMask, UnsignedInteger.class, true, a.dM, "0", -1);
            public static final Attribute<Boolean> IS_ABSTRACT = new Attribute<Boolean>("IsAbstract", Attributes.IsAbstract, Boolean.class, true, a.dM, "false", -1);
            public static final Attribute<Boolean> SYMMETRIC = new Attribute<Boolean>("Symmetric", Attributes.Symmetric, Boolean.class, true, a.dM, "false", -1);
            public static final Attribute<Boolean> CONTAINS_NO_LOOPS = new Attribute<Boolean>("ContainsNoLoops", Attributes.ContainsNoLoops, Boolean.class, true, a.dM, "false", -1);
            public static final Attribute<Boolean> EXECUTABLE = new Attribute<Boolean>("Executable", Attributes.Executable, Boolean.class, true, a.dM, "true", -1);
            public static final Attribute<Boolean> USER_EXECUTABLE = new Attribute<Boolean>("UserExecutable", Attributes.UserExecutable, Boolean.class, true, a.dM, "true", -1);
            public static final Attribute<Double> MINIMUM_SAMPLING_INTERVAL = new Attribute<Double>("MinimumSamplingInterval", Attributes.MinimumSamplingInterval, Double.class, true, a.dM, "0", -1);
            public static final Attribute<Boolean> HISTORIZING = new Attribute<Boolean>("Historizing", Attributes.Historizing, Boolean.class, true, a.dM, "false", -1);
            static final Attribute<InternalDefinitionXMLDataContainer> dE = new Attribute<InternalDefinitionXMLDataContainer>("Definition", Attributes.DataTypeDefinition, InternalDefinitionXMLDataContainer.class, true, a.dN, null, 5);
            public static final Attribute<String> DEFINITION_XML = new Attribute<String>("Definition", Attributes.DataTypeDefinition, String.class, true, a.dN, null, 5);
            public static final Attribute<String> VALUE_XML = new Attribute<String>("Value", Attributes.Value, String.class, true, a.dN, null, 4);
            public static final Attribute<UaNodeId> DATA_TYPE = new Attribute<UaNodeId>("DataType", Attributes.DataType, UaNodeId.class, true, a.dM, "i=24", -1);
            static final Comparator<Attribute> dF = (attribute, attribute2) -> {
                if (attribute.getKind() == a.dM && attribute2.getKind() == a.dM) {
                    return attribute.getXmlName().compareTo(attribute2.getXmlName());
                }
                if (attribute.getKind() == a.dM && attribute2.getKind() != a.dM) {
                    return -1;
                }
                if (attribute.getKind() != a.dM && attribute2.getKind() == a.dM) {
                    return 1;
                }
                return Integer.compare(attribute.dK, attribute2.dK);
            };
            private final UnsignedInteger dG;
            private final Class<? extends T> javaClass;
            private final boolean dH;
            private final a dI;
            private final String dJ;
            private final String defaultValue;
            private final int dK;
            private final boolean dL;

            private Attribute(String string, UnsignedInteger unsignedInteger, Class<? extends T> clazz, boolean bl, a a2, String string2, int n2) {
                this.dG = unsignedInteger;
                this.dH = bl;
                this.javaClass = clazz;
                this.dI = a2;
                this.dJ = string;
                this.defaultValue = string2;
                this.dK = n2;
                if (unsignedInteger != null) {
                    dD.put(unsignedInteger, this);
                }
                this.dL = UaNodeId.class.isAssignableFrom(clazz) || NodeId.class.isAssignableFrom(clazz);
            }

            public UnsignedInteger getId() {
                return this.dG;
            }

            public Class<? extends T> getJavaClass() {
                return this.javaClass;
            }

            public a getKind() {
                return this.dI;
            }

            public String getXmlName() {
                return this.dJ;
            }

            public boolean isMandatory() {
                return this.dH;
            }

            public String toString() {
                return "ModelNodeAttribute [xmlName=" + this.dJ + ", id=" + this.dG + ", javaClass=" + this.javaClass + ", kind=" + (Object)((Object)this.dI) + ", mandatory=" + this.dH + ", defaultValue=" + this.defaultValue + "]";
            }

            String getDefaultValue() {
                return this.defaultValue;
            }

            boolean ra() {
                return this.dL;
            }

            static enum a {
                dM,
                dN;

            }
        }
    }

    public static class ModelInfo {
        final UaNamespace cW;
        final String version;
        final DateTime dA;
        final List<ModelInfo> dB;
        private final Log dq;

        static a qU() {
            return new a();
        }

        ModelInfo(UaNamespace uaNamespace, String string, DateTime dateTime, List<ModelInfo> list, Log log) {
            this.cW = uaNamespace;
            this.version = string;
            this.dA = dateTime;
            this.dB = Collections.unmodifiableList(new ArrayList<ModelInfo>(list));
            this.dq = log;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ModelInfo)) {
                return false;
            }
            ModelInfo modelInfo = (ModelInfo)object;
            return Objects.equals(this.dB, modelInfo.dB) && Objects.equals(this.cW, modelInfo.cW) && Objects.equals(this.dA, modelInfo.dA) && Objects.equals(this.version, modelInfo.version);
        }

        public List<ModelInfo> getDependencies() {
            return this.dB;
        }

        public Log getLog() {
            return this.dq;
        }

        public UaNamespace getNamespace() {
            return this.cW;
        }

        public DateTime getPublicationDate() {
            return this.dA;
        }

        public String getVersion() {
            return this.version;
        }

        public int hashCode() {
            return Objects.hash(this.dB, this.cW, this.dA, this.version);
        }

        public String toString() {
            return "ModelInfo [namespace=" + this.cW + ", version=" + this.version + ", publicationDate=" + this.dA + ", dependencies=" + this.dB + "]";
        }

        static class a
        implements Log.b<a> {
            UaNamespace cW;
            String version;
            DateTime dA;
            final List<ModelInfo> dB = new ArrayList<ModelInfo>();
            final Log.a ds = new Log.a();

            private a() {
            }

            public a c(ModelInfo modelInfo) {
                this.dB.add(modelInfo);
                return this;
            }

            public ModelInfo qV() {
                return new ModelInfo(this.cW, this.version, this.dA, this.dB, this.ds.qT());
            }

            public a d(Log.Event.Level level, String string, String string2, Exception exception) {
                this.ds.c(level, string, string2, exception);
                return this;
            }

            public a h(UaNamespace uaNamespace) {
                this.cW = uaNamespace;
                return this;
            }

            public a a(DateTime dateTime) {
                this.dA = dateTime;
                return this;
            }

            public a o(String string) {
                this.version = string;
                return this;
            }

            @Override
            public /* synthetic */ Object b(Log.Event.Level level, String string, String string2, Exception exception) {
                return this.d(level, string, string2, exception);
            }
        }
    }

    public static class Log {
        private final List<Event> dt;
        private final long du;
        private final long dv;
        private final long dw;

        Log(List<Event> list) {
            this.dt = Collections.unmodifiableList(new ArrayList<Event>(list));
            this.du = list.stream().filter(event -> Event.Level.INFO == event.getLevel()).count();
            this.dv = list.stream().filter(event -> Event.Level.WARNING == event.getLevel()).count();
            this.dw = list.stream().filter(event -> Event.Level.ERROR == event.getLevel()).count();
        }

        public long getErrorCount() {
            return this.dw;
        }

        public List<Event> getErrors() {
            return Collections.unmodifiableList(new ArrayList(this.dt.stream().filter(event -> Event.Level.ERROR == event.getLevel()).collect(Collectors.toList())));
        }

        public List<Event> getEvents() {
            return this.dt;
        }

        public long getInfoCount() {
            return this.du;
        }

        public List<Event> getInfos() {
            return Collections.unmodifiableList(new ArrayList(this.dt.stream().filter(event -> Event.Level.INFO == event.getLevel()).collect(Collectors.toList())));
        }

        public long getWarningCount() {
            return this.dv;
        }

        public List<Event> getWarnings() {
            return Collections.unmodifiableList(new ArrayList(this.dt.stream().filter(event -> Event.Level.WARNING == event.getLevel()).collect(Collectors.toList())));
        }

        long a(Event.Level ... levelArray) {
            if (levelArray == null || levelArray.length == 0) {
                levelArray = Event.Level.values();
            }
            long l2 = 0L;
            HashSet<Event.Level> hashSet = new HashSet<Event.Level>(Arrays.asList(levelArray));
            if (hashSet.contains((Object)Event.Level.INFO)) {
                l2 += this.getInfoCount();
            }
            if (hashSet.contains((Object)Event.Level.WARNING)) {
                l2 += this.getWarningCount();
            }
            if (hashSet.contains((Object)Event.Level.ERROR)) {
                l2 += this.getErrorCount();
            }
            return l2;
        }

        static interface b<T> {
            default public T b(Event.Level level, String string, Exception exception) {
                return this.b(level, string, null, exception);
            }

            public T b(Event.Level var1, String var2, String var3, Exception var4);

            default public T l(String string) {
                return this.d(string, null);
            }

            default public T d(String string, Exception exception) {
                return this.b(Event.Level.ERROR, string, exception);
            }

            default public T m(String string) {
                return this.e(string, null);
            }

            default public T e(String string, Exception exception) {
                return this.b(Event.Level.INFO, string, exception);
            }

            default public T n(String string) {
                return this.f(string, null);
            }

            default public T f(String string, Exception exception) {
                return this.b(Event.Level.WARNING, string, exception);
            }
        }

        static class a {
            private final List<Event> dx = new ArrayList<Event>();

            a() {
            }

            public a a(Event.Level level, String string, Exception exception) {
                return this.c(level, string, null, exception);
            }

            public a c(Event.Level level, String string, String string2, Exception exception) {
                this.dx.add(new Event(level, string, string2, exception));
                return this;
            }

            public a i(String string) {
                return this.a(string, null);
            }

            public a a(String string, Exception exception) {
                return this.a(Event.Level.ERROR, string, exception);
            }

            public a j(String string) {
                return this.b(string, null);
            }

            public a b(String string, Exception exception) {
                return this.a(Event.Level.INFO, string, exception);
            }

            public a k(String string) {
                return this.c(string, null);
            }

            public a c(String string, Exception exception) {
                return this.a(Event.Level.WARNING, string, exception);
            }

            Log qT() {
                return new Log(this.dx);
            }
        }

        public static class Event {
            private final Level dy;
            private final String message;
            private final String additionalInfo;
            private final Exception exception;

            Event(Level level, String string, String string2, Exception exception) {
                this.dy = level;
                this.message = string;
                this.additionalInfo = string2;
                this.exception = exception;
            }

            public String getAdditionalInfo() {
                return this.additionalInfo;
            }

            public Exception getException() {
                return this.exception;
            }

            public Level getLevel() {
                return this.dy;
            }

            public String getMessage() {
                return this.message;
            }

            public static enum Level {
                INFO,
                WARNING,
                ERROR;

            }
        }
    }
}

