/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNamespace;
import com.prosysopc.ua.UaNamespaceTranslateable;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.core.EnumDefinition;
import com.prosysopc.ua.stack.core.EnumDescription;
import com.prosysopc.ua.stack.core.EnumField;
import com.prosysopc.ua.stack.core.KeyValuePair;
import com.prosysopc.ua.stack.core.SimpleTypeDescription;
import com.prosysopc.ua.stack.core.StructureDefinition;
import com.prosysopc.ua.stack.core.StructureDescription;
import com.prosysopc.ua.stack.core.StructureField;
import com.prosysopc.ua.stack.core.UABinaryFileDataType;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.EncodingException;
import com.prosysopc.ua.stack.encoding.binary.BinaryDecoder;
import com.prosysopc.ua.stack.encoding.binary.BinaryEncoder;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.OptionSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UaBinaryFile {
    private static final Logger logger = LoggerFactory.getLogger(UaBinaryFile.class);
    private final UABinaryFileDataType cP;
    private final EncoderContext W;

    public static UaBinaryFile from(EncoderContext encoderContext, Object object, String string, KeyValuePair ... keyValuePairArray) {
        UABinaryFileDataType.Builder builder = UABinaryFileDataType.builder();
        builder.setBody(object);
        builder.setFileHeader(keyValuePairArray);
        builder.setSchemaLocation(string);
        builder.setEnumDataTypes(null);
        builder.setNamespaces(null);
        builder.setSimpleDataTypes(null);
        builder.setStructureDataTypes(null);
        return new UaBinaryFile(builder.build(), encoderContext);
    }

    public static UaBinaryFile from(EncoderContext encoderContext, UABinaryFileDataType uABinaryFileDataType) {
        return new UaBinaryFile(uABinaryFileDataType, encoderContext);
    }

    public static UaBinaryFile parse(InputStream inputStream) throws DecodingException {
        if (inputStream == null) {
            throw new IllegalArgumentException("The given InputStream cannot be null");
        }
        NamespaceTable namespaceTable = new NamespaceTable();
        EncoderContext encoderContext = new EncoderContext(namespaceTable, new ServerTable());
        BinaryDecoder binaryDecoder = new BinaryDecoder(encoderContext, inputStream, Integer.MAX_VALUE);
        UABinaryFileDataType.Builder builder = UABinaryFileDataType.builder();
        binaryDecoder.setStructureFieldDecodeListener((fieldSpecification, object) -> {
            logger.error("TMP, field: {}, value: {}", fieldSpecification, object);
            if (UABinaryFileDataType.SPECIFICATION.getFields().contains(fieldSpecification)) {
                builder.set((FieldSpecification)fieldSpecification, object);
            }
            if (UABinaryFileDataType.Fields.SimpleDataTypes == fieldSpecification) {
                void var9_18;
                StructureDescription structureDescription;
                void var9_16;
                UABinaryFileDataType uABinaryFileDataType = builder.build();
                for (String object2 : uABinaryFileDataType.getNamespaces()) {
                    namespaceTable.add(object2);
                }
                for (SimpleTypeDescription simpleTypeDescription : uABinaryFileDataType.getSimpleDataTypes()) {
                    UaBinaryFile.a(simpleTypeDescription, encoderContext, namespaceTable);
                }
                for (EnumDescription enumDescription : uABinaryFileDataType.getEnumDataTypes()) {
                    if (UnsignedByte.valueOf(6).equals(enumDescription.getBuiltInType())) {
                        UaBinaryFile.a(enumDescription, encoderContext, namespaceTable);
                        continue;
                    }
                    if (UnsignedByte.valueOf(22).equals(enumDescription.getBuiltInType())) {
                        throw new IllegalStateException("Custom OptionSet-Structure types are not supported");
                    }
                    UaBinaryFile.a(namespaceTable, encoderContext, enumDescription);
                }
                HashMap hashMap = new HashMap();
                StructureDescription[] structureDescriptionArray = uABinaryFileDataType.getStructureDataTypes();
                int n2 = structureDescriptionArray.length;
                boolean bl = false;
                while (var9_16 < n2) {
                    UaNodeId uaNodeId;
                    structureDescription = structureDescriptionArray[var9_16];
                    UaNodeId uaNodeId2 = UaNodeId.fromLocal(structureDescription.getDataTypeId(), namespaceTable);
                    if (uaNodeId2.equals(uaNodeId = UaNodeId.fromLocal(structureDescription.getStructureDefinition().getBaseDataType(), namespaceTable))) {
                        throw new IllegalStateException("Structures BaseDataType field points to the same type, not allowed, type:" + uaNodeId2);
                    }
                    hashMap.put(uaNodeId2, uaNodeId);
                    ++var9_16;
                }
                structureDescriptionArray = uABinaryFileDataType.getStructureDataTypes();
                n2 = structureDescriptionArray.length;
                boolean bl2 = false;
                while (var9_18 < n2) {
                    structureDescription = structureDescriptionArray[var9_18];
                    UaBinaryFile.a(structureDescription, encoderContext, namespaceTable, hashMap);
                    ++var9_18;
                }
            }
        });
        ExtensionObject extensionObject = binaryDecoder.getExtensionObject(null);
        UABinaryFileDataType uABinaryFileDataType = (UABinaryFileDataType)extensionObject.getObject();
        return new UaBinaryFile(uABinaryFileDataType, encoderContext);
    }

    @Deprecated
    private static UaBinaryFile a(EncoderContext encoderContext, Object object) {
        NamespaceTable namespaceTable = new NamespaceTable();
        Variant variant = new Variant(object);
        HashSet hashSet = new HashSet();
        UaNamespaceTranslateable.Context context = UaNamespaceTranslateable.Context.namespaceIndexOnly(n2 -> {
            hashSet.add(n2);
            return n2;
        });
        variant.withTranslatedNamespaces(context);
        ArrayList arrayList = new ArrayList(hashSet);
        Collections.sort(arrayList);
        for (Integer n3 : arrayList) {
            if (n3 == 0) continue;
            UaNamespace uaNamespace = encoderContext.getNamespaceTable().getNamespace(n3);
            namespaceTable.add(uaNamespace.getURI());
        }
        return UaBinaryFile.from(encoderContext, object, null, new KeyValuePair[0]);
    }

    private static void a(EnumDescription enumDescription, EncoderContext encoderContext, NamespaceTable namespaceTable) {
        EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
        builder.setName(enumDescription.getName().getName());
        builder.setTypeId(UaNodeId.fromLocal(enumDescription.getDataTypeId(), namespaceTable));
        EnumDefinition enumDefinition = enumDescription.getEnumDefinition();
        for (EnumField enumField : enumDefinition.getFields()) {
            String string = enumField.getName();
            Long l2 = enumField.getValue();
            if (l2 > Long.valueOf(Integer.MAX_VALUE) && l2 < Long.valueOf(Integer.MIN_VALUE)) {
                logger.error("Encountered invalid enum value (outside of Int32 range) in type: {}, name:{}, value:{}, skipping", enumDescription.getName(), string, l2);
                continue;
            }
            builder.addMapping(l2.intValue(), string);
        }
        encoderContext.addDataTypeSpecification(builder.build());
    }

    private static void a(SimpleTypeDescription simpleTypeDescription, EncoderContext encoderContext, NamespaceTable namespaceTable) {
        SimpleTypeSpecification.Builder builder = SimpleTypeSpecification.builder();
        UaNodeId uaNodeId = UaNodeId.fromStandard(simpleTypeDescription.getBaseDataType());
        SimpleTypeSpecification simpleTypeSpecification = encoderContext.getSimpleTypeSpecification(uaNodeId);
        builder.setBaseTypeId(uaNodeId);
        builder.setJavaClass(simpleTypeSpecification.getJavaClass());
        builder.setName(simpleTypeDescription.getName().getName());
        builder.setTypeId(UaNodeId.fromLocal(simpleTypeDescription.getDataTypeId(), namespaceTable));
        encoderContext.addDataTypeSpecification(builder.build());
    }

    private static void a(StructureDescription structureDescription, EncoderContext encoderContext, NamespaceTable namespaceTable, Map<UaNodeId, UaNodeId> map) {
        Object object;
        Cloneable cloneable;
        Object object2;
        StructureSpecification.Builder<Structure.Builder> builder = StructureSpecification.builder();
        builder.setName(structureDescription.getName().getName());
        UaNodeId uaNodeId2 = UaNodeId.fromLocal(structureDescription.getDataTypeId(), namespaceTable);
        builder.setTypeId(uaNodeId2);
        StructureDefinition structureDefinition = structureDescription.getStructureDefinition();
        builder.setBinaryEncodeId(UaNodeId.fromLocal(structureDefinition.getDefaultEncodingId(), namespaceTable));
        boolean bl = false;
        boolean bl2 = false;
        switch (structureDefinition.getStructureType()) {
            case Structure: {
                builder.setStructureType(StructureSpecification.StructureType.NORMAL);
                break;
            }
            case StructureWithOptionalFields: {
                builder.setStructureType(StructureSpecification.StructureType.OPTIONAL);
                bl = true;
                break;
            }
            case StructureWithSubtypedValues: {
                builder.setStructureType(StructureSpecification.StructureType.SUBTYPES);
                bl2 = true;
                break;
            }
            case Union: {
                builder.setStructureType(StructureSpecification.StructureType.UNION);
                break;
            }
            case UnionWithSubtypedValues: {
                builder.setStructureType(StructureSpecification.StructureType.UNION_SUBTYPES);
                bl2 = true;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown StructureType constant: " + structureDefinition.getStructureType());
            }
        }
        if (structureDefinition.getBaseDataType() != null) {
            object2 = UaNodeId.fromLocal(structureDefinition.getBaseDataType(), namespaceTable);
            UaDataTypeSpecification uaDataTypeSpecification = null;
            cloneable = new ArrayList<StructureField[]>();
            cloneable.add(object2);
            while (uaDataTypeSpecification == null && object2 != null) {
                uaDataTypeSpecification = encoderContext.getDataTypeSpecification((UaNodeId)object2);
                if (uaDataTypeSpecification == null) {
                    object2 = map.get(object2);
                }
                cloneable.add(object2);
            }
            if (uaDataTypeSpecification == null) {
                throw new IllegalStateException("Cannot determine full inheritance path for DataTypeId: " + uaNodeId2);
            }
            if (!(uaDataTypeSpecification instanceof StructureSpecification)) {
                throw new IllegalStateException("Structure's inheritance path contains something else than Structure " + uaNodeId2);
            }
            Collections.reverse(cloneable);
            object = (StructureSpecification)uaDataTypeSpecification;
            object.getSuperTypeIds().forEach(uaNodeId -> builder.addSuperTypeId((UaNodeId)uaNodeId));
            cloneable.forEach(uaNodeId -> builder.addSuperTypeId((UaNodeId)uaNodeId));
            builder.setBuilderSupplier(object.getBuilderSupplier());
            builder.setJavaClass(uaDataTypeSpecification.getJavaClass());
        }
        object2 = structureDefinition.getFields();
        for (int i2 = 0; i2 < ((StructureField[])object2).length; ++i2) {
            cloneable = object2[i2];
            object = FieldSpecification.builder();
            if (bl) {
                object.setIsOptional(((StructureField)cloneable).getIsOptional());
            } else if (bl2) {
                object.setAllowSubTypes(((StructureField)cloneable).getIsOptional());
            }
            object.setFieldIndex(i2);
            object.setName(((StructureField)cloneable).getName());
            object.setArrayDimensions(UaArrayDimensions.valueOf(((StructureField)cloneable).getArrayDimensions()));
            UaNodeId uaNodeId3 = UaNodeId.fromLocal(((StructureField)cloneable).getDataType(), namespaceTable);
            object.setDataTypeId(uaNodeId3);
            if (((StructureField)cloneable).getDescription() != null) {
                object.setDescription(((StructureField)cloneable).getDescription().getText());
            }
            object.setMaxStringLength(((StructureField)cloneable).getMaxStringLength().intValue());
            object.setValueRank(((StructureField)cloneable).getValueRank());
            UaDataTypeSpecification uaDataTypeSpecification = null;
            UaNodeId uaNodeId4 = uaNodeId3;
            while (uaDataTypeSpecification == null && uaNodeId4 != null) {
                uaDataTypeSpecification = encoderContext.getDataTypeSpecification(uaNodeId4);
                if (uaDataTypeSpecification != null) continue;
                uaNodeId4 = map.get(uaNodeId4);
            }
            if (uaDataTypeSpecification == null) {
                throw new IllegalStateException("Cannot determine full inheritance path for DataTypeId: " + uaNodeId3);
            }
            object.setJavaClass(uaDataTypeSpecification.getJavaClass());
            builder.addField(object.build());
        }
        encoderContext.addDataTypeSpecification(builder.build());
    }

    private static void a(NamespaceTable namespaceTable, EncoderContext encoderContext, EnumDescription enumDescription) {
        OptionSetSpecification.Builder<UaOptionSet.Builder> builder = OptionSetSpecification.builder();
        builder.setName(enumDescription.getName().getName());
        builder.setTypeId(UaNodeId.fromLocal(enumDescription.getDataTypeId(), namespaceTable));
        switch (enumDescription.getBuiltInType().intValue()) {
            case 3: {
                builder.setBaseTypeId(UaIds.Byte);
                break;
            }
            case 5: {
                builder.setBaseTypeId(UaIds.UInt16);
                break;
            }
            case 7: {
                builder.setBaseTypeId(UaIds.UInt32);
                break;
            }
            case 9: {
                builder.setBaseTypeId(UaIds.UInt64);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected BuiltInType for OptionSet: " + enumDescription.getBuiltInType());
            }
        }
        EnumDefinition enumDefinition = enumDescription.getEnumDefinition();
        for (EnumField enumField : enumDefinition.getFields()) {
            Long l2 = enumField.getValue();
            OptionSpecification.Builder builder2 = OptionSpecification.builder();
            builder2.setBitPosition(l2.intValue());
            builder2.setDescription(enumField.getDescription());
            builder2.setName(enumField.getName());
            builder.addOptions(builder2.build());
        }
        encoderContext.addDataTypeSpecification(builder.build());
    }

    private UaBinaryFile(UABinaryFileDataType uABinaryFileDataType, EncoderContext encoderContext) {
        this.cP = uABinaryFileDataType;
        this.W = encoderContext;
    }

    public Object getBody() {
        return this.cP.getBody();
    }

    public EncoderContext getContext() {
        return this.W;
    }

    public UABinaryFileDataType getData() {
        return this.cP;
    }

    public ByteString toBinary() throws EncodingException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        BinaryEncoder binaryEncoder = new BinaryEncoder(this.getContext(), byteArrayOutputStream);
        binaryEncoder.put(null, new ExtensionObject(this.getData()), UaIds.Structure, 0);
        ByteString byteString = ByteString.from(byteArrayOutputStream);
        return byteString;
    }
}

