/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StructureUtils {
    private static final Logger logger = LoggerFactory.getLogger(StructureUtils.class);

    public static <T> T clone(T t2) {
        if (t2 == null) {
            return null;
        }
        if (t2.getClass().isArray()) {
            if (((Object[])t2).length == 0) {
                return t2;
            }
            try {
                Object object = MultiDimensionArrayUtils.deepClone(t2);
                return (T)object;
            }
            catch (Exception exception) {
                logger.error("Could not MultiDimensionArrayUtils.deepClone array object: {}, fallback: returning the given object", (Object)t2, (Object)exception);
            }
        }
        if (t2 instanceof Cloneable) {
            try {
                if (t2 instanceof Structure) {
                    Structure structure = ((Structure)t2).clone();
                    return (T)structure;
                }
                Method method = MultiDimensionArrayUtils.getCloneMethod(t2.getClass());
                Object object = method.invoke(t2, new Object[0]);
                return (T)object;
            }
            catch (Exception exception) {
                logger.error("Could not call clone on a Cloneable object: {}, fallback: returning the given object", (Object)t2, (Object)exception);
            }
        }
        return t2;
    }

    public static Map<FieldSpecification, Object> createFieldsMap(StructureSpecification structureSpecification, Object[] objectArray) {
        if (!(structureSpecification.getFields().isEmpty() || objectArray != null && structureSpecification.getFields().size() == objectArray.length)) {
            throw new IllegalArgumentException("The given structure field count differs from the given field values array size");
        }
        return new a(structureSpecification, objectArray);
    }

    public static <T extends Structure> T[] fixEmptyStructureArrayType(Class<T> clazz, Variant variant) {
        Object[] objectArray;
        if (clazz == null) {
            throw new IllegalArgumentException("The given clazz cannot be null");
        }
        if (variant == null || variant.getValue() == null) {
            return null;
        }
        Object object = variant.getValue();
        if (Structure[].class.equals(object.getClass()) && (objectArray = (Structure[])object).length == 0) {
            Structure[] structureArray = (Structure[])Array.newInstance(clazz, 0);
            return structureArray;
        }
        if (BigDecimal[].class.equals(object.getClass()) && (objectArray = (BigDecimal[])object).length == 0) {
            Structure[] structureArray = (Structure[])Array.newInstance(clazz, 0);
            return structureArray;
        }
        objectArray = (Structure[])object;
        return objectArray;
    }

    public static int hashCode(Object ... objectArray) {
        int n2 = 31;
        int n3 = 1;
        if (objectArray != null && objectArray.length != 0) {
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Object object = objectArray[i2];
                int n4 = 0;
                if (object != null) {
                    n4 = object.getClass().isArray() ? (object.getClass().getComponentType().isArray() ? Arrays.deepHashCode((Object[])object) : Arrays.hashCode((Object[])object)) : object.hashCode();
                }
                n3 = 31 * n3 + n4;
            }
        }
        return n3;
    }

    public static boolean scalarOrArrayEquals(Object object, Object object2) {
        boolean bl;
        boolean bl2;
        if (object == object2) {
            return true;
        }
        if (object == null && object2 != null) {
            return false;
        }
        if (object != null && object2 == null) {
            return false;
        }
        boolean bl3 = object.getClass().isArray();
        if (bl3 != (bl2 = object2.getClass().isArray())) {
            return false;
        }
        boolean bl4 = bl3 ? object.getClass().getComponentType().isArray() : false;
        boolean bl5 = bl = bl2 ? object2.getClass().getComponentType().isArray() : false;
        if (bl4 != bl) {
            return false;
        }
        if (bl4) {
            return Arrays.deepEquals((Object[])object, (Object[])object2);
        }
        if (bl3) {
            return Arrays.equals((Object[])object, (Object[])object2);
        }
        return object.equals(object2);
    }

    private StructureUtils() {
    }

    private static class com.prosysopc.ua.StructureUtils$a
    extends AbstractMap<FieldSpecification, Object>
    implements Map<FieldSpecification, Object> {
        private final StructureSpecification cx;
        private final Object[] values;

        private com.prosysopc.ua.StructureUtils$a(StructureSpecification structureSpecification, Object[] objectArray) {
            this.cx = structureSpecification;
            this.values = objectArray;
        }

        @Override
        public Set<Map.Entry<FieldSpecification, Object>> entrySet() {
            return new b(this.cx, this.values);
        }

        private static final class c
        implements Iterator<Map.Entry<FieldSpecification, Object>> {
            private final StructureSpecification cx;
            private final Object[] values;
            private final int size;
            private int index = 0;

            c(StructureSpecification structureSpecification, Object[] objectArray) {
                this.cx = structureSpecification;
                this.values = objectArray;
                this.size = structureSpecification.getFields().size();
            }

            @Override
            public boolean hasNext() {
                return this.index < this.size;
            }

            @Override
            public Map.Entry<FieldSpecification, Object> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                a a2 = new a(this.cx.getFields().get(this.index), this.values[this.index]);
                ++this.index;
                return a2;
            }
        }

        private static final class b
        extends AbstractSet<Map.Entry<FieldSpecification, Object>> {
            private final StructureSpecification cx;
            private final Object[] values;

            b(StructureSpecification structureSpecification, Object[] objectArray) {
                this.cx = structureSpecification;
                this.values = objectArray;
            }

            @Override
            public boolean add(Map.Entry<FieldSpecification, Object> entry) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<FieldSpecification, Object>> collection) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<Map.Entry<FieldSpecification, Object>> iterator() {
                return new c(this.cx, this.values);
            }

            @Override
            public int size() {
                return this.cx.getFields().size();
            }
        }

        private static final class a
        implements Map.Entry<FieldSpecification, Object> {
            private final FieldSpecification cy;
            private final Object value;

            private a(FieldSpecification fieldSpecification, Object object) {
                this.cy = fieldSpecification;
                this.value = object;
            }

            public FieldSpecification x() {
                return this.cy;
            }

            @Override
            public Object getValue() {
                return this.value;
            }

            @Override
            public Object setValue(Object object) {
                throw new UnsupportedOperationException();
            }

            @Override
            public /* synthetic */ Object getKey() {
                return this.x();
            }
        }
    }
}

