/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.SecureIdentityException;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.transport.security.Cert;
import com.prosysopc.ua.stack.transport.security.KeyPair;
import com.prosysopc.ua.stack.transport.security.PrivKey;
import com.prosysopc.ua.stack.transport.security.SecurityAlgorithm;
import com.prosysopc.ua.stack.transport.security.SecurityPolicy;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Enumeration;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureIdentity {
    private static Logger logger = LoggerFactory.getLogger(SecureIdentity.class);
    protected Cert certificate;
    protected final PrivKey privateKey;

    private static void a(byte[] byArray, byte[] byArray2, RSAPrivateKey rSAPrivateKey, SecurityAlgorithm securityAlgorithm) throws SecureIdentityException {
        Cipher cipher = null;
        if (logger.isDebugEnabled()) {
            logger.debug("rsa_Decrypt: {}", (Object)CryptoUtil.toHex(byArray));
        }
        if (securityAlgorithm == null) {
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("rsa_Decrypt: algorithm={} transformation={}", (Object)securityAlgorithm, (Object)securityAlgorithm.getTransformation());
        }
        try {
            cipher = CryptoUtil.getAsymmetricCipher(securityAlgorithm);
        }
        catch (ServiceResultException serviceResultException) {
            logger.info("rsa_Decrypt: Failed to get asymmetric cipher for algorithm {}", (Object)securityAlgorithm);
            throw new SecureIdentityException("Error in asymmetric decrypt: failed to get asymmtric cipher for algorithm" + (Object)((Object)securityAlgorithm), serviceResultException);
        }
        int n2 = rSAPrivateKey.getModulus().bitLength() / 8;
        logger.debug("rsa_Decrypt: {}", (Object)n2);
        if (byArray.length % n2 != 0) {
            logger.info("rsa_Decrypt: Wrong blockSize!!!");
            throw new SecureIdentityException("Error in asymmetric decrypt: Input data is not an even number of encryption blocks.");
        }
        try {
            cipher.init(2, rSAPrivateKey);
            cipher.getOutputSize(byArray.length);
            cipher.getBlockSize();
            int n3 = 0;
            int n4 = n3 + byArray.length;
            int n5 = -1;
            int n6 = 0;
            for (int i2 = n3; i2 < n4; i2 += n2) {
                n5 = cipher.doFinal(byArray, n6, n2, byArray2, n3);
                n6 += n2;
                n3 += n5;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("rsa_Decrypt: output={}", (Object)CryptoUtil.toHex(byArray2));
            }
        }
        catch (ShortBufferException shortBufferException) {
            logger.info("rsa_Decrypt: Error in asymmetric decrypt: ", shortBufferException);
            throw new SecureIdentityException("Error in asymmetric decrypt", shortBufferException);
        }
        catch (GeneralSecurityException generalSecurityException) {
            logger.info("rsa_Decrypt: Error in asymmetric decrypt: ", generalSecurityException);
            throw new SecureIdentityException("Error in asymmetric decrypt", generalSecurityException);
        }
    }

    private static void a(byte[] byArray, Certificate certificate, SecurityAlgorithm securityAlgorithm, int n2, byte[] byArray2, int n3) throws SecureIdentityException {
        if (securityAlgorithm == null) {
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            return;
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)certificate.getPublicKey();
        Cipher cipher = null;
        try {
            if (byArray.length % n2 != 0) {
                logger.warn("Wrong block size in asym encryption");
                throw new SecureIdentityException("Error in asymmetric encrypt: Input data is not an even number of encryption blocks.");
            }
            cipher = Cipher.getInstance(securityAlgorithm.getTransformation());
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            logger.debug("NoSuchAlgorithmException: ", noSuchAlgorithmException);
            throw new SecureIdentityException("Error in asymmetric encrypt: no such algorithm ", noSuchAlgorithmException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            logger.debug("NoSuchPaddingException: ", noSuchPaddingException);
            throw new SecureIdentityException("Error in asymmetric encrypt: failed to get asymmetric cipher", noSuchPaddingException);
        }
        try {
            cipher.init(1, rSAPublicKey);
            int n4 = n3 + byArray.length;
            int n5 = 0;
            for (int i2 = n3; i2 < n4; i2 += n2) {
                int n6 = cipher.doFinal(byArray, n5, n2, byArray2, n3);
                n5 += n2;
                n3 += n6;
            }
        }
        catch (InvalidKeyException invalidKeyException) {
            logger.debug("InvalidKeyException: ", invalidKeyException);
            throw new SecureIdentityException("Error in asymmetric encrypt", invalidKeyException);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            logger.debug("IllegalBlockSizeException: ", illegalBlockSizeException);
            throw new SecureIdentityException("Error in asymmetric encrypt", illegalBlockSizeException);
        }
        catch (BadPaddingException badPaddingException) {
            logger.debug("BadPaddingException: ", badPaddingException);
            throw new SecureIdentityException("Error in asymmetric encrypt", badPaddingException);
        }
        catch (ShortBufferException shortBufferException) {
            logger.debug("ShortBufferException: ", shortBufferException);
            throw new SecureIdentityException("Error in asymmetric encrypt", shortBufferException);
        }
    }

    public SecureIdentity(Cert cert, PrivKey privKey) {
        this.certificate = cert;
        this.privateKey = privKey;
    }

    public SecureIdentity(File file, File file2, String string) throws IOException, SecureIdentityException {
        try {
            this.certificate = Cert.load(file);
        }
        catch (CertificateException certificateException) {
            throw new SecureIdentityException("Cannot load certificate from " + file, certificateException);
        }
        this.privateKey = this.a(file2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecureIdentity(File file, String string, String string2, String string3, String string4) throws IOException, SecureIdentityException {
        KeyStore keyStore = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            try {
                keyStore = KeyStore.getInstance(string4);
                keyStore.load(fileInputStream, string3.toCharArray());
                if (!keyStore.containsAlias(string)) {
                    string = null;
                }
                if (string == null) {
                    Enumeration<String> enumeration = keyStore.aliases();
                    while (enumeration.hasMoreElements()) {
                        string = enumeration.nextElement();
                    }
                    if (string == null) {
                        throw new KeyStoreException("Empty Key Store.");
                    }
                }
                this.certificate = new Cert((X509Certificate)keyStore.getCertificate(string));
                this.privateKey = string2 != null ? new PrivKey((RSAPrivateKey)keyStore.getKey(string, string2.toCharArray())) : new PrivKey((RSAPrivateKey)keyStore.getKey(string, null));
            }
            catch (KeyStoreException keyStoreException) {
                throw new SecureIdentityException("Cannot load key from PKCS12 KeyStore: " + keyStoreException.getMessage(), keyStoreException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SecureIdentityException("Cannot load key from PKCS12 KeyStore: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
            }
            catch (CertificateException certificateException) {
                throw new SecureIdentityException("Cannot load key from PKCS12 KeyStore: " + certificateException.getMessage(), certificateException);
            }
            catch (UnrecoverableKeyException unrecoverableKeyException) {
                throw new SecureIdentityException("Cannot load key from PKCS12 KeyStore: " + unrecoverableKeyException.getMessage(), unrecoverableKeyException);
            }
        }
    }

    public SecureIdentity(URL uRL, URL uRL2, String string) throws IOException, SecureIdentityException {
        try {
            this.certificate = Cert.load(uRL);
        }
        catch (CertificateException certificateException) {
            throw new SecureIdentityException("Cannot load certificate from " + uRL, certificateException);
        }
        try {
            this.privateKey = PrivKey.loadFromKeyStore(uRL2, string);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new SecureIdentityException("Cannot load private key from " + uRL2, unrecoverableKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecureIdentityException("Cannot load private key from " + uRL2, noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new SecureIdentityException("Cannot load private key from " + uRL2, certificateException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new SecureIdentityException("Cannot load private key from " + uRL2, keyStoreException);
        }
    }

    protected SecureIdentity() {
        this.certificate = null;
        this.privateKey = null;
    }

    public byte[] decrypt(SecurityPolicy securityPolicy, byte[] byArray) throws SecureIdentityException {
        return this.decrypt(securityPolicy.getAsymmetricEncryptionAlgorithm(), byArray, this.privateKey);
    }

    public byte[] encrypt(SecurityPolicy securityPolicy, byte[] byArray) throws SecureIdentityException {
        int n2;
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        SecurityAlgorithm securityAlgorithm = securityPolicy.getAsymmetricEncryptionAlgorithm();
        logger.debug("encrypt: algorithm={}", (Object)securityAlgorithm);
        try {
            n2 = CryptoUtil.getPlainTextBlockSize(securityAlgorithm, this.certificate.getCertificate().getPublicKey());
        }
        catch (ServiceResultException serviceResultException) {
            throw new SecureIdentityException("Error in asymmetric encrypt: failed to get plain text block size", serviceResultException);
        }
        int n3 = (byArray.length + 4) / n2 + 1;
        int n4 = byArray.length / n2 + 1;
        n4 *= n2;
        byte[] byArray2 = new byte[n3 *= n2];
        byArray2[0] = (byte)(0xFF & byArray.length);
        byArray2[1] = (byte)((0xFF00 & byArray.length) >> 8);
        byArray2[2] = (byte)((0xFF0000 & byArray.length) >> 16);
        byArray2[3] = (byte)((0xFF000000 & byArray.length) >> 24);
        System.arraycopy(byArray, 0, byArray2, 4, byArray.length);
        byte[] byArray3 = new byte[n4];
        SecureIdentity.a(byArray2, this.certificate.getCertificate(), securityAlgorithm, n2, byArray3, 0);
        return byArray3;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof SecureIdentity)) {
            return false;
        }
        SecureIdentity secureIdentity = (SecureIdentity)object;
        return !(this.certificate == null ? secureIdentity.certificate != null : !this.certificate.equals(secureIdentity.certificate));
    }

    public Cert getCertificate() {
        return this.certificate;
    }

    public KeyPair getKeys() {
        return this.certificate == null ? null : new KeyPair(this.certificate, this.privateKey);
    }

    public PrivKey getPrivateKey() {
        return this.privateKey;
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.certificate == null ? 0 : this.certificate.hashCode());
        return n3;
    }

    private PrivKey a(File file, String string) throws IOException, SecureIdentityException {
        try {
            try {
                return PrivKey.loadFromKeyStore(file, string);
            }
            catch (IOException iOException) {
                if (iOException.getCause() instanceof UnrecoverableKeyException) {
                    throw new SecureIdentityException("Wrong password for key store " + file, iOException);
                }
                try {
                    return PrivKey.load(file, string);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new SecureIdentityException("Cannot load private key from " + file, generalSecurityException);
                }
            }
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            throw new SecureIdentityException("Cannot load private key from key store " + file, unrecoverableKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecureIdentityException("Cannot load private key from key store " + file, noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw new SecureIdentityException("Cannot load private key from key store " + file, certificateException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new SecureIdentityException("Cannot load private key from key store " + file, keyStoreException);
        }
    }

    protected byte[] decrypt(SecurityAlgorithm securityAlgorithm, byte[] byArray, PrivKey privKey) throws SecureIdentityException {
        if (byArray == null || byArray.length == 0) {
            return byArray;
        }
        RSAPrivateKey rSAPrivateKey = privKey.getPrivateKey();
        int n2 = rSAPrivateKey == null || rSAPrivateKey.getModulus().bitLength() <= 2048 ? 256 : 512;
        byte[] byArray2 = new byte[n2];
        SecureIdentity.a(byArray, byArray2, rSAPrivateKey, securityAlgorithm);
        int n3 = 0;
        n3 += byArray2[0];
        n3 += byArray2[1] << 8;
        n3 += byArray2[2] << 16;
        n3 += byArray2[3] << 24;
        if (logger.isDebugEnabled()) {
            logger.debug("decrypt: length={}", (Object)n3);
        }
        if (n3 > byArray2.length - 4) {
            throw new SecureIdentityException("Invalid length");
        }
        for (int i2 = n3 + 4; i2 < byArray2.length; ++i2) {
            if (byArray2[i2] == 0) continue;
            throw new SecureIdentityException("Invalid padding");
        }
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray2, 4, byArray3, 0, n3);
        return byArray3;
    }
}

