/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.AbstractOptionSetDataType;
import com.prosysopc.ua.OptionSetDataType;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;

public final class OptionSetUtils {
    private static final Map<Class<?>, Map<Object, Object>> cache = new HashMap();

    public static final <T extends OptionSetDataType<?, ?>> T checkInterned(T t2) {
        if (!cache.containsKey(t2.getClass())) {
            return t2;
        }
        Map<Object, Object> map = cache.get(t2.getClass());
        OptionSetDataType optionSetDataType = (OptionSetDataType)map.get(t2);
        return (T)(optionSetDataType == null ? t2 : optionSetDataType);
    }

    public static final <T extends Number, S extends AbstractOptionSetDataType<?, T, ?, ?>> Object convert(Variant variant, Class<T> clazz, Class<S> clazz2, Factory<T, S> factory) throws StatusException {
        if (variant == null || variant.getValue() == null) {
            return null;
        }
        if (!variant.getValue().getClass().isArray()) {
            Number number;
            try {
                number = (Number)clazz.cast(variant.getValue());
            }
            catch (ClassCastException classCastException) {
                throw new StatusException(StatusCodes.Bad_TypeMismatch, (Throwable)classCastException);
            }
            return factory.create(number);
        }
        if (MultiDimensionArrayUtils.getDimension(variant.getValue()) == 1) {
            Number[] numberArray = (Number[])variant.getValue();
            AbstractOptionSetDataType[] abstractOptionSetDataTypeArray = (AbstractOptionSetDataType[])Array.newInstance(clazz2, numberArray.length);
            for (int i2 = 0; i2 < numberArray.length; ++i2) {
                abstractOptionSetDataTypeArray[i2] = (AbstractOptionSetDataType)factory.create(numberArray[i2]);
            }
            return abstractOptionSetDataTypeArray;
        }
        int[] nArray = MultiDimensionArrayUtils.getArrayLengths(variant.getValue());
        Number[] numberArray = (Number[])MultiDimensionArrayUtils.muxArray(variant.getValue(), nArray);
        AbstractOptionSetDataType[] abstractOptionSetDataTypeArray = (AbstractOptionSetDataType[])Array.newInstance(clazz2, numberArray.length);
        for (int i3 = 0; i3 < numberArray.length; ++i3) {
            abstractOptionSetDataTypeArray[i3] = (AbstractOptionSetDataType)factory.create(numberArray[i3]);
        }
        return MultiDimensionArrayUtils.demuxArray(abstractOptionSetDataTypeArray, nArray);
    }

    public static <T extends OptionSetDataType<?, ?>> T intern(T t2) {
        Map<Object, Object> map;
        if (t2 == null) {
            throw new IllegalArgumentException("Cannot intern null value");
        }
        Map<Object, Object> map2 = cache.get(t2.getClass());
        if (map2 != null && (map = (OptionSetDataType)map2.get(t2)) != null) {
            return (T)map;
        }
        map = cache.get(t2.getClass());
        if (map == null) {
            map = new HashMap<T, T>();
            cache.put(t2.getClass(), map);
        }
        map.put(t2, t2);
        return t2;
    }

    private OptionSetUtils() {
    }

    public static interface Factory<T, S> {
        public S create(T var1) throws StatusException;
    }
}

