/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.ModelException;
import com.prosysopc.ua.ServiceException;
import com.prosysopc.ua.StatusException;
import com.prosysopc.ua.UaApplication;
import com.prosysopc.ua.UaArrayDimensions;
import com.prosysopc.ua.UaIds;
import com.prosysopc.ua.UaNodeId;
import com.prosysopc.ua.UaOptionSet;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.builtintypes.XmlElement;
import com.prosysopc.ua.stack.common.NamespaceTable;
import com.prosysopc.ua.stack.common.ServerTable;
import com.prosysopc.ua.stack.core.AccessLevelType;
import com.prosysopc.ua.stack.core.AddNodesItem;
import com.prosysopc.ua.stack.core.AddReferencesItem;
import com.prosysopc.ua.stack.core.DataTypeAttributes;
import com.prosysopc.ua.stack.core.DataTypeIdentifiers;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.core.MethodAttributes;
import com.prosysopc.ua.stack.core.NodeAttributes;
import com.prosysopc.ua.stack.core.NodeClass;
import com.prosysopc.ua.stack.core.ObjectAttributes;
import com.prosysopc.ua.stack.core.ObjectTypeAttributes;
import com.prosysopc.ua.stack.core.OptionSet;
import com.prosysopc.ua.stack.core.ReferenceTypeAttributes;
import com.prosysopc.ua.stack.core.ReferenceTypeIdentifiers;
import com.prosysopc.ua.stack.core.StatusCodes;
import com.prosysopc.ua.stack.core.VariableAttributes;
import com.prosysopc.ua.stack.core.VariableTypeAttributes;
import com.prosysopc.ua.stack.core.ViewAttributes;
import com.prosysopc.ua.stack.encoding.DecodingException;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import com.prosysopc.ua.stack.encoding.xml.XmlDecoder;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.stack.utils.OSUtil;
import com.prosysopc.ua.stack.utils.XMLFactoryCache;
import com.prosysopc.ua.typedictionary.DynamicUIntOptionSet;
import com.prosysopc.ua.typedictionary.EnumerationSpecification;
import com.prosysopc.ua.typedictionary.FieldSpecification;
import com.prosysopc.ua.typedictionary.OptionSetSpecification;
import com.prosysopc.ua.typedictionary.OptionSetStructureSpecification;
import com.prosysopc.ua.typedictionary.OptionSpecification;
import com.prosysopc.ua.typedictionary.SimpleTypeSpecification;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public abstract class ModelParserBase {
    public static final String UTF8_BOM = "\ufeff";
    private static final boolean aE = OSUtil.isAndroid();
    private static boolean aF = false;
    private static final Logger logger = LoggerFactory.getLogger(ModelParserBase.class);
    private String alias;
    private final HashMap<String, NodeId> aG = new HashMap();
    private final UaApplication aH;
    private boolean aI;
    private final Set<ExpandedNodeId> aJ = new TreeSet<ExpandedNodeId>();
    private String aK;
    private String aL;
    private final NamespaceTable aM;
    private Locator locator;
    private final d aN = new d();
    private final Set<UaNodeId> aO = new HashSet<UaNodeId>();
    private AddNodesItem aP;
    private NodeAttributes aQ;
    private AddReferencesItem aR;
    private final List<AddReferencesItem> aS = new ArrayList<AddReferencesItem>();
    private final List<AddNodesItem> nodes = new ArrayList<AddNodesItem>();
    private final StringBuilder aT = new StringBuilder();
    private b aU;
    private boolean aV;
    private XMLReader reader;
    private int aW = 0;
    private boolean aX;
    private int aY = 0;
    private final List<AddReferencesItem> aZ = new ArrayList<AddReferencesItem>();
    private final UnsignedInteger ba = UnsignedInteger.ZERO;
    private TransformerHandler bb;
    private DOMResult bc;
    List<String> aC = new ArrayList<String>();
    private final List<VariableAttributes> bd = new ArrayList<VariableAttributes>();
    private final List<VariableTypeAttributes> be = new ArrayList<VariableTypeAttributes>();
    private Map<UaNodeId, StructureSpecification> bf = new HashMap<UaNodeId, StructureSpecification>();
    private Map<UaNodeId, e> bg = new HashMap<UaNodeId, e>();
    private Map<UaNodeId, UaNodeId> bh = new HashMap<UaNodeId, UaNodeId>();
    private Map<UaNodeId, UaNodeId> bi = new HashMap<UaNodeId, UaNodeId>();
    private Map<UaNodeId, UaNodeId> bj = new HashMap<UaNodeId, UaNodeId>();
    private Set<UaNodeId> bk = new HashSet<UaNodeId>();
    private Map<UaNodeId, UaNodeId> bl = new HashMap<UaNodeId, UaNodeId>();
    private Map<UaNodeId, UaNodeId> bm = new HashMap<UaNodeId, UaNodeId>();
    private Map<UaNodeId, UaNodeId> bn = new HashMap<UaNodeId, UaNodeId>();

    public static boolean isSkipValuesOnAndroid() {
        return aF;
    }

    public static void setSkipValuesOnAndroid(boolean bl) {
        aF = bl;
    }

    public ModelParserBase(UaApplication uaApplication) {
        this.aH = uaApplication;
        this.aM = new NamespaceTable();
    }

    public void createModel(boolean bl) throws ModelException, ServiceException {
        logger.debug("Starting model creation..");
        this.setFailOnFirstError(bl);
        ArrayList<AddNodesItem> arrayList = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList2 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList3 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList4 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList5 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList6 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList7 = new ArrayList<AddNodesItem>();
        ArrayList<AddNodesItem> arrayList8 = new ArrayList<AddNodesItem>();
        block10: for (AddNodesItem cloneable2 : this.nodes) {
            if (this.aJ.contains(cloneable2.getRequestedNewNodeId())) {
                logger.debug("ignored: {} NodeId={}", (Object)cloneable2.getBrowseName(), (Object)cloneable2.getRequestedNewNodeId());
                continue;
            }
            if (cloneable2.getNodeClass() == null) {
                arrayList5.add(cloneable2);
                continue;
            }
            switch (cloneable2.getNodeClass()) {
                case ReferenceType: {
                    arrayList.add(cloneable2);
                    continue block10;
                }
                case DataType: {
                    arrayList2.add(cloneable2);
                    continue block10;
                }
                case Method: {
                    arrayList8.add(cloneable2);
                    continue block10;
                }
                case Object: {
                    arrayList3.add(cloneable2);
                    continue block10;
                }
                case ObjectType: {
                    arrayList6.add(cloneable2);
                    continue block10;
                }
                case Variable: {
                    arrayList4.add(cloneable2);
                    continue block10;
                }
                case VariableType: {
                    arrayList7.add(cloneable2);
                    continue block10;
                }
                case View: {
                    arrayList5.add(cloneable2);
                    continue block10;
                }
            }
            logger.warn("Encountered unkown NodeClass, ignoring node: " + cloneable2.getNodeClass());
        }
        ArrayList arrayList9 = new ArrayList();
        ArrayList<AddReferencesItem> arrayList10 = new ArrayList<AddReferencesItem>();
        for (AddReferencesItem addReferencesItem : this.aZ) {
            if (this.aO.contains(UaNodeId.fromLocal(addReferencesItem.getSourceNodeId(), this.aH.getNamespaceTable()))) {
                if (ReferenceTypeIdentifiers.HasSubtype.equals(addReferencesItem.getReferenceTypeId())) {
                    arrayList9.add(addReferencesItem);
                    continue;
                }
                arrayList10.add(addReferencesItem);
                continue;
            }
            arrayList10.add(addReferencesItem);
        }
        this.addNodes(arrayList, "ReferenceTypes");
        this.addNodes(arrayList2, "DataTypes");
        this.addReferences(arrayList9);
        this.q();
        this.r();
        this.addNodes(arrayList6, "ObjectTypeNodes");
        this.addNodes(arrayList7, "VariableTypeNodes");
        this.addNodes(arrayList3, "ObjectNodes");
        this.addNodes(arrayList4, "VariableNodes");
        this.addNodes(arrayList5, "OtherNodes");
        this.addNodes(arrayList8, "MethodNodes");
        this.addReferences(arrayList10);
        for (AddNodesItem addNodesItem : arrayList3) {
            this.afterCreate(addNodesItem);
        }
        logger.debug("createModel: done. Errors={}", (Object)this.aC.size());
        if (!this.aC.isEmpty()) {
            throw new ModelException(this.aC);
        }
    }

    public EncoderContext getEncoderContext() {
        return this.aH.getEncoderContext();
    }

    public List<String> getErrorList() {
        return this.aC;
    }

    public Collection<ExpandedNodeId> getIgnoredNodes() {
        return this.aJ;
    }

    public List<AddNodesItem> getNodes() {
        return this.nodes;
    }

    public List<AddReferencesItem> getReferences() {
        return this.aZ;
    }

    public boolean isFailOnFirstError() {
        return this.aI;
    }

    public boolean isReadingExtensions() {
        return this.aW > 0;
    }

    public void parseFile(InputStream inputStream) throws IOException, SAXException, ModelException {
        this.parseFile(inputStream, StandardCharsets.UTF_8);
    }

    public void parseFile(InputStream inputStream, Charset charset) throws IOException, SAXException, ModelException {
        logger.debug("parseFile: charset={}" + charset);
        this.aK = "stream";
        this.reader = XMLReaderFactory.createXMLReader();
        this.reader.setContentHandler(this.aN);
        this.reader.setErrorHandler(this.aN);
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        inputStream.mark(10);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
        logger.debug("encoding={}", (Object)inputStreamReader.getEncoding());
        char[] cArray = new char[2];
        inputStreamReader.read(cArray, 0, inputStreamReader.getEncoding().equals("UTF8") ? 1 : 2);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format(Locale.ROOT, "cbuf=%04x %04x bom=%04x", (int)cArray[0], (int)cArray[1], (int)UTF8_BOM.charAt(0)));
        }
        if (cArray[0] != UTF8_BOM.charAt(0)) {
            inputStream.reset();
            inputStreamReader = new InputStreamReader(inputStream, charset);
        }
        this.reader.parse(new InputSource(inputStreamReader));
        if (!this.aC.isEmpty()) {
            throw new ModelException(this.aC);
        }
    }

    public void parseFile(URI uRI) throws SAXException, IOException, ModelException {
        if (logger.isDebugEnabled()) {
            logger.debug("parseFile:" + uRI);
        }
        this.aK = uRI.toString();
        InputStream inputStream = uRI.toURL().openStream();
        this.parseFile(inputStream);
    }

    public void setFailOnFirstError(boolean bl) {
        this.aI = bl;
    }

    public void setIgnoredNodes(Collection<ExpandedNodeId> collection) {
        if (collection != null) {
            this.aJ.addAll(collection);
        }
    }

    private void a(AddNodesItem addNodesItem) throws ModelException {
        try {
            NodeId nodeId = this.doAddNode(addNodesItem);
            if (!nodeId.getValue().equals(addNodesItem.getRequestedNewNodeId().getValue())) {
                logger.warn("addNode: {} requested NodeId={} actual NodeId={}", addNodesItem.getBrowseName(), addNodesItem.getRequestedNewNodeId(), nodeId);
            } else {
                logger.debug("addNode:{} requested NodeId={}", (Object)addNodesItem.getBrowseName(), (Object)addNodesItem.getRequestedNewNodeId());
            }
        }
        catch (Exception exception) {
            this.a(this.aI, this.aC, exception, "Failed to create node: " + addNodesItem.getBrowseName() + " with id:" + addNodesItem.getRequestedNewNodeId());
        }
    }

    private void addReference(AddReferencesItem addReferencesItem) throws ModelException {
        block3: {
            try {
                this.doAddReference(addReferencesItem);
                if (logger.isDebugEnabled()) {
                    logger.debug("createModel: Adding refitem: " + addReferencesItem.getSourceNodeId() + " --> " + addReferencesItem.getTargetNodeId() + " forward:" + addReferencesItem.getIsForward() + " type: " + addReferencesItem.getReferenceTypeId());
                }
            }
            catch (Exception exception) {
                if (this.isIgnoredReference(addReferencesItem)) break block3;
                this.a(this.aI, this.aC, exception, "Failed to create reference: " + addReferencesItem.getSourceNodeId() + "--->" + addReferencesItem.getTargetNodeId() + " forward:" + addReferencesItem.getIsForward() + " type: " + addReferencesItem.getReferenceTypeId());
            }
        }
    }

    private void c(Variant variant) {
        if (this.aQ != null) {
            logger.debug("addValue: {}", (Object)variant);
            if (this.aQ instanceof VariableAttributes) {
                ((VariableAttributes)this.aQ).setValue(variant.getValue());
                if (variant.getValue() != null && variant.getValue() instanceof ExtensionObject && ((ExtensionObject)variant.getValue()).isEncoded()) {
                    this.bd.add((VariableAttributes)this.aQ);
                }
            }
            if (this.aQ instanceof VariableTypeAttributes) {
                ((VariableTypeAttributes)this.aQ).setValue(variant.getValue());
                if (variant.getValue() != null && variant.getValue() instanceof ExtensionObject && ((ExtensionObject)variant.getValue()).isEncoded()) {
                    this.be.add((VariableTypeAttributes)this.aQ);
                }
            }
        }
    }

    private void f() {
        this.aG.put(this.alias, this.a(this.aT.toString(), false));
    }

    private void a(Attributes attributes) {
        this.aP = this.g(attributes);
        this.aQ = this.b(attributes);
        this.aP.setNodeClass(NodeClass.DataType);
    }

    private NodeAttributes b(Attributes attributes) {
        DataTypeAttributes dataTypeAttributes = new DataTypeAttributes();
        this.a(attributes, dataTypeAttributes);
        dataTypeAttributes.setIsAbstract(this.a(attributes, "IsAbstract", false));
        return dataTypeAttributes;
    }

    private void c(Attributes attributes) {
        this.aU = new b();
        this.aU.isUnion = this.a(attributes, "IsUnion", false);
        this.aU.isOptionSet = this.a(attributes, "IsOptionSet", false);
    }

    private void d(Attributes attributes) {
        if (this.aU == null) {
            logger.warn("Field tag outside of Definition block, ignoring..");
            return;
        }
        a a2 = new a();
        a2.name = this.b(attributes, "Name", "");
        String string = this.b(attributes, "Value", null);
        if (string == null || string.isEmpty()) {
            String string2 = this.b(attributes, "DataType", "i=24");
            a2.bq = this.a(string2, true);
            a2.br = this.a(attributes, "IsOptional", false);
            a2.bv = this.a(attributes, "AllowSubTypes", false);
            a2.bt = this.a(attributes, "ValueRank", -1);
            if (a2.bt >= 1) {
                String string3 = Arrays.toString(new int[a2.bt.intValue()]);
                string3 = string3.substring(1, string3.length() - 1);
                string3 = string3.replaceAll("\\s", "");
                a2.bu = this.a(attributes, "ArrayDimensions", string3);
            }
        } else {
            a2.bs = this.a(attributes, "Value", -1);
        }
        this.aU.fields.add(a2);
    }

    private void e(Attributes attributes) {
        this.aP = this.g(attributes);
        this.aQ = this.f(attributes);
        this.aP.setNodeClass(NodeClass.Method);
    }

    private NodeAttributes f(Attributes attributes) {
        MethodAttributes methodAttributes = new MethodAttributes();
        this.a(attributes, methodAttributes);
        methodAttributes.setExecutable(this.a(attributes, "Executable", true));
        methodAttributes.setUserExecutable(this.a(attributes, "UserExecutable", true));
        return methodAttributes;
    }

    private void a(boolean bl, List<String> list, Exception exception, String string) throws ModelException {
        logger.warn("createModel: " + string + " ", exception);
        if (bl) {
            if (this.locator != null) {
                throw new ModelException(string, exception, this.locator.getLineNumber());
            }
            throw new ModelException(string, exception);
        }
        if (this.locator != null) {
            list.add(string + exception + " (near line " + this.locator.getLineNumber() + ")");
        } else {
            list.add(string + exception);
        }
    }

    private AddNodesItem g(Attributes attributes) {
        AddNodesItem addNodesItem = new AddNodesItem();
        ExpandedNodeId expandedNodeId = this.a(attributes, "NodeId");
        if (expandedNodeId == null) {
            throw new NullPointerException("createNode: NodeId should not be null");
        }
        addNodesItem.setRequestedNewNodeId(expandedNodeId);
        addNodesItem.setBrowseName(this.b(attributes, "BrowseName"));
        logger.debug("Creating node: {}", (Object)addNodesItem.getBrowseName().getName());
        return addNodesItem;
    }

    private void h(Attributes attributes) {
        this.aP = this.g(attributes);
        this.aQ = this.i(attributes);
        this.aP.setNodeClass(NodeClass.Object);
    }

    private ObjectAttributes i(Attributes attributes) {
        ObjectAttributes objectAttributes = new ObjectAttributes();
        this.a(attributes, objectAttributes);
        objectAttributes.setEventNotifier(this.a(attributes, "EventNotifier", UnsignedByte.valueOf(0)));
        return objectAttributes;
    }

    private void j(Attributes attributes) {
        this.aP = this.g(attributes);
        this.aQ = this.k(attributes);
        this.aP.setNodeClass(NodeClass.ObjectType);
    }

    private NodeAttributes k(Attributes attributes) {
        ObjectTypeAttributes objectTypeAttributes = new ObjectTypeAttributes();
        this.a(attributes, objectTypeAttributes);
        objectTypeAttributes.setIsAbstract(this.a(attributes, "IsAbstract", false));
        return objectTypeAttributes;
    }

    private void l(Attributes attributes) {
        if (this.aP != null) {
            this.aR = new AddReferencesItem();
            this.aR.setIsForward(this.a(attributes, "IsForward", true));
            this.aR.setReferenceTypeId(this.toGlobalNodeId(this.a(attributes, "ReferenceType", Identifiers.References)));
            NodeId nodeId = this.toGlobalNodeId(this.aP.getRequestedNewNodeId());
            this.aR.setSourceNodeId(nodeId);
        }
    }

    private void m(Attributes attributes) {
        this.aP = this.g(attributes);
        this.aQ = this.n(attributes);
        this.aP.setNodeClass(NodeClass.ReferenceType);
    }

    private NodeAttributes n(Attributes attributes) {
        ReferenceTypeAttributes referenceTypeAttributes = new ReferenceTypeAttributes();
        this.a(attributes, referenceTypeAttributes);
        referenceTypeAttributes.setIsAbstract(this.a(attributes, "IsAbstract", false));
        referenceTypeAttributes.setSymmetric(this.a(attributes, "Symmetric", false));
        return referenceTypeAttributes;
    }

    private void g() throws TransformerConfigurationException, SAXException {
        this.bc = new DOMResult();
        this.bb = XMLFactoryCache.getSAXTransformerFactory().newTransformerHandler();
        this.bb.setResult(this.bc);
        this.bb.startDocument();
        logger.debug("Created valueHandler");
    }

    private void o(Attributes attributes) {
        this.aP = this.g(attributes);
        this.aQ = this.p(attributes);
        this.aP.setNodeClass(NodeClass.Variable);
    }

    private NodeAttributes p(Attributes attributes) {
        VariableAttributes variableAttributes = new VariableAttributes();
        this.a(attributes, variableAttributes);
        variableAttributes.setAccessLevel(this.u(attributes));
        variableAttributes.setArrayDimensions(this.a(attributes, "ArrayDimensions", ""));
        variableAttributes.setDataType(this.toGlobalNodeId(this.a(attributes, "DataType", Identifiers.BaseDataType)));
        variableAttributes.setHistorizing(this.a(attributes, "Historizing", false));
        variableAttributes.setMinimumSamplingInterval(this.a(attributes, "MinimumSamplingInterval", 0.0));
        variableAttributes.setUserAccessLevel(this.a(attributes, "UserAccessLevel", UnsignedByte.valueOf(1)));
        variableAttributes.setValueRank(this.a(attributes, "ValueRank", -1));
        return variableAttributes;
    }

    private void q(Attributes attributes) {
        this.aP = this.g(attributes);
        this.aQ = this.r(attributes);
        this.aP.setNodeClass(NodeClass.VariableType);
    }

    private NodeAttributes r(Attributes attributes) {
        VariableTypeAttributes variableTypeAttributes = new VariableTypeAttributes();
        this.a(attributes, variableTypeAttributes);
        variableTypeAttributes.setIsAbstract(this.a(attributes, "IsAbstract", false));
        variableTypeAttributes.setValueRank(this.a(attributes, "ValueRank", -1));
        variableTypeAttributes.setArrayDimensions(this.a(attributes, "ArrayDimensions", ""));
        variableTypeAttributes.setDataType(this.toGlobalNodeId(this.a(attributes, "DataType", Identifiers.BaseDataType)));
        return variableTypeAttributes;
    }

    private void s(Attributes attributes) {
        this.aP = this.g(attributes);
        this.aQ = this.t(attributes);
        this.aP.setNodeClass(NodeClass.View);
    }

    private NodeAttributes t(Attributes attributes) {
        ViewAttributes viewAttributes = new ViewAttributes();
        this.a(attributes, viewAttributes);
        viewAttributes.setContainsNoLoops(this.a(attributes, "ContainsNoLoops", false));
        return viewAttributes;
    }

    private void h() {
        logger.debug("Read extensions - readingExtensions:={}", (Object)this.aW);
    }

    private void j() {
        if (this.aQ == null) {
            return;
        }
        this.aP.setNodeAttributes(this.aQ);
        this.nodes.add(this.aP);
        int n2 = -1;
        try {
            n2 = this.aH.getNamespaceTable().toNodeId(this.aP.getRequestedNewNodeId()).getNamespaceIndex();
        }
        catch (Exception exception) {
            n2 = -1;
        }
        UaNodeId uaNodeId = UaNodeId.fromLocal(this.aP.getRequestedNewNodeId(), this.aH.getNamespaceTable());
        boolean bl = NodeClass.DataType.equals(this.aP.getNodeClass());
        if (bl) {
            this.aO.add(uaNodeId);
        }
        if (bl && !this.aH.getKnownDataTypeDictionary().knownAddressSpaceNamespaces().contains(uaNodeId.getNamespaceUri()) && n2 != 0 && !this.aH.getEncoderContext().getDataTypeSpecifications().containsKey(uaNodeId)) {
            e e2 = new e();
            e2.name = this.aP.getBrowseName().getName();
            if (this.aQ instanceof DataTypeAttributes && Boolean.TRUE.equals(((DataTypeAttributes)this.aQ).getIsAbstract())) {
                e2.isAbstract = true;
            }
            e2.cd = this.aU != null ? this.aU : new b();
            e2.typeId = uaNodeId;
            this.bg.put(uaNodeId, e2);
        }
        if (this.bm.containsKey(uaNodeId) && !this.bk.contains(uaNodeId)) {
            this.a(uaNodeId, this.bm.get(uaNodeId));
        }
        this.aP = null;
        this.aQ = null;
        this.aU = null;
    }

    private void k() {
        if (this.aR != null) {
            if (this.aV) {
                this.aR.setTargetNodeId(this.toGlobalExpandedNodeId(this.h(this.aT.toString())));
            }
            this.aV = false;
            if (logger.isDebugEnabled()) {
                logger.debug("referenceToString(nodeReference): {}", (Object)this.a(this.aR));
            }
            this.aS.add(this.aR);
            this.aR = null;
        }
    }

    private void l() {
        if (this.aS.size() == 0) {
            logger.debug("Zero references..");
        }
        for (AddReferencesItem addReferencesItem : this.aS) {
            UaNodeId uaNodeId;
            UaNodeId uaNodeId2;
            if (addReferencesItem.getReferenceTypeId().equals(Identifiers.HasTypeDefinition) && addReferencesItem.getIsForward().booleanValue()) {
                this.aP.setTypeDefinition(addReferencesItem.getTargetNodeId());
            }
            this.aZ.add(addReferencesItem);
            if (Identifiers.HasEncoding.equals(addReferencesItem.getReferenceTypeId())) {
                uaNodeId2 = UaNodeId.fromLocal(addReferencesItem.getSourceNodeId(), this.aH.getNamespaceTable());
                uaNodeId = UaNodeId.fromLocal(addReferencesItem.getTargetNodeId(), this.aH.getNamespaceTable());
                if (addReferencesItem.getIsForward().booleanValue()) {
                    this.bn.put(uaNodeId2, uaNodeId);
                    this.bm.put(uaNodeId, uaNodeId2);
                } else {
                    this.a(uaNodeId2, uaNodeId);
                }
            }
            if (!Identifiers.HasSubtype.equals(addReferencesItem.getReferenceTypeId())) continue;
            uaNodeId2 = UaNodeId.fromLocal(addReferencesItem.getSourceNodeId(), this.aH.getNamespaceTable());
            uaNodeId = UaNodeId.fromLocal(addReferencesItem.getTargetNodeId(), this.aH.getNamespaceTable());
            if (addReferencesItem.getIsForward().booleanValue()) {
                this.bl.put(uaNodeId, uaNodeId2);
                continue;
            }
            this.bl.put(uaNodeId2, uaNodeId);
        }
        this.aS.clear();
    }

    private void m() {
        String string = this.aT.toString().trim();
        this.addNamespaceUri(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void n() throws TransformerFactoryConfigurationError, TransformerException, SAXException, DecodingException {
        this.bb.endDocument();
        if (!ModelParserBase.aE || !ModelParserBase.aF) {
            ModelParserBase.logger.debug("finalizing value:{}", (Object)this.bc.getNode());
            var1_1 = new StringWriter();
            var2_2 = XMLFactoryCache.getTransformerFactory().newTransformer();
            var2_2.setOutputProperty("omit-xml-declaration", "yes");
            var2_2.transform(new DOMSource(this.bc.getNode()), new StreamResult(var1_1));
            var3_3 = var1_1.toString();
            ModelParserBase.logger.debug("Parsed XML of value:\n{}", (Object)var3_3);
            var4_4 = new XmlElement(var3_3);
            var5_5 = new XmlDecoder(var4_4, this.getEncoderContext());
            try {
                var5_5.setNamespaceTable(this.aM);
                this.c(var5_5.getVariant(""));
            }
            catch (Exception var6_6) {
                ModelParserBase.logger.warn("Could not load the value of node: {}, (it is probably non-codegenerated Structure)", (Object)this.aP.getRequestedNewNodeId(), (Object)var6_6);
                if (!ModelParserBase.logger.isDebugEnabled()) ** GOTO lbl25
                ModelParserBase.logger.debug("Failure was: ", var6_6);
            }
            finally {
                var5_5.close();
            }
        } else {
            ModelParserBase.logger.debug("finalizing value: skipping because we are on android and skipValuesOnAndroid setting is true");
        }
lbl25:
        // 4 sources

        this.bb = null;
    }

    private UnsignedByte u(Attributes attributes) {
        UnsignedInteger unsignedInteger = this.a(attributes, "AccessLevel", UnsignedInteger.ONE);
        if (unsignedInteger.longValue() <= 255L) {
            return UnsignedByte.valueOf(unsignedInteger.longValue());
        }
        HashSet<AccessLevelType.Options> hashSet = new HashSet<AccessLevelType.Options>();
        for (AccessLevelType.Options options : AccessLevelType.Options.values()) {
            if (!unsignedInteger.isBitSet(options.getBitPosition())) continue;
            hashSet.add(options);
        }
        UnsignedByte unsignedByte = (UnsignedByte)AccessLevelType.of(hashSet).asBuiltInType();
        logger.warn("Encountered larger than Byte AccessLevel value: {}, truncated to: {} (AccessLevelEx is not yet supported)", (Object)unsignedInteger, (Object)unsignedByte);
        return unsignedByte;
    }

    private UnsignedInteger[] a(Attributes attributes, String string, String string2) {
        String string3 = string2;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            string3 = attributes.getValue(i2);
            break;
        }
        if ("".equals(string3) || string3 == null) {
            return null;
        }
        if (string3.indexOf(",") < 0) {
            try {
                return new UnsignedInteger[]{UnsignedInteger.parseUnsignedInteger(string3)};
            }
            catch (Exception exception) {
                return null;
            }
        }
        String[] stringArray = string3.split(",");
        try {
            UnsignedInteger[] unsignedIntegerArray = new UnsignedInteger[stringArray.length];
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                unsignedIntegerArray[i3] = UnsignedInteger.parseUnsignedInteger(stringArray[i3]);
            }
            return unsignedIntegerArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Boolean a(Attributes attributes, String string, boolean bl) {
        Boolean bl2 = bl;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            bl2 = Boolean.parseBoolean(attributes.getValue(i2));
            break;
        }
        return bl2;
    }

    private Double a(Attributes attributes, String string, double d2) {
        double d3 = d2;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            d3 = Double.parseDouble(attributes.getValue(i2));
            break;
        }
        return d3;
    }

    private ExpandedNodeId a(Attributes attributes, String string) {
        ExpandedNodeId expandedNodeId = null;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            NodeId nodeId = this.h(attributes.getValue(i2));
            expandedNodeId = this.toGlobalExpandedNodeId(nodeId);
            break;
        }
        return expandedNodeId;
    }

    private Integer a(Attributes attributes, String string, int n2) {
        int n3 = n2;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            n3 = Integer.parseInt(attributes.getValue(i2));
            break;
        }
        return n3;
    }

    private String c(NodeId nodeId) {
        String string = this.aM.getUri(nodeId.getNamespaceIndex());
        if (string == null) {
            throw new IllegalArgumentException("Invalid NamespaceIndex for nodeId=" + nodeId + " localNamespaceTable=" + this.aM);
        }
        return string;
    }

    private void a(Attributes attributes, NodeAttributes nodeAttributes) {
        nodeAttributes.setUserWriteMask(this.a(attributes, "UserWriteMask", UnsignedInteger.valueOf(0L)));
        nodeAttributes.setWriteMask(this.a(attributes, "WriteMask", UnsignedInteger.valueOf(0L)));
    }

    private NodeId a(Attributes attributes, String string, NodeId nodeId) {
        NodeId nodeId2 = nodeId;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            nodeId2 = this.h(attributes.getValue(i2));
            break;
        }
        return nodeId2;
    }

    private NodeId h(String string) {
        return this.a(string, true);
    }

    private NodeId a(String string, boolean bl) {
        if (bl && this.aG.containsKey(string)) {
            return this.aG.get(string);
        }
        return NodeId.parseNodeId(string);
    }

    private QualifiedName b(Attributes attributes, String string) {
        QualifiedName qualifiedName = null;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            qualifiedName = this.b(QualifiedName.parseQualifiedName(attributes.getValue(i2)));
            break;
        }
        return qualifiedName;
    }

    private String b(Attributes attributes, String string, String string2) {
        String string3 = string2;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            string3 = attributes.getValue(i2);
            break;
        }
        return string3;
    }

    private UnsignedByte a(Attributes attributes, String string, UnsignedByte unsignedByte) {
        UnsignedByte unsignedByte2 = unsignedByte;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            unsignedByte2 = UnsignedByte.parseUnsignedByte(attributes.getValue(i2));
            break;
        }
        return unsignedByte2;
    }

    private UnsignedInteger a(Attributes attributes, String string, UnsignedInteger unsignedInteger) {
        UnsignedInteger unsignedInteger2 = unsignedInteger;
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            if (!attributes.getLocalName(i2).equalsIgnoreCase(string)) continue;
            unsignedInteger2 = UnsignedInteger.parseUnsignedInteger(attributes.getValue(i2));
            break;
        }
        return unsignedInteger2;
    }

    private boolean o() {
        return this.aY > 0;
    }

    private int a(int n2) {
        String string = this.aM.getUri(n2);
        return this.getNamespaceTable().getIndex(string);
    }

    private void p() {
        this.aV = true;
        this.aT.setLength(0);
    }

    private void v(Attributes attributes) {
        this.alias = this.b(attributes, "Alias", "");
    }

    private void w(Attributes attributes) {
        this.aL = this.b(attributes, "Locale", "");
    }

    private String a(AddReferencesItem addReferencesItem) {
        return String.format(Locale.ROOT, "finalizeReference: %s->%s (isForward=%s)", addReferencesItem.getSourceNodeId(), addReferencesItem.getTargetNodeId(), addReferencesItem.getIsForward());
    }

    private void a(UaNodeId uaNodeId, UaNodeId uaNodeId2) {
        if ("Default Binary".equalsIgnoreCase(this.aP.getBrowseName().getName())) {
            this.bh.put(uaNodeId2, uaNodeId);
            this.bk.add(uaNodeId);
        } else if ("Default XML".equalsIgnoreCase(this.aP.getBrowseName().getName())) {
            this.bi.put(uaNodeId2, uaNodeId);
            this.bk.add(uaNodeId);
        } else if ("Default JSON".equalsIgnoreCase(this.aP.getBrowseName().getName())) {
            this.bj.put(uaNodeId2, uaNodeId);
            this.bk.add(uaNodeId);
        }
        this.bn.put(uaNodeId2, uaNodeId);
        this.bm.put(uaNodeId, uaNodeId2);
    }

    private FieldSpecification a(FieldSpecification fieldSpecification, UaNodeId uaNodeId, int n2) {
        UaNodeId uaNodeId2 = fieldSpecification.getDataTypeId();
        FieldSpecification.Builder builder = fieldSpecification.toBuilder();
        Class<?> clazz = null;
        try {
            UaDataType uaDataType = this.aH.getAddressSpace().getNode(uaNodeId2.asExpandedNodeId(), UaDataType.class);
            clazz = uaDataType.getJavaClass();
        }
        catch (Exception exception) {
            logger.error("Cannot get the DataType node {}", (Object)uaNodeId2, (Object)exception);
        }
        if (clazz == null) {
            logger.error("Cannot resolve Java Class mappings for DataType: {} while trying to resolve Structure type: {}", (Object)uaNodeId2, (Object)uaNodeId);
            return null;
        }
        if (fieldSpecification.getValueRank() > 0) {
            clazz = MultiDimensionArrayUtils.arrayClassOf(clazz, fieldSpecification.getValueRank());
        }
        builder.setJavaClass(clazz);
        builder.setFieldIndex(n2);
        return builder.build();
    }

    private void q() {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        ArrayList arrayList5 = new ArrayList();
        this.bg.forEach((uaNodeId, e2) -> {
            try {
                UaDataType uaDataType = (UaDataType)this.aH.getAddressSpace().findNode(uaNodeId.asNodeId(this.aH.getNamespaceTable()));
                if (uaDataType.inheritsFrom(DataTypeIdentifiers.OptionSet)) {
                    arrayList4.add(e2);
                } else if (uaDataType.inheritsFrom(DataTypeIdentifiers.Enumeration)) {
                    arrayList2.add(e2);
                } else if (uaDataType.inheritsFrom(DataTypeIdentifiers.Structure)) {
                    arrayList5.add(e2);
                } else if (e2.cd.isOptionSet) {
                    arrayList3.add(e2);
                } else {
                    arrayList.add(e2);
                }
            }
            catch (Exception exception) {
                logger.warn("Cannot resolve UaDataTypeSpecifications of {}, skipping", uaNodeId, (Object)exception);
                return;
            }
        });
        arrayList.forEach(this::c);
        arrayList2.forEach(this::a);
        arrayList3.forEach(this::b);
        arrayList4.forEach(this::d);
        arrayList5.forEach(this::d);
        ConcurrentHashMap<UaNodeId, StructureSpecification> concurrentHashMap = new ConcurrentHashMap<UaNodeId, StructureSpecification>();
        concurrentHashMap.putAll(this.bf);
        logger.debug("StructureSpecifications to resolve: {}", (Object)concurrentHashMap.size());
        if (!concurrentHashMap.isEmpty()) {
            boolean bl = true;
            while (bl) {
                bl = false;
                for (Map.Entry entry : concurrentHashMap.entrySet()) {
                    if (!this.a((StructureSpecification)entry.getValue(), concurrentHashMap.keySet())) continue;
                    concurrentHashMap.remove(entry.getKey());
                    bl = true;
                }
                if (!concurrentHashMap.isEmpty()) continue;
                bl = false;
            }
        }
        if (!concurrentHashMap.isEmpty()) {
            logger.warn("Failed to resolve custom Structure types: {}", (Object)concurrentHashMap.keySet());
        } else {
            logger.debug("Resolved all unknown Structure types");
        }
    }

    private void r() {
        ExtensionObject extensionObject;
        logger.debug("Undecoded Variable Values count: {}", (Object)this.bd.size());
        logger.debug("Undecoded VariableType Values count: {}", (Object)this.be.size());
        logger.debug("Attempting to decode them now");
        for (VariableAttributes nodeAttributes : this.bd) {
            extensionObject = (ExtensionObject)nodeAttributes.getValue();
            try {
                nodeAttributes.setValue(extensionObject.decode(this.getEncoderContext(), this.aM));
            }
            catch (DecodingException decodingException) {
                logger.debug("Could not decode {}", (Object)extensionObject, (Object)decodingException);
            }
        }
        for (VariableTypeAttributes variableTypeAttributes : this.be) {
            extensionObject = (ExtensionObject)variableTypeAttributes.getValue();
            try {
                variableTypeAttributes.setValue(extensionObject.decode(this.getEncoderContext(), this.aM));
            }
            catch (DecodingException decodingException) {
                logger.debug("Could not decode {}", (Object)extensionObject, (Object)decodingException);
            }
        }
    }

    private void t() {
        if (this.aV && this.aQ != null) {
            this.aQ.setDescription(new LocalizedText(this.aT.toString(), this.aL));
        }
        this.aV = false;
    }

    private void u() {
        if (this.aV && this.aQ != null) {
            this.aQ.setDisplayName(new LocalizedText(this.aT.toString(), this.aL));
        }
        this.aV = false;
    }

    private void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    private void v() {
        if (this.aV && this.aQ != null) {
            ((ReferenceTypeAttributes)this.aQ).setInverseName(new LocalizedText(this.aT.toString(), this.aL));
        }
        this.aV = false;
    }

    private void w() {
        logger.debug("Reading extensions - readingExtensions:={}", (Object)this.aW);
    }

    private QualifiedName b(QualifiedName qualifiedName) {
        return new QualifiedName(this.a(qualifiedName.getNamespaceIndex()), qualifiedName.getName());
    }

    private boolean a(StructureSpecification structureSpecification, Set<UaNodeId> set) {
        UaNodeId uaNodeId = this.bl.get(structureSpecification.getTypeId());
        if (uaNodeId != null && set.contains(uaNodeId)) {
            logger.debug("Skipping temporarily type {}, since super type {} is not yet processed", (Object)structureSpecification.getTypeId(), (Object)uaNodeId);
            return false;
        }
        StructureSpecification.Builder builder = structureSpecification.toBuilder();
        builder.setBinaryEncodeId(this.bh.get(structureSpecification.getTypeId()));
        builder.setXmlEncodeId(this.bi.get(structureSpecification.getTypeId()));
        builder.setJsonEncodeId(this.bj.get(structureSpecification.getTypeId()));
        ArrayList<FieldSpecification> arrayList = new ArrayList<FieldSpecification>();
        UaNodeId uaNodeId2 = UaNodeId.fromLocal(Identifiers.Structure, this.aH.getNamespaceTable());
        int n2 = 0;
        if (!uaNodeId2.equals(uaNodeId) && this.aH.getEncoderContext().getStructureSpecification(uaNodeId) != null) {
            StructureSpecification structureSpecification2 = this.aH.getEncoderContext().getStructureSpecification(uaNodeId);
            if (StructureSpecification.StructureType.OPTIONAL == structureSpecification2.getStructureType()) {
                builder.setStructureType(StructureSpecification.StructureType.OPTIONAL);
            } else {
                builder.setStructureType(structureSpecification.getStructureType());
            }
            for (FieldSpecification fieldSpecification2 : structureSpecification2.getFields()) {
                arrayList.add(fieldSpecification2);
            }
            structureSpecification2.getSuperTypeIds().forEach(builder::addSuperTypeId);
            n2 = structureSpecification2.getFields().size();
            builder.addSuperTypeId(structureSpecification2.getTypeId());
            Function<UaDataTypeSpecification, ? extends Structure.Builder> function = structureSpecification2.getBuilderSupplier();
            builder.setBuilderSupplier(function);
            builder.setJavaClass(structureSpecification2.getJavaClass());
        } else {
            builder.setStructureType(structureSpecification.getStructureType());
            builder.addSuperTypeId(UaIds.Structure);
        }
        for (FieldSpecification fieldSpecification : structureSpecification.getFields()) {
            FieldSpecification fieldSpecification2;
            fieldSpecification2 = this.a(fieldSpecification, structureSpecification.getTypeId(), n2);
            if (fieldSpecification2 == null) {
                return false;
            }
            arrayList.add(fieldSpecification2);
            ++n2;
        }
        builder.setFields(arrayList);
        this.aH.getEncoderContext().addDataTypeSpecification(builder.build());
        logger.debug("Resolved partial StructureSpecification for typeId: {}", (Object)structureSpecification.getTypeId());
        return true;
    }

    private void a(char[] cArray, int n2, int n3) {
        try {
            String string = new String(cArray, n2, n3);
            string = string.trim();
            if (string.isEmpty()) {
                return;
            }
            logger.debug("valueCharacters: {}", (Object)string);
            this.bb.characters(cArray, n2, n3);
        }
        catch (SAXException sAXException) {
            logger.error("Error in valueCharacters, start=" + n2 + " ,length=" + n3 + " ch len=" + cArray.length, sAXException);
        }
        catch (Exception exception) {
            String string = new String(cArray, n2, n3);
            string = string.trim();
            logger.error("Error in valueCharacters, start=" + n2 + " ,length=" + n3 + " ch len=" + cArray.length + " chars:" + (string.isEmpty() ? "isEmpty()=true" : string), exception);
        }
    }

    private void a(String string, String string2, String string3) {
        logger.debug("valueEndElement: localName={}", (Object)string2);
        try {
            this.bb.endElement(string, string2, string3);
        }
        catch (SAXException sAXException) {
            logger.error("Error in valueEndElement: localName=" + string2, sAXException);
        }
        catch (EmptyStackException emptyStackException) {
            logger.error("Error in valueEndElement: localName=" + string2, emptyStackException);
        }
    }

    private void a(String string, String string2, String string3, Attributes attributes) {
        logger.debug("valueStartElement: {}", (Object)string2);
        try {
            this.bb.startElement(string, string2, string3, attributes);
        }
        catch (SAXException sAXException) {
            logger.error("Error in valueStartElement", sAXException);
        }
    }

    private void a(e e2) {
        if (this.aH.getEncoderContext().getEnumerationSpecification(e2.typeId) == null) {
            EnumerationSpecification.Builder builder = EnumerationSpecification.builder();
            builder.setTypeId(e2.typeId);
            builder.setName(e2.name);
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            for (a a2 : e2.cd.fields) {
                hashMap.put(a2.bs, a2.name);
            }
            builder.setMappings(hashMap);
            this.aH.getEncoderContext().addDataTypeSpecification(builder.build());
        } else {
            logger.debug("EncoderContext already had EnumerationSpecification for type {}, ignoring parsing", (Object)e2.typeId);
        }
    }

    private void b(e e2) {
        if (this.aH.getEncoderContext().getOptionSetSpecification(e2.typeId) != null) {
            return;
        }
        try {
            OptionSetSpecification.Builder<UaOptionSet.Builder> builder = OptionSetSpecification.builder();
            builder.setName(e2.name);
            builder.setTypeId(e2.typeId);
            builder.setJavaClass(DynamicUIntOptionSet.class);
            HashSet<NodeId> hashSet = new HashSet<NodeId>();
            hashSet.add(DataTypeIdentifiers.Byte);
            hashSet.add(DataTypeIdentifiers.UInt16);
            hashSet.add(DataTypeIdentifiers.UInt32);
            hashSet.add(DataTypeIdentifiers.UInt64);
            UaDataType uaDataType = (UaDataType)this.aH.getAddressSpace().findNode(e2.typeId.asNodeId(this.aH.getNamespaceTable()));
            while (uaDataType != null) {
                if ((uaDataType = (UaDataType)uaDataType.getSuperType()) == null) {
                    logger.warn("Encountered numeric OptionSet type that doesn't inherit from Byte, UInt16, UInt32 or UInt64, skipping: {}", (Object)e2.typeId);
                }
                if (!hashSet.contains(uaDataType.getNodeId())) continue;
                builder.setBaseTypeId(UaNodeId.fromStandard(uaDataType.getNodeId()));
                break;
            }
            for (a a2 : e2.cd.fields) {
                OptionSpecification.Builder builder2 = OptionSpecification.builder();
                builder2.setName(a2.name);
                builder2.setBitPosition(a2.bs);
                builder.addOptions(builder2.build());
            }
            this.aH.getEncoderContext().addDataTypeSpecification(builder.build());
        }
        catch (Exception exception) {
            logger.warn("Cannot resolve UaDataTypeSpecification for (numeric) OptionSet type: {}, skipping", (Object)e2.typeId);
        }
    }

    private void c(e e2) {
        if (this.aH.getEncoderContext().getDataTypeSpecifications().containsKey(e2.typeId)) {
            return;
        }
        try {
            SimpleTypeSpecification.Builder builder = SimpleTypeSpecification.builder();
            builder.setName(e2.name);
            builder.setTypeId(e2.typeId);
            builder.setAbstract(e2.isAbstract);
            UaDataType uaDataType = (UaDataType)this.aH.getAddressSpace().findNode(e2.typeId.asNodeId(this.aH.getNamespaceTable()));
            SimpleTypeSpecification simpleTypeSpecification = null;
            while (simpleTypeSpecification == null) {
                uaDataType = (UaDataType)uaDataType.getSuperType();
                simpleTypeSpecification = this.aH.getEncoderContext().getSimpleTypeSpecification(UaNodeId.fromLocal(uaDataType.getNodeId(), this.aH.getNamespaceTable()));
            }
            builder.setBaseTypeId(simpleTypeSpecification.getBaseTypeId());
            builder.setJavaClass(simpleTypeSpecification.getJavaClass());
            this.aH.getEncoderContext().addDataTypeSpecification(builder.build());
        }
        catch (Exception exception) {
            logger.warn("Cannot resolve UaDataTypeSpecification for Simple type: {}, skipping", (Object)e2.typeId);
        }
    }

    private void d(e e2) {
        boolean bl = false;
        boolean bl2 = false;
        for (a object : e2.cd.fields) {
            if (Boolean.TRUE.equals(object.br)) {
                bl = true;
                break;
            }
            if (!Boolean.TRUE.equals(object.bv)) continue;
            bl2 = true;
            break;
        }
        if (this.aH.getEncoderContext().getDataTypeSpecification(e2.typeId) == null) {
            StructureSpecification.Builder<Structure.Builder> builder = e2.cd.isOptionSet ? OptionSetStructureSpecification.builder() : StructureSpecification.builder();
            builder.setTypeId(e2.typeId);
            builder.setName(e2.name);
            builder.setAbstract(e2.isAbstract);
            if (e2.cd.isUnion) {
                if (bl2) {
                    builder.setStructureType(StructureSpecification.StructureType.UNION_SUBTYPES);
                } else {
                    builder.setStructureType(StructureSpecification.StructureType.UNION);
                }
            } else if (bl) {
                builder.setStructureType(StructureSpecification.StructureType.OPTIONAL);
            } else if (bl2) {
                builder.setStructureType(StructureSpecification.StructureType.SUBTYPES);
            } else {
                builder.setStructureType(StructureSpecification.StructureType.NORMAL);
            }
            if (!e2.cd.isOptionSet) {
                List<a> list = e2.cd.fields;
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    a a2 = list.get(i2);
                    FieldSpecification.Builder builder2 = FieldSpecification.builder();
                    builder2.setFieldIndex(i2);
                    UaNodeId uaNodeId = UaNodeId.fromLocal(a2.bq, this.aM);
                    builder2.setDataTypeId(uaNodeId);
                    builder2.setIsOptional(Boolean.TRUE.equals(a2.br));
                    builder2.setAllowSubTypes(Boolean.TRUE.equals(a2.bv));
                    builder2.setValueRank(a2.bt);
                    builder2.setName(a2.name);
                    if (a2.bu != null) {
                        builder2.setArrayDimensions(UaArrayDimensions.valueOf(a2.bu));
                    }
                    builder.addField(builder2.build());
                }
            } else {
                OptionSetStructureSpecification.Builder builder3 = (OptionSetStructureSpecification.Builder)builder;
                builder3.setBaseTypeId(UaIds.OptionSet);
                builder3.setJavaClass((Class)OptionSet.class);
                for (a a3 : e2.cd.fields) {
                    OptionSpecification.Builder builder4 = OptionSpecification.builder();
                    builder4.setName(a3.name);
                    builder4.setBitPosition(a3.bs);
                    builder3.addOptions(builder4.build());
                }
            }
            StructureSpecification structureSpecification = builder.build();
            this.bf.put(structureSpecification.getTypeId(), structureSpecification);
        } else {
            logger.debug("EncoderContext already had StructureSpecification for type {}, ignoring parsing", (Object)e2.typeId);
        }
    }

    protected void addNamespaceUri(String string) {
        this.aM.add(string);
        this.getNamespaceTable().add(string);
    }

    protected void addNodes(List<AddNodesItem> list, String string) throws ModelException, ServiceException {
        logger.debug("addNodes: {}", (Object)string);
        for (AddNodesItem addNodesItem : list) {
            this.a(addNodesItem);
        }
    }

    protected void addReferences(List<AddReferencesItem> list) throws ModelException {
        for (AddReferencesItem addReferencesItem : list) {
            this.addReference(addReferencesItem);
        }
    }

    protected void afterCreate(AddNodesItem addNodesItem) {
    }

    protected void characters(char[] cArray, int n2, int n3) {
        try {
            if (this.o()) {
                this.a(cArray, n2, n3);
            } else if (this.aV) {
                this.aT.append(cArray, n2, n3);
            }
        }
        catch (Exception exception) {
            logger.error("Error in ModelParser2.characters, start=" + n2 + ", length=" + n3, exception);
        }
    }

    protected NodeId doAddNode(AddNodesItem addNodesItem) throws StatusException, ServiceException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    protected void doAddReference(AddReferencesItem addReferencesItem) throws StatusException, ServiceException {
        throw new StatusException(StatusCodes.Bad_NotImplemented);
    }

    protected void endElement(String string, String string2, String string3) throws SAXException {
        logger.debug("endElement: {}", (Object)string2);
        try {
            if (this.o()) {
                this.a(string, string2, string3);
                if (string2.equals("Value")) {
                    logger.debug("endElement: readingValue={}", (Object)this.aY);
                    --this.aY;
                    if (this.aY <= 0) {
                        this.n();
                    }
                }
                return;
            }
            if (this.isReadingNamespaces() && string2.equals("Uri")) {
                this.m();
                return;
            }
            if (this.isReadingExtensions()) {
                if (string2.equals("Extensions")) {
                    logger.debug("endElement: readingExtensions={}", (Object)this.aW);
                    --this.aW;
                    if (this.aW <= 0) {
                        this.h();
                    }
                }
                return;
            }
            c c2 = c.valueOf(string2);
            switch (c2) {
                case bK: {
                    this.aX = false;
                    break;
                }
                case bR: 
                case bS: 
                case bU: 
                case bV: 
                case bW: 
                case bX: 
                case bY: 
                case bZ: {
                    this.j();
                    break;
                }
                case bw: {
                    this.f();
                    break;
                }
                case bA: {
                    this.t();
                    break;
                }
                case bB: {
                    this.u();
                    break;
                }
                case bG: {
                    this.v();
                    break;
                }
                case ca: {
                    logger.error("endElement reached Value with readingValue false, localName={}", (Object)string2);
                    break;
                }
                case bL: {
                    this.k();
                    break;
                }
                case bM: {
                    this.l();
                    break;
                }
                case bE: {
                    logger.error("endElement reached Extensions with readingExtensions false, localName={}", (Object)string2);
                    break;
                }
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (!this.isReadingExtensions()) {
                logger.info("Unknown element in XML: " + string2);
            }
        }
        catch (Exception exception) {
            try {
                this.a(this.aI, this.aC, exception, "Error in ModelParser2.endElement: localName=" + string2);
            }
            catch (ModelException modelException) {
                throw new SAXException("Error in ModelParser2.endElement: localName=" + string2, modelException);
            }
        }
    }

    protected NamespaceTable getNamespaceTable() {
        return this.aH.getNamespaceTable();
    }

    protected abstract UaNode getNode(NodeId var1) throws StatusException;

    protected ServerTable getServerTable() {
        return this.aH.getServerTable();
    }

    protected boolean isIgnoredReference(AddReferencesItem addReferencesItem) {
        return this.aJ.contains(this.getNamespaceTable().toExpandedNodeId(addReferencesItem.getSourceNodeId())) || this.aJ.contains(addReferencesItem.getTargetNodeId());
    }

    protected boolean isReadingNamespaces() {
        return this.aX;
    }

    protected void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        logger.debug("startElement: {} readingValue={}", (Object)string2, (Object)this.aY);
        try {
            if (this.o()) {
                if (string2.equals("Value")) {
                    ++this.aY;
                }
                this.a(string, string2, string3, attributes);
                return;
            }
            if (this.isReadingNamespaces()) {
                if (string2.equals("Uri")) {
                    this.p();
                }
                return;
            }
            if (this.isReadingExtensions()) {
                if (string2.equals("Extensions")) {
                    ++this.aW;
                }
                return;
            }
            c c2 = c.valueOf(string2);
            switch (c2) {
                case bK: {
                    this.aX = true;
                    break;
                }
                case bR: {
                    this.a(attributes);
                    break;
                }
                case bS: {
                    this.e(attributes);
                    break;
                }
                case bU: {
                    this.h(attributes);
                    break;
                }
                case bV: {
                    this.j(attributes);
                    break;
                }
                case bW: {
                    this.m(attributes);
                    break;
                }
                case bX: {
                    this.o(attributes);
                    break;
                }
                case bY: {
                    this.q(attributes);
                    break;
                }
                case bZ: {
                    this.s(attributes);
                    break;
                }
                case bw: {
                    this.v(attributes);
                    this.p();
                    break;
                }
                case bA: 
                case bB: 
                case bG: {
                    this.w(attributes);
                    this.p();
                    break;
                }
                case ca: {
                    ++this.aY;
                    this.g();
                    this.a(string, string2, string3, attributes);
                    logger.debug("Start - readingValue={}, element={}", (Object)this.aY, (Object)string2);
                    break;
                }
                case bM: {
                    break;
                }
                case bL: {
                    this.l(attributes);
                    this.p();
                    break;
                }
                case bz: {
                    this.c(attributes);
                    break;
                }
                case bF: {
                    this.d(attributes);
                    break;
                }
                case bE: {
                    ++this.aW;
                    this.w();
                    break;
                }
                default: {
                    logger.debug("Ignoring element {} in {}", (Object)string2, (Object)this.aK);
                    break;
                }
            }
        }
        catch (Exception exception) {
            try {
                this.a(this.aI, this.aC, exception, "Error in ModelParser2.startElement: localName=" + string2);
            }
            catch (ModelException modelException) {
                throw new SAXException("Error in ModelParser2.startElement: localName=" + string2, modelException);
            }
        }
    }

    protected ExpandedNodeId toGlobalExpandedNodeId(NodeId nodeId) {
        return new ExpandedNodeId(this.ba, this.c(nodeId), nodeId.getValue());
    }

    protected NodeId toGlobalNodeId(ExpandedNodeId expandedNodeId) {
        return NodeId.get(expandedNodeId.getIdType(), this.getNamespaceTable().getIndex(expandedNodeId.getNamespaceUri()), expandedNodeId.getValue());
    }

    protected NodeId toGlobalNodeId(NodeId nodeId) {
        return NodeId.get(nodeId.getIdType(), this.a(nodeId.getNamespaceIndex()), nodeId.getValue());
    }

    private static class e {
        public b cd;
        public String name;
        public UaNodeId typeId;
        public boolean isAbstract = false;

        private e() {
        }
    }

    private class d
    extends DefaultHandler {
        private d() {
        }

        @Override
        public void characters(char[] cArray, int n2, int n3) throws SAXException {
            ModelParserBase.this.characters(cArray, n2, n3);
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            ModelParserBase.this.endElement(string, string2, string3);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            ModelParserBase.this.setDocumentLocator(locator);
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            ModelParserBase.this.startElement(string, string2, string3, attributes);
        }
    }

    private static enum c {
        bw,
        bx,
        by,
        bz,
        bA,
        bB,
        bC,
        bD,
        bE,
        bF,
        bG,
        bH,
        bI,
        bJ,
        bK,
        bL,
        bM,
        bN,
        bO,
        bP,
        bQ,
        bR,
        bS,
        bT,
        bU,
        bV,
        bW,
        bX,
        bY,
        bZ,
        ca;

    }

    private static class b {
        public boolean isUnion = false;
        public boolean isOptionSet = false;
        public final List<a> fields = new ArrayList<a>();

        private b() {
        }
    }

    private static class a {
        NodeId bq;
        Boolean br;
        String name;
        Integer bs;
        Integer bt;
        UnsignedInteger[] bu;
        Boolean bv;

        private a() {
        }
    }
}

