/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.DataTypeConversionException;
import com.prosysopc.ua.InternalUaDataTypeSpecificationMappings;
import com.prosysopc.ua.UaAddressSpace;
import com.prosysopc.ua.UaException;
import com.prosysopc.ua.nodes.UaDataType;
import com.prosysopc.ua.nodes.UaNode;
import com.prosysopc.ua.nodes.UaReference;
import com.prosysopc.ua.stack.builtintypes.ByteString;
import com.prosysopc.ua.stack.builtintypes.DateTime;
import com.prosysopc.ua.stack.builtintypes.Enumeration;
import com.prosysopc.ua.stack.builtintypes.ExpandedNodeId;
import com.prosysopc.ua.stack.builtintypes.ExtensionObject;
import com.prosysopc.ua.stack.builtintypes.LocalizedText;
import com.prosysopc.ua.stack.builtintypes.NodeId;
import com.prosysopc.ua.stack.builtintypes.QualifiedName;
import com.prosysopc.ua.stack.builtintypes.StatusCode;
import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.builtintypes.UnsignedByte;
import com.prosysopc.ua.stack.builtintypes.UnsignedInteger;
import com.prosysopc.ua.stack.builtintypes.UnsignedLong;
import com.prosysopc.ua.stack.builtintypes.UnsignedShort;
import com.prosysopc.ua.stack.builtintypes.Variant;
import com.prosysopc.ua.stack.common.ServiceResultException;
import com.prosysopc.ua.stack.core.Identifiers;
import com.prosysopc.ua.stack.utils.CryptoUtil;
import com.prosysopc.ua.stack.utils.MultiDimensionArrayUtils;
import com.prosysopc.ua.typedictionary.StructureSpecification;
import com.prosysopc.ua.typedictionary.UaDataTypeSpecification;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.ParseException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataTypeConverter {
    private static Logger logger = LoggerFactory.getLogger(DataTypeConverter.class);
    private final UaAddressSpace Q;
    private final AtomicReference<Map<Class<?>, Set<UaDataType>>> R = new AtomicReference<Object>(null);

    public DataTypeConverter(UaAddressSpace uaAddressSpace) {
        this.Q = uaAddressSpace;
    }

    public Variant convert(Variant variant, Class<?> clazz) throws DataTypeConversionException {
        Object object;
        Object object2;
        block18: {
            Object object3;
            Class<?> clazz2;
            block16: {
                int n2;
                block17: {
                    if (variant == null || variant.getValue() == null) {
                        return new Variant(null);
                    }
                    clazz2 = variant.getCompositeClass();
                    if (clazz2.equals(clazz) && variant.isArray() == clazz.isArray()) {
                        return variant;
                    }
                    if (Enumeration.class.isAssignableFrom(MultiDimensionArrayUtils.getComponentType(clazz)) && Integer.class.equals(variant.getCompositeClass())) {
                        return variant;
                    }
                    if (ExtensionObject.class.equals(MultiDimensionArrayUtils.getComponentType(clazz)) && Structure.class.isAssignableFrom(variant.getCompositeClass()) && MultiDimensionArrayUtils.getClassDimensions(clazz) == MultiDimensionArrayUtils.getClassDimensions(variant.getValue().getClass())) {
                        return this.a(variant);
                    }
                    if (Structure.class.equals(MultiDimensionArrayUtils.getComponentType(clazz)) && Structure.class.isAssignableFrom(variant.getCompositeClass()) && MultiDimensionArrayUtils.getClassDimensions(clazz) == MultiDimensionArrayUtils.getClassDimensions(variant.getValue().getClass())) {
                        return this.a(variant);
                    }
                    object2 = null;
                    object = variant.getValue();
                    if (!variant.isArray()) break block16;
                    object3 = variant.getArrayDimensions();
                    if (((int[])object3).length != 1) {
                        throw new DataTypeConversionException("Cannot convert array of dim " + ((int[])object3).length);
                    }
                    n2 = Array.getLength(object);
                    if (clazz.isArray()) break block17;
                    switch (n2) {
                        case 0: {
                            object2 = null;
                            break block18;
                        }
                        case 1: {
                            object2 = Array.get(object, 0);
                            break block18;
                        }
                        default: {
                            throw new DataTypeConversionException("Cannot convert array of length " + n2 + " to scalar");
                        }
                    }
                }
                Class<?> clazz3 = clazz.getComponentType();
                object2 = Array.newInstance(clazz3, n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    Object object4 = this.convertValue(Array.get(object, i2), clazz2, clazz3);
                    Array.set(object2, i2, object4);
                }
                break block18;
            }
            if (clazz.isArray()) {
                object3 = clazz.getComponentType();
                object2 = Array.newInstance(object3, 1);
                Array.set(object2, 0, this.convertValue(object, clazz2, (Class<?>)object3));
            } else {
                object2 = this.convertValue(variant.getValue(), clazz2, clazz);
            }
        }
        if (object2 != null) {
            return new Variant(object2);
        }
        try {
            return this.parseVariant(object.toString(), this.getDataTypeForJavaClass(clazz));
        }
        catch (Exception exception) {
            throw new DataTypeConversionException("Cannot convert", exception);
        }
    }

    public Variant convert(Variant variant, NodeId nodeId) throws DataTypeConversionException {
        UaNode uaNode;
        try {
            uaNode = this.Q.getNode(nodeId);
        }
        catch (UaException uaException) {
            throw new DataTypeConversionException("Could not find node: " + nodeId, uaException);
        }
        if (uaNode != null && uaNode instanceof UaDataType) {
            return this.convert(variant, (UaDataType)uaNode);
        }
        throw new DataTypeConversionException("Could not find node: " + nodeId + " or it is not UaDataType instance");
    }

    public Variant convert(Variant variant, UaDataType uaDataType) throws DataTypeConversionException {
        if (uaDataType == null) {
            throw new IllegalArgumentException("dataType is null");
        }
        Class<?> clazz = uaDataType.getJavaClass();
        if (clazz == null) {
            throw new IllegalArgumentException("No Javaclass corresponding to dataType " + uaDataType.getBrowseName());
        }
        return this.convert(variant, clazz);
    }

    @Deprecated
    public UaDataType getDataTypeForJavaClass(Class<?> clazz) {
        UaDataType[] uaDataTypeArray = this.getDataTypesForJavaClass(clazz);
        if (uaDataTypeArray == null || uaDataTypeArray.length == 0) {
            return null;
        }
        return uaDataTypeArray[0];
    }

    public UaDataType[] getDataTypesForJavaClass(Class<?> clazz) {
        Set<UaDataType> set;
        if (clazz == null) {
            return null;
        }
        logger.debug("getDataTypeForJavaClass: {}", (Object)clazz);
        clazz = MultiDimensionArrayUtils.getComponentType(clazz);
        Map<Class<?>, Set<UaDataType>> map = this.R.get();
        if (map == null) {
            try {
                this.a();
            }
            catch (UaException uaException) {
                throw new RuntimeException("Could not initialize classmap", uaException);
            }
            map = this.R.get();
            if (map == null) {
                throw new RuntimeException("could not initialize classmap");
            }
        }
        if (Structure.class.equals(clazz)) {
            clazz = Structure.class;
        }
        if ((set = map.get(clazz)) == null) {
            if (Structure.class.isAssignableFrom(clazz)) {
                UaDataTypeSpecification uaDataTypeSpecification = InternalUaDataTypeSpecificationMappings.get(clazz);
                if (uaDataTypeSpecification == null || !(uaDataTypeSpecification instanceof StructureSpecification)) {
                    throw new IllegalArgumentException("Cannot find StructureSpecification for class: " + clazz);
                }
                try {
                    NodeId nodeId;
                    ExpandedNodeId expandedNodeId = uaDataTypeSpecification.getTypeId().asExpandedNodeId();
                    try {
                        nodeId = this.Q.getNamespaceTable().toNodeId(expandedNodeId);
                    }
                    catch (ServiceResultException serviceResultException) {
                        throw new IllegalArgumentException("Could not convert ExpandedNodeId " + expandedNodeId + " to NodeId");
                    }
                    UaDataType uaDataType = (UaDataType)this.Q.getNode(nodeId);
                    if (uaDataType == null) {
                        throw new IllegalArgumentException("Cannot find data type of Structure type " + clazz);
                    }
                    set = new HashSet<UaDataType>();
                    set.add(uaDataType);
                    map.put(clazz, set);
                }
                catch (UaException | IllegalArgumentException exception) {
                    throw new IllegalArgumentException("Cannot find data type of Structure type " + clazz, exception);
                }
            }
            throw new IllegalArgumentException("Cannot find data type of " + clazz);
        }
        return set.toArray(new UaDataType[0]);
    }

    public boolean isNullable(NodeId nodeId) {
        return true;
    }

    public Variant parseVariant(String string, Class<?> clazz) {
        if (string == null) {
            throw new NullPointerException("string is null");
        }
        if (clazz == null) {
            throw new NullPointerException("javaclass is null");
        }
        Object object = null;
        if (clazz == UnsignedByte.class) {
            object = UnsignedByte.parseUnsignedByte(string);
        } else if (clazz == Boolean.class) {
            try {
                object = this.convertValue(string, String.class, Boolean.class);
            }
            catch (DataTypeConversionException dataTypeConversionException) {
                throw new IllegalArgumentException(dataTypeConversionException);
            }
        } else if (clazz == DateTime.class) {
            try {
                object = DateTime.parseDateTime(string);
            }
            catch (ParseException parseException) {
                throw new IllegalArgumentException(parseException);
            }
        } else {
            object = clazz == Double.class ? Double.valueOf(Double.parseDouble(string)) : (clazz == ExpandedNodeId.class ? ExpandedNodeId.parseExpandedNodeId(string) : (clazz == Float.class ? Float.valueOf(Float.parseFloat(string)) : (clazz == UUID.class ? UUID.fromString(string) : (clazz == Short.class ? Short.valueOf(Short.parseShort(string)) : (clazz == Integer.class ? Integer.valueOf(Integer.parseInt(string)) : (clazz == Long.class ? Long.valueOf(Long.parseLong(string)) : (clazz == LocalizedText.class ? new LocalizedText(string, "") : (clazz == NodeId.class ? NodeId.parseNodeId(string) : (clazz == QualifiedName.class ? new QualifiedName(string) : (clazz == Byte.class ? Byte.valueOf(Byte.parseByte(string)) : (clazz == UnsignedShort.class ? UnsignedShort.parseUnsignedShort(string) : (clazz == UnsignedInteger.class ? UnsignedInteger.parseUnsignedInteger(string) : (clazz == UnsignedLong.class ? UnsignedLong.parseUnsignedLong(string) : (clazz == StatusCode.class ? StatusCode.parseStatusCode(string) : string))))))))))))));
        }
        try {
            return new Variant(clazz.cast(object));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(numberFormatException);
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException(classCastException);
        }
    }

    public Variant parseVariant(String string, NodeId nodeId) {
        try {
            UaNode uaNode = this.Q.getNode(nodeId);
            if (uaNode != null && uaNode instanceof UaDataType) {
                return this.parseVariant(string, (UaDataType)uaNode);
            }
        }
        catch (UaException uaException) {
            logger.error("Could not resolve {} to node", (Object)nodeId, (Object)uaException);
        }
        return new Variant(string);
    }

    public Variant parseVariant(String string, UaDataType uaDataType) {
        if (uaDataType == null) {
            throw new IllegalArgumentException("dataType is null");
        }
        Class<?> clazz = uaDataType.getJavaClass();
        if (clazz == null) {
            throw new IllegalArgumentException("No Javaclass corresponding to dataType " + uaDataType.getBrowseName());
        }
        return this.parseVariant(string, clazz);
    }

    private void a(UaDataType uaDataType, Map<Class<?>, Set<UaDataType>> map) {
        Class<?> clazz = uaDataType.getJavaClass();
        if (!map.containsKey(clazz)) {
            HashSet<UaDataType> hashSet = new HashSet<UaDataType>();
            hashSet.add(uaDataType);
            map.put(clazz, hashSet);
        } else {
            map.get(clazz).add(uaDataType);
        }
        this.b(uaDataType, map);
    }

    private void b(UaDataType uaDataType, Map<Class<?>, Set<UaDataType>> map) {
        if (uaDataType != null) {
            for (UaReference uaReference : uaDataType.getReferences(Identifiers.HasSubtype, false)) {
                if (!(uaReference.getTargetNode() instanceof UaDataType)) continue;
                this.a((UaDataType)uaReference.getTargetNode(), map);
            }
        }
    }

    private Variant a(Variant variant) {
        return new Variant(MultiDimensionArrayUtils.map(variant.getValue(), Structure.class, ExtensionObject.class, structure -> new ExtensionObject((Structure)structure)));
    }

    private synchronized void a() throws UaException {
        if (this.R.get() != null) {
            return;
        }
        UaDataType uaDataType = (UaDataType)this.Q.getNode(Identifiers.BaseDataType);
        HashMap hashMap = new HashMap();
        this.b(uaDataType, hashMap);
        this.R.set(hashMap);
    }

    protected Boolean booleanValue(Object object) throws DataTypeConversionException {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Number) {
            return ((Number)object).longValue() != 0L;
        }
        if (object instanceof String) {
            String string = ((String)object).toLowerCase(Locale.ROOT);
            if (string.equals("true") || string.equals("1")) {
                return true;
            }
            if (string.equals("false") || string.equals("0")) {
                return false;
            }
            throw new DataTypeConversionException("String value '" + string + "' cannot be cast to boolean");
        }
        return (Boolean)object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object convertValue(Object object, Class<?> clazz, Class<?> clazz2) throws DataTypeConversionException {
        if (object == null) {
            return null;
        }
        Object object2 = null;
        if (object instanceof Variant) {
            object2 = this.convertVariant((Variant)object, clazz, clazz2);
        }
        if (object2 != null) return object2;
        if (clazz2.equals(Boolean.class)) {
            return this.booleanValue(object);
        }
        if (clazz.equals(ByteString.class) && clazz2.equals(String.class)) {
            return CryptoUtil.toHex(ByteString.asByteArray((ByteString)object));
        }
        if (clazz.equals(LocalizedText.class) && clazz2.equals(String.class)) {
            return ((LocalizedText)object).getText();
        }
        if (clazz.equals(String.class) && clazz2.equals(LocalizedText.class)) {
            return new LocalizedText((String)object, LocalizedText.NO_LOCALE);
        }
        if (clazz.equals(QualifiedName.class) && clazz2.equals(String.class)) {
            return ((QualifiedName)object).getName();
        }
        if (clazz.equals(String.class) && clazz2.equals(QualifiedName.class)) {
            return new QualifiedName((String)object);
        }
        if (clazz.equals(StatusCode.class)) {
            StatusCode statusCode = (StatusCode)object;
            int n2 = statusCode.getValueAsIntBits();
            if (clazz2.equals(UnsignedInteger.class)) {
                return UnsignedInteger.getFromBits(n2);
            }
            if (clazz2.equals(Integer.class)) {
                return n2;
            }
            if (clazz2.equals(UnsignedShort.class)) {
                return UnsignedShort.valueOf(n2 >> 16);
            }
            if (!clazz2.equals(Short.class)) throw new DataTypeConversionException("Cannot convert StatusCode to " + clazz2);
            return (short)(n2 >> 16);
        }
        if (clazz2.equals(String.class)) {
            return object.toString();
        }
        try {
            Number number = this.toNumber(object, clazz2);
            logger.debug("convertValue: number={}", (Object)number);
            if (clazz2.equals(StatusCode.class)) {
                if (clazz.equals(UnsignedInteger.class)) return StatusCode.getFromBits(number.intValue());
                if (clazz.equals(Integer.class)) {
                    return StatusCode.getFromBits(number.intValue());
                }
                if (clazz.equals(UnsignedShort.class)) return StatusCode.getFromBits(number.shortValue() << 16);
                if (!clazz.equals(Short.class)) return object2;
                return StatusCode.getFromBits(number.shortValue() << 16);
            }
            Number number2 = null;
            if (clazz2.equals(UnsignedInteger.class)) {
                number2 = UnsignedInteger.valueOf(number.longValue());
            } else if (clazz2.equals(UnsignedShort.class)) {
                number2 = UnsignedShort.valueOf((int)number.longValue());
            } else if (clazz2.equals(UnsignedByte.class)) {
                number2 = UnsignedByte.valueOf((int)number.longValue());
            } else {
                if (clazz2.equals(UnsignedLong.class)) {
                    if (clazz.equals(Float.class)) return UnsignedLong.valueOf(BigDecimal.valueOf(number.doubleValue()).toBigInteger());
                    if (clazz.equals(Double.class)) {
                        return UnsignedLong.valueOf(BigDecimal.valueOf(number.doubleValue()).toBigInteger());
                    }
                    if (!(number instanceof BigInteger)) return UnsignedLong.valueOf(number.longValue());
                    return UnsignedLong.valueOf((BigInteger)number);
                }
                if (clazz2.equals(Integer.class)) {
                    number2 = number.intValue();
                } else if (clazz2.equals(Short.class)) {
                    number2 = number.shortValue();
                } else if (clazz2.equals(Byte.class)) {
                    number2 = number.byteValue();
                } else if (clazz2.equals(Long.class)) {
                    number2 = number.longValue();
                    if (number.doubleValue() > 9.223372036854776E18) {
                        throw new IllegalArgumentException("value overflow");
                    }
                    if (number.doubleValue() < -9.223372036854776E18) {
                        throw new IllegalArgumentException("value underflow");
                    }
                } else {
                    if (clazz2.equals(Double.class)) {
                        return number.doubleValue();
                    }
                    if (clazz2.equals(Float.class)) {
                        if (number.doubleValue() > 3.4028234663852886E38) {
                            throw new IllegalArgumentException("value overflow");
                        }
                        if (!(number.doubleValue() < -3.4028234663852886E38)) return Float.valueOf(number.floatValue());
                        throw new IllegalArgumentException("value underflow");
                    }
                }
            }
            logger.debug("convertValue: n={}", (Object)number2);
            if (number2 != null) {
                logger.debug("convertValue: n.longValue={}", (Object)number2.longValue());
            }
            if (number2 == null) throw new DataTypeConversionException("Cannot convert " + object + " to " + clazz2);
            if (number2.longValue() == number.longValue()) return number2;
            throw new DataTypeConversionException("Cannot convert " + object + " to " + clazz2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new DataTypeConversionException("Cannot convert " + object + " to " + clazz2, illegalArgumentException);
        }
    }

    protected Object convertVariant(Variant variant, Class<?> clazz, Class<?> clazz2) throws DataTypeConversionException {
        return this.convertValue(variant.getValue(), clazz, clazz2);
    }

    protected Object numberToInteger(Number number, NodeId nodeId) {
        UaNode uaNode;
        try {
            uaNode = this.Q.getNode(nodeId);
        }
        catch (UaException uaException) {
            throw new IllegalArgumentException("Cannot get the node of the given dataTypeId: " + nodeId, uaException);
        }
        if (uaNode != null && uaNode instanceof UaDataType) {
            return this.numberToInteger(number, (UaDataType)uaNode);
        }
        return null;
    }

    protected Object numberToInteger(Number number, UaDataType uaDataType) {
        Number number2 = null;
        if (uaDataType.getJavaClass().equals(Byte.class)) {
            number2 = number.byteValue();
        } else if (uaDataType.getJavaClass().equals(Short.class)) {
            number2 = number.shortValue();
        } else if (uaDataType.getJavaClass().equals(Integer.class)) {
            number2 = number.intValue();
        } else if (uaDataType.getJavaClass().equals(Long.class)) {
            number2 = number.longValue();
        }
        return number2;
    }

    protected Number toNumber(Object object, Class<?> clazz) throws ClassCastException {
        Number number = null;
        if (object instanceof Number) {
            number = (Number)object;
        } else if (object instanceof Boolean) {
            number = (Boolean)object != false ? 1 : 0;
        } else if (object instanceof String) {
            number = clazz.equals(Double.class) ? (Number)Double.parseDouble((String)object) : (Number)(clazz.equals(Float.class) ? (Number)Float.valueOf(Float.parseFloat((String)object)) : (Number)(clazz.equals(Long.class) || clazz.equals(UnsignedInteger.class) ? (Number)Long.parseLong((String)object) : (Number)(UnsignedLong.class.equals(clazz) ? new BigInteger((String)object) : Integer.valueOf(Integer.parseInt((String)object)))));
        } else {
            throw new ClassCastException("Cannot convert to Number: " + object);
        }
        return number;
    }
}

