/*
 * Decompiled with CFR 0.152.
 */
package com.prosysopc.ua;

import com.prosysopc.ua.stack.builtintypes.Structure;
import com.prosysopc.ua.stack.core.ContentFilter;
import com.prosysopc.ua.stack.core.ContentFilterElement;
import com.prosysopc.ua.stack.core.FilterOperand;
import com.prosysopc.ua.stack.core.FilterOperator;
import com.prosysopc.ua.stack.encoding.EncoderContext;
import java.util.ArrayList;
import java.util.List;

public class ContentFilterBuilder {
    private final List<ContentFilterElement> elements = new ArrayList<ContentFilterElement>();

    public static void checkOperandCount(FilterOperator filterOperator, int n2) {
        int n3;
        if (filterOperator == FilterOperator.InList) {
            if (n2 < 2) {
                throw new IllegalArgumentException("operand count for operator " + filterOperator + " must be at least 2; was " + n2);
            }
            return;
        }
        switch (filterOperator) {
            case IsNull: 
            case Not: 
            case InView: 
            case OfType: {
                n3 = 1;
                break;
            }
            case Between: {
                n3 = 3;
                break;
            }
            case RelatedTo: {
                n3 = 6;
                break;
            }
            default: {
                n3 = 2;
            }
        }
        if (n2 != n3) {
            throw new IllegalArgumentException("operand count for operator " + filterOperator + " must be " + n3 + "; was " + n2);
        }
    }

    public ContentFilterBuilder() {
    }

    @Deprecated
    public ContentFilterBuilder(EncoderContext encoderContext) {
    }

    public void add(FilterOperator filterOperator, FilterOperand ... filterOperandArray) {
        ContentFilterBuilder.checkOperandCount(filterOperator, filterOperandArray.length);
        Structure[] structureArray = new Structure[filterOperandArray.length];
        for (int i2 = 0; i2 < filterOperandArray.length; ++i2) {
            structureArray[i2] = filterOperandArray[i2];
        }
        ContentFilterElement contentFilterElement = new ContentFilterElement(filterOperator, structureArray);
        this.elements.add(contentFilterElement);
    }

    public ContentFilter getContentFilter() {
        return new ContentFilter(this.elements.toArray(new ContentFilterElement[this.elements.size()]));
    }
}

