/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nvideo.display;

import com.tridium.nvideo.BVideoDevice;
import com.tridium.nvideo.display.BDisplayDeviceExt;
import com.tridium.nvideo.display.BVideoLocation;
import com.tridium.videoDriver.camera.control.BIVideoPanTiltControl;
import com.tridium.videoDriver.display.BIVideoDisplay;
import com.tridium.videoDriver.display.BIVideoDisplayDeviceExt;
import com.tridium.videoDriver.display.BIVideoDisplayLayout;
import com.tridium.videoDriver.display.BVideoDisplayMultistream;
import com.tridium.videoDriver.display.VideoDisplayController;
import com.tridium.videoDriver.enums.BVideoPanTiltEnum;
import com.tridium.videoDriver.enums.BVideoZoomEnum;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public abstract class BVideoDisplay
extends BVideoDevice
implements BIVideoPanTiltControl,
BIVideoDisplay {
    public static final String NO_MONITOR_FEED = "";
    public static final Property videoDisplayMultistream = BVideoDisplay.newProperty((int)0, (BValue)new BVideoDisplayMultistream(), null);
    public static final Action move = BVideoDisplay.newAction((int)4, (BValue)BVideoPanTiltEnum.none, null);
    public static final Action zoom = BVideoDisplay.newAction((int)4, (BValue)BVideoZoomEnum.none, null);
    public static final Action makeActiveCamera = BVideoDisplay.newAction((int)4, (BValue)BOrd.NULL, null);
    public static final Type TYPE = Sys.loadType(BVideoDisplay.class);
    private static final BIcon icon = BIcon.make((String)"module://videoDriver/icons/videoDisplay.png");
    protected VideoDisplayController controller;

    public BVideoDisplayMultistream getVideoDisplayMultistream() {
        return (BVideoDisplayMultistream)this.get(videoDisplayMultistream);
    }

    public void setVideoDisplayMultistream(BVideoDisplayMultistream v) {
        this.set(videoDisplayMultistream, (BValue)v, null);
    }

    public void move(BVideoPanTiltEnum panTiltEnum) {
        this.invoke(move, (BValue)panTiltEnum, null);
    }

    public void zoom(BVideoZoomEnum zoomAction) {
        this.invoke(zoom, (BValue)zoomAction, null);
    }

    public void makeActiveCamera(BOrd ordOfactiveCamera) {
        this.invoke(makeActiveCamera, (BValue)ordOfactiveCamera, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public BVideoDisplay() {
        this.setFlags((Slot)status, this.getFlags((Slot)status) | 4);
        this.setFlags((Slot)faultCause, this.getFlags((Slot)faultCause) | 4);
        this.setFlags((Slot)health, this.getFlags((Slot)health) | 4);
        this.setFlags((Slot)alarmSourceInfo, this.getFlags((Slot)health) | 4);
        this.setFlags((Slot)videoDeviceId, this.getFlags((Slot)videoDeviceId) | 4);
    }

    public void started() throws Exception {
        super.started();
        this.controller = this.getVideoDisplayController();
    }

    public BVideoLocation getLocation() {
        BComplex parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof BVideoLocation); parent = parent.getParent()) {
        }
        return (BVideoLocation)parent;
    }

    public BIVideoDisplayDeviceExt getDisplayDeviceExt() {
        BComplex parent;
        for (parent = this.getParent(); parent != null && !(parent instanceof BDisplayDeviceExt); parent = parent.getParent()) {
        }
        return (BIVideoDisplayDeviceExt)parent;
    }

    public void doMove(BVideoPanTiltEnum panTiltAction) {
    }

    public void doZoom(BVideoZoomEnum zoomAction) {
    }

    public void doMakeActiveCamera(BOrd ordOfActiveCamera) {
    }

    protected abstract VideoDisplayController getVideoDisplayController();

    public void gotoPlaybackTime(BAbsTime time) {
    }

    public void switchToLayout(Object layout, Context cx) {
        if (layout instanceof BIVideoDisplayLayout) {
            this.switchToLayout((BIVideoDisplayLayout)layout);
        }
    }

    public void switchToLayout(BIVideoDisplayLayout layout) {
        if (this.controller != null) {
            this.controller.switchDisplayToLayout(layout);
        }
    }

    public void mapCamerasToLayout(Object arg, Context cx) {
        if (arg instanceof BComponent) {
            BComponent comp = (BComponent)arg;
            BOrdList ords = (BOrdList)comp.get("ords");
            BIVideoDisplayLayout layout = (BIVideoDisplayLayout)comp.get("layout");
            if (ords != null && layout != null) {
                this.mapCamerasToLayout(ords.toArray(), layout);
            }
        }
    }

    public void mapCamerasToLayout(BOrd[] cameraOrds, BIVideoDisplayLayout layout) {
        if (this.controller != null) {
            this.controller.switchDisplayToLayout(layout);
            this.controller.mapCamerasToLayout(cameraOrds, layout);
        }
    }

    public void mapCamerasToCurrentLayout(Object ords, Context cx) {
        if (ords instanceof BOrdList) {
            BOrdList ordList = (BOrdList)ords;
            this.mapCamerasToCurrentLayout(ordList.toArray());
        }
    }

    public void mapCamerasToCurrentLayout(BOrd[] cameraOrds) {
        this.mapCamerasToLayout(cameraOrds, this.getCurrentLayout());
    }

    public BIVideoDisplayLayout getCurrentLayout() {
        return (BIVideoDisplayLayout)this.getVideoDisplayMultistream().getLayout();
    }

    public BIcon getIcon() {
        return icon;
    }
}

