/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nvideo.display;

import com.tridium.nvideo.display.BVideoLocation;
import com.tridium.videoDriver.BIVideoDeviceSystem;
import com.tridium.videoDriver.display.BIVideoDisplay;
import com.tridium.videoDriver.display.BIVideoDisplayDeviceExt;
import com.tridium.videoDriver.display.BIVideoLocation;
import java.util.ArrayList;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceExt;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BDisplayDeviceExt
extends BDeviceExt
implements BIVideoDisplayDeviceExt,
BIDeviceFolder {
    public static final Type TYPE = Sys.loadType(BDisplayDeviceExt.class);
    private static final BIcon icon = BIcon.make((String)"module://videoDriver/icons/displayExt.png");

    public Type getType() {
        return TYPE;
    }

    public BIVideoDeviceSystem getVideoSystem() {
        return (BIVideoDeviceSystem)this.getDevice();
    }

    protected Type getLocationType() {
        return BVideoLocation.TYPE;
    }

    protected Type getDisplayType() {
        return this.getVideoSystem().getVideoDisplayType();
    }

    public BIVideoLocation[] getAllLocations() {
        ArrayList<BIVideoLocation> list = new ArrayList<BIVideoLocation>();
        this.getAllLocations((BComponent)this, this.getLocationType(), list);
        return list.toArray(new BIVideoLocation[list.size()]);
    }

    private void getAllLocations(BComponent comp, Type locationType, ArrayList<BIVideoLocation> list) {
        SlotCursor cursor = comp.loadSlots().getProperties();
        while (cursor.nextComponent()) {
            BComponent kid = cursor.get().asComponent();
            if (kid.getType().is(locationType)) {
                list.add((BIVideoLocation)kid);
                continue;
            }
            this.getAllLocations(kid, locationType, list);
        }
    }

    public BIVideoDisplay[] getAllDisplays() {
        ArrayList<BIVideoDisplay> list = new ArrayList<BIVideoDisplay>();
        this.getAllDisplays((BComponent)this, this.getDisplayType(), list);
        if (list.size() > 0) {
            return list.toArray(new BIVideoDisplay[list.size()]);
        }
        return new BIVideoDisplay[0];
    }

    private void getAllDisplays(BComponent comp, Type displayType, ArrayList<BIVideoDisplay> list) {
        SlotCursor cursor = comp.loadSlots().getProperties();
        while (cursor.nextComponent()) {
            BComponent kid = cursor.get().asComponent();
            if (kid.getType().is(displayType)) {
                list.add((BIVideoDisplay)kid);
                continue;
            }
            this.getAllDisplays(kid, displayType, list);
        }
    }

    public void updateStatus() {
        BIVideoLocation[] locations = this.getAllLocations();
        for (int i = 0; i < locations.length; ++i) {
            if (!(locations[i] instanceof BDevice)) continue;
            ((BDevice)locations[i]).updateStatus();
        }
        BIVideoDisplay[] displays = this.getAllDisplays();
        for (int i = 0; i < displays.length; ++i) {
            if (!(displays[i] instanceof BDevice)) continue;
            ((BDevice)displays[i]).updateStatus();
        }
    }

    public Type getDeviceType() {
        return this.getDisplayType();
    }

    public final Type getDeviceFolderType() {
        return this.getLocationType();
    }

    public BIcon getIcon() {
        return icon;
    }
}

