/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sysmon;

import com.tridium.sysmon.BAbstractMemoryMonitor;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="usedMetaSpaceMemory", type="long", defaultValue="0", flags=3, facets={@Facet(value="BFacets.make(KB_UNITS, BFacets.make(BFacets.MIN, BLong.make(-1)))")})
public final class BMetaSpaceMemoryMonitor
extends BAbstractMemoryMonitor {
    public static final Property usedMetaSpaceMemory = BMetaSpaceMemoryMonitor.newProperty((int)3, (int)0, (BFacets)BFacets.make((BFacets)KB_UNITS, (BFacets)BFacets.make((String)"min", (BIDataValue)BLong.make((long)-1L))));
    public static final Type TYPE = Sys.loadType(BMetaSpaceMemoryMonitor.class);

    public long getUsedMetaSpaceMemory() {
        return this.getLong(usedMetaSpaceMemory);
    }

    public void setUsedMetaSpaceMemory(long v) {
        this.setLong(usedMetaSpaceMemory, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected String getHistoryName() {
        return "usedMetaSpaceMemory";
    }

    @Override
    protected String getToNormalText() {
        return "%lexicon(systemMonitor:metaSpaceMemoryToNormal)%";
    }

    @Override
    protected String getToOffnormalText() {
        return "%lexicon(systemMonitor:metaSpaceToOffnormal)%";
    }

    @Override
    protected long checkMemory() {
        long usedMetaSpaceSize = 0L;
        try {
            List<MemoryPoolMXBean> poolList = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean pool : poolList) {
                if (!pool.getName().equalsIgnoreCase("Metaspace")) continue;
                MemoryUsage currentUsage = pool.getUsage();
                usedMetaSpaceSize = currentUsage.getUsed() / 1024L;
                break;
            }
            this.setUsedMetaSpaceMemory(usedMetaSpaceSize);
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Used meta space memory: " + usedMetaSpaceSize + " KB");
            }
        }
        catch (Exception e) {
            this.getLog().error("Checking meta space memory", (Throwable)e);
        }
        return usedMetaSpaceSize;
    }
}

