/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sysmon;

import com.tridium.nre.platform.PlatformUtil;
import com.tridium.sysmon.BAbstractCPUMonitor;
import java.security.AccessController;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="targetCPU", type="int", defaultValue="-1"), @NiagaraProperty(name="lastInterval", type="long", defaultValue="0", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"millisecond\"))")}), @NiagaraProperty(name="lastIntervalPercent", type="double", defaultValue="0.0", flags=3, facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0), BFacets.MAX, BInteger.make(100), BFacets.UNITS, BUnit.getUnit(\"percent\"))")}), @NiagaraProperty(name="sinceStartPercent", type="double", defaultValue="0.0", flags=3, facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0), BFacets.MAX, BInteger.make(100), BFacets.UNITS, BUnit.getUnit(\"percent\"))")}), @NiagaraProperty(name="lastMinute", type="long", defaultValue="-1", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"millisecond\"))")}), @NiagaraProperty(name="lastMinutePercent", type="double", defaultValue="0.0", flags=3, facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0), BFacets.MAX, BInteger.make(100), BFacets.UNITS, BUnit.getUnit(\"percent\"))")}), @NiagaraProperty(name="lastHour", type="long", defaultValue="-1", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"millisecond\"))")}), @NiagaraProperty(name="lastHourPercent", type="double", defaultValue="0.0", flags=3, facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0), BFacets.MAX, BInteger.make(100), BFacets.UNITS, BUnit.getUnit(\"percent\"))")}), @NiagaraProperty(name="lastDay", type="long", defaultValue="-1", flags=3, facets={@Facet(value="BFacets.make(BFacets.UNITS, BUnit.getUnit(\"millisecond\"))")}), @NiagaraProperty(name="lastDayPercent", type="double", defaultValue="0.0", flags=3, facets={@Facet(value="BFacets.make(BFacets.MIN, BInteger.make(0), BFacets.MAX, BInteger.make(100), BFacets.UNITS, BUnit.getUnit(\"percent\"))")})})
@NiagaraActions(value={@NiagaraAction(name="pollMinute", flags=4), @NiagaraAction(name="pollHour", flags=4), @NiagaraAction(name="pollDay", flags=4)})
public final class BIdleCPUMonitor
extends BAbstractCPUMonitor {
    public static final Property targetCPU = BIdleCPUMonitor.newProperty((int)0, (int)-1, null);
    public static final Property lastInterval = BIdleCPUMonitor.newProperty((int)3, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    public static final Property lastIntervalPercent = BIdleCPUMonitor.newProperty((int)3, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100), (String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    public static final Property sinceStartPercent = BIdleCPUMonitor.newProperty((int)3, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100), (String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    public static final Property lastMinute = BIdleCPUMonitor.newProperty((int)3, (int)-1, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    public static final Property lastMinutePercent = BIdleCPUMonitor.newProperty((int)3, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100), (String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    public static final Property lastHour = BIdleCPUMonitor.newProperty((int)3, (int)-1, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    public static final Property lastHourPercent = BIdleCPUMonitor.newProperty((int)3, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100), (String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    public static final Property lastDay = BIdleCPUMonitor.newProperty((int)3, (int)-1, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    public static final Property lastDayPercent = BIdleCPUMonitor.newProperty((int)3, (double)0.0, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100), (String)"units", (BIDataValue)BUnit.getUnit((String)"percent")));
    public static final Action pollMinute = BIdleCPUMonitor.newAction((int)4, null);
    public static final Action pollHour = BIdleCPUMonitor.newAction((int)4, null);
    public static final Action pollDay = BIdleCPUMonitor.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BIdleCPUMonitor.class);
    Clock.Ticket pollMinuteTicket = null;
    Clock.Ticket pollHourTicket = null;
    Clock.Ticket pollDayTicket = null;
    long idleMillisecondsAtStart = 0L;
    long timeAtStart = 0L;
    long lastTriggerTimeMillis = 0L;
    long idleMillisAtPreviousInterval = 0L;
    long idleMillisAtPreviousMinute = 0L;
    long idleMillisAtPreviousHour = 0L;
    long idleMillisAtPreviousDay = 0L;

    public int getTargetCPU() {
        return this.getInt(targetCPU);
    }

    public void setTargetCPU(int v) {
        this.setInt(targetCPU, v, null);
    }

    public long getLastInterval() {
        return this.getLong(lastInterval);
    }

    public void setLastInterval(long v) {
        this.setLong(lastInterval, v, null);
    }

    public double getLastIntervalPercent() {
        return this.getDouble(lastIntervalPercent);
    }

    public void setLastIntervalPercent(double v) {
        this.setDouble(lastIntervalPercent, v, null);
    }

    public double getSinceStartPercent() {
        return this.getDouble(sinceStartPercent);
    }

    public void setSinceStartPercent(double v) {
        this.setDouble(sinceStartPercent, v, null);
    }

    public long getLastMinute() {
        return this.getLong(lastMinute);
    }

    public void setLastMinute(long v) {
        this.setLong(lastMinute, v, null);
    }

    public double getLastMinutePercent() {
        return this.getDouble(lastMinutePercent);
    }

    public void setLastMinutePercent(double v) {
        this.setDouble(lastMinutePercent, v, null);
    }

    public long getLastHour() {
        return this.getLong(lastHour);
    }

    public void setLastHour(long v) {
        this.setLong(lastHour, v, null);
    }

    public double getLastHourPercent() {
        return this.getDouble(lastHourPercent);
    }

    public void setLastHourPercent(double v) {
        this.setDouble(lastHourPercent, v, null);
    }

    public long getLastDay() {
        return this.getLong(lastDay);
    }

    public void setLastDay(long v) {
        this.setLong(lastDay, v, null);
    }

    public double getLastDayPercent() {
        return this.getDouble(lastDayPercent);
    }

    public void setLastDayPercent(double v) {
        this.setDouble(lastDayPercent, v, null);
    }

    public void pollMinute() {
        this.invoke(pollMinute, null, null);
    }

    public void pollHour() {
        this.invoke(pollHour, null, null);
    }

    public void pollDay() {
        this.invoke(pollDay, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected String getHistoryName() {
        return "idleCPUTime";
    }

    @Override
    protected String getToNormalText() {
        return "%lexicon(systemMonitor:idleCPUCyclesToNormal)%";
    }

    @Override
    protected String getToOffnormalText() {
        return "%lexicon(systemMonitor:idleCPUCyclesToOffnormal)%";
    }

    @Override
    protected long checkCPU() {
        long idleThisInterval = 0L;
        try {
            long idleNow = AccessController.doPrivileged(() -> PlatformUtil.getPlatformProvider().getIdleTime(this.getTargetCPU()));
            idleThisInterval = idleNow - this.idleMillisAtPreviousInterval;
            long timeNow = System.currentTimeMillis();
            long timeElapsedMillis = timeNow - this.lastTriggerTimeMillis;
            if (this.getTargetCPU() == -1) {
                timeElapsedMillis *= (long)Runtime.getRuntime().availableProcessors();
            }
            this.lastTriggerTimeMillis = timeNow;
            double percent = (double)idleThisInterval * 100.0 / (double)timeElapsedMillis;
            this.setLastInterval(idleThisInterval);
            this.setLastIntervalPercent(percent);
            this.idleMillisAtPreviousInterval = idleNow;
            long idleMillisSinceStart = idleNow - this.idleMillisecondsAtStart;
            timeElapsedMillis = System.currentTimeMillis() - this.timeAtStart;
            if (this.getTargetCPU() == -1) {
                timeElapsedMillis *= (long)Runtime.getRuntime().availableProcessors();
            }
            double sinceStartPercent = (double)idleMillisSinceStart * 100.0 / (double)timeElapsedMillis;
            this.setSinceStartPercent(sinceStartPercent);
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Idle milliseconds in last interval: " + idleThisInterval + " (" + percent + "%)");
                this.getLog().trace("Idle milliseconds since started: " + idleMillisSinceStart + " (" + sinceStartPercent + "%)");
            }
        }
        catch (Exception e) {
            this.getLog().error("Checking CPU idle cycles", (Throwable)e);
        }
        return idleThisInterval;
    }

    public void doPollMinute() {
        try {
            long idleNow = AccessController.doPrivileged(() -> PlatformUtil.getPlatformProvider().getIdleTime(this.getTargetCPU()));
            long idleThisMinute = idleNow - this.idleMillisAtPreviousMinute;
            long elapsed = 60000L;
            if (this.getTargetCPU() == -1) {
                elapsed *= (long)Runtime.getRuntime().availableProcessors();
            }
            double percent = (double)idleThisMinute * 100.0 / (double)elapsed;
            this.setLastMinute(idleThisMinute);
            this.setLastMinutePercent(percent);
            this.idleMillisAtPreviousMinute = idleNow;
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Idle milliseconds in last minute: " + idleThisMinute + " (" + percent + "%)");
            }
        }
        catch (Exception e) {
            this.getLog().error("Checking minutely CPU idle cycles", (Throwable)e);
        }
    }

    public void doPollHour() {
        try {
            long idleNow = AccessController.doPrivileged(() -> PlatformUtil.getPlatformProvider().getIdleTime(this.getTargetCPU()));
            long idleThisHour = idleNow - this.idleMillisAtPreviousHour;
            long elapsed = 3600000L;
            if (this.getTargetCPU() == -1) {
                elapsed *= (long)Runtime.getRuntime().availableProcessors();
            }
            double percent = (double)idleThisHour * 100.0 / (double)elapsed;
            this.setLastHour(idleThisHour);
            this.setLastHourPercent(percent);
            this.idleMillisAtPreviousHour = idleNow;
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Idle milliseconds in last hour: " + idleThisHour + " (" + percent + "%)");
            }
        }
        catch (Exception e) {
            this.getLog().error("Checking hourly CPU idle cycles", (Throwable)e);
        }
    }

    public void doPollDay() {
        try {
            long idleNow = AccessController.doPrivileged(() -> PlatformUtil.getPlatformProvider().getIdleTime(this.getTargetCPU()));
            long idleThisDay = idleNow - this.idleMillisAtPreviousDay;
            long elapsed = 86400000L;
            if (this.getTargetCPU() == -1) {
                elapsed *= (long)Runtime.getRuntime().availableProcessors();
            }
            double percent = (double)idleThisDay * 100.0 / (double)elapsed;
            this.setLastDay(idleThisDay);
            this.setLastDayPercent(percent);
            this.idleMillisAtPreviousDay = idleNow;
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Idle milliseconds in last day: " + idleThisDay + " (" + percent + "%)");
            }
        }
        catch (Exception e) {
            this.getLog().error("Checking daily CPU idle cycles", (Throwable)e);
        }
    }

    @Override
    public void doStarted() throws Exception {
        this.idleMillisecondsAtStart = PlatformUtil.getPlatformProvider().getIdleTime(this.getTargetCPU());
        this.lastTriggerTimeMillis = this.timeAtStart = System.currentTimeMillis();
        this.idleMillisAtPreviousMinute = this.idleMillisecondsAtStart;
        this.idleMillisAtPreviousInterval = this.idleMillisecondsAtStart;
        this.idleMillisAtPreviousHour = this.idleMillisecondsAtStart;
        this.idleMillisAtPreviousDay = this.idleMillisecondsAtStart;
        if (this.pollMinuteTicket != null) {
            this.pollMinuteTicket.cancel();
        }
        if (this.pollHourTicket != null) {
            this.pollHourTicket.cancel();
        }
        if (this.pollDayTicket != null) {
            this.pollDayTicket.cancel();
        }
        Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.MINUTE, (Action)pollMinute, null);
        Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.HOUR, (Action)pollHour, null);
        Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.DAY, (Action)pollDay, null);
        super.doStarted();
    }

    public void stopped() {
        if (this.pollMinuteTicket != null) {
            this.pollMinuteTicket.cancel();
        }
        if (this.pollHourTicket != null) {
            this.pollHourTicket.cancel();
        }
        if (this.pollDayTicket != null) {
            this.pollDayTicket.cancel();
        }
    }
}

