/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.sysmon;

import com.tridium.sysmon.BAbstractMemoryMonitor;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLong;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="usedCodeCacheMemory", type="long", defaultValue="0", flags=3, facets={@Facet(value="BFacets.make(KB_UNITS, BFacets.make(BFacets.MIN, BLong.make(-1)))")})
public final class BCodeCacheMemoryMonitor
extends BAbstractMemoryMonitor {
    public static final Property usedCodeCacheMemory = BCodeCacheMemoryMonitor.newProperty((int)3, (int)0, (BFacets)BFacets.make((BFacets)KB_UNITS, (BFacets)BFacets.make((String)"min", (BIDataValue)BLong.make((long)-1L))));
    public static final Type TYPE = Sys.loadType(BCodeCacheMemoryMonitor.class);

    public long getUsedCodeCacheMemory() {
        return this.getLong(usedCodeCacheMemory);
    }

    public void setUsedCodeCacheMemory(long v) {
        this.setLong(usedCodeCacheMemory, v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    protected String getHistoryName() {
        return "usedCodeCacheMemory";
    }

    @Override
    protected String getToNormalText() {
        return "%lexicon(systemMonitor:codeCacheMemoryToNormal)%";
    }

    @Override
    protected String getToOffnormalText() {
        return "%lexicon(systemMonitor:codeCacheMemoryToOffnormal)%";
    }

    @Override
    protected long checkMemory() {
        long usedCodeCacheSize = 0L;
        try {
            List<MemoryPoolMXBean> poolList = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean pool : poolList) {
                if (!pool.getName().equalsIgnoreCase("Code Cache")) continue;
                MemoryUsage currentUsage = pool.getUsage();
                usedCodeCacheSize = currentUsage.getUsed() / 1024L;
                break;
            }
            this.setUsedCodeCacheMemory(usedCodeCacheSize);
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("Used code cache space memory: " + usedCodeCacheSize + " KB");
            }
        }
        catch (Exception e) {
            this.getLog().error("Checking code cache memory", (Throwable)e);
        }
        return usedCodeCacheSize;
    }
}

