/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.util;

import com.tridium.kitControl.math.BMath;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BReset
extends BMath {
    public static final Property inA = BReset.newProperty((int)0, (BValue)new BStatusNumeric(0.0, BStatus.nullStatus), null);
    public static final Property inputLowLimit = BReset.newProperty((int)0, (BValue)new BStatusNumeric(), null);
    public static final Property inputHighLimit = BReset.newProperty((int)0, (BValue)new BStatusNumeric(), null);
    public static final Property outputLowLimit = BReset.newProperty((int)0, (BValue)new BStatusNumeric(), null);
    public static final Property outputHighLimit = BReset.newProperty((int)0, (BValue)new BStatusNumeric(), null);
    public static final Type TYPE = Sys.loadType(BReset.class);
    private static final BIcon icon = BIcon.std((String)"control/math/reset.png");

    public BStatusNumeric getInA() {
        return (BStatusNumeric)this.get(inA);
    }

    public void setInA(BStatusNumeric v) {
        this.set(inA, (BValue)v, null);
    }

    public BStatusNumeric getInputLowLimit() {
        return (BStatusNumeric)this.get(inputLowLimit);
    }

    public void setInputLowLimit(BStatusNumeric v) {
        this.set(inputLowLimit, (BValue)v, null);
    }

    public BStatusNumeric getInputHighLimit() {
        return (BStatusNumeric)this.get(inputHighLimit);
    }

    public void setInputHighLimit(BStatusNumeric v) {
        this.set(inputHighLimit, (BValue)v, null);
    }

    public BStatusNumeric getOutputLowLimit() {
        return (BStatusNumeric)this.get(outputLowLimit);
    }

    public void setOutputLowLimit(BStatusNumeric v) {
        this.set(outputLowLimit, (BValue)v, null);
    }

    public BStatusNumeric getOutputHighLimit() {
        return (BStatusNumeric)this.get(outputHighLimit);
    }

    public void setOutputHighLimit(BStatusNumeric v) {
        this.set(outputHighLimit, (BValue)v, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void onExecute(BStatusValue o, Context cx) {
        BStatusNumeric inA = this.getInA();
        BStatus sa = inA.getStatus();
        BStatusNumeric out = (BStatusNumeric)o;
        BStatusNumeric inputLowLimit = this.getInputLowLimit();
        BStatusNumeric inputHighLimit = this.getInputHighLimit();
        BStatusNumeric outputLowLimit = this.getOutputLowLimit();
        BStatusNumeric outputHighLimit = this.getOutputHighLimit();
        BStatus ilStatus = inputLowLimit.getStatus();
        BStatus ihStatus = inputHighLimit.getStatus();
        BStatus olStatus = outputLowLimit.getStatus();
        BStatus ohStatus = outputHighLimit.getStatus();
        if (ilStatus.isNull() || ihStatus.isNull() || olStatus.isNull() || ohStatus.isNull() || sa.isNull()) {
            out.setValue(Double.NaN);
            out.setStatus(BStatus.nullStatus);
        } else {
            int il = 0;
            int ih = 0;
            int ol = 0;
            int oh = 0;
            il = ilStatus.getBits();
            ih = ihStatus.getBits();
            ol = olStatus.getBits();
            oh = ohStatus.getBits();
            double result = BReset.reset(inA.getValue(), inputLowLimit.getValue(), inputHighLimit.getValue(), outputLowLimit.getValue(), outputHighLimit.getValue());
            out.setValue(result);
            out.setStatus(this.propagate(sa));
        }
    }

    private static double reset(double x, double inputLowLimit, double inputHighLimit, double outputLowLimit, double outputHighLimit) {
        if (x < inputLowLimit) {
            return outputLowLimit;
        }
        if (x > inputHighLimit) {
            return outputHighLimit;
        }
        return (outputHighLimit - outputLowLimit) / (inputHighLimit - inputLowLimit) * (x - inputLowLimit) + outputLowLimit;
    }

    public BIcon getIcon() {
        return icon;
    }
}

