/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.util;

import javax.baja.control.BBooleanPoint;
import javax.baja.data.BIDataValue;
import javax.baja.log.Log;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BMultiVibrator
extends BBooleanPoint {
    public static final Property enabled = BMultiVibrator.newProperty((int)0, (boolean)true, null);
    public static final Property period = BMultiVibrator.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.TRUE, (String)"min", (BIDataValue)BRelTime.make((long)200L)));
    public static final Property dutyCycle = BMultiVibrator.newProperty((int)0, (int)50, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0), (String)"max", (BIDataValue)BInteger.make((int)100)));
    public static final Type TYPE = Sys.loadType(BMultiVibrator.class);
    private static final BIcon icon = BIcon.std((String)"control/util/sine.png");
    private Clock.Ticket ticket = null;
    static final Log log = Log.getLog((String)"kitControl");
    private long start;
    private long highTime;
    private long lowTime;
    private boolean high = false;

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    public BRelTime getPeriod() {
        return (BRelTime)this.get(period);
    }

    public void setPeriod(BRelTime v) {
        this.set(period, (BValue)v, null);
    }

    public int getDutyCycle() {
        return this.getInt(dutyCycle);
    }

    public void setDutyCycle(int v) {
        this.setInt(dutyCycle, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.initTimer();
    }

    private synchronized void initTimer() {
        int cycle = this.getDutyCycle();
        if (cycle <= 0) {
            cycle = 0;
        }
        if (cycle >= 100) {
            cycle = 100;
        }
        this.highTime = this.getPeriod().getMillis() * (long)cycle / 100L;
        this.lowTime = this.getPeriod().getMillis() * (long)(100 - cycle) / 100L;
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        if (this.getEnabled()) {
            this.ticket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)this.lowTime), (Action)execute, null);
        }
    }

    public void changed(Property prop, Context cx) {
        super.changed(prop, cx);
        if ((prop == period || prop == dutyCycle || prop == enabled) && this.isRunning()) {
            this.initTimer();
        }
    }

    public synchronized void onExecute(BStatusValue o, Context cx) {
        if (this.getEnabled()) {
            if (this.highTime <= 0L) {
                this.high = false;
            } else if (this.lowTime <= 0L) {
                this.high = true;
            } else if (this.high) {
                this.high = false;
                if (this.ticket != null) {
                    this.ticket.cancel();
                }
                this.ticket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)this.lowTime), (Action)execute, null);
            } else {
                this.high = true;
                if (this.ticket != null) {
                    this.ticket.cancel();
                }
                this.ticket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.make((long)this.highTime), (Action)execute, null);
            }
            BStatusBoolean out = (BStatusBoolean)o;
            out.setValue(this.high);
        }
    }

    public BIcon getIcon() {
        return icon;
    }
}

