/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.util;

import com.tridium.kitControl.BKitNumeric;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BCounter
extends BKitNumeric
implements BIStatus,
BINumeric {
    public static final Property out = BCounter.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property countUp = BCounter.newProperty((int)8, (BValue)new BStatusBoolean(), null);
    public static final Property countDown = BCounter.newProperty((int)0, (BValue)new BStatusBoolean(), null);
    public static final Property presetIn = BCounter.newProperty((int)0, (BValue)new BStatusBoolean(), null);
    public static final Property clearIn = BCounter.newProperty((int)0, (BValue)new BStatusBoolean(), null);
    public static final Property presetValue = BCounter.newProperty((int)0, (BValue)new BStatusNumeric(), null);
    public static final Property countIncrement = BCounter.newProperty((int)0, (float)1.0f, null);
    public static final Action preset = BCounter.newAction((int)16, null);
    public static final Action clear = BCounter.newAction((int)16, null);
    public static final Type TYPE = Sys.loadType(BCounter.class);
    private static final BIcon icon = BIcon.std((String)"control/control.png");
    boolean lastCountUp;
    boolean lastCountDown;
    boolean lastPreset;
    boolean lastClear;

    public BStatusNumeric getOut() {
        return (BStatusNumeric)this.get(out);
    }

    public void setOut(BStatusNumeric v) {
        this.set(out, (BValue)v, null);
    }

    public BStatusBoolean getCountUp() {
        return (BStatusBoolean)this.get(countUp);
    }

    public void setCountUp(BStatusBoolean v) {
        this.set(countUp, (BValue)v, null);
    }

    public BStatusBoolean getCountDown() {
        return (BStatusBoolean)this.get(countDown);
    }

    public void setCountDown(BStatusBoolean v) {
        this.set(countDown, (BValue)v, null);
    }

    public BStatusBoolean getPresetIn() {
        return (BStatusBoolean)this.get(presetIn);
    }

    public void setPresetIn(BStatusBoolean v) {
        this.set(presetIn, (BValue)v, null);
    }

    public BStatusBoolean getClearIn() {
        return (BStatusBoolean)this.get(clearIn);
    }

    public void setClearIn(BStatusBoolean v) {
        this.set(clearIn, (BValue)v, null);
    }

    public BStatusNumeric getPresetValue() {
        return (BStatusNumeric)this.get(presetValue);
    }

    public void setPresetValue(BStatusNumeric v) {
        this.set(presetValue, (BValue)v, null);
    }

    public float getCountIncrement() {
        return this.getFloat(countIncrement);
    }

    public void setCountIncrement(float v) {
        this.setFloat(countIncrement, v, null);
    }

    public void preset() {
        this.invoke(preset, null, null);
    }

    public void clear() {
        this.invoke(clear, null, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public void started() {
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p == countUp || p == countDown || p == presetIn || p == clearIn) {
            this.getOut().setValue(this.calculate());
            this.getOut().setStatus(this.propagateStatus());
        }
    }

    public BStatus propagateStatus() {
        int status = this.getCountUp().getStatus().getBits();
        status |= this.getCountDown().getStatus().getBits();
        status |= this.getPresetIn().getStatus().getBits();
        status |= this.getClearIn().getStatus().getBits();
        return BStatus.make((int)(status &= this.getPropagateFlags().getBits()));
    }

    public double calculate() {
        boolean countUp = this.getCountUp().getStatus().isValid() ? this.getCountUp().getValue() : this.lastCountUp;
        boolean countDown = this.getCountDown().getStatus().isValid() ? this.getCountDown().getValue() : this.lastCountDown;
        boolean preset = this.getPresetIn().getStatus().isValid() ? this.getPresetIn().getValue() : this.lastPreset;
        boolean clear = this.getClearIn().getStatus().isValid() ? this.getClearIn().getValue() : this.lastClear;
        double count = this.getOut().getValue();
        if (clear && !this.lastClear) {
            count = 0.0;
        }
        if (preset && !this.lastPreset) {
            count = this.getPresetValue().getValue();
        }
        if (countUp && !this.lastCountUp) {
            count += (double)this.getCountIncrement();
        }
        if (countDown && !this.lastCountDown) {
            count -= (double)this.getCountIncrement();
        }
        this.lastCountUp = countUp;
        this.lastCountDown = countDown;
        this.lastPreset = preset;
        this.lastClear = clear;
        return count;
    }

    public void doPreset() {
        this.getOut().setValue(this.getPresetValue().getValue());
    }

    public void doClear() {
        this.getOut().setValue(0.0);
    }

    public String toString(Context cx) {
        return this.getOut().toString(cx);
    }

    @Override
    public BFacets getSlotFacets(Slot slot) {
        if (slot.getName().equals("out")) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public BStatus getStatus() {
        return this.getOut().getStatus();
    }

    public double getNumeric() {
        return this.getOut().getValue();
    }

    public final BFacets getNumericFacets() {
        return this.getOut().getStatus().getFacets();
    }

    public BIcon getIcon() {
        return icon;
    }
}

