/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.timer;

import javax.baja.data.BIDataValue;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnum;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIcon;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BBooleanDelay
extends BComponent
implements BIStatus,
BIBoolean {
    public static final Property facets = BBooleanDelay.newProperty((int)0, (BValue)BFacets.makeBoolean(), null);
    public static final Property in = BBooleanDelay.newProperty((int)8, (BValue)new BStatusBoolean(), null);
    public static final Property onDelay = BBooleanDelay.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0)));
    public static final Property offDelay = BBooleanDelay.newProperty((int)0, (BValue)BRelTime.make((long)1000L), (BFacets)BFacets.make((String)"min", (BIDataValue)BRelTime.makeSeconds((int)0)));
    public static final Property onDelayActive = BBooleanDelay.newProperty((int)3, (boolean)false, null);
    public static final Property offDelayActive = BBooleanDelay.newProperty((int)3, (boolean)false, null);
    public static final Property out = BBooleanDelay.newProperty((int)74, (BValue)new BStatusBoolean(false), null);
    public static final Property outNot = BBooleanDelay.newProperty((int)74, (BValue)new BStatusBoolean(true), null);
    public static final Action onTimerExpired = BBooleanDelay.newAction((int)4, null);
    public static final Action offTimerExpired = BBooleanDelay.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BBooleanDelay.class);
    private static final BIcon icon = BIcon.std((String)"control/control.png");
    boolean lastInput = false;
    Clock.Ticket onTicket;
    Clock.Ticket offTicket;

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BStatusBoolean getIn() {
        return (BStatusBoolean)this.get(in);
    }

    public void setIn(BStatusBoolean v) {
        this.set(in, (BValue)v, null);
    }

    public BRelTime getOnDelay() {
        return (BRelTime)this.get(onDelay);
    }

    public void setOnDelay(BRelTime v) {
        this.set(onDelay, (BValue)v, null);
    }

    public BRelTime getOffDelay() {
        return (BRelTime)this.get(offDelay);
    }

    public void setOffDelay(BRelTime v) {
        this.set(offDelay, (BValue)v, null);
    }

    public boolean getOnDelayActive() {
        return this.getBoolean(onDelayActive);
    }

    public void setOnDelayActive(boolean v) {
        this.setBoolean(onDelayActive, v, null);
    }

    public boolean getOffDelayActive() {
        return this.getBoolean(offDelayActive);
    }

    public void setOffDelayActive(boolean v) {
        this.setBoolean(offDelayActive, v, null);
    }

    public BStatusBoolean getOut() {
        return (BStatusBoolean)this.get(out);
    }

    public void setOut(BStatusBoolean v) {
        this.set(out, (BValue)v, null);
    }

    public BStatusBoolean getOutNot() {
        return (BStatusBoolean)this.get(outNot);
    }

    public void setOutNot(BStatusBoolean v) {
        this.set(outNot, (BValue)v, null);
    }

    public void onTimerExpired() {
        this.invoke(onTimerExpired, null, null);
    }

    public void offTimerExpired() {
        this.invoke(offTimerExpired, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
    }

    public void atSteadyState() {
        this.calculate();
    }

    public void changed(Property p, Context cx) {
        if (!this.isRunning()) {
            return;
        }
        if (p == in) {
            this.calculate();
        }
    }

    public void calculate() {
        if (!this.getIn().getStatus().isValid()) {
            return;
        }
        boolean input = this.getIn().getValue();
        if (input && !this.lastInput) {
            this.lastInput = input;
            if (this.getOnDelay().getMillis() == 0L) {
                if (this.offTicket != null) {
                    this.offTicket.cancel();
                }
                this.setOutput(true);
            } else {
                this.startOnTimer();
            }
        } else if (!input && this.lastInput) {
            this.lastInput = input;
            if (this.getOffDelay().getMillis() == 0L) {
                if (this.onTicket != null) {
                    this.onTicket.cancel();
                }
                this.setOutput(false);
            } else {
                this.startOffTimer();
            }
        }
    }

    private void setOutput(boolean value) {
        this.getOut().setValue(value);
        this.getOutNot().setValue(!value);
    }

    public void doOnTimerExpired() {
        this.setOutput(true);
        this.setOnDelayActive(false);
    }

    public void doOffTimerExpired() {
        this.setOutput(false);
        this.setOffDelayActive(false);
    }

    void startOnTimer() {
        if (this.offTicket != null) {
            this.offTicket.cancel();
        }
        if (this.onTicket != null) {
            this.onTicket.cancel();
        }
        this.onTicket = Clock.schedule((BComponent)this, (BRelTime)this.getOnDelay(), (Action)onTimerExpired, null);
        this.setOnDelayActive(true);
        this.setOffDelayActive(false);
    }

    void startOffTimer() {
        if (this.onTicket != null) {
            this.onTicket.cancel();
        }
        if (this.offTicket != null) {
            this.offTicket.cancel();
        }
        this.offTicket = Clock.schedule((BComponent)this, (BRelTime)this.getOffDelay(), (Action)offTimerExpired, null);
        this.setOffDelayActive(true);
        this.setOnDelayActive(false);
    }

    public String toString(Context cx) {
        return this.getOut().toString(cx);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot == out) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public BStatus getStatus() {
        return this.getOut().getStatus();
    }

    public boolean getBoolean() {
        return this.getOut().getValue();
    }

    public final BFacets getBooleanFacets() {
        return this.getFacets();
    }

    public final BEnum getEnum() {
        return this.getOut().getEnum();
    }

    public final BFacets getEnumFacets() {
        return this.getFacets();
    }

    public BIcon getIcon() {
        return icon;
    }
}

