/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.hvac;

import com.tridium.kitControl.hvac.BSequence;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BSequenceBinary
extends BSequence {
    public static final Property delay = BSequenceBinary.newProperty((int)0, (BValue)BRelTime.make((long)0L), null);
    public static final Type TYPE = Sys.loadType(BSequenceBinary.class);

    @Override
    public Type getType() {
        return TYPE;
    }

    @Override
    public void calculate() {
        double maxStages = (int)Math.pow(2.0, this.getNumberOutputs()) - 1;
        double maxInValue = this.getInMaximum();
        double minInValue = this.getInMinimum();
        double range = maxInValue - minInValue;
        double spDelta = range / maxStages;
        double cv = this.getIn().getValue();
        if (cv > maxInValue) {
            cv = maxInValue;
        } else if (cv < minInValue) {
            cv = minInValue;
        }
        int currentStagesOn = this.numStagesOn;
        if (this.getIn().getStatus().isValid()) {
            this.numStagesOn = (int)((cv - this.getInMinimum()) / spDelta);
            if (cv > this.getInMinimum() && currentStagesOn > this.numStagesOn) {
                ++this.numStagesOn;
            }
        }
        this.setOutputs();
    }

    @Override
    public void setOutputs() {
        if (this.numStagesOn < 0) {
            this.numStagesOn = 0;
        }
        this.setDesiredStagesOn(this.numStagesOn);
        if (this.numStagesOn == this.curStagesOn) {
            return;
        }
        if (this.numStagesOn > this.curStagesOn && this.isDelayProgrammed()) {
            if (this.getOnDelayActive() || this.getOffDelayActive()) {
                return;
            }
            ++this.curStagesOn;
            this.startOnDelayTimer();
        } else if (this.numStagesOn < this.curStagesOn && this.isDelayProgrammed()) {
            if (this.getOffDelayActive() || this.getOnDelayActive()) {
                return;
            }
            --this.curStagesOn;
            this.startOffDelayTimer();
        } else {
            this.curStagesOn = this.numStagesOn;
        }
        this.getOutA().setValue((this.curStagesOn & 1) != 0);
        this.getOutB().setValue((this.curStagesOn & 2) != 0);
        this.getOutC().setValue((this.curStagesOn & 4) != 0);
        this.getOutD().setValue((this.curStagesOn & 8) != 0);
        this.getOutE().setValue((this.curStagesOn & 0x10) != 0);
        this.getOutF().setValue((this.curStagesOn & 0x20) != 0);
        this.getOutG().setValue((this.curStagesOn & 0x40) != 0);
        this.getOutH().setValue((this.curStagesOn & 0x80) != 0);
        this.getOutI().setValue((this.curStagesOn & 0x100) != 0);
        this.getOutJ().setValue((this.curStagesOn & 0x200) != 0);
        this.setCurrentStagesOn(this.curStagesOn);
    }
}

