/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.hvac;

import javax.baja.status.BStatusBoolean;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BLink;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BLeadLagCycles
extends BComponent {
    public static final Property facets = BLeadLagCycles.newProperty((int)0, (BValue)BFacets.makeBoolean(), null);
    public static final Property in = BLeadLagCycles.newProperty((int)8, (BValue)new BStatusBoolean(), null);
    public static final Property numberOutputs = BLeadLagCycles.newProperty((int)0, (int)2, (BFacets)BFacets.makeInt(null, (int)2, (int)10));
    public static final Property maxRuntime = BLeadLagCycles.newProperty((int)0, (BValue)BRelTime.make((long)360000L), null);
    public static final Property feedback = BLeadLagCycles.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property feedbackDelay = BLeadLagCycles.newProperty((int)0, (BValue)BRelTime.make((long)5000L), null);
    public static final Property clearAlarmTime = BLeadLagCycles.newProperty((int)0, (BValue)BRelTime.makeHours((int)1), null);
    public static final Property outA = BLeadLagCycles.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outB = BLeadLagCycles.newProperty((int)10, (BValue)new BStatusBoolean(), null);
    public static final Property outC = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outD = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outE = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outF = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outG = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outH = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outI = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property outJ = BLeadLagCycles.newProperty((int)2, (BValue)new BStatusBoolean(), null);
    public static final Property cycleCountA = BLeadLagCycles.newProperty((int)10, (int)0, null);
    public static final Property cycleCountB = BLeadLagCycles.newProperty((int)10, (int)0, null);
    public static final Property cycleCountC = BLeadLagCycles.newProperty((int)2, (int)0, null);
    public static final Property cycleCountD = BLeadLagCycles.newProperty((int)2, (int)0, null);
    public static final Property cycleCountE = BLeadLagCycles.newProperty((int)2, (int)0, null);
    public static final Property cycleCountF = BLeadLagCycles.newProperty((int)2, (int)0, null);
    public static final Property cycleCountG = BLeadLagCycles.newProperty((int)2, (int)0, null);
    public static final Property cycleCountH = BLeadLagCycles.newProperty((int)2, (int)0, null);
    public static final Property cycleCountI = BLeadLagCycles.newProperty((int)2, (int)0, null);
    public static final Property cycleCountJ = BLeadLagCycles.newProperty((int)2, (int)0, null);
    public static final Action rotateTimerExpired = BLeadLagCycles.newAction((int)4, null);
    public static final Action feedbackTimerExpired = BLeadLagCycles.newAction((int)4, null);
    public static final Action clearAlarmState = BLeadLagCycles.newAction((int)0, null);
    public static final Type TYPE = Sys.loadType(BLeadLagCycles.class);
    private static final BIcon icon = BIcon.std((String)"control/control.png");
    int numOutputs;
    int lastNumberOutputs;
    boolean feedbackTimerActive = false;
    boolean currentIn;
    boolean wasOn = false;
    int[] cycleCounts = new int[10];
    Clock.Ticket rotateTicket;
    Clock.Ticket feedbackTicket;
    Clock.Ticket alarmClearTicket;

    public BFacets getFacets() {
        return (BFacets)this.get(facets);
    }

    public void setFacets(BFacets v) {
        this.set(facets, (BValue)v, null);
    }

    public BStatusBoolean getIn() {
        return (BStatusBoolean)this.get(in);
    }

    public void setIn(BStatusBoolean v) {
        this.set(in, (BValue)v, null);
    }

    public int getNumberOutputs() {
        return this.getInt(numberOutputs);
    }

    public void setNumberOutputs(int v) {
        this.setInt(numberOutputs, v, null);
    }

    public BRelTime getMaxRuntime() {
        return (BRelTime)this.get(maxRuntime);
    }

    public void setMaxRuntime(BRelTime v) {
        this.set(maxRuntime, (BValue)v, null);
    }

    public BStatusBoolean getFeedback() {
        return (BStatusBoolean)this.get(feedback);
    }

    public void setFeedback(BStatusBoolean v) {
        this.set(feedback, (BValue)v, null);
    }

    public BRelTime getFeedbackDelay() {
        return (BRelTime)this.get(feedbackDelay);
    }

    public void setFeedbackDelay(BRelTime v) {
        this.set(feedbackDelay, (BValue)v, null);
    }

    public BRelTime getClearAlarmTime() {
        return (BRelTime)this.get(clearAlarmTime);
    }

    public void setClearAlarmTime(BRelTime v) {
        this.set(clearAlarmTime, (BValue)v, null);
    }

    public BStatusBoolean getOutA() {
        return (BStatusBoolean)this.get(outA);
    }

    public void setOutA(BStatusBoolean v) {
        this.set(outA, (BValue)v, null);
    }

    public BStatusBoolean getOutB() {
        return (BStatusBoolean)this.get(outB);
    }

    public void setOutB(BStatusBoolean v) {
        this.set(outB, (BValue)v, null);
    }

    public BStatusBoolean getOutC() {
        return (BStatusBoolean)this.get(outC);
    }

    public void setOutC(BStatusBoolean v) {
        this.set(outC, (BValue)v, null);
    }

    public BStatusBoolean getOutD() {
        return (BStatusBoolean)this.get(outD);
    }

    public void setOutD(BStatusBoolean v) {
        this.set(outD, (BValue)v, null);
    }

    public BStatusBoolean getOutE() {
        return (BStatusBoolean)this.get(outE);
    }

    public void setOutE(BStatusBoolean v) {
        this.set(outE, (BValue)v, null);
    }

    public BStatusBoolean getOutF() {
        return (BStatusBoolean)this.get(outF);
    }

    public void setOutF(BStatusBoolean v) {
        this.set(outF, (BValue)v, null);
    }

    public BStatusBoolean getOutG() {
        return (BStatusBoolean)this.get(outG);
    }

    public void setOutG(BStatusBoolean v) {
        this.set(outG, (BValue)v, null);
    }

    public BStatusBoolean getOutH() {
        return (BStatusBoolean)this.get(outH);
    }

    public void setOutH(BStatusBoolean v) {
        this.set(outH, (BValue)v, null);
    }

    public BStatusBoolean getOutI() {
        return (BStatusBoolean)this.get(outI);
    }

    public void setOutI(BStatusBoolean v) {
        this.set(outI, (BValue)v, null);
    }

    public BStatusBoolean getOutJ() {
        return (BStatusBoolean)this.get(outJ);
    }

    public void setOutJ(BStatusBoolean v) {
        this.set(outJ, (BValue)v, null);
    }

    public int getCycleCountA() {
        return this.getInt(cycleCountA);
    }

    public void setCycleCountA(int v) {
        this.setInt(cycleCountA, v, null);
    }

    public int getCycleCountB() {
        return this.getInt(cycleCountB);
    }

    public void setCycleCountB(int v) {
        this.setInt(cycleCountB, v, null);
    }

    public int getCycleCountC() {
        return this.getInt(cycleCountC);
    }

    public void setCycleCountC(int v) {
        this.setInt(cycleCountC, v, null);
    }

    public int getCycleCountD() {
        return this.getInt(cycleCountD);
    }

    public void setCycleCountD(int v) {
        this.setInt(cycleCountD, v, null);
    }

    public int getCycleCountE() {
        return this.getInt(cycleCountE);
    }

    public void setCycleCountE(int v) {
        this.setInt(cycleCountE, v, null);
    }

    public int getCycleCountF() {
        return this.getInt(cycleCountF);
    }

    public void setCycleCountF(int v) {
        this.setInt(cycleCountF, v, null);
    }

    public int getCycleCountG() {
        return this.getInt(cycleCountG);
    }

    public void setCycleCountG(int v) {
        this.setInt(cycleCountG, v, null);
    }

    public int getCycleCountH() {
        return this.getInt(cycleCountH);
    }

    public void setCycleCountH(int v) {
        this.setInt(cycleCountH, v, null);
    }

    public int getCycleCountI() {
        return this.getInt(cycleCountI);
    }

    public void setCycleCountI(int v) {
        this.setInt(cycleCountI, v, null);
    }

    public int getCycleCountJ() {
        return this.getInt(cycleCountJ);
    }

    public void setCycleCountJ(int v) {
        this.setInt(cycleCountJ, v, null);
    }

    public void rotateTimerExpired() {
        this.invoke(rotateTimerExpired, null, null);
    }

    public void feedbackTimerExpired() {
        this.invoke(feedbackTimerExpired, null, null);
    }

    public void clearAlarmState() {
        this.invoke(clearAlarmState, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.initNumberOutputs();
    }

    public void atSteadyState() {
        this.currentIn = this.getIn().getValue();
        this.calculate();
    }

    public void changed(Property p, Context cx) {
        if (p == numberOutputs) {
            this.initNumberOutputs();
        }
        if (!this.isRunning()) {
            return;
        }
        if (p == in) {
            this.currentIn = this.getIn().getValue();
            this.calculate();
        } else if (p == feedback) {
            if (!this.currentIn) {
                return;
            }
            if (this.getFeedback().getValue()) {
                return;
            }
            if (this.feedbackTimerActive) {
                return;
            }
            this.setCurrentOutputAlarm(true);
            this.getCycleCounts();
            this.startOutput();
        }
    }

    public void initNumberOutputs() {
        this.numOutputs = this.getNumberOutputs();
        block12: for (int i = 0; i < 10; ++i) {
            int setFlags = i >= this.numOutputs ? 6 : 10;
            switch (i) {
                case 0: {
                    this.initSlot("outA", setFlags | 1);
                    this.initSlot("cycleCountA", setFlags);
                    continue block12;
                }
                case 1: {
                    this.initSlot("outB", setFlags | 1);
                    this.initSlot("cycleCountB", setFlags);
                    continue block12;
                }
                case 2: {
                    this.initSlot("outC", setFlags | 1);
                    this.initSlot("cycleCountC", setFlags);
                    continue block12;
                }
                case 3: {
                    this.initSlot("outD", setFlags | 1);
                    this.initSlot("cycleCountD", setFlags);
                    continue block12;
                }
                case 4: {
                    this.initSlot("outE", setFlags | 1);
                    this.initSlot("cycleCountE", setFlags);
                    continue block12;
                }
                case 5: {
                    this.initSlot("outF", setFlags | 1);
                    this.initSlot("cycleCountF", setFlags);
                    continue block12;
                }
                case 6: {
                    this.initSlot("outG", setFlags | 1);
                    this.initSlot("cycleCountG", setFlags);
                    continue block12;
                }
                case 7: {
                    this.initSlot("outH", setFlags | 1);
                    this.initSlot("cycleCountH", setFlags);
                    continue block12;
                }
                case 8: {
                    this.initSlot("outI", setFlags | 1);
                    this.initSlot("cycleCountI", setFlags);
                    continue block12;
                }
                case 9: {
                    this.initSlot("outJ", setFlags | 1);
                    this.initSlot("cycleCountJ", setFlags);
                }
            }
        }
    }

    void initSlot(String slot, int flags) {
        try {
            this.setFlags(this.getSlot(slot), flags, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doClearAlarmState() {
        if (this.alarmClearTicket != null) {
            this.alarmClearTicket.cancel();
            this.alarmClearTicket = null;
        }
        for (int i = 0; i < this.numOutputs; ++i) {
            this.getStatusOutput(i).setStatusInAlarm(false);
        }
    }

    public void doRotateTimerExpired() {
        if (!this.currentIn) {
            return;
        }
        this.getCycleCounts();
        this.startOutput();
    }

    public void doFeedbackTimerExpired() {
        this.feedbackTimerActive = false;
        if (!this.currentIn) {
            return;
        }
        if (this.getFeedback().getValue()) {
            return;
        }
        this.setCurrentOutputAlarm(true);
        this.getCycleCounts();
        this.startOutput();
    }

    void calculate() {
        this.getCycleCounts();
        if (this.currentIn) {
            if (!this.wasOn) {
                this.startOutput();
                this.wasOn = true;
            }
        } else {
            if (this.wasOn) {
                if (this.rotateTicket != null) {
                    this.rotateTicket.cancel();
                }
                if (this.feedbackTicket != null) {
                    this.feedbackTicket.cancel();
                }
                this.wasOn = false;
            }
            this.stopOutput();
        }
    }

    void getCycleCounts() {
        for (int i = 0; i < this.numOutputs; ++i) {
            this.cycleCounts[i] = this.isCycleCountLinked(i) && !this.getOutValue(i) ? this.getCycleCount(i) : Integer.MAX_VALUE;
        }
    }

    int getCycleCount(int index) {
        switch (index) {
            case 0: {
                return this.getCycleCountA();
            }
            case 1: {
                return this.getCycleCountB();
            }
            case 2: {
                return this.getCycleCountC();
            }
            case 3: {
                return this.getCycleCountD();
            }
            case 4: {
                return this.getCycleCountE();
            }
            case 5: {
                return this.getCycleCountF();
            }
            case 6: {
                return this.getCycleCountG();
            }
            case 7: {
                return this.getCycleCountH();
            }
            case 8: {
                return this.getCycleCountI();
            }
            case 9: {
                return this.getCycleCountJ();
            }
        }
        return Integer.MAX_VALUE;
    }

    boolean getOutValue(int index) {
        switch (index) {
            case 0: {
                return this.getOutA().getValue();
            }
            case 1: {
                return this.getOutB().getValue();
            }
            case 2: {
                return this.getOutC().getValue();
            }
            case 3: {
                return this.getOutD().getValue();
            }
            case 4: {
                return this.getOutE().getValue();
            }
            case 5: {
                return this.getOutF().getValue();
            }
            case 6: {
                return this.getOutG().getValue();
            }
            case 7: {
                return this.getOutH().getValue();
            }
            case 8: {
                return this.getOutI().getValue();
            }
            case 9: {
                return this.getOutJ().getValue();
            }
        }
        return false;
    }

    boolean isCycleCountLinked(int index) {
        BLink[] links = null;
        switch (index) {
            case 0: {
                links = this.getLinks(this.getSlot("cycleCountA"));
                break;
            }
            case 1: {
                links = this.getLinks(this.getSlot("cycleCountB"));
                break;
            }
            case 2: {
                links = this.getLinks(this.getSlot("cycleCountC"));
                break;
            }
            case 3: {
                links = this.getLinks(this.getSlot("cycleCountD"));
                break;
            }
            case 4: {
                links = this.getLinks(this.getSlot("cycleCountE"));
                break;
            }
            case 5: {
                links = this.getLinks(this.getSlot("cycleCountF"));
                break;
            }
            case 6: {
                links = this.getLinks(this.getSlot("cycleCountG"));
                break;
            }
            case 7: {
                links = this.getLinks(this.getSlot("cycleCountH"));
                break;
            }
            case 8: {
                links = this.getLinks(this.getSlot("cycleCountI"));
                break;
            }
            case 9: {
                links = this.getLinks(this.getSlot("cycleCountJ"));
            }
        }
        if (links == null) {
            return false;
        }
        return links.length != 0;
    }

    void startOutput() {
        int i;
        int minCycleCounts = Integer.MAX_VALUE;
        int index = 0;
        for (i = 0; i < this.numOutputs; ++i) {
            if (this.getStatusOutput(i).getStatus().isAlarm() || this.cycleCounts[i] >= minCycleCounts) continue;
            minCycleCounts = this.cycleCounts[i];
            index = i;
        }
        for (i = 0; i < this.numOutputs; ++i) {
            this.getStatusOutput(i).setValue(index == i);
        }
        this.startRotateTimer();
        this.startFeedbackTimer();
    }

    BStatusBoolean getStatusOutput(int index) {
        switch (index) {
            case 0: {
                return this.getOutA();
            }
            case 1: {
                return this.getOutB();
            }
            case 2: {
                return this.getOutC();
            }
            case 3: {
                return this.getOutD();
            }
            case 4: {
                return this.getOutE();
            }
            case 5: {
                return this.getOutF();
            }
            case 6: {
                return this.getOutG();
            }
            case 7: {
                return this.getOutH();
            }
            case 8: {
                return this.getOutI();
            }
            case 9: {
                return this.getOutJ();
            }
        }
        if (index < 0) {
            return this.getOutA();
        }
        return this.getOutJ();
    }

    void setCurrentOutputAlarm(boolean alarm) {
        if (alarm) {
            this.startAlarmClearTimer();
        }
        for (int i = 0; i < this.numOutputs; ++i) {
            BStatusBoolean currentOut = this.getStatusOutput(i);
            if (!currentOut.getValue()) continue;
            currentOut.setStatusInAlarm(alarm);
        }
    }

    void stopOutput() {
        for (int i = 0; i < this.numOutputs; ++i) {
            this.getStatusOutput(i).setValue(false);
        }
    }

    void startAlarmClearTimer() {
        BRelTime clearTime = this.getClearAlarmTime();
        if (clearTime.getMillis() == 0L || this.alarmClearTicket != null) {
            return;
        }
        this.alarmClearTicket = Clock.schedule((BComponent)this, (BRelTime)clearTime, (Action)clearAlarmState, null);
    }

    void startRotateTimer() {
        if (this.rotateTicket != null) {
            this.rotateTicket.cancel();
        }
        this.rotateTicket = Clock.schedule((BComponent)this, (BRelTime)this.getMaxRuntime(), (Action)rotateTimerExpired, null);
    }

    void startFeedbackTimer() {
        if (this.feedbackTicket != null) {
            this.feedbackTicket.cancel();
        }
        this.feedbackTimerActive = true;
        this.feedbackTicket = Clock.schedule((BComponent)this, (BRelTime)this.getFeedbackDelay(), (Action)feedbackTimerExpired, null);
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.getName().startsWith("out")) {
            return this.getFacets();
        }
        return super.getSlotFacets(slot);
    }

    public BIcon getIcon() {
        return icon;
    }
}

