/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.energy;

import javax.baja.status.BStatus;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

public class BShedControl
extends BComponent {
    public static final Property numberLevels = BShedControl.newProperty((int)0, (int)16, (BFacets)BFacets.makeInt((int)1, (int)32));
    public static final Property shedEnable = BShedControl.newProperty((int)0, (boolean)true, null);
    public static final Property primaryShedLevel = BShedControl.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property secondaryShedLevel = BShedControl.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property status = BShedControl.newProperty((int)0, (String)"", null);
    public static final Action calculate = BShedControl.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BShedControl.class);
    int baseLevel;
    int mode;
    int previousLevel;
    int shedLevel;
    protected static final int SHED_LEVEL = 1;
    protected static final int SHEDDING_LEVEL = 2;
    protected static final int RESTORING_LEVEL = 3;
    protected static final int DISABLED = 4;
    protected static final int ALL_SHED = 5;
    protected static final int ALL_RESTORED = 6;
    protected static String SHED_LEVEL_MSG = Lexicon.make((String)"kitControl").getText("shedControl.shedLevel");
    protected static String SHEDDING_LEVEL_MSG = Lexicon.make((String)"kitControl").getText("shedControl.sheddingLevel");
    protected static String RESTORING_LEVEL_MSG = Lexicon.make((String)"kitControl").getText("shedControl.restoringLevel");
    protected static String DISABLED_MSG = Lexicon.make((String)"kitControl").getText("shedControl.disabled");
    protected static String ALL_SHED_MSG = Lexicon.make((String)"kitControl").getText("shedControl.allShed");
    protected static String ALL_RESTORED_MSG = Lexicon.make((String)"kitControl").getText("shedControl.allRestored");

    public int getNumberLevels() {
        return this.getInt(numberLevels);
    }

    public void setNumberLevels(int v) {
        this.setInt(numberLevels, v, null);
    }

    public boolean getShedEnable() {
        return this.getBoolean(shedEnable);
    }

    public void setShedEnable(boolean v) {
        this.setBoolean(shedEnable, v, null);
    }

    public BStatusNumeric getPrimaryShedLevel() {
        return (BStatusNumeric)this.get(primaryShedLevel);
    }

    public void setPrimaryShedLevel(BStatusNumeric v) {
        this.set(primaryShedLevel, (BValue)v, null);
    }

    public BStatusNumeric getSecondaryShedLevel() {
        return (BStatusNumeric)this.get(secondaryShedLevel);
    }

    public void setSecondaryShedLevel(BStatusNumeric v) {
        this.set(secondaryShedLevel, (BValue)v, null);
    }

    public String getStatus() {
        return this.getString(status);
    }

    public void setStatus(String v) {
        this.setString(status, v, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        if (!this.isRunning() || !Sys.atSteadyState()) {
            return;
        }
        this.addRemoveOutputs();
        this.doCalculate();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.equals(numberLevels)) {
            this.addRemoveOutputs();
            this.doCalculate();
        }
        if (property.equals(shedEnable) || property.equals(primaryShedLevel) || property.equals(secondaryShedLevel)) {
            this.doCalculate();
        }
    }

    public void removed(Property property, BValue oldValue, Context context) {
        if (oldValue instanceof BLink) {
            this.doCalculate();
        }
    }

    private void addRemoveOutputs() {
        int numOuts = this.getNumberLevels();
        for (int i = 1; i <= 32; ++i) {
            if (i <= numOuts) {
                if (this.getSlot("out" + i) != null) continue;
                Property prop = this.add("out" + i, (BValue)this.getAutoValue());
                this.setFlags((Slot)prop, this.getFlags((Slot)prop) | 8);
                continue;
            }
            if (this.getSlot("out" + i) == null) continue;
            this.remove("out" + i);
        }
    }

    public void doCalculate() {
        this.shedLevel = this.getLinks((Slot)primaryShedLevel).length == 0 || !this.getPrimaryShedLevel().getStatus().isValid() || this.getPrimaryShedLevel().getValue() < 0.0 ? (int)this.getSecondaryShedLevel().getValue() : (int)this.getPrimaryShedLevel().getValue();
        for (int i = 1; i <= this.getNumberLevels(); ++i) {
            if (!this.getShedEnable() || this.shedLevel < i) {
                this.set("out" + i, (BValue)this.getAutoValue());
                continue;
            }
            this.set("out" + i, (BValue)this.getShedValue());
        }
        this.mode = 1;
        if (!this.getShedEnable()) {
            this.mode = 4;
            this.shedLevel = 0;
        } else if (this.shedLevel == 0) {
            this.mode = 6;
        } else if (this.shedLevel >= this.getNumberLevels()) {
            this.mode = 5;
        } else if (this.shedLevel > this.previousLevel) {
            this.mode = 2;
        } else if (this.shedLevel < this.previousLevel) {
            this.mode = 3;
        }
        this.previousLevel = this.shedLevel;
        switch (this.mode) {
            case 2: {
                this.setStatus(SHEDDING_LEVEL_MSG + ' ' + this.shedLevel);
                break;
            }
            case 3: {
                this.setStatus(RESTORING_LEVEL_MSG + ' ' + (this.shedLevel + 1));
                break;
            }
            case 4: {
                this.setStatus(DISABLED_MSG);
                break;
            }
            case 5: {
                this.setStatus(ALL_SHED_MSG);
                break;
            }
            case 6: {
                this.setStatus(ALL_RESTORED_MSG);
                break;
            }
            default: {
                this.setStatus(SHED_LEVEL_MSG + ' ' + this.shedLevel);
            }
        }
    }

    private BStatusBoolean getAutoValue() {
        return new BStatusBoolean(false, BStatus.make((int)64));
    }

    private BStatusBoolean getShedValue() {
        return new BStatusBoolean(false);
    }
}

