/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.kitControl.energy;

import com.tridium.kitControl.enums.BEnglishMetric;
import com.tridium.kitControl.hvac.Psychrometric;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;
import javax.baja.units.UnitDatabase;

public class BPsychrometric
extends BComponent {
    public static final Property unitSelect = BPsychrometric.newProperty((int)0, (BValue)BEnglishMetric.english, null);
    public static final Property temperatureFacets = BPsychrometric.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"fahrenheit"), (int)1), null);
    public static final Property humidityFacets = BPsychrometric.newProperty((int)0, (BValue)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"percent relative humidity"), (int)1), null);
    public static final Property inTemp = BPsychrometric.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property inHumidity = BPsychrometric.newProperty((int)8, (BValue)new BStatusNumeric(), null);
    public static final Property outDewPoint = BPsychrometric.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    public static final Property outEnthalpy = BPsychrometric.newProperty((int)10, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"btu per pound"), (int)2));
    public static final Property outSatPress = BPsychrometric.newProperty((int)10, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"pounds per square inch"), (int)3));
    public static final Property outVaporPress = BPsychrometric.newProperty((int)10, (BValue)new BStatusNumeric(), (BFacets)BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"pounds per square inch"), (int)3));
    public static final Property outWetBulbTemp = BPsychrometric.newProperty((int)10, (BValue)new BStatusNumeric(), null);
    public static final Action calculate = BPsychrometric.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType(BPsychrometric.class);
    private static double fiveNineths = 0.5555555555555556;
    private static BFacets pressureEnglishFacets = BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"pounds per square inch"), (int)3);
    private static BFacets pressureMetricFacets = BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"kilopascal"), (int)3);
    private static BFacets enthalpyEnglishFacets = BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"btu per pound"), (int)3);
    private static BFacets enthalpyMetricFacets = BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"kilojoule per kilogram"), (int)3);
    Clock.Ticket ticket = null;
    private boolean isEnglish = true;

    public BEnglishMetric getUnitSelect() {
        return (BEnglishMetric)this.get(unitSelect);
    }

    public void setUnitSelect(BEnglishMetric v) {
        this.set(unitSelect, (BValue)v, null);
    }

    public BFacets getTemperatureFacets() {
        return (BFacets)this.get(temperatureFacets);
    }

    public void setTemperatureFacets(BFacets v) {
        this.set(temperatureFacets, (BValue)v, null);
    }

    public BFacets getHumidityFacets() {
        return (BFacets)this.get(humidityFacets);
    }

    public void setHumidityFacets(BFacets v) {
        this.set(humidityFacets, (BValue)v, null);
    }

    public BStatusNumeric getInTemp() {
        return (BStatusNumeric)this.get(inTemp);
    }

    public void setInTemp(BStatusNumeric v) {
        this.set(inTemp, (BValue)v, null);
    }

    public BStatusNumeric getInHumidity() {
        return (BStatusNumeric)this.get(inHumidity);
    }

    public void setInHumidity(BStatusNumeric v) {
        this.set(inHumidity, (BValue)v, null);
    }

    public BStatusNumeric getOutDewPoint() {
        return (BStatusNumeric)this.get(outDewPoint);
    }

    public void setOutDewPoint(BStatusNumeric v) {
        this.set(outDewPoint, (BValue)v, null);
    }

    public BStatusNumeric getOutEnthalpy() {
        return (BStatusNumeric)this.get(outEnthalpy);
    }

    public void setOutEnthalpy(BStatusNumeric v) {
        this.set(outEnthalpy, (BValue)v, null);
    }

    public BStatusNumeric getOutSatPress() {
        return (BStatusNumeric)this.get(outSatPress);
    }

    public void setOutSatPress(BStatusNumeric v) {
        this.set(outSatPress, (BValue)v, null);
    }

    public BStatusNumeric getOutVaporPress() {
        return (BStatusNumeric)this.get(outVaporPress);
    }

    public void setOutVaporPress(BStatusNumeric v) {
        this.set(outVaporPress, (BValue)v, null);
    }

    public BStatusNumeric getOutWetBulbTemp() {
        return (BStatusNumeric)this.get(outWetBulbTemp);
    }

    public void setOutWetBulbTemp(BStatusNumeric v) {
        this.set(outWetBulbTemp, (BValue)v, null);
    }

    public void calculate() {
        this.invoke(calculate, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        this.ticket = Clock.schedule((BComponent)this, (BRelTime)BRelTime.makeMinutes((int)1), (Action)calculate, null);
        super.started();
        if (!Sys.atSteadyState()) {
            return;
        }
    }

    public void stopped() throws Exception {
        if (this.ticket != null) {
            this.ticket.cancel();
        }
        super.stopped();
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (!Sys.atSteadyState() || !this.isRunning()) {
            return;
        }
        if (property.getName().startsWith("in") || property.equals(unitSelect)) {
            this.doCalculate();
        }
        if (property.equals(unitSelect)) {
            this.isEnglish = this.getUnitSelect().equals((Object)BEnglishMetric.english);
            int precision = this.getTemperatureFacets().geti("precision", 1);
            if (this.isEnglish) {
                this.setTemperatureFacets(BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"fahrenheit"), (int)precision));
            } else {
                this.setTemperatureFacets(BFacets.makeNumeric((BUnit)UnitDatabase.getUnit((String)"celsius"), (int)precision));
            }
        }
    }

    public BFacets getSlotFacets(Slot slot) {
        this.isEnglish = this.getUnitSelect().equals((Object)BEnglishMetric.english);
        if (slot.equals((Object)inTemp) || slot.equals((Object)outDewPoint) || slot.equals((Object)outWetBulbTemp)) {
            return this.getTemperatureFacets();
        }
        if (slot.equals((Object)inHumidity)) {
            return this.getHumidityFacets();
        }
        if (slot.equals((Object)outEnthalpy)) {
            if (this.isEnglish) {
                return enthalpyEnglishFacets;
            }
            return enthalpyMetricFacets;
        }
        if (slot.equals((Object)outSatPress) || slot.equals((Object)outVaporPress)) {
            if (this.isEnglish) {
                return pressureEnglishFacets;
            }
            return pressureMetricFacets;
        }
        return super.getSlotFacets(slot);
    }

    public void atSteadyState() {
        this.doCalculate();
    }

    public void doCalculate() {
        boolean tempAndRhValid;
        this.isEnglish = this.getUnitSelect().equals((Object)BEnglishMetric.english);
        float temp = this.getInTempEnglish();
        float RH = (float)this.getInHumidity().getValue();
        BStatusNumeric dewPointValue = new BStatusNumeric();
        BStatusNumeric enthalpyValue = new BStatusNumeric();
        BStatusNumeric vaporPressValue = new BStatusNumeric();
        BStatusNumeric wetBulbTempValue = new BStatusNumeric();
        BStatusNumeric satPressValue = new BStatusNumeric();
        boolean bl = tempAndRhValid = this.isTempValid() && this.isRHValid();
        if (tempAndRhValid) {
            dewPointValue.setValue((double)Psychrometric.dewpointTemperature(temp, RH));
            enthalpyValue.setValue((double)Psychrometric.enthalpy(temp, RH));
            vaporPressValue.setValue((double)Psychrometric.vaporPressure(temp, RH));
            wetBulbTempValue.setValue((double)Psychrometric.wetbulbTemperature(temp, RH));
        } else {
            dewPointValue.setValue(Double.NaN);
            enthalpyValue.setValue(Double.NaN);
            vaporPressValue.setValue(Double.NaN);
            wetBulbTempValue.setValue(Double.NaN);
        }
        dewPointValue.setStatus(BStatus.makeFault((BStatus)this.getOutDewPoint().getStatus(), (!tempAndRhValid ? 1 : 0) != 0));
        enthalpyValue.setStatus(BStatus.makeFault((BStatus)this.getOutEnthalpy().getStatus(), (!tempAndRhValid ? 1 : 0) != 0));
        vaporPressValue.setStatus(BStatus.makeFault((BStatus)this.getOutVaporPress().getStatus(), (!tempAndRhValid ? 1 : 0) != 0));
        wetBulbTempValue.setStatus(BStatus.makeFault((BStatus)this.getOutWetBulbTemp().getStatus(), (!tempAndRhValid ? 1 : 0) != 0));
        if (this.isTempValid()) {
            satPressValue.setValue((double)Psychrometric.saturationPressure(temp));
        } else {
            satPressValue.setValue(Double.NaN);
        }
        satPressValue.setStatus(BStatus.makeFault((BStatus)this.getOutSatPress().getStatus(), (!this.isTempValid() ? 1 : 0) != 0));
        if (!this.isEnglish) {
            dewPointValue.setValue(this.convertTemp(dewPointValue.getValue()));
            enthalpyValue.setValue(this.convertEnthalpy(enthalpyValue.getValue()));
            vaporPressValue.setValue(this.convertPress(vaporPressValue.getValue()));
            wetBulbTempValue.setValue(this.convertTemp(wetBulbTempValue.getValue()));
            satPressValue.setValue(this.convertPress(satPressValue.getValue()));
        }
        this.setOutDewPoint(dewPointValue);
        this.setOutEnthalpy(enthalpyValue);
        this.setOutVaporPress(vaporPressValue);
        this.setOutWetBulbTemp(wetBulbTempValue);
        this.setOutSatPress(satPressValue);
    }

    private boolean isTempValid() {
        return this.getInTemp().getStatus().isValid() && Psychrometric.isTempValid(this.getInTempEnglish());
    }

    private boolean isRHValid() {
        return this.getInHumidity().getStatus().isValid() && Psychrometric.isRHValid((float)this.getInHumidity().getValue());
    }

    private float getInTempEnglish() {
        float inTempValue = (float)this.getInTemp().getValue();
        if (this.isEnglish) {
            return inTempValue;
        }
        return 1.8f * inTempValue + 32.0f;
    }

    private double convertTemp(double value) {
        if (Double.isNaN(value)) {
            return value;
        }
        return (value - 32.0) * fiveNineths;
    }

    private double convertEnthalpy(double value) {
        if (Double.isNaN(value)) {
            return value;
        }
        return (value - 7.68152) * 2.326;
    }

    private double convertPress(double value) {
        if (Double.isNaN(value)) {
            return value;
        }
        return value * 6.89475729;
    }
}

